/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.grid.targets;

import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.NonPlaceholderDragTarget;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.BaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.handlers.grid.GridBarriers;
import com.android.tools.idea.uibuilder.handlers.grid.GridUtilsKt;
import com.android.tools.idea.uibuilder.handlers.grid.targets.DragCellCommand;
import com.android.tools.idea.uibuilder.handlers.grid.targets.DrawDraggableRegionCommand;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.ThrowableRunnable;
import java.awt.Cursor;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0004H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\tH\u0016J\b\u0010\u0015\u001a\u00020\u0004H\u0014J0\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\tH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\tH\u0016J&\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\t2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0016J&\u0010%\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\t2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020$0#H\u0016J\u0018\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0018H\u0016J \u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\tH\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/android/tools/idea/uibuilder/handlers/grid/targets/GridDragTarget;", "Lcom/android/tools/idea/common/scene/target/BaseTarget;", "Lcom/android/tools/idea/common/scene/NonPlaceholderDragTarget;", "isSupportLibrary", "", "(Z)V", "barrier", "Lcom/android/tools/idea/uibuilder/handlers/grid/GridBarriers;", "firstMouseX", "", "firstMouseY", "nameSpace", "", "offsetX", "offsetY", "selectedColumn", "selectedRow", "canChangeSelection", "getMouseCursor", "Ljava/awt/Cursor;", "getPreferenceLevel", "isHittable", "layout", "context", "Lcom/android/tools/idea/common/scene/SceneContext;", "l", "t", "r", "b", "mouseDown", "", "x", "y", "mouseDrag", "closestTargets", "", "Lcom/android/tools/idea/common/scene/target/Target;", "mouseRelease", "closestTarget", "render", "list", "Lcom/android/tools/idea/common/scene/draw/DisplayList;", "sceneContext", "updateAttributes", "attributes", "Lcom/android/tools/idea/common/model/AttributesTransaction;", "intellij.android.designer"})
public final class GridDragTarget
extends BaseTarget
implements NonPlaceholderDragTarget {
    private final String nameSpace;
    private GridBarriers barrier;
    private int selectedRow;
    private int selectedColumn;
    private int firstMouseX;
    private int firstMouseY;
    private int offsetX;
    private int offsetY;

    @Override
    public boolean layout(@NotNull SceneContext context, int l, int t, int r, int b) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        int xShift = r - l < 16 ? (16 - (r - l)) / 2 : 0;
        this.myLeft = l - xShift;
        this.myRight = r + xShift;
        int yShift = b - t < 16 ? (16 - (b - t)) / 2 : 0;
        this.myTop = t - yShift;
        this.myBottom = b + yShift;
        SceneComponent sceneComponent = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent, (String)"myComponent");
        if (!sceneComponent.isDragging()) {
            SceneComponent sceneComponent2 = this.myComponent;
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent2, (String)"myComponent");
            SceneComponent sceneComponent3 = sceneComponent2.getParent();
            if (sceneComponent3 == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent3, (String)"myComponent.parent ?: return false");
            SceneComponent parent = sceneComponent3;
            this.barrier = GridUtilsKt.getGridBarriers(parent);
        }
        return false;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        Intrinsics.checkParameterIsNotNull((Object)list, (String)"list");
        Intrinsics.checkParameterIsNotNull((Object)sceneContext, (String)"sceneContext");
        SceneComponent sceneComponent = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent, (String)"myComponent");
        if (sceneComponent.isDragging() && this.barrier != null) {
            GridBarriers gridBarriers = this.barrier;
            if (gridBarriers == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.tools.idea.uibuilder.handlers.grid.GridBarriers");
            }
            GridBarriers b = gridBarriers;
            list.add(new DrawDraggableRegionCommand(b.getLeft(), b.getTop(), b.getRight(), b.getBottom()));
            if (this.selectedColumn != -1 && this.selectedRow != -1) {
                list.add(new DragCellCommand(b.getColumns()[this.selectedColumn], b.getRows()[this.selectedRow], b.getColumns()[this.selectedColumn + 1], b.getRows()[this.selectedRow + 1]));
            }
        }
    }

    @Override
    public void mouseDown(int x, int y) {
        this.firstMouseX = x;
        this.firstMouseY = y;
        this.offsetX = x - this.myComponent.getDrawX(System.currentTimeMillis());
        this.offsetY = y - this.myComponent.getDrawY(System.currentTimeMillis());
        this.myComponent.setModelUpdateAuthorized(true);
    }

    public void mouseDrag(int x, int y, @NotNull List<? extends Target> closestTargets) {
        Intrinsics.checkParameterIsNotNull(closestTargets, (String)"closestTargets");
        SceneComponent sceneComponent = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent, (String)"myComponent");
        sceneComponent.setDragging(true);
        SceneComponent sceneComponent2 = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent2, (String)"myComponent");
        SceneComponent sceneComponent3 = sceneComponent2.getParent();
        if (sceneComponent3 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent3, (String)"myComponent.parent ?: return");
        SceneComponent parent = sceneComponent3;
        int dragX = x - this.offsetX;
        int dragY = y - this.offsetY;
        int n = parent.getDrawX();
        int n2 = parent.getDrawX() + parent.getDrawWidth();
        SceneComponent sceneComponent4 = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent4, (String)"myComponent");
        int componentX = Math.max(n, Math.min(dragX, n2 - sceneComponent4.getDrawWidth()));
        int n3 = parent.getDrawY();
        int n4 = parent.getDrawY() + parent.getDrawHeight();
        SceneComponent sceneComponent5 = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent5, (String)"myComponent");
        int componentY = Math.max(n3, Math.min(dragY, n4 - sceneComponent5.getDrawHeight()));
        this.myComponent.setPosition(componentX, componentY, false);
        SceneComponent sceneComponent6 = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent6, (String)"myComponent");
        NlComponent nlComponent = sceneComponent6.getNlComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)nlComponent, (String)"myComponent.nlComponent");
        NlComponent component = nlComponent;
        AttributesTransaction attributesTransaction = component.startAttributeTransaction();
        Intrinsics.checkExpressionValueIsNotNull((Object)attributesTransaction, (String)"component.startAttributeTransaction()");
        AttributesTransaction attributes = attributesTransaction;
        this.updateAttributes(attributes, x, y);
        attributes.apply();
        component.fireLiveChangeEvent();
        SceneComponent sceneComponent7 = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent7, (String)"myComponent");
        sceneComponent7.getScene().repaint();
    }

    private final void updateAttributes(AttributesTransaction attributes, int x, int y) {
        int n;
        int n2;
        block7: {
            int n3;
            int it;
            ListIterator iterator$iv;
            List $this$indexOfLast$iv;
            boolean $i$f$indexOfLast;
            GridDragTarget gridDragTarget;
            GridBarriers b;
            block6: {
                if (this.barrier == null) {
                    return;
                }
                GridBarriers gridBarriers = this.barrier;
                if (gridBarriers == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.android.tools.idea.uibuilder.handlers.grid.GridBarriers");
                }
                b = gridBarriers;
                List list = ArraysKt.slice((Object[])b.getColumns(), (IntRange)RangesKt.until((int)0, (int)ArraysKt.getLastIndex((Object[])b.getColumns())));
                gridDragTarget = this;
                $i$f$indexOfLast = false;
                iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                while (iterator$iv.hasPrevious()) {
                    it = ((Number)iterator$iv.previous()).intValue();
                    boolean bl = false;
                    if (!(x > it)) continue;
                    n3 = iterator$iv.nextIndex();
                    break block6;
                }
                n3 = -1;
            }
            gridDragTarget.selectedColumn = n2 = n3;
            $this$indexOfLast$iv = ArraysKt.slice((Object[])b.getRows(), (IntRange)RangesKt.until((int)0, (int)ArraysKt.getLastIndex((Object[])b.getRows())));
            gridDragTarget = this;
            $i$f$indexOfLast = false;
            iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                it = ((Number)iterator$iv.previous()).intValue();
                boolean bl = false;
                if (!(y > it)) continue;
                n = iterator$iv.nextIndex();
                break block7;
            }
            n = -1;
        }
        gridDragTarget.selectedRow = n2 = n;
        if (this.selectedColumn != -1) {
            attributes.setAttribute(this.nameSpace, "layout_column", String.valueOf(this.selectedColumn));
        }
        if (this.selectedRow != -1) {
            attributes.setAttribute(this.nameSpace, "layout_row", String.valueOf(this.selectedRow));
        }
    }

    public void mouseRelease(int x, int y, @NotNull List<? extends Target> closestTarget) {
        Intrinsics.checkParameterIsNotNull(closestTarget, (String)"closestTarget");
        SceneComponent sceneComponent = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent, (String)"myComponent");
        if (!sceneComponent.isDragging()) {
            return;
        }
        SceneComponent sceneComponent2 = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent2, (String)"myComponent");
        sceneComponent2.setDragging(false);
        SceneComponent sceneComponent3 = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent3, (String)"myComponent");
        NlComponent nlComponent = sceneComponent3.getAuthoritativeNlComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)nlComponent, (String)"myComponent.authoritativeNlComponent");
        NlComponent component = nlComponent;
        AttributesTransaction attributesTransaction = component.startAttributeTransaction();
        Intrinsics.checkExpressionValueIsNotNull((Object)attributesTransaction, (String)"component.startAttributeTransaction()");
        AttributesTransaction attributes = attributesTransaction;
        this.updateAttributes(attributes, x, y);
        attributes.apply();
        if (Math.abs(x - this.firstMouseX) > 1 || Math.abs(y - this.firstMouseY) > 1) {
            NlModel nlModel = component.getModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)nlModel, (String)"component.model");
            WriteCommandAction.writeCommandAction((PsiFile)((PsiFile)nlModel.getFile()), (PsiFile[])new PsiFile[0]).withName("Dragged " + StringUtil.getShortName((String)component.getTagName())).run((ThrowableRunnable)new ThrowableRunnable<Throwable>(attributes){
                final /* synthetic */ AttributesTransaction $attributes;

                public final void run() {
                    this.$attributes.commit();
                }
                {
                    this.$attributes = attributesTransaction;
                }
            });
        }
        this.myComponent.updateTargets();
        SceneComponent sceneComponent4 = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent4, (String)"myComponent");
        sceneComponent4.getScene().needsLayout(1);
        SceneComponent sceneComponent5 = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent5, (String)"myComponent");
        sceneComponent5.getScene().repaint();
    }

    @Override
    protected boolean isHittable() {
        SceneComponent sceneComponent = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent, (String)"myComponent");
        return !sceneComponent.isDragging();
    }

    @Override
    public int getPreferenceLevel() {
        return 20;
    }

    @Override
    @Nullable
    public Cursor getMouseCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    @Override
    public boolean canChangeSelection() {
        return true;
    }

    public GridDragTarget(boolean isSupportLibrary) {
        this.nameSpace = isSupportLibrary ? "http://schemas.android.com/apk/res-auto" : "http://schemas.android.com/apk/res/android";
        this.selectedRow = -1;
        this.selectedColumn = -1;
    }
}

