/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.grid;

import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Placeholder;
import com.android.tools.idea.common.scene.Region;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneInteraction;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.handlers.grid.GridBarriers;
import com.android.tools.idea.uibuilder.handlers.grid.GridDragHandler;
import com.android.tools.idea.uibuilder.handlers.grid.GridPlaceholder;
import com.android.tools.idea.uibuilder.handlers.grid.GridUtilsKt;
import com.android.tools.idea.uibuilder.handlers.grid.targets.GridDragTarget;
import com.android.tools.idea.uibuilder.handlers.grid.targets.GridResizeTarget;
import com.android.tools.idea.uibuilder.scene.target.ResizeBaseTarget;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u0019H\u0014J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0013H\u0016J\u0016\u0010\u001e\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u0019H\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\b2\u0006\u0010!\u001a\u00020\u000bH\u0016J\b\u0010\"\u001a\u00020#H\u0016J(\u0010$\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006("}, d2={"Lcom/android/tools/idea/uibuilder/handlers/grid/GridLayoutHandler;", "Lcom/android/tools/idea/uibuilder/api/ViewGroupHandler;", "()V", "namespace", "", "getNamespace", "()Ljava/lang/String;", "createChildTargets", "", "Lcom/android/tools/idea/common/scene/target/Target;", "parentComponent", "Lcom/android/tools/idea/common/scene/SceneComponent;", "childComponent", "createDragHandler", "Lcom/android/tools/idea/uibuilder/api/DragHandler;", "editor", "Lcom/android/tools/idea/uibuilder/api/ViewEditor;", "layout", "components", "Lcom/android/tools/idea/common/model/NlComponent;", "type", "Lcom/android/tools/idea/common/api/DragType;", "createDragTarget", "", "listBuilder", "Lcom/google/common/collect/ImmutableList$Builder;", "createInteraction", "Lcom/android/tools/idea/common/scene/SceneInteraction;", "screenView", "Lcom/android/tools/idea/uibuilder/surface/ScreenView;", "createResizeTarget", "getPlaceholders", "Lcom/android/tools/idea/common/scene/Placeholder;", "component", "handlesPainting", "", "onChildRemoved", "newChild", "insertType", "Lcom/android/tools/idea/common/api/InsertType;", "intellij.android.designer"})
public class GridLayoutHandler
extends ViewGroupHandler {
    @NotNull
    private final String namespace = "http://schemas.android.com/apk/res/android";

    @NotNull
    protected String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public DragHandler createDragHandler(@NotNull ViewEditor editor2, @NotNull SceneComponent layout2, @NotNull List<? extends NlComponent> components, @NotNull DragType type) {
        Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)layout2, (String)"layout");
        Intrinsics.checkParameterIsNotNull(components, (String)"components");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        return new GridDragHandler(editor2, this, layout2, components, type);
    }

    @Override
    public void onChildRemoved(@NotNull ViewEditor editor2, @NotNull NlComponent layout2, @NotNull NlComponent newChild, @NotNull InsertType insertType) {
        Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)layout2, (String)"layout");
        Intrinsics.checkParameterIsNotNull((Object)newChild, (String)"newChild");
        Intrinsics.checkParameterIsNotNull((Object)((Object)insertType), (String)"insertType");
        newChild.removeAttribute(this.getNamespace(), "layout_row");
        newChild.removeAttribute(this.getNamespace(), "layout_column");
        newChild.removeAttribute(this.getNamespace(), "layout_rowSpan");
        newChild.removeAttribute(this.getNamespace(), "layout_columnSpan");
    }

    @Override
    @NotNull
    public SceneInteraction createInteraction(@NotNull ScreenView screenView, @NotNull NlComponent layout2) {
        Intrinsics.checkParameterIsNotNull((Object)screenView, (String)"screenView");
        Intrinsics.checkParameterIsNotNull((Object)layout2, (String)"layout");
        return new SceneInteraction(screenView);
    }

    @Override
    public boolean handlesPainting() {
        return true;
    }

    @Override
    @NotNull
    public List<Target> createChildTargets(@NotNull SceneComponent parentComponent, @NotNull SceneComponent childComponent) {
        ImmutableList.Builder listBuilder;
        Intrinsics.checkParameterIsNotNull((Object)parentComponent, (String)"parentComponent");
        Intrinsics.checkParameterIsNotNull((Object)childComponent, (String)"childComponent");
        ImmutableList.Builder builder = listBuilder = ImmutableList.builder();
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"listBuilder");
        this.createDragTarget((ImmutableList.Builder<Target>)builder);
        this.createResizeTarget((ImmutableList.Builder<Target>)listBuilder);
        ImmutableList immutableList = listBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"listBuilder.build()");
        return (List)immutableList;
    }

    protected void createDragTarget(@NotNull ImmutableList.Builder<Target> listBuilder) {
        Intrinsics.checkParameterIsNotNull(listBuilder, (String)"listBuilder");
        listBuilder.add((Object)new GridDragTarget(false));
    }

    /*
     * WARNING - void declaration
     */
    private final void createResizeTarget(ImmutableList.Builder<Target> listBuilder) {
        void $this$mapTo$iv$iv;
        ResizeBaseTarget.Type[] $this$map$iv = ResizeBaseTarget.Type.values();
        boolean $i$f$map = false;
        ResizeBaseTarget.Type[] typeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var7_7 = $this$mapTo$iv$iv;
        int n = ((void)var7_7).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var11_11 = item$iv$iv = var7_7[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ImmutableList.Builder builder = listBuilder.add((Object)new GridResizeTarget((ResizeBaseTarget.Type)it));
            collection.add(builder);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Placeholder> getPlaceholders(@NotNull SceneComponent component) {
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        GridBarriers barrier = GridUtilsKt.getGridBarriers(component);
        int n = 0;
        int n2 = ArraysKt.getLastIndex((Object[])barrier.getRows());
        while (n < n2) {
            void row;
            int n3 = 0;
            int n4 = ArraysKt.getLastIndex((Object[])barrier.getColumns());
            while (n3 < n4) {
                void column;
                int left = barrier.getColumns()[column];
                int top = barrier.getRows()[row];
                int right = barrier.getColumns()[column + true];
                int bottom = barrier.getRows()[row + true];
                Region r = new Region(left, top, right, bottom, component.getDepth());
                listBuilder.add((Object)new GridPlaceholder(r, (int)row, (int)column, this.getNamespace(), component));
                ++column;
            }
            ++row;
        }
        ImmutableList immutableList = listBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"listBuilder.build()");
        return (List)immutableList;
    }
}

