/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.targets;

import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawBarrier;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ConstraintDragTarget;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BarrierTarget
extends ConstraintDragTarget {
    int myDirection;
    private static int GAP = 6;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;

    public static int parseDirection(String dir) {
        if ("TOP".equalsIgnoreCase(dir)) {
            return 1;
        }
        if ("BOTTOM".equalsIgnoreCase(dir)) {
            return 2;
        }
        if ("LEFT".equalsIgnoreCase(dir)) {
            return 3;
        }
        if ("RIGHT".equalsIgnoreCase(dir)) {
            return 4;
        }
        if ("START".equalsIgnoreCase(dir)) {
            return 3;
        }
        if ("END".equalsIgnoreCase(dir)) {
            return 4;
        }
        return 1;
    }

    @Override
    @Nullable
    public List<SceneComponent> newSelection() {
        return ImmutableList.of((Object)this.getComponent());
    }

    private boolean isHorizontal() {
        return this.myDirection == 1 || this.myDirection == 2;
    }

    @Override
    public int getPreferenceLevel() {
        return 40;
    }

    public BarrierTarget(int direction) {
        this.myDirection = direction;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (list == null) {
            BarrierTarget.$$$reportNull$$$0(0);
        }
        if (sceneContext == null) {
            BarrierTarget.$$$reportNull$$$0(1);
        }
        if (this.isHorizontal()) {
            DrawBarrier.add(list, sceneContext, this.myLeft, this.myTop, this.myRight - this.myLeft, this.myDirection, this.myComponent.isSelected());
        } else {
            DrawBarrier.add(list, sceneContext, this.myLeft, this.myTop, this.myBottom - this.myTop, this.myDirection, this.myComponent.isSelected());
        }
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        if (sceneTransform == null) {
            BarrierTarget.$$$reportNull$$$0(2);
        }
        int dist = 4;
        SceneComponent parent = this.myComponent.getParent();
        if (parent != null) {
            this.myLeft = parent.getDrawX();
            this.myRight = parent.getDrawX() + parent.getDrawWidth();
            this.myTop = parent.getDrawY();
            this.myBottom = parent.getDrawY() + parent.getDrawHeight();
            switch (this.myDirection) {
                case 1: {
                    this.myTop = t;
                    this.myBottom = t + dist;
                    break;
                }
                case 2: {
                    this.myTop = t;
                    this.myBottom = t + dist;
                    break;
                }
                case 3: {
                    this.myLeft = l;
                    this.myRight = l + dist;
                    break;
                }
                case 4: {
                    this.myLeft = l;
                    this.myRight = l + dist;
                }
            }
        }
        return false;
    }

    @Override
    public void mouseDown(int x, int y) {
        this.myComponent.setSelected(true);
    }

    @Override
    protected void updateAttributes(@NotNull NlAttributesHolder attributes, int x, int y) {
        if (attributes == null) {
            BarrierTarget.$$$reportNull$$$0(3);
        }
    }

    @Override
    public String getToolTipText() {
        switch (this.myDirection) {
            case 1: {
                return "Barrier Top";
            }
            case 2: {
                return "Barrier Bottom";
            }
            case 3: {
                return "Barrier Left";
            }
            case 4: {
                return "Barrier Right";
            }
        }
        return "Barrier Unknown";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneTransform";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/targets/BarrierTarget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "layout";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateAttributes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

