/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import com.android.tools.idea.uibuilder.handlers.constraint.animation.Animation;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ColorSet;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import org.jetbrains.annotations.NotNull;

public class DrawAnchor
extends DrawRegion {
    private final Mode myMode;
    private final boolean myIsConnected;
    private final Type myType;

    public DrawAnchor(int x, int y, int width, int height, Type type, boolean isConnected, Mode mode) {
        super(x, y, width, height);
        this.myMode = mode;
        this.myIsConnected = isConnected;
        this.myType = type;
    }

    private static int getPulseAlpha(int deltaT) {
        return (int)Animation.EaseInOutinterpolator((double)Math.abs(deltaT - 500) / 500.0, 0.0, 255.0);
    }

    @Override
    public int getLevel() {
        if (this.myMode == Mode.OVER) {
            return 80;
        }
        return 50;
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        Composite comp;
        int alpha;
        int delta2;
        int delta;
        if (this.myType == Type.BASELINE) {
            this.paintBaseline(g, sceneContext);
            return;
        }
        ColorSet colorSet = sceneContext.getColorSet();
        Color background = colorSet.getComponentObligatoryBackground();
        Color color = colorSet.getSelectedFrames();
        if (this.myMode == Mode.OVER) {
            if (this.myIsConnected) {
                g.setColor(colorSet.getAnchorDisconnectionCircle());
            } else {
                g.setColor(colorSet.getAnchorConnectionCircle());
            }
            delta = this.width / 3;
            delta2 = delta * 2;
            g.fillRoundRect(this.x - delta, this.y - delta, this.width + delta2, this.height + delta2, this.width + delta2, this.height + delta2);
            g.drawRoundRect(this.x - delta, this.y - delta, this.width + delta2, this.height + delta2, this.width + delta2, this.height + delta2);
        }
        g.setColor(background);
        g.fillRoundRect(this.x, this.y, this.width, this.height, this.width, this.height);
        g.setColor(color);
        g.drawRoundRect(this.x, this.y, this.width, this.height, this.width, this.height);
        delta = this.width / 4;
        delta2 = delta * 2;
        if (this.myIsConnected) {
            g.fillRoundRect(this.x + delta, this.y + delta, this.width - delta2, this.height - delta2, this.width - delta2, this.height - delta2);
            g.drawRoundRect(this.x + delta, this.y + delta, this.width - delta2, this.height - delta2, this.width - delta2, this.height - delta2);
        }
        if (this.myMode == Mode.CAN_CONNECT) {
            alpha = DrawAnchor.getPulseAlpha((int)(sceneContext.getTime() % 1000L));
            comp = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, (float)alpha / 255.0f));
            g.setColor(colorSet.getAnchorConnectionCircle().darker());
            g.fillRoundRect(this.x, this.y, this.width, this.height, this.width, this.height);
            sceneContext.repaint();
            g.setComposite(comp);
        }
        if (this.myMode == Mode.CANNOT_CONNECT) {
            alpha = DrawAnchor.getPulseAlpha((int)(sceneContext.getTime() % 1000L));
            comp = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, (float)alpha / 255.0f));
            g.setColor(colorSet.getAnchorDisconnectionCircle());
            g.fillRoundRect(this.x, this.y, this.width, this.height, this.width, this.height);
            sceneContext.repaint();
            g.setComposite(comp);
        }
        if (this.myMode == Mode.OVER) {
            alpha = DrawAnchor.getPulseAlpha((int)(sceneContext.getTime() % 1000L));
            comp = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, (float)alpha / 255.0f));
            if (this.myIsConnected) {
                g.setColor(colorSet.getAnchorDisconnectionCircle());
            } else {
                g.setColor(colorSet.getAnchorConnectionCircle());
            }
            g.fillRoundRect(this.x, this.y, this.width, this.height, this.width, this.height);
            sceneContext.repaint();
            g.setComposite(comp);
        }
    }

    public void paintBaseline(Graphics2D g, SceneContext sceneContext) {
        Composite comp;
        int alpha;
        int inset = this.width / 10;
        ColorSet colorSet = sceneContext.getColorSet();
        Color background = colorSet.getComponentObligatoryBackground();
        Color color = colorSet.getFrames();
        g.setColor(color);
        g.fillRect(this.x, this.y + this.height / 2, this.width, 1);
        int ovalX = this.x + inset;
        int ovalW = this.width - 2 * inset;
        g.setColor(background);
        g.fillRoundRect(ovalX, this.y, ovalW, this.height, this.height, this.height);
        g.setColor(color);
        g.drawRoundRect(ovalX, this.y, ovalW, this.height, this.height, this.height);
        int delta = 3;
        int delta2 = delta * 2;
        if (this.myIsConnected) {
            g.fillRoundRect(ovalX + delta, this.y + delta, ovalW - delta2, this.height - delta2, this.height - delta2, this.height - delta2);
            g.drawRoundRect(ovalX + delta, this.y + delta, ovalW - delta2, this.height - delta2, this.height - delta2, this.height - delta2);
        }
        if (this.myMode == Mode.CAN_CONNECT) {
            alpha = DrawAnchor.getPulseAlpha((int)(sceneContext.getTime() % 1000L));
            comp = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, (float)alpha / 255.0f));
            g.setColor(colorSet.getAnchorConnectionCircle());
            g.fillRoundRect(ovalX, this.y, ovalW, this.height, this.height, this.height);
            g.drawRoundRect(ovalX, this.y, ovalW, this.height, this.height, this.height);
            sceneContext.repaint();
            g.setComposite(comp);
        }
        if (this.myMode == Mode.OVER) {
            alpha = DrawAnchor.getPulseAlpha((int)(sceneContext.getTime() % 1000L));
            comp = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, (float)alpha / 255.0f));
            if (this.myIsConnected) {
                g.setColor(colorSet.getAnchorDisconnectionCircle());
            } else {
                g.setColor(colorSet.getAnchorConnectionCircle());
            }
            g.fillRoundRect(ovalX, this.y, ovalW, this.height, this.height, this.height);
            g.drawRoundRect(ovalX, this.y, ovalW, this.height, this.height, this.height);
            sceneContext.repaint();
            g.setComposite(comp);
        }
    }

    @Override
    public String serialize() {
        return this.getClass().getSimpleName() + "," + this.x + "," + this.y + "," + this.width + "," + this.height + "," + this.myMode.ordinal();
    }

    public static void add(@NotNull DisplayList list, @NotNull SceneContext transform2, float left, float top, float right, float bottom, Type type, boolean isConnected, Mode mode) {
        if (list == null) {
            DrawAnchor.$$$reportNull$$$0(0);
        }
        if (transform2 == null) {
            DrawAnchor.$$$reportNull$$$0(1);
        }
        int l = transform2.getSwingXDip(left);
        int t = transform2.getSwingYDip(top);
        int w = transform2.getSwingDimensionDip(right - left);
        int h = transform2.getSwingDimensionDip(bottom - top);
        list.add(new DrawAnchor(l, t, w, h, type, isConnected, mode));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "list";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "transform";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/uibuilder/handlers/constraint/draw/DrawAnchor";
        objectArray[2] = "add";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Mode {
        NORMAL,
        OVER,
        CAN_CONNECT,
        CANNOT_CONNECT,
        DO_NOT_DRAW;

    }

    public static enum Type {
        NORMAL,
        BASELINE;

    }
}

