/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class MarginPopup
extends JPanel {
    private JBTextField myTextField = new JBTextField();
    private JButton[] myHistoryButtons = new JButton[4];
    private int[] myDefaultValues = new int[]{0, 8, 16, 24};
    private int[] myHistoryValues = new int[]{-1, -1, -1, -1};
    ActionListener myListener;
    private int myValue = 8;
    private ActionListener myDefaultListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton b = (JButton)e.getSource();
            String s = b.getText();
            try {
                MarginPopup.this.myValue = Integer.parseInt(s);
            }
            catch (NumberFormatException e1) {
                MarginPopup.this.myValue = 0;
                s = "0";
            }
            if (!s.isEmpty()) {
                MarginPopup.this.myTextField.setText(s);
            }
            if (MarginPopup.this.myListener != null) {
                MarginPopup.this.myListener.actionPerformed(e);
            }
            SwingUtilities.getWindowAncestor(MarginPopup.this).setVisible(false);
        }
    };
    private ActionListener mTextListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MarginPopup.this.saveNewValue(e);
            SwingUtilities.getWindowAncestor(MarginPopup.this).setVisible(false);
        }
    };

    public int getValue() {
        return this.myValue;
    }

    private boolean isADefault(int value2) {
        for (int i2 = 0; i2 < this.myDefaultValues.length; ++i2) {
            if (this.myDefaultValues[i2] != value2) continue;
            return true;
        }
        return false;
    }

    public void setActionListener(ActionListener actionListener2) {
        this.myListener = actionListener2;
    }

    void saveNewValue(ActionEvent e) {
        try {
            int value2 = this.myValue = Integer.parseInt(this.myTextField.getText());
            if (!this.isADefault(value2)) {
                for (int i2 = 0; i2 < this.myHistoryValues.length; ++i2) {
                    int old = this.myHistoryValues[i2];
                    this.myHistoryValues[i2] = value2;
                    if (value2 > 0) {
                        this.myHistoryButtons[i2].setText(Integer.toString(value2));
                    }
                    value2 = old;
                }
            }
        }
        catch (NumberFormatException e1) {
            e1.printStackTrace();
        }
        if (this.myListener != null) {
            this.myListener.actionPerformed(e);
        }
    }

    public MarginPopup() {
        super(new GridBagLayout());
        int i2;
        this.setBackground(JBColor.background());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 3;
        gc.insets = JBUI.insets((int)10, (int)5, (int)5, (int)0);
        gc.fill = 1;
        this.myTextField.setHorizontalAlignment(4);
        this.myTextField.setText(Integer.toString(this.myValue));
        this.add((Component)this.myTextField, gc);
        gc.gridx = 3;
        gc.gridwidth = 1;
        gc.insets.bottom = JBUIScale.scale((int)0);
        gc.insets.left = JBUIScale.scale((int)2);
        gc.insets.right = JBUIScale.scale((int)5);
        gc.insets.top = JBUIScale.scale((int)2);
        this.add((Component)new JBLabel("dp"), gc);
        gc.gridwidth = 1;
        gc.gridy = 1;
        gc.insets.bottom = JBUIScale.scale((int)0);
        gc.insets.left = JBUIScale.scale((int)0);
        gc.insets.right = JBUIScale.scale((int)0);
        gc.insets.top = JBUIScale.scale((int)0);
        ((AbstractDocument)this.myTextField.getDocument()).setDocumentFilter(new DocumentFilter(){

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                for (int i2 = 0; i2 < text.length(); ++i2) {
                    if (Character.isDigit(text.charAt(i2))) continue;
                    return;
                }
                super.replace(fb, offset, length, text, attrs);
            }
        });
        gc.fill = 2;
        this.myTextField.addActionListener(this.mTextListener);
        Insets margin = new Insets(0, 0, 0, 0);
        for (i2 = 0; i2 < 4; ++i2) {
            JButton b = new JButton("" + this.myDefaultValues[i2]);
            b.setMargin(margin);
            b.addActionListener(this.myDefaultListener);
            gc.gridx = i2;
            int i22 = i2 == 0 ? 5 : 0;
            gc.insets.left = JBUIScale.scale((int)i22);
            int i1 = i2 == 3 ? 5 : 0;
            gc.insets.right = JBUIScale.scale((int)i1);
            this.add((Component)b, gc);
        }
        gc.gridy = 2;
        gc.insets.bottom = JBUIScale.scale((int)7);
        for (i2 = 0; i2 < this.myHistoryButtons.length; ++i2) {
            this.myHistoryButtons[i2] = new JButton("XXX");
            this.myHistoryButtons[i2].setPreferredSize(this.myHistoryButtons[i2].getPreferredSize());
            this.myHistoryButtons[i2].setMargin(margin);
            if (this.myHistoryValues[i2] > 0) {
                this.myHistoryButtons[i2].setText(Integer.toString(this.myHistoryValues[i2]));
            } else {
                this.myHistoryButtons[i2].setText("");
            }
            this.myHistoryButtons[i2].addActionListener(this.myDefaultListener);
            gc.gridx = i2;
            int i23 = i2 == 0 ? 5 : 0;
            gc.insets.left = JBUIScale.scale((int)i23);
            int i1 = i2 == 3 ? 5 : 0;
            gc.insets.right = JBUIScale.scale((int)i1);
            this.add((Component)this.myHistoryButtons[i2], gc);
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                MarginPopup.this.saveNewValue(null);
            }
        });
    }

    public JComponent getTextField() {
        return this.myTextField;
    }
}

