/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlComponentDelegate;
import com.android.tools.idea.rendering.parsers.AttributeSnapshot;
import com.android.utils.Pair;
import com.intellij.psi.xml.XmlTag;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentModification
implements NlAttributesHolder {
    private final NlComponent myComponent;
    private final NlComponentDelegate myComponentDelegate;
    private final String myLabel;
    HashMap<Pair<String, String>, String> myAttributes;

    public ComponentModification(@NotNull NlComponent component, @NotNull String label) {
        if (component == null) {
            ComponentModification.$$$reportNull$$$0(0);
        }
        if (label == null) {
            ComponentModification.$$$reportNull$$$0(1);
        }
        this.myAttributes = new HashMap();
        this.myComponent = component;
        this.myLabel = label;
        this.myComponentDelegate = this.myComponent.getDelegate();
        List<AttributeSnapshot> attributeSnapshots = component.getAttributes();
        for (AttributeSnapshot snapshot : attributeSnapshots) {
            this.setAttribute(snapshot.namespace, snapshot.name, snapshot.value);
        }
    }

    public NlComponent getComponent() {
        return this.myComponent;
    }

    @Override
    public void setAttribute(@Nullable String namespace, @NotNull String name, @Nullable String value2) {
        if (name == null) {
            ComponentModification.$$$reportNull$$$0(2);
        }
        this.myAttributes.put((Pair<String, String>)Pair.of((Object)namespace, (Object)name), value2);
    }

    @Override
    public String getAttribute(@Nullable String namespace, @NotNull String attribute) {
        if (attribute == null) {
            ComponentModification.$$$reportNull$$$0(3);
        }
        return this.myAttributes.get(Pair.of((Object)namespace, (Object)attribute));
    }

    public HashMap<Pair<String, String>, String> getAttributes() {
        return this.myAttributes;
    }

    @Override
    public void removeAttribute(@NotNull String namespace, @NotNull String name) {
        if (namespace == null) {
            ComponentModification.$$$reportNull$$$0(4);
        }
        if (name == null) {
            ComponentModification.$$$reportNull$$$0(5);
        }
        this.myAttributes.remove(Pair.of((Object)namespace, (Object)name));
    }

    public void apply() {
        if (this.myComponentDelegate != null && this.myComponentDelegate.handlesApply(this)) {
            this.myComponentDelegate.apply(this);
            AttributesTransaction transaction = this.myComponent.startAttributeTransaction();
            for (Pair<String, String> key : this.myAttributes.keySet()) {
                String value2 = this.myAttributes.get(key);
                transaction.setAttribute((String)key.getFirst(), (String)key.getSecond(), value2);
            }
            transaction.apply();
        } else {
            AttributesTransaction transaction = this.myComponent.startAttributeTransaction();
            for (Pair<String, String> key : this.myAttributes.keySet()) {
                String value3 = this.myAttributes.get(key);
                transaction.setAttribute((String)key.getFirst(), (String)key.getSecond(), value3);
            }
            transaction.apply();
        }
    }

    public void commit() {
        if (this.myComponentDelegate != null && this.myComponentDelegate.handlesCommit(this)) {
            this.myComponentDelegate.commit(this);
            this.myComponent.clearTransaction();
            AttributesTransaction transaction = null;
            for (Pair<String, String> key : this.myAttributes.keySet()) {
                if (this.myComponentDelegate.commitToMotionScene(key)) continue;
                String value2 = this.myAttributes.get(key);
                if (transaction == null) {
                    transaction = this.myComponent.startAttributeTransaction();
                }
                transaction.setAttribute((String)key.getFirst(), (String)key.getSecond(), value2);
            }
            if (transaction != null) {
                transaction.apply();
                NlWriteCommandAction.run(this.myComponent, this.myLabel, transaction::commit);
            }
        } else {
            AttributesTransaction transaction = this.myComponent.startAttributeTransaction();
            for (Pair<String, String> key : this.myAttributes.keySet()) {
                String value3 = this.myAttributes.get(key);
                transaction.setAttribute((String)key.getFirst(), (String)key.getSecond(), value3);
            }
            transaction.apply();
            NlWriteCommandAction.run(this.myComponent, this.myLabel, transaction::commit);
        }
    }

    public void commitTo(XmlTag view) {
        for (Pair<String, String> key : this.myAttributes.keySet()) {
            String value2 = this.myAttributes.get(key);
            if (this.myComponentDelegate != null && !this.myComponentDelegate.commitToMotionScene(key)) continue;
            String namespace = (String)key.getFirst();
            if (namespace.equalsIgnoreCase("http://schemas.android.com/tools")) {
                namespace = "http://schemas.android.com/apk/res-auto";
            }
            view.setAttribute((String)key.getSecond(), namespace, value2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ComponentModification";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setAttribute";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getAttribute";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "removeAttribute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

