/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlDependencyManager;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurfaceHelper;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.ui.resourcechooser.ChooseResourceDialog;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.model.NlModelHelperKt;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.lint.checks.AnnotationDetector;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.android.uipreview.ChooseClassDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewEditorImpl
extends ViewEditor {
    private final Configuration myConfiguration;
    private final NlModel myModel;
    private final SceneManager mySceneManager;
    private final Scene myScene;
    private Collection<ViewInfo> myRootViews;
    private NlDependencyManager myDependencyManager;

    public ViewEditorImpl(@NotNull SceneView sceneView) {
        if (sceneView == null) {
            ViewEditorImpl.$$$reportNull$$$0(0);
        }
        this(sceneView.getModel(), sceneView.getScene());
    }

    public ViewEditorImpl(@NotNull NlModel model) {
        if (model == null) {
            ViewEditorImpl.$$$reportNull$$$0(1);
        }
        this(model, null);
    }

    public ViewEditorImpl(@NotNull NlModel model, @Nullable Scene scene) {
        if (model == null) {
            ViewEditorImpl.$$$reportNull$$$0(2);
        }
        this.myConfiguration = model.getConfiguration();
        this.myModel = model;
        this.myScene = scene;
        this.mySceneManager = scene != null ? scene.getSceneManager() : null;
        this.myDependencyManager = NlDependencyManager.Companion.get();
    }

    @Override
    @Nullable
    public AndroidVersion getCompileSdkVersion() {
        return AndroidModuleInfo.getInstance(this.myModel.getFacet()).getBuildSdkVersion();
    }

    @Override
    @NotNull
    public AndroidVersion getMinSdkVersion() {
        AndroidVersion androidVersion = AndroidModuleInfo.getInstance(this.myModel.getFacet()).getMinSdkVersion();
        if (androidVersion == null) {
            ViewEditorImpl.$$$reportNull$$$0(3);
        }
        return androidVersion;
    }

    @Override
    @NotNull
    public AndroidVersion getTargetSdkVersion() {
        AndroidVersion androidVersion = AndroidModuleInfo.getInstance(this.myModel.getFacet()).getTargetSdkVersion();
        if (androidVersion == null) {
            ViewEditorImpl.$$$reportNull$$$0(4);
        }
        return androidVersion;
    }

    @Override
    @NotNull
    public Configuration getConfiguration() {
        Configuration configuration = this.myConfiguration;
        if (configuration == null) {
            ViewEditorImpl.$$$reportNull$$$0(5);
        }
        return configuration;
    }

    @Override
    @NotNull
    public NlModel getModel() {
        NlModel nlModel = this.myModel;
        if (nlModel == null) {
            ViewEditorImpl.$$$reportNull$$$0(6);
        }
        return nlModel;
    }

    @Override
    @NotNull
    public LayoutlibSceneManager getSceneBuilder() {
        assert (this.mySceneManager != null) : "ViewEditorImpl incorrectly configured";
        LayoutlibSceneManager layoutlibSceneManager = (LayoutlibSceneManager)this.mySceneManager;
        if (layoutlibSceneManager == null) {
            ViewEditorImpl.$$$reportNull$$$0(7);
        }
        return layoutlibSceneManager;
    }

    @Override
    @NotNull
    public Collection<ViewInfo> getRootViews() {
        if (this.myRootViews != null) {
            Collection<ViewInfo> collection = this.myRootViews;
            if (collection == null) {
                ViewEditorImpl.$$$reportNull$$$0(8);
            }
            return collection;
        }
        RenderResult result2 = this.getSceneBuilder().getRenderResult();
        if (result2 == null) {
            List<ViewInfo> list = Collections.emptyList();
            if (list == null) {
                ViewEditorImpl.$$$reportNull$$$0(9);
            }
            return list;
        }
        ImmutableList<ViewInfo> immutableList = result2.getRootViews();
        if (immutableList == null) {
            ViewEditorImpl.$$$reportNull$$$0(10);
        }
        return immutableList;
    }

    public void setRootViews(@NotNull Collection<ViewInfo> rootViews) {
        if (rootViews == null) {
            ViewEditorImpl.$$$reportNull$$$0(11);
        }
        this.myRootViews = rootViews;
    }

    @Override
    @Nullable
    public Map<NlComponent, Dimension> measureChildren(@NotNull NlComponent parent, @Nullable RenderTask.AttributeFilter filter2) {
        if (parent == null) {
            ViewEditorImpl.$$$reportNull$$$0(12);
        }
        HashMap unweightedSizes = Maps.newHashMap();
        XmlTag parentTag = parent.getTag();
        if (parentTag.isValid()) {
            if (parent.getChildCount() == 0) {
                return Collections.emptyMap();
            }
            HashMap tagToComponent = Maps.newHashMapWithExpectedSize((int)parent.getChildCount());
            for (NlComponent child : parent.getChildren()) {
                tagToComponent.put(child.getTag(), child);
            }
            NlModel model = this.myModel;
            XmlFile xmlFile = model.getFile();
            Module module = model.getModule();
            RenderService renderService = RenderService.getInstance(module.getProject());
            RenderTask task = renderService.taskBuilder(model.getFacet(), this.getConfiguration()).withPsiFile((PsiFile)xmlFile).build();
            if (task == null) {
                return null;
            }
            Map<XmlTag, ViewInfo> map2 = task.measureChildren(parentTag, filter2);
            task.dispose();
            if (map2 != null) {
                for (Map.Entry<XmlTag, ViewInfo> entry : map2.entrySet()) {
                    ViewInfo viewInfo = entry.getValue();
                    viewInfo = RenderService.getSafeBounds(viewInfo);
                    Dimension size = new Dimension(viewInfo.getRight() - viewInfo.getLeft(), viewInfo.getBottom() - viewInfo.getTop());
                    NlComponent child = (NlComponent)tagToComponent.get(entry.getKey());
                    if (child == null) continue;
                    unweightedSizes.put(child, size);
                }
            }
        }
        return unweightedSizes;
    }

    @Override
    @Nullable
    public String displayResourceInput(@NotNull String title, @NotNull EnumSet<ResourceType> types, boolean includeSampleData) {
        String resource;
        if (title == null) {
            ViewEditorImpl.$$$reportNull$$$0(13);
        }
        if (types == null) {
            ViewEditorImpl.$$$reportNull$$$0(14);
        }
        NlModel model = this.myModel;
        ChooseResourceDialog dialog = ChooseResourceDialog.builder().setModule(model.getModule()).setTypes(types).setConfiguration(model.getConfiguration()).setShowSampleDataPicker(includeSampleData).build();
        if (!title.isEmpty()) {
            dialog.setTitle(title);
        }
        dialog.show();
        if (dialog.isOK() && (resource = dialog.getResourceName()) != null && !resource.isEmpty()) {
            return resource;
        }
        return null;
    }

    @Override
    @Nullable
    public String displayClassInput(@NotNull String title, @NotNull Set<String> superTypes, @Nullable Predicate<String> filter2, @Nullable String currentValue) {
        if (title == null) {
            ViewEditorImpl.$$$reportNull$$$0(15);
        }
        if (superTypes == null) {
            ViewEditorImpl.$$$reportNull$$$0(16);
        }
        Module module = this.myModel.getModule();
        String[] superTypesArray = ArrayUtilRt.toStringArray(superTypes);
        Predicate<PsiClass> psiFilter = ChooseClassDialog.getIsPublicAndUnrestrictedFilter();
        if (filter2 == null) {
            filter2 = ChooseClassDialog.getIsUserDefinedFilter();
        }
        psiFilter = psiFilter.and(ChooseClassDialog.qualifiedNameFilter(filter2));
        return ChooseClassDialog.openDialog(module, title, currentValue, psiFilter, superTypesArray);
    }

    static boolean isPublicAndUnRestricted(@NotNull PsiClass psiClass) {
        PsiModifierList modifiers;
        if (psiClass == null) {
            ViewEditorImpl.$$$reportNull$$$0(17);
        }
        if ((modifiers = psiClass.getModifierList()) == null) {
            return false;
        }
        if (!modifiers.hasModifierProperty("public")) {
            return false;
        }
        for (PsiAnnotation annotation : modifiers.getAnnotations()) {
            if (!AnnotationDetector.RESTRICT_TO_ANNOTATION.isEquals(annotation.getQualifiedName())) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Scene getScene() {
        assert (this.myScene != null) : "ViewEditorImpl incorrectly configured";
        Scene scene = this.myScene;
        if (scene == null) {
            ViewEditorImpl.$$$reportNull$$$0(18);
        }
        return scene;
    }

    @Override
    public boolean canInsertChildren(@NotNull NlComponent parent, @NotNull List<NlComponent> children, int index) {
        if (parent == null) {
            ViewEditorImpl.$$$reportNull$$$0(19);
        }
        if (children == null) {
            ViewEditorImpl.$$$reportNull$$$0(20);
        }
        return this.getModel().canAddComponents(children, parent, ViewEditorImpl.getChild(parent, index));
    }

    @Override
    public void insertChildren(@NotNull NlComponent parent, @NotNull List<NlComponent> children, int index, @NotNull InsertType insertType) {
        if (parent == null) {
            ViewEditorImpl.$$$reportNull$$$0(21);
        }
        if (children == null) {
            ViewEditorImpl.$$$reportNull$$$0(22);
        }
        if (insertType == null) {
            ViewEditorImpl.$$$reportNull$$$0(23);
        }
        this.getModel().addComponents(children, parent, ViewEditorImpl.getChild(parent, index), insertType, this.myScene.getDesignSurface());
    }

    @Override
    @NotNull
    public NlDependencyManager getDependencyManager() {
        NlDependencyManager nlDependencyManager = this.myDependencyManager;
        if (nlDependencyManager == null) {
            ViewEditorImpl.$$$reportNull$$$0(24);
        }
        return nlDependencyManager;
    }

    @Nullable
    private static NlComponent getChild(@NotNull NlComponent parent, int index) {
        if (parent == null) {
            ViewEditorImpl.$$$reportNull$$$0(25);
        }
        return 0 <= index && index < parent.getChildCount() ? parent.getChild(index) : null;
    }

    @Override
    public void openResourceFile(@NotNull String resourceId) {
        if (resourceId == null) {
            ViewEditorImpl.$$$reportNull$$$0(26);
        }
        DesignSurfaceHelper.openResource(this.myConfiguration, resourceId, this.myModel.getVirtualFile());
    }

    @NotNull
    public static ViewEditor getOrCreate(@NotNull Scene scene) {
        if (scene == null) {
            ViewEditorImpl.$$$reportNull$$$0(27);
        }
        ViewEditor viewEditor = ((LayoutlibSceneManager)scene.getSceneManager()).getViewEditor();
        if (viewEditor == null) {
            ViewEditorImpl.$$$reportNull$$$0(28);
        }
        return viewEditor;
    }

    @Override
    public boolean moduleDependsOnAppCompat() {
        return NlModelHelperKt.moduleDependsOnAppCompat(this.myModel);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 24: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 24: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneView";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/ViewEditorImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootViews";
                break;
            }
            case 12: 
            case 19: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superTypes";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertType";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceId";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scene";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/ViewEditorImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinSdkVersion";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetSdkVersion";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneBuilder";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootViews";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getScene";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyManager";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 24: 
            case 28: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setRootViews";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "measureChildren";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "displayResourceInput";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "displayClassInput";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isPublicAndUnRestricted";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "canInsertChildren";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "insertChildren";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getChild";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "openResourceFile";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 24: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

