/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.target.ComponentAssistantActionTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.res.SampleDataResourceItem;
import com.android.tools.idea.res.SampleDataResourceRepository;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.android.tools.idea.uibuilder.handlers.assistant.ImageViewAssistant;
import com.android.tools.idea.uibuilder.model.NlModelHelperKt;
import com.android.tools.idea.uibuilder.property.assistant.ComponentAssistantFactory;
import com.android.xml.XmlBuilder;
import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageViewHandler
extends ViewHandler {
    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        ImmutableList immutableList = ImmutableList.of((Object)"src", (Object)"tools:src", (Object)"contentDescription", (Object)"background", (Object)"scaleType", (Object)"adjustViewBounds", (Object)"cropToPadding");
        if (immutableList == null) {
            ImageViewHandler.$$$reportNull$$$0(0);
        }
        return immutableList;
    }

    @Override
    @NotNull
    public String getPreferredProperty() {
        if ("src" == null) {
            ImageViewHandler.$$$reportNull$$$0(1);
        }
        return "src";
    }

    @Override
    @NotNull
    @Language(value="XML")
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        if (tagName == null) {
            ImageViewHandler.$$$reportNull$$$0(2);
        }
        if (xmlType == null) {
            ImageViewHandler.$$$reportNull$$$0(3);
        }
        String string = new XmlBuilder().startTag(tagName).androidAttribute("src", this.getSampleImageSrc()).androidAttribute("layout_width", "wrap_content").androidAttribute("layout_height", "wrap_content").endTag(tagName).toString();
        if (string == null) {
            ImageViewHandler.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public boolean onCreate(@NotNull ViewEditor editor2, @Nullable NlComponent parent, @NotNull NlComponent newChild, @NotNull InsertType insertType) {
        if (editor2 == null) {
            ImageViewHandler.$$$reportNull$$$0(5);
        }
        if (newChild == null) {
            ImageViewHandler.$$$reportNull$$$0(6);
        }
        if (insertType == null) {
            ImageViewHandler.$$$reportNull$$$0(7);
        }
        if (insertType == InsertType.CREATE) {
            String src = ImageViewHandler.getSrcAttribute(newChild);
            if (src != null && !src.equals(this.getSampleImageSrc())) {
                this.setSrcAttribute(newChild, src);
                return true;
            }
            return this.showImageChooser(editor2, newChild);
        }
        if (insertType.isCreate()) {
            this.setSrcAttribute(newChild, this.getSampleImageSrc());
        }
        return true;
    }

    private boolean showImageChooser(@NotNull ViewEditor editor2, @NotNull NlComponent component) {
        String src;
        if (editor2 == null) {
            ImageViewHandler.$$$reportNull$$$0(8);
        }
        if (component == null) {
            ImageViewHandler.$$$reportNull$$$0(9);
        }
        if ((src = editor2.displayResourceInput(EnumSet.of(ResourceType.DRAWABLE), true)) != null) {
            if (src.startsWith("@sample/") || src.startsWith("@tools:sample/")) {
                this.setToolsSrc(component, src);
                this.setSrcAttribute(component, null);
            } else {
                this.setSrcAttribute(component, src);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public String getSampleImageSrc() {
        if ("@tools:sample/avatars" == null) {
            ImageViewHandler.$$$reportNull$$$0(10);
        }
        return "@tools:sample/avatars";
    }

    private static String getSrcAttribute(@NotNull NlComponent newChild) {
        String src;
        if (newChild == null) {
            ImageViewHandler.$$$reportNull$$$0(11);
        }
        if ((src = newChild.getAttribute("http://schemas.android.com/apk/res/android", "src")) == null) {
            src = newChild.getAttribute("http://schemas.android.com/apk/res-auto", "srcCompat");
        }
        return src;
    }

    public void setSrcAttribute(@NotNull NlComponent component, @Nullable String imageSource) {
        if (component == null) {
            ImageViewHandler.$$$reportNull$$$0(12);
        }
        NlWriteCommandAction.run(component, "", () -> {
            if (ImageViewHandler.shouldUseSrcCompat(component.getModel())) {
                component.setAttribute("http://schemas.android.com/apk/res/android", "src", null);
                component.setAttribute("http://schemas.android.com/apk/res-auto", "srcCompat", imageSource);
            } else {
                component.setAttribute("http://schemas.android.com/apk/res/android", "src", imageSource);
                component.setAttribute("http://schemas.android.com/apk/res-auto", "srcCompat", null);
            }
        });
    }

    public void setToolsSrc(@NotNull NlComponent component, @Nullable SampleDataResourceItem item, int resourceValueIndex) {
        if (component == null) {
            ImageViewHandler.$$$reportNull$$$0(13);
        }
        if (item != null) {
            String suffix = resourceValueIndex >= 0 ? "[" + resourceValueIndex + "]" : "";
            this.setToolsSrc(component, ImageViewHandler.getResourcePrefix(item.getNamespace()) + item.getName() + suffix);
        } else {
            this.setToolsSrc(component, null);
        }
    }

    public void setToolsSrc(@NotNull NlComponent component, @Nullable String value2) {
        if (component == null) {
            ImageViewHandler.$$$reportNull$$$0(14);
        }
        String attr = ImageViewHandler.shouldUseSrcCompat(component.getModel()) ? "srcCompat" : "src";
        NlWriteCommandAction.run(component, "Set sample source", () -> component.setAttribute("http://schemas.android.com/tools", attr, value2));
    }

    @Nullable
    public String getToolsSrc(@NotNull NlComponent component) {
        if (component == null) {
            ImageViewHandler.$$$reportNull$$$0(15);
        }
        String attr = ImageViewHandler.shouldUseSrcCompat(component.getModel()) ? "srcCompat" : "src";
        return component.getAttribute("http://schemas.android.com/tools", attr);
    }

    @NotNull
    private static String getResourcePrefix(ResourceNamespace namespace) {
        String packageName;
        String prefix = SampleDataResourceRepository.PREDEFINED_SAMPLES_NS.equals((Object)namespace) ? "@tools:sample/" : (ResourceNamespace.TODO().equals((Object)namespace) ? "@sample/" : ((packageName = namespace.getPackageName()) != null ? "@" + packageName + ":" + "@sample/".substring(1) : "@sample/"));
        String string = prefix;
        if (string == null) {
            ImageViewHandler.$$$reportNull$$$0(16);
        }
        return string;
    }

    public static boolean shouldUseSrcCompat(@NotNull NlModel model) {
        if (model == null) {
            ImageViewHandler.$$$reportNull$$$0(17);
        }
        return NlModelHelperKt.moduleDependsOnAppCompat(model) && NlModelHelperKt.currentActivityIsDerivedFromAppCompatActivity(model);
    }

    @Nullable
    private ComponentAssistantFactory getComponentAssistant() {
        if (!((Boolean)StudioFlags.NELE_SAMPLE_DATA_UI.get()).booleanValue()) {
            return null;
        }
        return context -> new ImageViewAssistant(context, this).getComponent();
    }

    @Override
    @NotNull
    public List<Target> createTargets(@NotNull SceneComponent sceneComponent) {
        ComponentAssistantFactory panelFactory;
        if (sceneComponent == null) {
            ImageViewHandler.$$$reportNull$$$0(18);
        }
        ImmutableList immutableList = (panelFactory = this.getComponentAssistant()) != null ? ImmutableList.of((Object)new ComponentAssistantActionTarget(panelFactory)) : ImmutableList.of();
        if (immutableList == null) {
            ImageViewHandler.$$$reportNull$$$0(19);
        }
        return immutableList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/ImageViewHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlType";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChild";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertType";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectorProperties";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredProperty";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/ImageViewHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getXml";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSampleImageSrc";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourcePrefix";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargets";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getXml";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onCreate";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showImageChooser";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSrcAttribute";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setSrcAttribute";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setToolsSrc";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getToolsSrc";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "shouldUseSrcCompat";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createTargets";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

