/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import com.android.tools.idea.uibuilder.util.JavaDocViewer;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.function.Supplier;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentHelpAction
extends AnAction {
    private static final String DEFAULT_ANDROID_REFERENCE_PREFIX = "https://developer.android.com/reference/";
    private final Project myProject;
    private final Supplier<String> myTagNameSupplier;

    public ComponentHelpAction(@NotNull Project project, @NotNull Supplier<String> tagNameSupplier) {
        if (project == null) {
            ComponentHelpAction.$$$reportNull$$$0(0);
        }
        if (tagNameSupplier == null) {
            ComponentHelpAction.$$$reportNull$$$0(1);
        }
        super("Android Documentation");
        this.myProject = project;
        this.myTagNameSupplier = tagNameSupplier;
        this.setShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(112, 64)));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        String tagName;
        if (event == null) {
            ComponentHelpAction.$$$reportNull$$$0(2);
        }
        if ((tagName = this.myTagNameSupplier.get()) == null) {
            return;
        }
        String className = this.findClassName(tagName);
        if (className == null) {
            return;
        }
        String reference2 = ComponentHelpAction.computeReferenceFromClassName(className);
        if (reference2 != null) {
            BrowserUtil.browse((String)reference2);
            return;
        }
        PsiClass psiClass = this.findClassByClassName(className);
        if (psiClass == null) {
            return;
        }
        JavaDocViewer.getInstance().showExternalJavaDoc(psiClass, event.getDataContext());
    }

    @Nullable
    private String findClassName(@NotNull String tagName) {
        if (tagName == null) {
            ComponentHelpAction.$$$reportNull$$$0(3);
        }
        if (tagName.indexOf(46) != -1) {
            return tagName;
        }
        if (this.findClassByClassName("android.widget." + tagName) != null) {
            return "android.widget." + tagName;
        }
        if (this.findClassByClassName("android.view." + tagName) != null) {
            return "android.view." + tagName;
        }
        if (this.findClassByClassName("android.webkit." + tagName) != null) {
            return "android.webkit." + tagName;
        }
        return null;
    }

    @Nullable
    private PsiClass findClassByClassName(@NotNull String fullyQualifiedClassName) {
        if (fullyQualifiedClassName == null) {
            ComponentHelpAction.$$$reportNull$$$0(4);
        }
        JavaPsiFacade javaFacade = JavaPsiFacade.getInstance((Project)this.myProject);
        return javaFacade.findClass(fullyQualifiedClassName, GlobalSearchScope.allScope((Project)this.myProject));
    }

    @Nullable
    private static String computeReferenceFromClassName(@NotNull String className) {
        if (className == null) {
            ComponentHelpAction.$$$reportNull$$$0(5);
        }
        if (className.startsWith("android.") || className.startsWith("android.support.") || className.startsWith("androidx.") || className.startsWith("com.google.android.")) {
            return DEFAULT_ANDROID_REFERENCE_PREFIX + StringUtil.replaceChar((String)className, (char)'.', (char)'/') + ".html";
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagNameSupplier";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullyQualifiedClassName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/actions/ComponentHelpAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findClassName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findClassByClassName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "computeReferenceFromClassName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

