/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser.preview;

import com.android.ide.common.resources.ResourceItem;
import com.android.tools.idea.ui.resourcechooser.preview.ResourceEditorTab;
import com.android.tools.idea.ui.resourcechooser.util.SimpleTabUI;
import com.google.common.collect.Lists;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditResourcePanel
extends JBScrollPane {
    private JPanel myFullPanel;
    private JTextField myResourceNameField;
    private JComboBox myVariantComboBox;
    private JBLabel myResourceNameMessage;
    private JTabbedPane myEditorTabs;
    @NotNull
    private List<ResourceItem> myVariants;
    @NotNull
    private final Map<Component, ResourceEditorTab> myAllTabs;

    public EditResourcePanel(@Nullable String resourceName) {
        this.$$$setupUI$$$();
        this.myVariants = Collections.emptyList();
        this.myAllTabs = new HashMap<Component, ResourceEditorTab>();
        Color notificationsBackgroundColor = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.NOTIFICATION_BACKGROUND);
        this.myResourceNameMessage.setBackground((Color)(notificationsBackgroundColor == null ? JBColor.YELLOW : notificationsBackgroundColor));
        this.myEditorTabs.setUI(new SimpleTabUI());
        if (resourceName != null) {
            this.myResourceNameField.setText(resourceName);
        }
        this.setBorder(null);
        this.setViewportView(this.myFullPanel);
    }

    @NotNull
    public Dimension getMinimumSize() {
        Insets insets = this.getInsets();
        Dimension dimension2 = new Dimension(this.getViewport().getView().getMinimumSize().width + insets.left + insets.right, super.getMinimumSize().height);
        if (dimension2 == null) {
            EditResourcePanel.$$$reportNull$$$0(0);
        }
        return dimension2;
    }

    public void setResourceName(@NotNull String resourceName) {
        if (resourceName == null) {
            EditResourcePanel.$$$reportNull$$$0(1);
        }
        this.myResourceNameField.setText(resourceName);
    }

    @NotNull
    public String getResourceName() {
        String string = this.myResourceNameField.getText();
        if (string == null) {
            EditResourcePanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getResourceNameMessage() {
        String string = this.myResourceNameMessage.getText();
        if (string == null) {
            EditResourcePanel.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setResourceNameMessage(@NotNull String message) {
        if (message == null) {
            EditResourcePanel.$$$reportNull$$$0(4);
        }
        this.myResourceNameMessage.setText(message);
    }

    @NotNull
    public JTextField getResourceNameField() {
        JTextField jTextField = this.myResourceNameField;
        if (jTextField == null) {
            EditResourcePanel.$$$reportNull$$$0(5);
        }
        return jTextField;
    }

    public void addTab(@NotNull ResourceEditorTab panel2) {
        if (panel2 == null) {
            EditResourcePanel.$$$reportNull$$$0(6);
        }
        this.myAllTabs.put(panel2.getFullPanel(), panel2);
        this.myEditorTabs.addTab(panel2.getTabTitle(), panel2.getFullPanel());
    }

    @NotNull
    public ResourceEditorTab getSelectedTab() {
        ResourceEditorTab resourceEditorTab = this.myAllTabs.get(this.myEditorTabs.getSelectedComponent());
        if (resourceEditorTab == null) {
            EditResourcePanel.$$$reportNull$$$0(7);
        }
        return resourceEditorTab;
    }

    public void setSelectedTab(@NotNull ResourceEditorTab panel2) {
        if (panel2 == null) {
            EditResourcePanel.$$$reportNull$$$0(8);
        }
        this.myEditorTabs.setSelectedComponent(panel2.getFullPanel());
    }

    public void addVariantActionListener(@NotNull ActionListener al) {
        if (al == null) {
            EditResourcePanel.$$$reportNull$$$0(9);
        }
        this.myVariantComboBox.addActionListener(al);
    }

    public void setVariant(@NotNull List<ResourceItem> resources, @Nullable ResourceItem defaultValue) {
        if (resources == null) {
            EditResourcePanel.$$$reportNull$$$0(10);
        }
        if (resources.size() > 1) {
            resources = Lists.newArrayList(resources);
            Collections.sort(resources, (element1, element2) -> {
                String dirName1 = element1.getSource().getParentFileName();
                String dirName2 = element2.getSource().getParentFileName();
                return dirName1.compareTo(dirName2);
            });
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
            String defaultSelection = null;
            for (ResourceItem resource : resources) {
                String name = resource.getSource().getParentFileName();
                model.addElement(name);
                if (defaultSelection != null || resource != defaultValue) continue;
                defaultSelection = name;
            }
            model.setSelectedItem(defaultSelection);
            this.myVariantComboBox.setModel(model);
        }
        this.myVariants = resources;
        this.myVariantComboBox.setVisible(resources.size() > 1);
    }

    @NotNull
    public ResourceItem getSelectedVariant() {
        ResourceItem resourceItem = this.myVariants.size() > 1 ? this.myVariants.get(this.myVariantComboBox.getSelectedIndex()) : this.myVariants.get(0);
        if (resourceItem == null) {
            EditResourcePanel.$$$reportNull$$$0(11);
        }
        return resourceItem;
    }

    public void setSelectedVariant(@NotNull ResourceItem selectedVariant) {
        if (selectedVariant == null) {
            EditResourcePanel.$$$reportNull$$$0(12);
        }
        if (this.myVariants.size() == 1) {
            assert (this.myVariants.get(0) == selectedVariant);
        } else {
            ActionListener[] listeners;
            ComboBoxModel model = this.myVariantComboBox.getModel();
            for (ActionListener l : listeners = this.myVariantComboBox.getActionListeners()) {
                this.myVariantComboBox.removeActionListener(l);
            }
            model.setSelectedItem(model.getElementAt(this.myVariants.indexOf(selectedVariant)));
            for (ActionListener l : listeners) {
                this.myVariantComboBox.addActionListener(l);
            }
        }
    }

    @NotNull
    public Collection<ResourceEditorTab> getAllTabs() {
        Collection<ResourceEditorTab> collection = this.myAllTabs.values();
        if (collection == null) {
            EditResourcePanel.$$$reportNull$$$0(13);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ui/resourcechooser/preview/EditResourcePanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "al";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resources";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedVariant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinimumSize";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ui/resourcechooser/preview/EditResourcePanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceNameMessage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceNameField";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedTab";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedVariant";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTabs";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setResourceName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setResourceNameMessage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addTab";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedTab";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addVariantActionListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setVariant";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedVariant";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTabbedPane jTabbedPane;
        JBLabel jBLabel;
        JComboBox jComboBox;
        JTextField jTextField;
        JPanel jPanel;
        this.myFullPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 5, new Insets(10, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(5, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Name");
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myResourceNameField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myVariantComboBox = jComboBox = new JComboBox();
        jComboBox.setMaximumRowCount(15);
        ((Component)jComboBox).setVisible(false);
        jPanel.add(jComboBox, new GridConstraints(0, 3, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 4, 1, 1, 0, 1, 0, 1, null, new Dimension(10, -1), null));
        this.myResourceNameMessage = jBLabel = new JBLabel();
        jBLabel.setOpaque(true);
        jPanel.add((Component)jBLabel, new GridConstraints(1, 1, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myEditorTabs = jTabbedPane = new JTabbedPane();
        jPanel.add((Component)jTabbedPane, new GridConstraints(2, 0, 1, 5, 0, 3, 3, 3, null, null, null));
        jBLabel2.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myFullPanel;
    }
}

