/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser.colorpicker2;

import com.android.tools.idea.ui.resourcechooser.colorpicker2.ColorPickerModel;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.ColorPipette;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0007B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/ColorPipetteButton;", "Ljavax/swing/JButton;", "colorPickerModel", "Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/ColorPickerModel;", "pipette", "Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/ColorPipette;", "(Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/ColorPickerModel;Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/ColorPipette;)V", "MyCallback", "intellij.android.core"})
public final class ColorPipetteButton
extends JButton {
    private final ColorPickerModel colorPickerModel;
    private final ColorPipette pipette;

    public ColorPipetteButton(@NotNull ColorPickerModel colorPickerModel, @NotNull ColorPipette pipette) {
        Intrinsics.checkParameterIsNotNull((Object)colorPickerModel, (String)"colorPickerModel");
        Intrinsics.checkParameterIsNotNull((Object)pipette, (String)"pipette");
        this.colorPickerModel = colorPickerModel;
        this.pipette = pipette;
        this.setRolloverEnabled(true);
        this.setIcon(this.pipette.getIcon());
        this.setRolloverIcon(this.pipette.getRolloverIcon());
        this.setPressedIcon(this.pipette.getPressedIcon());
        this.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                pipette.pick(new MyCallback(colorPickerModel));
            }
        });
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/ColorPipetteButton$MyCallback;", "Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/ColorPipette$Callback;", "model", "Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/ColorPickerModel;", "(Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/ColorPipetteButton;Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/ColorPickerModel;)V", "getModel", "()Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/ColorPickerModel;", "originalColor", "Ljava/awt/Color;", "cancel", "", "picked", "pickedColor", "update", "updatedColor", "intellij.android.core"})
    private final class MyCallback
    implements ColorPipette.Callback {
        private final Color originalColor;
        @NotNull
        private final ColorPickerModel model;

        @Override
        public void picked(@NotNull Color pickedColor) {
            Intrinsics.checkParameterIsNotNull((Object)pickedColor, (String)"pickedColor");
            this.model.setColor(pickedColor, ColorPipetteButton.this);
        }

        @Override
        public void update(@NotNull Color updatedColor) {
            Intrinsics.checkParameterIsNotNull((Object)updatedColor, (String)"updatedColor");
            this.model.setColor(updatedColor, ColorPipetteButton.this);
        }

        @Override
        public void cancel() {
            this.model.setColor(this.originalColor, ColorPipetteButton.this);
        }

        @NotNull
        public final ColorPickerModel getModel() {
            return this.model;
        }

        public MyCallback(ColorPickerModel model) {
            Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
            this.model = model;
            this.originalColor = this.model.getColor();
        }
    }
}

