/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.SampleDataResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.SampleDataResourceItem;
import com.android.tools.idea.res.SampleDataResourceRepository;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceChooserItem {
    public static final String DEFAULT_FOLDER_NAME = "Default";
    @NotNull
    protected final ResourceType myType;
    @NotNull
    protected final String myName;
    private final HashMap<Integer, Icon> myIcons;

    ResourceChooserItem(@NotNull ResourceType type, @NotNull String name) {
        if (type == null) {
            ResourceChooserItem.$$$reportNull$$$0(0);
        }
        if (name == null) {
            ResourceChooserItem.$$$reportNull$$$0(1);
        }
        this.myIcons = Maps.newHashMapWithExpectedSize((int)2);
        this.myType = type;
        this.myName = name;
    }

    @NotNull
    public List<String> getQualifiers() {
        List<String> list = Collections.singletonList(DEFAULT_FOLDER_NAME);
        if (list == null) {
            ResourceChooserItem.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public ResourceType getType() {
        ResourceType resourceType = this.myType;
        if (resourceType == null) {
            ResourceChooserItem.$$$reportNull$$$0(3);
        }
        return resourceType;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ResourceChooserItem.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getQualifiedName() {
        String string = this.isFramework() ? "android:" + this.getName() : this.getName();
        if (string == null) {
            ResourceChooserItem.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public PathString getFile() {
        return null;
    }

    @Nullable
    public String getPath() {
        return null;
    }

    @Nullable
    public String getFileForQualifiers(String qualifiers) {
        return null;
    }

    @NotNull
    public abstract String getResourceUrl();

    @NotNull
    public ResourceValue getResourceValue() {
        ResourceValueImpl resourceValueImpl = new ResourceValueImpl(ResourceNamespace.fromBoolean((boolean)this.isFramework()), this.getType(), this.getName(), this.getResourceUrl());
        if (resourceValueImpl == null) {
            ResourceChooserItem.$$$reportNull$$$0(6);
        }
        return resourceValueImpl;
    }

    public String toString() {
        return this.getName();
    }

    @Nullable
    public Icon getIcon(int iconSize) {
        return this.myIcons.get(iconSize);
    }

    public void setIcon(@NotNull Icon icon) {
        if (icon == null) {
            ResourceChooserItem.$$$reportNull$$$0(7);
        }
        assert (icon.getIconWidth() == icon.getIconHeight());
        this.myIcons.put(icon.getIconWidth(), icon);
    }

    public abstract boolean isFramework();

    public boolean isAttr() {
        return false;
    }

    public boolean isReference() {
        String s = this.getDefaultValue();
        if (s != null) {
            return s.startsWith("@") || s.startsWith("?");
        }
        return false;
    }

    @Nullable
    public abstract String getDefaultValue();

    @NotNull
    public List<Pair<FolderConfiguration, String>> getQualifiersAndValues() {
        List<Pair<FolderConfiguration, String>> list = Collections.emptyList();
        if (list == null) {
            ResourceChooserItem.$$$reportNull$$$0(8);
        }
        return list;
    }

    public static ResourceChooserItem createProjectItem(@NotNull ResourceType type, @NotNull String name, @NotNull List<ResourceItem> resourceItems) {
        if (type == null) {
            ResourceChooserItem.$$$reportNull$$$0(9);
        }
        if (name == null) {
            ResourceChooserItem.$$$reportNull$$$0(10);
        }
        if (resourceItems == null) {
            ResourceChooserItem.$$$reportNull$$$0(11);
        }
        return new ResourceChooserItemImpl(type, name, resourceItems, false);
    }

    public static ResourceChooserItem createFrameworkItem(@NotNull ResourceType type, @NotNull String name, @NotNull List<ResourceItem> resourceItems) {
        if (type == null) {
            ResourceChooserItem.$$$reportNull$$$0(12);
        }
        if (name == null) {
            ResourceChooserItem.$$$reportNull$$$0(13);
        }
        if (resourceItems == null) {
            ResourceChooserItem.$$$reportNull$$$0(14);
        }
        return new ResourceChooserItemImpl(type, name, resourceItems, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceValue";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiersAndValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setIcon";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createProjectItem";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createFrameworkItem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SampleDataItem
    extends ResourceChooserItem {
        @NotNull
        private final SampleDataResourceItem myItem;
        private int myIndex;

        public SampleDataItem(@NotNull SampleDataResourceItem item) {
            if (item == null) {
                SampleDataItem.$$$reportNull$$$0(0);
            }
            super(ResourceType.SAMPLE_DATA, item.getName());
            this.myIndex = -1;
            this.myItem = item;
        }

        @NotNull
        public SampleDataResourceItem getResourceItem() {
            SampleDataResourceItem sampleDataResourceItem = this.myItem;
            if (sampleDataResourceItem == null) {
                SampleDataItem.$$$reportNull$$$0(1);
            }
            return sampleDataResourceItem;
        }

        @Override
        @NotNull
        public String getResourceUrl() {
            boolean isPredefinedData = SampleDataResourceRepository.PREDEFINED_SAMPLES_NS.equals((Object)this.myItem.getResourceValue().getNamespace());
            String prefix = isPredefinedData ? "@tools:sample/" : "@sample/";
            String string = prefix + this.myName + (this.myIndex >= 0 ? "[" + this.myIndex + "]" : "");
            if (string == null) {
                SampleDataItem.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public boolean isFramework() {
            return false;
        }

        @Override
        @Nullable
        public String getDefaultValue() {
            return (String)Iterables.getFirst((Iterable)this.getSampleDataResourceValue().getValueAsLines(), (Object)this.getResourceUrl());
        }

        @NotNull
        private SampleDataResourceValue getSampleDataResourceValue() {
            SampleDataResourceValue value2;
            SampleDataResourceValue sampleDataResourceValue = value2 = (SampleDataResourceValue)this.myItem.getResourceValue();
            if (sampleDataResourceValue == null) {
                SampleDataItem.$$$reportNull$$$0(3);
            }
            return sampleDataResourceValue;
        }

        public void setValueIndex(int index) {
            if (index >= this.getSampleDataResourceValue().getValueAsLines().size()) {
                throw new IndexOutOfBoundsException();
            }
            this.myIndex = index;
        }

        @Override
        @NotNull
        public List<Pair<FolderConfiguration, String>> getQualifiersAndValues() {
            FolderConfiguration folderConfiguration = new FolderConfiguration();
            List<Pair<FolderConfiguration, String>> list = this.getSampleDataResourceValue().getValueAsLines().stream().limit(10L).map(string -> Pair.create((Object)folderConfiguration, (Object)string)).collect(Collectors.toList());
            if (list == null) {
                SampleDataItem.$$$reportNull$$$0(4);
            }
            return list;
        }

        @Override
        @NotNull
        public ResourceValue getResourceValue() {
            ResourceType type = this.myItem.getContentType() == SampleDataResourceItem.ContentType.IMAGE ? ResourceType.DRAWABLE : this.myItem.getType();
            SampleDataResourceValue value2 = this.getSampleDataResourceValue();
            ResourceValueImpl resourceValueImpl = new ResourceValueImpl(this.myItem.getNamespace(), type, this.myItem.getName(), (String)value2.getValueAsLines().get(0), value2.getLibraryName());
            if (resourceValueImpl == null) {
                SampleDataItem.$$$reportNull$$$0(5);
            }
            return resourceValueImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem$SampleDataItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem$SampleDataItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResourceItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResourceUrl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSampleDataResourceValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQualifiersAndValues";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResourceValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AttrItem
    extends ResourceChooserItem {
        private boolean myFramework;

        public AttrItem(@NotNull ResourceType type, boolean framework, @NotNull String name) {
            if (type == null) {
                AttrItem.$$$reportNull$$$0(0);
            }
            if (name == null) {
                AttrItem.$$$reportNull$$$0(1);
            }
            super(type, name);
            this.myFramework = framework;
        }

        @Override
        public boolean isAttr() {
            return true;
        }

        @Override
        public boolean isFramework() {
            return this.myFramework;
        }

        @Override
        @NotNull
        public String getResourceUrl() {
            if (this.isFramework()) {
                String string = "?android:" + ResourceType.ATTR.getName() + '/' + this.myName;
                if (string == null) {
                    AttrItem.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = "?" + ResourceType.ATTR.getName() + '/' + this.myName;
            if (string == null) {
                AttrItem.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public String toString() {
            return this.getQualifiedName();
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public String getDefaultValue() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem$AttrItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem$AttrItem";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResourceUrl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ResourceChooserItemImpl
    extends ResourceChooserItem {
        @NotNull
        private final List<ResourceItem> myResourceItems;
        private final boolean myIsFramework;

        public ResourceChooserItemImpl(@NotNull ResourceType type, @NotNull String name, @NotNull List<ResourceItem> resourceItems, boolean isFramework) {
            if (type == null) {
                ResourceChooserItemImpl.$$$reportNull$$$0(0);
            }
            if (name == null) {
                ResourceChooserItemImpl.$$$reportNull$$$0(1);
            }
            if (resourceItems == null) {
                ResourceChooserItemImpl.$$$reportNull$$$0(2);
            }
            super(type, name);
            this.myResourceItems = resourceItems;
            this.myIsFramework = isFramework;
        }

        @Override
        public boolean isFramework() {
            return this.myIsFramework;
        }

        @Override
        @Nullable
        public PathString getFile() {
            return !this.myResourceItems.isEmpty() ? this.myResourceItems.get(0).getSource() : null;
        }

        @Override
        @Nullable
        public String getPath() {
            PathString file = this.getFile();
            return file != null ? file.getNativePath() : null;
        }

        @Override
        @Nullable
        public String getFileForQualifiers(String qualifiers) {
            for (ResourceItem item : this.myResourceItems) {
                PathString file;
                if (!qualifiers.equals(item.getConfiguration().getQualifierString()) || (file = item.getSource()) == null) continue;
                return file.getNativePath();
            }
            return null;
        }

        @Override
        @NotNull
        public String getResourceUrl() {
            StringBuilder builder = new StringBuilder("@");
            if (this.isFramework()) {
                builder.append("android:");
            }
            String string = builder.append(this.myType.getName()).append('/').append(this.myName).toString();
            if (string == null) {
                ResourceChooserItemImpl.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public List<String> getQualifiers() {
            HashSet set = Sets.newHashSet();
            for (ResourceItem item : this.myResourceItems) {
                String q = item.getConfiguration().getQualifierString();
                if (!q.isEmpty()) {
                    set.add(q);
                    continue;
                }
                set.add(ResourceChooserItem.DEFAULT_FOLDER_NAME);
            }
            ArrayList<String> qualifiers = new ArrayList<String>(set);
            Collections.sort(qualifiers);
            ArrayList<String> arrayList = qualifiers;
            if (arrayList == null) {
                ResourceChooserItemImpl.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        @Override
        public String getDefaultValue() {
            ResourceItem first = this.myResourceItems.get(0);
            ResourceValue value2 = first.getResourceValue();
            if (value2 != null) {
                return value2.getValue();
            }
            return null;
        }

        @Override
        @NotNull
        public List<Pair<FolderConfiguration, String>> getQualifiersAndValues() {
            ArrayList<Pair<FolderConfiguration, String>> pairs = new ArrayList<Pair<FolderConfiguration, String>>(this.myResourceItems.size());
            for (ResourceItem item : this.myResourceItems) {
                ResourceValue resourceValue2 = item.getResourceValue();
                FolderConfiguration configuration = item.getConfiguration();
                pairs.add((Pair<FolderConfiguration, String>)Pair.create((Object)configuration, (Object)(resourceValue2 != null ? resourceValue2.getValue() : null)));
            }
            ArrayList<Pair<FolderConfiguration, String>> arrayList = pairs;
            if (arrayList == null) {
                ResourceChooserItemImpl.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceItems";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem$ResourceChooserItemImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/ui/resourcechooser/ResourceChooserItem$ResourceChooserItemImpl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResourceUrl";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQualifiers";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQualifiersAndValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

