/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.adtui.treegrid.TreeGrid;
import com.android.tools.adtui.treegrid.TreeGridSpeedSearch;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.editors.theme.ColorUtils;
import com.android.tools.idea.editors.theme.MaterialColorUtils;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.editors.DrawableRendererEditor;
import com.android.tools.idea.editors.theme.attributes.editors.GraphicalResourceRendererEditor;
import com.android.tools.idea.editors.theme.ui.ResourceComponent;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.javadoc.AndroidJavaDocRenderer;
import com.android.tools.idea.rendering.HtmlBuilderHelper;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.res.IdeResourceNameValidator;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.SampleDataResourceItem;
import com.android.tools.idea.res.StateList;
import com.android.tools.idea.ui.resourcechooser.ColorPicker;
import com.android.tools.idea.ui.resourcechooser.FilteringTableModel;
import com.android.tools.idea.ui.resourcechooser.ResourceChooserItem;
import com.android.tools.idea.ui.resourcechooser.ResourceSwatchComponent;
import com.android.tools.idea.ui.resourcechooser.ResourceTableContentProvider;
import com.android.tools.idea.ui.resourcechooser.ResourceTreeContentProvider;
import com.android.tools.idea.ui.resourcechooser.StateListPicker;
import com.android.tools.idea.ui.resourcechooser.groups.ResourceChooserGroup;
import com.android.tools.idea.ui.resourcechooser.groups.ResourceChooserGroups;
import com.android.tools.idea.ui.resourcechooser.icons.IconFactory;
import com.android.tools.idea.ui.resourcechooser.preview.EditResourcePanel;
import com.android.tools.idea.ui.resourcechooser.preview.ResourceDrawablePanel;
import com.android.tools.idea.ui.resourcechooser.preview.ResourceEditorTab;
import com.android.tools.idea.ui.resourcechooser.preview.ResourceTablePanel;
import com.android.tools.idea.ui.resourcechooser.preview.SampleDrawablePanel;
import com.android.tools.idea.ui.resourcechooser.util.SimpleTabUI;
import com.android.tools.idea.util.DefaultIgnorable;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.ColorPickerListener;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.android.actions.CreateResourceFileAction;
import org.jetbrains.android.actions.CreateXmlResourceDialog;
import org.jetbrains.android.actions.CreateXmlResourcePanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.AndroidBaseLayoutRefactoringAction;
import org.jetbrains.android.refactoring.AndroidExtractStyleAction;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class ChooseResourceDialog
extends DialogWrapper {
    private static final String TYPE_KEY = "ResourceType";
    private static final String FOLDER_TYPE_KEY = "ResourceFolderType";
    private static final String GRID_MODE_KEY = "ResourceChooserGridMode";
    private static final String APP_NAMESPACE_LABEL = "Project";
    private static final int GRID_ICON_SIZE = JBUIScale.scale((int)50);
    private static final int GRID_CHECK_SIZE = JBUIScale.scale((int)8);
    private static final int GRID_CELL_SIZE = JBUIScale.scale((int)120);
    private static final int LIST_ICON_SIZE = JBUIScale.scale((int)28);
    private static final int LIST_CHECK_SIZE = JBUIScale.scale((int)5);
    private static final int LIST_CELL_HEIGHT = JBUIScale.scale((int)40);
    static final int TABLE_CELL_HEIGHT = JBUIScale.scale((int)30);
    private static final JBColor LIST_DIVIDER_COLOR = new JBColor((Color)Gray._245, (Color)Gray._80);
    private static final JBInsets LIST_PADDING = JBInsets.create((int)7, (int)6);
    private static final JBDimension PANEL_PREFERRED_SIZE = JBUI.size((int)850, (int)620);
    private static final SimpleTextAttributes SEARCH_MATCH_ATTRIBUTES = new SimpleTextAttributes(null, null, null, 64);
    private static final Action[] EMPTY_ACTIONS = new Action[0];
    private static final ResourceChooserGroup[] EMPTY_RESOURCE_CHOOSER_GROUPS = new ResourceChooserGroup[0];
    private static final Border GRID_SELECTION_BORDER = BorderFactory.createLineBorder(UIUtil.getListSelectionBackground());
    @NotNull
    private final Module myModule;
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final Configuration myConfiguration;
    @Nullable
    private final XmlTag myTag;
    private final JComponent myContentPanel;
    private final JTabbedPane myTabbedPane;
    private final JPanel myAltPane;
    private final JComponent myViewOption;
    private final String myResourceNameSuggestion;
    private final EnumSet<ResourceType> myTypes;
    private final String myInitialValue;
    private final boolean myInitialValueIsFramework;
    private final ResourceNameVisibility myResourceNameVisibility;
    private final boolean myFilterColorStateLists;
    private final boolean myShowSampleDataPicker;
    private boolean myGridMode;
    @Nullable
    private ResourceEditorTab myColorPickerPanel;
    @Nullable
    private ColorPicker myColorPicker;
    @Nullable
    private ResourceEditorTab myStateListPickerPanel;
    @Nullable
    private StateListPicker myStateListPicker;
    @Nullable
    private ResourcePickerListener myResourcePickerListener;
    @NotNull
    private ImmutableMap<String, Color> myContrastColorsWithDescription;
    private boolean myIsBackgroundColor;
    private final SearchTextField mySearchField;
    private final boolean myHideLeftSideActions;
    private String myResultResourceName;
    private boolean myUseGlobalUndo;
    private final IconFactory myIconFactory;
    private RenderTask myRenderTask;
    private final MultiMap<ResourceType, String> myThemAttributes;
    private final Condition<ResourceChooserItem> myFilterCondition;
    private final Map<ResourceType, ResourcePanel> myTypeToPanels;

    @NotNull
    public static Builder builder() {
        Builder builder = new Builder();
        if (builder == null) {
            ChooseResourceDialog.$$$reportNull$$$0(0);
        }
        return builder;
    }

    private ChooseResourceDialog(@NotNull AndroidFacet facet, @NotNull Configuration configuration, @Nullable XmlTag tag, @NotNull EnumSet<ResourceType> types, @Nullable ResourceType defaultType, @Nullable String value2, boolean isFrameworkValue, @NotNull ResourceNameVisibility resourceNameVisibility, @Nullable String resourceNameSuggestion, boolean hideLeftSideActions, boolean filterColorStateLists, boolean showSampleDataPicker) {
        if (facet == null) {
            ChooseResourceDialog.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            ChooseResourceDialog.$$$reportNull$$$0(2);
        }
        if (types == null) {
            ChooseResourceDialog.$$$reportNull$$$0(3);
        }
        if (resourceNameVisibility == null) {
            ChooseResourceDialog.$$$reportNull$$$0(4);
        }
        super(facet.getModule().getProject());
        this.myGridMode = PropertiesComponent.getInstance().getBoolean(GRID_MODE_KEY, false);
        this.myContrastColorsWithDescription = ImmutableMap.of();
        this.myTypeToPanels = Maps.newEnumMap(ResourceType.class);
        this.myModule = facet.getModule();
        this.myFacet = facet;
        this.myConfiguration = configuration;
        this.myTag = tag;
        this.myInitialValue = value2;
        this.myInitialValueIsFramework = isFrameworkValue;
        this.myResourceNameVisibility = resourceNameVisibility;
        this.myShowSampleDataPicker = showSampleDataPicker;
        this.myTypes = types.clone();
        if (this.myTypes.contains(ResourceType.MIPMAP)) {
            this.myTypes.add(ResourceType.DRAWABLE);
            this.myTypes.remove(ResourceType.MIPMAP);
        }
        if (this.myTypes.contains(ResourceType.DRAWABLE) || types.contains(ResourceType.MIPMAP) && !types.contains(ResourceType.COLOR)) {
            this.myTypes.add(ResourceType.COLOR);
        }
        this.myHideLeftSideActions = hideLeftSideActions;
        this.myResourceNameSuggestion = resourceNameSuggestion;
        ResourceResolver resolver = configuration.getResourceResolver();
        assert (resolver != null);
        this.myThemAttributes = ChooseResourceDialog.initializeThemeAttributes(configuration, resolver, facet);
        ResourceValue resValue = null;
        if (value2 != null) {
            resValue = resolver.findResValue(value2, isFrameworkValue);
        }
        this.myViewOption = this.createViewOptions();
        this.myTabbedPane = this.initializeTabbedPane(defaultType);
        if (this.myTabbedPane == null) {
            this.myAltPane = new JPanel(new BorderLayout());
            this.myAltPane.setPreferredSize((Dimension)PANEL_PREFERRED_SIZE);
            this.myAltPane.setBorder((Border)JBUI.Borders.emptyLeft((int)12));
        } else {
            this.myAltPane = null;
        }
        this.myContentPanel = new JPanel(new BorderLayout());
        this.myContentPanel.add(this.myTabbedPane != null ? this.myTabbedPane : this.myAltPane);
        this.mySearchField = this.createSearchField();
        this.myContentPanel.add((Component)this.createToolbar(), "North");
        this.myFilterColorStateLists = filterColorStateLists;
        this.myFilterCondition = item -> {
            String string;
            ResourcePanel panel2 = this.getSelectedPanel();
            String text = this.mySearchField.getText();
            List<Color> cachedColorResolution = null;
            if (this.myFilterColorStateLists && panel2.getType() == ResourceType.COLOR && (cachedColorResolution = ResourceHelper.resolveMultipleColors((RenderResources)this.getResourceResolver(), item.getResourceValue(), this.myModule.getProject())).size() > 1) {
                return false;
            }
            if (text.isEmpty()) {
                return true;
            }
            if (panel2.getType() == ResourceType.COLOR && text.startsWith("#")) {
                assert (item.getType() == ResourceType.COLOR);
                Color color = ResourceHelper.parseColor(text);
                return (cachedColorResolution == null ? ResourceHelper.resolveMultipleColors((RenderResources)this.getResourceResolver(), item.getResourceValue(), this.myModule.getProject()) : cachedColorResolution).contains(color);
            }
            if (item.getType() == ResourceType.STRING && StringUtil.containsIgnoreCase((String)(string = ResourceHelper.resolveStringValue((RenderResources)this.getResourceResolver(), item.getResourceUrl())), (String)text)) {
                return true;
            }
            if (text.endsWith(" ")) {
                return StringUtil.equalsIgnoreCase((CharSequence)item.getName(), (CharSequence)text.trim());
            }
            return StringUtil.containsIgnoreCase((String)item.getName(), (String)text);
        };
        this.myIconFactory = new IconFactory(this::getRenderTask);
        this.setTitle("Resources");
        this.setupViewOptions();
        this.init();
        this.updateFilter();
        this.selectResourceValue(resValue);
        this.doValidate();
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            ChooseResourceDialog.$$$reportNull$$$0(5);
        }
        return module;
    }

    @NotNull
    public AndroidFacet getFacet() {
        AndroidFacet androidFacet = this.myFacet;
        if (androidFacet == null) {
            ChooseResourceDialog.$$$reportNull$$$0(6);
        }
        return androidFacet;
    }

    private void selectResourceValue(@Nullable ResourceValue resValue) {
        if (resValue != null) {
            ResourcePanel panel2 = this.getSelectedPanel();
            if (panel2.select(resValue)) {
                return;
            }
            ResourceType type = resValue instanceof StyleItemResourceValue ? ResolutionUtils.getAttrType((StyleItemResourceValue)resValue, this.myConfiguration) : resValue.getResourceType();
            if (type != null && type != ResourceType.SAMPLE_DATA && (panel2 = this.getPanel(this.myTabbedPane, type)) != null) {
                if (this.myTabbedPane != null) {
                    this.myTabbedPane.setSelectedComponent(panel2.myComponent.getParent());
                }
                if (!panel2.select(resValue) && type == ResourceType.COLOR) {
                    panel2.showPreview(null, true);
                }
            }
        }
    }

    private static MultiMap<ResourceType, String> initializeThemeAttributes(@NotNull Configuration configuration, @NotNull ResourceResolver resolver, @NotNull AndroidFacet facet) {
        if (configuration == null) {
            ChooseResourceDialog.$$$reportNull$$$0(7);
        }
        if (resolver == null) {
            ChooseResourceDialog.$$$reportNull$$$0(8);
        }
        if (facet == null) {
            ChooseResourceDialog.$$$reportNull$$$0(9);
        }
        MultiMap attrs = new MultiMap();
        String themeName = configuration.getTheme();
        for (StyleItemResourceValue item : ResolutionUtils.getThemeAttributes(resolver, themeName)) {
            ResourceType type = ResolutionUtils.getAttrType(item, configuration);
            if (type == null || !ResourceHelper.isAccessibleInXml((ResourceValue)item, facet)) continue;
            attrs.putValue((Object)type, (Object)ResolutionUtils.getQualifiedItemAttrName(item));
        }
        return attrs;
    }

    private boolean allowColors() {
        return this.myTypes.contains(ResourceType.COLOR);
    }

    private boolean allowDrawables() {
        return this.myTypes.contains(ResourceType.DRAWABLE) || this.myTypes.contains(ResourceType.MIPMAP);
    }

    @NotNull
    private JComponent createToolbar() {
        Box toolbar = Box.createHorizontalBox();
        toolbar.add((Component)this.mySearchField);
        toolbar.add(Box.createHorizontalStrut(JBUIScale.scale((int)20)));
        toolbar.add(this.myViewOption);
        toolbar.add(Box.createHorizontalGlue());
        JBLabel addNew = new JBLabel("Add new resource");
        addNew.setIcon(PlatformIcons.COMBOBOX_ARROW_ICON);
        addNew.setHorizontalTextPosition(2);
        addNew.setIconTextGap(0);
        if (ScreenReader.isActive()) {
            addNew.setFocusable(true);
        }
        toolbar.add((Component)addNew);
        MyAddNewResourceLabelListener listener2 = new MyAddNewResourceLabelListener();
        addNew.addMouseListener((MouseListener)listener2);
        addNew.addKeyListener((KeyListener)listener2);
        toolbar.setBorder(new CompoundBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)0, (int)0, (int)1, (int)0), JBUI.Borders.empty((int)8)));
        Box box = toolbar;
        if (box == null) {
            ChooseResourceDialog.$$$reportNull$$$0(10);
        }
        return box;
    }

    private JComponent createViewOptions() {
        ToggleAction listView = this.createListViewAction();
        ToggleAction gridView = this.createGridViewAction();
        DefaultActionGroup group = new DefaultActionGroup(new AnAction[]{listView, gridView});
        JComponent component = ActionManager.getInstance().createActionToolbar("ResourceViewOptionToolbar", (ActionGroup)group, true).getComponent();
        component.setBorder(null);
        component.setMaximumSize(new Dimension(JBUIScale.scale((int)100), component.getMaximumSize().height));
        return component;
    }

    @Nullable
    private JTabbedPane initializeTabbedPane(@Nullable ResourceType defaultType) {
        if (this.myTypes.size() <= 1) {
            return null;
        }
        JTabbedPane pane = new JTabbedPane(2);
        pane.setName("ResourceTypeTabs");
        pane.setUI(new SimpleTabUI());
        ArrayList sorted = Lists.newArrayList(this.myTypes);
        sorted.sort(Comparator.comparingInt(ChooseResourceDialog::typeRank));
        int defaultTypesIndex = 0;
        int currentTypeIndex = 0;
        for (ResourceType type : sorted) {
            JPanel container = new JPanel(new BorderLayout());
            container.setPreferredSize((Dimension)PANEL_PREFERRED_SIZE);
            container.putClientProperty(ResourceType.class, type);
            pane.addTab(type.getDisplayName(), container);
            if (type.equals((Object)defaultType)) {
                defaultTypesIndex = currentTypeIndex;
            }
            ++currentTypeIndex;
        }
        pane.setSelectedIndex(defaultTypesIndex);
        pane.addChangeListener(e -> this.handleTabChange());
        return pane;
    }

    private static int typeRank(ResourceType type) {
        switch (type) {
            case DRAWABLE: {
                return 0;
            }
            case COLOR: {
                return 1;
            }
        }
        return type.ordinal() + 2;
    }

    private void handleTabChange() {
        ResourcePanel panel2 = this.getSelectedPanel();
        panel2.configureList(this.myGridMode);
        this.updateFilter();
        this.setupViewOptions();
    }

    @NotNull
    private ResourcePanel getSelectedPanel() {
        if (this.myTabbedPane != null) {
            JPanel selectedComponent = (JPanel)this.myTabbedPane.getSelectedComponent();
            ResourceType type = (ResourceType)selectedComponent.getClientProperty(ResourceType.class);
            ResourcePanel resourcePanel = this.getPanel(this.myTabbedPane, type);
            if (resourcePanel == null) {
                ChooseResourceDialog.$$$reportNull$$$0(11);
            }
            return resourcePanel;
        }
        ResourcePanel resourcePanel = this.getPanel(null, (ResourceType)this.myTypes.iterator().next());
        if (resourcePanel == null) {
            ChooseResourceDialog.$$$reportNull$$$0(12);
        }
        return resourcePanel;
    }

    private ResourcePanel getPanel(@Nullable JTabbedPane tabbedPane2, @NotNull ResourceType resourceType) {
        ResourcePanel panel2;
        ResourceType type;
        if (resourceType == null) {
            ChooseResourceDialog.$$$reportNull$$$0(13);
        }
        if ((type = resourceType) == ResourceType.MIPMAP) {
            type = ResourceType.DRAWABLE;
        }
        if ((panel2 = this.myTypeToPanels.get(type)) == null) {
            boolean includeFileResources = type != ResourceType.COLOR || !this.allowDrawables() || !this.myFilterColorStateLists;
            panel2 = new ResourcePanel(type, includeFileResources, this.myThemAttributes.get((Object)type), this.myShowSampleDataPicker);
            panel2.expandAll();
            JPanel container = this.myAltPane;
            if (container == null && tabbedPane2 != null) {
                int n = tabbedPane2.getComponentCount();
                for (int i2 = 0; i2 < n; ++i2) {
                    JPanel tab = (JPanel)tabbedPane2.getComponentAt(i2);
                    if (tab.getClientProperty(ResourceType.class) != type) continue;
                    container = tab;
                    break;
                }
            }
            if (container != null) {
                container.add((Component)panel2.myComponent, "Center");
                this.myTypeToPanels.put(type, panel2);
            }
        }
        return panel2;
    }

    @NotNull
    private ToggleAction createGridViewAction() {
        ToggleAction toggleAction = new ToggleAction(null, "grid", StudioIcons.LayoutEditor.Palette.GRID_VIEW){

            public boolean isSelected(AnActionEvent e) {
                return ChooseResourceDialog.this.myGridMode;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                ChooseResourceDialog.this.setGridMode(state);
            }
        };
        if (toggleAction == null) {
            ChooseResourceDialog.$$$reportNull$$$0(14);
        }
        return toggleAction;
    }

    @NotNull
    private ToggleAction createListViewAction() {
        ToggleAction toggleAction = new ToggleAction(null, "list", StudioIcons.LayoutEditor.Palette.LIST_VIEW){

            public boolean isSelected(AnActionEvent e) {
                return !ChooseResourceDialog.this.myGridMode;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                ChooseResourceDialog.this.setGridMode(!state);
            }
        };
        if (toggleAction == null) {
            ChooseResourceDialog.$$$reportNull$$$0(15);
        }
        return toggleAction;
    }

    @NotNull
    private AnAction createNewResourceValueAction() {
        AnAction anAction = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                ResourceType type = (ResourceType)this.getTemplatePresentation().getClientProperty(ChooseResourceDialog.TYPE_KEY);
                ChooseResourceDialog.this.createNewResourceValue(type);
            }
        };
        if (anAction == null) {
            ChooseResourceDialog.$$$reportNull$$$0(16);
        }
        return anAction;
    }

    @NotNull
    private AnAction createNewResourceFileAction() {
        AnAction anAction = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                ResourceFolderType type = (ResourceFolderType)this.getTemplatePresentation().getClientProperty(ChooseResourceDialog.FOLDER_TYPE_KEY);
                ChooseResourceDialog.this.createNewResourceFile(type);
            }
        };
        if (anAction == null) {
            ChooseResourceDialog.$$$reportNull$$$0(17);
        }
        return anAction;
    }

    @NotNull
    private AbstractAction createNewResourceAction() {
        AbstractAction abstractAction = new AbstractAction("New Resource", AllIcons.General.ComboArrowDown){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComponent component = (JComponent)e.getSource();
                ActionPopupMenu popupMenu = ChooseResourceDialog.this.createNewResourcePopupMenu();
                popupMenu.getComponent().show(component, 0, component.getHeight());
            }
        };
        if (abstractAction == null) {
            ChooseResourceDialog.$$$reportNull$$$0(18);
        }
        return abstractAction;
    }

    @NotNull
    private AnAction createExtractStyleAction() {
        AnAction anAction = new AnAction("Extract Style..."){

            public void actionPerformed(AnActionEvent e) {
                ChooseResourceDialog.this.extractStyle();
            }
        };
        if (anAction == null) {
            ChooseResourceDialog.$$$reportNull$$$0(19);
        }
        return anAction;
    }

    @NotNull
    private AnAction createNewResourceReferenceAction() {
        AnAction anAction = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                ResourcePanel panel2 = ChooseResourceDialog.this.getSelectedPanel();
                panel2.showNewResource(panel2.myReferencePanel);
            }
        };
        if (anAction == null) {
            ChooseResourceDialog.$$$reportNull$$$0(20);
        }
        return anAction;
    }

    @NotNull
    private SearchTextField createSearchField() {
        SearchTextField searchField = new SearchTextField(false){

            protected void showPopup() {
            }
        };
        searchField.getTextEditor().addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 40) {
                    e.consume();
                    ChooseResourceDialog.this.getSelectedPanel().selectFirst();
                }
            }
        });
        searchField.setMaximumSize(new Dimension(JBUIScale.scale((int)300), searchField.getMaximumSize().height));
        searchField.addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ChooseResourceDialog.this.updateFilter();
            }
        });
        SearchTextField searchTextField = searchField;
        if (searchTextField == null) {
            ChooseResourceDialog.$$$reportNull$$$0(21);
        }
        return searchTextField;
    }

    private void updateFilter() {
        String text = this.mySearchField.getText();
        ResourcePanel panel2 = this.getSelectedPanel();
        panel2.setShowFiltered(!text.isEmpty());
        if (text.isEmpty() && !this.myFilterColorStateLists && panel2.isFiltered()) {
            panel2.setFilter(null);
        }
        panel2.setFilter(this.myFilterCondition);
    }

    private void initializeColorPicker(@Nullable String value2, @NotNull ResourceNameVisibility resourceNameVisibility, ResourceResolver resolver, ResourceValue resValue) {
        if (resourceNameVisibility == null) {
            ChooseResourceDialog.$$$reportNull$$$0(22);
        }
        Color color = null;
        if (resValue != null) {
            color = ResourceHelper.resolveColor((RenderResources)resolver, resValue, this.myModule.getProject());
        }
        if (color == null) {
            color = ResourceHelper.parseColor(value2);
        }
        this.myColorPicker = new ColorPicker(this.myDisposable, color, true, new ColorPickerListener(){

            public void colorChanged(Color color) {
                ChooseResourceDialog.this.notifyResourcePickerListeners(ResourceHelper.colorToString(color));
            }

            public void closed(@Nullable Color color) {
            }
        });
        this.myColorPicker.pickARGB();
        this.myColorPickerPanel = new ResourceEditorTab(this.myModule, "Color", this.myColorPicker, resourceNameVisibility, ResourceFolderType.VALUES, true, ResourceType.COLOR){

            @Override
            @NotNull
            public String doSave() {
                String value2 = ResourceHelper.colorToString(ChooseResourceDialog.this.myColorPicker.getColor());
                if (this.getResourceNameVisibility() == ResourceNameVisibility.FORCE || this.getResourceNameVisibility() == ResourceNameVisibility.SHOW && !ChooseResourceDialog.this.getSelectedPanel().myEditorPanel.getResourceName().isEmpty()) {
                    value2 = ChooseResourceDialog.this.saveValuesResource(ChooseResourceDialog.this.getSelectedPanel().myEditorPanel.getResourceName(), value2, this.getLocationSettings());
                }
                String string = value2;
                if (string == null) {
                    12.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog$12", "doSave"));
            }
        };
    }

    private void ensurePickersInitialized() {
        boolean allowDrawables = this.allowDrawables();
        boolean allowColors = this.allowColors();
        if (allowColors || allowDrawables) {
            ResourceFolderType stateListFolderType;
            ResourceType stateListType;
            if (this.myStateListPicker != null || this.myColorPicker != null) {
                return;
            }
            Configuration configuration = this.getConfiguration();
            ResourceResolver resolver = configuration.getResourceResolver();
            assert (resolver != null);
            ResourceValue resValue = null;
            if (this.myInitialValue != null) {
                resValue = resolver.findResValue(this.myInitialValue, this.myInitialValueIsFramework);
            }
            if (allowDrawables) {
                stateListType = ResourceType.DRAWABLE;
                stateListFolderType = ResourceFolderType.DRAWABLE;
            } else {
                stateListType = ResourceType.COLOR;
                stateListFolderType = ResourceFolderType.COLOR;
            }
            this.initializeStateListPicker(configuration, resolver, resValue, stateListType, stateListFolderType);
            this.initializeColorPicker(this.myInitialValue, this.myResourceNameVisibility, resolver, resValue);
        }
    }

    private void initializeStateListPicker(@NotNull Configuration configuration, ResourceResolver resolver, ResourceValue resValue, ResourceType stateListType, ResourceFolderType stateListFolderType) {
        if (configuration == null) {
            ChooseResourceDialog.$$$reportNull$$$0(23);
        }
        StateList stateList = null;
        if (resValue != null && (stateList = ResourceHelper.resolveStateList((RenderResources)resolver, resValue, this.myModule.getProject())) != null && stateList.getType() != stateListType) {
            Logger.getInstance(ChooseResourceDialog.class).warn("StateList type mismatch " + stateList.getType() + " " + stateListType);
            stateList = null;
        }
        this.myStateListPicker = new StateListPicker(stateList, this.myModule, configuration);
        this.myStateListPickerPanel = new ResourceEditorTab(this.myModule, "Statelist", this.myStateListPicker, ResourceNameVisibility.FORCE, stateListFolderType, false, stateListType){

            @Override
            @Nullable
            public ValidationInfo doValidate() {
                ValidationInfo error = super.doValidate();
                if (error == null) {
                    int minDirectoriesApi = ThemeEditorUtils.getMinFolderApi(this.getLocationSettings().getDirNames(), ChooseResourceDialog.this.myModule);
                    error = ChooseResourceDialog.this.myStateListPicker.doValidate(minDirectoriesApi);
                }
                return error;
            }

            @Override
            @NotNull
            public String doSave() {
                String stateListName = ChooseResourceDialog.this.getSelectedPanel().myEditorPanel.getResourceName();
                Module module = this.getSelectedModule();
                VirtualFile resDir = this.getResourceDirectory();
                List<String> dirNames = this.getLocationSettings().getDirNames();
                ResourceFolderType resourceFolderType = ResourceFolderType.getFolderType((String)dirNames.get(0));
                assert (resourceFolderType != null);
                ResourceType resourceType = FolderTypeRelationship.getNonIdRelatedResourceType((ResourceFolderType)resourceFolderType);
                Project project = module.getProject();
                List<VirtualFile> files2 = null;
                if (resDir == null) {
                    AndroidUtils.reportError(project, AndroidBundle.message("check.resource.dir.error", module.getName()));
                } else if (resourceType != null) {
                    files2 = AndroidResourceUtil.findOrCreateStateListFiles(project, resDir, resourceFolderType, resourceType, stateListName, dirNames);
                }
                if (files2 != null) {
                    assert (ChooseResourceDialog.this.myStateListPicker != null);
                    StateList stateList1 = ChooseResourceDialog.this.myStateListPicker.getStateList();
                    assert (stateList1 != null);
                    AndroidResourceUtil.updateStateList(project, stateList1, files2);
                }
                if (resourceFolderType == ResourceFolderType.COLOR) {
                    String string = "@color/" + stateListName;
                    if (string == null) {
                        13.$$$reportNull$$$0(0);
                    }
                    return string;
                }
                assert (resourceFolderType == ResourceFolderType.DRAWABLE);
                String string = "@drawable/" + stateListName;
                if (string == null) {
                    13.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog$13", "doSave"));
            }
        };
    }

    @NotNull
    Configuration getConfiguration() {
        Configuration configuration = this.myConfiguration;
        if (configuration == null) {
            ChooseResourceDialog.$$$reportNull$$$0(24);
        }
        return configuration;
    }

    private void setupViewOptions() {
        this.myViewOption.setVisible(this.getSelectedPanel().supportsGridMode());
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            ChooseResourceDialog.$$$reportNull$$$0(25);
        }
        return dialogStyle;
    }

    public void setContrastParameters(@NotNull ImmutableMap<String, Color> contrastColorsWithDescription, boolean isBackground, boolean displayWarning) {
        if (contrastColorsWithDescription == null) {
            ChooseResourceDialog.$$$reportNull$$$0(26);
        }
        this.ensurePickersInitialized();
        if (this.myColorPicker != null) {
            this.myColorPicker.setContrastParameters(contrastColorsWithDescription, isBackground, displayWarning);
        }
        if (this.myStateListPicker != null) {
            this.myStateListPicker.setContrastParameters(contrastColorsWithDescription, isBackground);
        }
        this.myContrastColorsWithDescription = contrastColorsWithDescription;
        this.myIsBackgroundColor = isBackground;
    }

    protected boolean postponeValidation() {
        return false;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.getSelectedPanel().doValidate();
    }

    public void setResourcePickerListener(@Nullable ResourcePickerListener resourcePickerListener) {
        this.myResourcePickerListener = resourcePickerListener;
    }

    private void notifyResourcePickerListeners(@Nullable String resource) {
        if (this.myResourcePickerListener != null) {
            this.myResourcePickerListener.resourceChanged(resource);
        }
    }

    public void generateColorSuggestions(@NotNull Color primaryColor, @NotNull String attributeName) {
        if (primaryColor == null) {
            ChooseResourceDialog.$$$reportNull$$$0(27);
        }
        if (attributeName == null) {
            ChooseResourceDialog.$$$reportNull$$$0(28);
        }
        List<Color> suggestedColors = null;
        switch (attributeName) {
            case "colorPrimary": {
                suggestedColors = MaterialColorUtils.suggestPrimaryColors();
                break;
            }
            case "colorPrimaryDark": {
                suggestedColors = MaterialColorUtils.suggestPrimaryDarkColors(primaryColor);
                break;
            }
            case "colorAccent": {
                suggestedColors = MaterialColorUtils.suggestAccentColors(primaryColor);
            }
        }
        if (suggestedColors != null) {
            this.ensurePickersInitialized();
            assert (this.myColorPicker != null);
            this.myColorPicker.setRecommendedColors(suggestedColors);
        }
    }

    private ActionPopupMenu createNewResourcePopupMenu() {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        ResourcePanel panel2 = this.getSelectedPanel();
        ResourceType resourceType = panel2.getType();
        ResourceFolderType folderType = FolderTypeRelationship.getNonValuesRelatedFolder((ResourceType)resourceType);
        if (folderType != null) {
            AnAction newFileAction = this.createNewResourceFileAction();
            newFileAction.getTemplatePresentation().setText("New " + folderType.getName() + " File...");
            newFileAction.getTemplatePresentation().putClientProperty(FOLDER_TYPE_KEY, (Object)folderType);
            actionGroup.add(newFileAction);
        }
        if (AndroidResourceUtil.VALUE_RESOURCE_TYPES.contains(resourceType)) {
            String title = "New " + resourceType + " Value...";
            if (resourceType == ResourceType.LAYOUT) {
                title = "New Layout Alias";
            }
            AnAction newValueAction = this.createNewResourceValueAction();
            newValueAction.getTemplatePresentation().setText(title);
            newValueAction.getTemplatePresentation().putClientProperty(TYPE_KEY, (Object)resourceType);
            actionGroup.add(newValueAction);
        }
        if (this.myTag != null && ResourceType.STYLE.equals((Object)resourceType)) {
            boolean enabled = AndroidBaseLayoutRefactoringAction.getLayoutViewElement(this.myTag) != null && AndroidExtractStyleAction.doIsEnabled(this.myTag);
            AnAction extractStyleAction = this.createExtractStyleAction();
            extractStyleAction.getTemplatePresentation().setEnabled(enabled);
            actionGroup.add(extractStyleAction);
        }
        if (GraphicalResourceRendererEditor.COLORS_AND_DRAWABLES.contains(resourceType)) {
            AnAction newReferenceAction = this.createNewResourceReferenceAction();
            newReferenceAction.getTemplatePresentation().setText("New " + resourceType + " Reference...");
            actionGroup.add(newReferenceAction);
        }
        return actionManager.createActionPopupMenu("unknown", (ActionGroup)actionGroup);
    }

    private void createNewResourceValue(ResourceType resourceType) {
        this.ensurePickersInitialized();
        if (resourceType == ResourceType.COLOR && this.myColorPickerPanel != null) {
            this.getSelectedPanel().showNewResource(this.myColorPickerPanel);
            return;
        }
        CreateXmlResourceDialog dialog = new CreateXmlResourceDialog(this.myModule, resourceType, null, null, true, null, null);
        dialog.setTitle("New " + StringUtil.capitalize((String)resourceType.getDisplayName()) + " Value Resource");
        if (!dialog.showAndGet()) {
            return;
        }
        Project project = this.myModule.getProject();
        VirtualFile resDir = dialog.getResourceDirectory();
        if (resDir == null) {
            AndroidUtils.reportError(project, AndroidBundle.message("check.resource.dir.error", this.myModule));
            return;
        }
        String fileName = dialog.getFileName();
        List<String> dirNames = dialog.getDirNames();
        String resValue = dialog.getValue();
        String resName = dialog.getResourceName();
        if (!AndroidResourceUtil.createValueResource(project, resDir, resName, resourceType, fileName, dirNames, resValue)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)this.myModule.getProject()).commitAllDocuments();
        this.myResultResourceName = "@" + resourceType.getName() + "/" + resName;
        this.close(0);
    }

    private void createNewResourceFile(ResourceFolderType folderType) {
        this.ensurePickersInitialized();
        if (this.myStateListPicker != null && this.myStateListPicker.getStateList() != null && folderType == this.myStateListPicker.getStateList().getFolderType()) {
            assert (this.myStateListPickerPanel != null);
            this.getSelectedPanel().showNewResource(this.myStateListPickerPanel);
            return;
        }
        XmlFile newFile = CreateResourceFileAction.createFileResource(this.myFacet, folderType, null, null, null, true, null, null, null);
        if (newFile != null) {
            String name = newFile.getName();
            int index = name.lastIndexOf(46);
            if (index != -1) {
                name = name.substring(0, index);
            }
            this.myResultResourceName = "@" + folderType.getName() + "/" + name;
            this.close(0);
        }
    }

    private void extractStyle() {
        assert (this.myTag != null);
        String resName = AndroidExtractStyleAction.doExtractStyle(this.myModule, this.myTag, false, null);
        if (resName == null) {
            return;
        }
        this.myResultResourceName = "@style/" + resName;
        this.close(0);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySearchField;
    }

    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    @NotNull
    protected Action[] getCreateActions() {
        Action[] actionArray;
        if (!this.myHideLeftSideActions) {
            Action[] actionArray2 = new Action[1];
            actionArray = actionArray2;
            actionArray2[0] = this.createNewResourceAction();
        } else {
            actionArray = EMPTY_ACTIONS;
        }
        if (actionArray == null) {
            ChooseResourceDialog.$$$reportNull$$$0(29);
        }
        return actionArray;
    }

    public void openLocationSettings() {
        this.ensurePickersInitialized();
        if (this.myColorPickerPanel != null) {
            this.myColorPickerPanel.setLocationSettingsOpen(true);
        }
        if (this.myStateListPickerPanel != null) {
            this.myStateListPickerPanel.setLocationSettingsOpen(true);
        }
        this.getSelectedPanel().myReferencePanel.setLocationSettingsOpen(true);
    }

    public String getResourceName() {
        return this.myResultResourceName;
    }

    protected void doOKAction() {
        ResourceChooserItem item;
        ResourcePanel resourcePanel = this.getSelectedPanel();
        ResourceEditorTab editor2 = resourcePanel.getCurrentResourceEditor();
        this.notifyResourcePickerListeners(null);
        this.myResultResourceName = editor2 != null ? editor2.doSave() : ((item = resourcePanel.getSelectedItem()) != null ? item.getResourceUrl() : null);
        super.doOKAction();
    }

    private void setGridMode(boolean gridMode) {
        if (gridMode != this.myGridMode) {
            this.myGridMode = gridMode;
            this.getSelectedPanel().configureList(this.myGridMode);
            PropertiesComponent.getInstance().setValue(GRID_MODE_KEY, gridMode, false);
        }
    }

    public void setUseGlobalUndo() {
        this.myUseGlobalUndo = true;
    }

    @Nullable
    private Icon getIcon(@NotNull ResourceChooserItem item, int size, int checkerboardSize, @Nullable Runnable onLoadComplete) {
        Icon cachedIcon;
        if (item == null) {
            ChooseResourceDialog.$$$reportNull$$$0(30);
        }
        if ((cachedIcon = item.getIcon(size)) != null) {
            return cachedIcon;
        }
        switch (item.getType()) {
            case DRAWABLE: 
            case COLOR: 
            case MIPMAP: {
                Icon icon = null;
                String path = item.getPath();
                if (path != null) {
                    icon = this.myIconFactory.createIconFromPath(size, checkerboardSize, true, item.getPath());
                }
                if (icon == null) {
                    icon = this.myIconFactory.createAsyncIconFromResourceValue(size, checkerboardSize, true, item.getResourceValue(), (Icon)EmptyIcon.create((int)size), onLoadComplete);
                }
                item.setIcon(icon);
                return icon;
            }
        }
        return null;
    }

    @NotNull
    private ResourceSwatchComponent.SwatchIcon getSwatchIcon(@Nullable String name) {
        ResourceSwatchComponent.SwatchIcon swatchIcon = StateListPicker.getSwatchIcon(name, this.getResourceResolver(), this.getRenderTask());
        if (swatchIcon == null) {
            ChooseResourceDialog.$$$reportNull$$$0(31);
        }
        return swatchIcon;
    }

    @NotNull
    private ResourceResolver getResourceResolver() {
        Configuration config = this.getConfiguration();
        ResourceResolver resolver = config.getResourceResolver();
        assert (resolver != null);
        ResourceResolver resourceResolver = resolver;
        if (resourceResolver == null) {
            ChooseResourceDialog.$$$reportNull$$$0(32);
        }
        return resourceResolver;
    }

    @NotNull
    private RenderTask getRenderTask() {
        if (this.myRenderTask == null) {
            this.myRenderTask = DrawableRendererEditor.configureRenderTask(this.myModule, this.getConfiguration());
            Disposer.register((Disposable)this.getDisposable(), () -> this.myRenderTask.dispose());
            this.myRenderTask.setMaxRenderSize(150, 150);
        }
        RenderTask renderTask = this.myRenderTask;
        if (renderTask == null) {
            ChooseResourceDialog.$$$reportNull$$$0(33);
        }
        return renderTask;
    }

    @NotNull
    private String saveValuesResource(@NotNull String name, @NotNull String value2, @NotNull CreateXmlResourcePanel locationSettings) {
        if (name == null) {
            ChooseResourceDialog.$$$reportNull$$$0(34);
        }
        if (value2 == null) {
            ChooseResourceDialog.$$$reportNull$$$0(35);
        }
        if (locationSettings == null) {
            ChooseResourceDialog.$$$reportNull$$$0(36);
        }
        ResourceType type = locationSettings.getType();
        String fileName = locationSettings.getFileName();
        List<String> dirNames = locationSettings.getDirNames();
        Project project = this.myModule.getProject();
        VirtualFile resDir = locationSettings.getResourceDirectory();
        if (resDir == null) {
            AndroidUtils.reportError(project, AndroidBundle.message("check.resource.dir.error", this.myModule.getName()));
        } else if (!AndroidResourceUtil.changeValueResource(project, resDir, name, type, value2, fileName, dirNames, this.myUseGlobalUndo)) {
            AndroidResourceUtil.createValueResource(project, resDir, name, type, fileName, dirNames, value2);
        }
        String string = "@" + type + "/" + name;
        if (string == null) {
            ChooseResourceDialog.$$$reportNull$$$0(37);
        }
        return string;
    }

    @NotNull
    private static EnumSet<ResourceType> getAllowedTypes(@NotNull ResourceType type) {
        if (type == null) {
            ChooseResourceDialog.$$$reportNull$$$0(38);
        }
        switch (type) {
            case COLOR: {
                EnumSet<ResourceType> enumSet = GraphicalResourceRendererEditor.COLORS_ONLY;
                if (enumSet == null) {
                    ChooseResourceDialog.$$$reportNull$$$0(39);
                }
                return enumSet;
            }
            case DRAWABLE: {
                EnumSet<ResourceType> enumSet = GraphicalResourceRendererEditor.DRAWABLES_ONLY;
                if (enumSet == null) {
                    ChooseResourceDialog.$$$reportNull$$$0(40);
                }
                return enumSet;
            }
        }
        EnumSet<ResourceType> enumSet = EnumSet.of(type);
        if (enumSet == null) {
            ChooseResourceDialog.$$$reportNull$$$0(41);
        }
        return enumSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 38: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 38: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: 
            case 7: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 4: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceNameVisibility";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contrastColorsWithDescription";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primaryColor";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationSettings";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "builder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacet";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedPanel";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createGridViewAction";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createListViewAction";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewResourceValueAction";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewResourceFileAction";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewResourceAction";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtractStyleAction";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewResourceReferenceAction";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchField";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateActions";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getSwatchIcon";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceResolver";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderTask";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "saveValuesResource";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllowedTypes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "initializeThemeAttributes";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPanel";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "initializeColorPicker";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "initializeStateListPicker";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setContrastParameters";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "generateColorSuggestions";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "saveValuesResource";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getAllowedTypes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 38: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyAddNewResourceLabelListener
    extends MouseAdapter
    implements KeyListener {
        private MyAddNewResourceLabelListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.handle(e);
        }

        public void handle(InputEvent e) {
            Action[] actions2;
            DefaultActionGroup group = new DefaultActionGroup();
            final Component source = (Component)e.getSource();
            DataContext context = SimpleDataContext.getSimpleContext((String)PlatformDataKeys.CONTEXT_COMPONENT.getName(), (Object)source, null);
            for (final Action action2 : actions2 = ChooseResourceDialog.this.getCreateActions()) {
                AnAction anAction = new AnAction(){

                    public void actionPerformed(AnActionEvent e) {
                        action2.actionPerformed(new ActionEvent(source, 0, ""));
                    }

                    public void update(AnActionEvent e) {
                        Presentation presentation = e.getPresentation();
                        String name = (String)action2.getValue("Name");
                        if (name != null) {
                            presentation.setText(name);
                        }
                    }
                };
                if (actions2.length == 1) {
                    AnActionEvent actionEvent = AnActionEvent.createFromInputEvent((InputEvent)e, (String)ChooseResourceDialog.class.getSimpleName(), (Presentation)new Presentation(), (DataContext)context);
                    anAction.actionPerformed(actionEvent);
                    return;
                }
                group.add(anAction);
            }
            JBPopupFactory factory = JBPopupFactory.getInstance();
            ListPopup popup2 = factory.createActionGroupPopup(null, (ActionGroup)group, context, true, null, 10);
            popup2.showUnderneathOf(source);
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getModifiers() == 0 && e.getKeyCode() == 32) {
                this.handle(e);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    private class ResourcePanel {
        private static final String NONE = "None";
        private static final String TEXT = "Text";
        private static final String EDITOR = "Editor";
        private static final String DRAWABLE = "Bitmap";
        private static final String TABLE = "Table";
        private static final String SAMPLE_DRAWABLE = "Sample Data";
        @NotNull
        public final JBSplitter myComponent;
        @Nullable
        private TreeGrid<ResourceChooserItem> myList;
        @Nullable
        private JBTable myTable;
        @NotNull
        private final JPanel myPreviewPanel;
        private JLabel myNoPreviewComponent;
        private JTextPane myHtmlTextArea;
        private EditResourcePanel myEditorPanel;
        @Nullable
        private ResourceDrawablePanel myDrawablePanel;
        @Nullable
        private SampleDrawablePanel mySampleImagePanel;
        @Nullable
        private ResourceTablePanel myTablePanel;
        private ResourceComponent myReferenceComponent;
        private ResourceEditorTab myReferencePanel;
        @NotNull
        private ResourceChooserGroup[] myGroups;
        @NotNull
        private final ResourceType myType;
        private ResourceValue mySelectedValue;

        public ResourcePanel(ResourceType type, @NotNull boolean includeFileResources, Collection<String> attrs, boolean showSampleDataPicker) {
            if (type == null) {
                ResourcePanel.$$$reportNull$$$0(0);
            }
            if (attrs == null) {
                ResourcePanel.$$$reportNull$$$0(1);
            }
            this.myGroups = new ResourceChooserGroup[0];
            this.myType = type;
            this.myComponent = new JBSplitter(false, 0.5f);
            Disposable animationDisposable = Disposer.newDisposable();
            JBLoadingPanel loadingPanel = new JBLoadingPanel((LayoutManager)new FlowLayout(), animationDisposable);
            this.myComponent.setFirstComponent((JComponent)loadingPanel);
            loadingPanel.startLoading();
            this.myComponent.setSplitterProportionKey("android.resource_dialog_splitter");
            CompletableFuture.runAsync(() -> {
                ResourceChooserGroup themeItems;
                ResourceChooserGroup frameworkItems;
                ResourceChooserGroup projectItems;
                ResourceChooserGroup sampleDataItems;
                ArrayList groups = Lists.newArrayListWithCapacity((int)4);
                if (showSampleDataPicker && ((Boolean)StudioFlags.NELE_SAMPLE_DATA_UI.get()).booleanValue() && !(sampleDataItems = ResourceChooserGroups.createSampleDataGroup(type, ChooseResourceDialog.this.myFacet)).isEmpty()) {
                    groups.add(sampleDataItems);
                }
                if (!(projectItems = ResourceChooserGroups.createResourceItemsGroup(ChooseResourceDialog.APP_NAMESPACE_LABEL, type, ChooseResourceDialog.this.myFacet, false, includeFileResources)).isEmpty()) {
                    groups.add(projectItems);
                }
                if (!(frameworkItems = ResourceChooserGroups.createResourceItemsGroup("android", type, ChooseResourceDialog.this.myFacet, true, includeFileResources)).isEmpty()) {
                    groups.add(frameworkItems);
                }
                if (!(themeItems = ResourceChooserGroups.createThemeAttributesGroup(type, ChooseResourceDialog.this.myFacet, attrs)).isEmpty()) {
                    groups.add(themeItems);
                }
                this.myGroups = groups.toArray(EMPTY_RESOURCE_CHOOSER_GROUPS);
                JComponent firstComponent = this.createListPanel(this.myGroups);
                firstComponent.setPreferredSize((Dimension)JBUI.size((int)200, (int)600));
                this.myComponent.setFirstComponent(firstComponent);
                Disposer.dispose((Disposable)animationDisposable);
            }, PooledThreadExecutor.INSTANCE).thenRunAsync(() -> {
                ChooseResourceDialog.this.updateFilter();
                this.select(this.mySelectedValue);
            }, (Executor)EdtExecutorService.getInstance());
            this.myPreviewPanel = new JPanel(new CardLayout());
            this.myPreviewPanel.setPreferredSize((Dimension)JBUI.size((int)400, (int)600));
            this.myComponent.setSecondComponent((JComponent)this.myPreviewPanel);
            this.showPreview(null);
        }

        @NotNull
        private JComponent createListPanel(@NotNull ResourceChooserGroup[] groups) {
            TreeGrid component;
            if (groups == null) {
                ResourcePanel.$$$reportNull$$$0(2);
            }
            if (this.myType == ResourceType.DRAWABLE || this.myType == ResourceType.COLOR || this.myType == ResourceType.MIPMAP || this.myType == ResourceType.STYLE || this.myType == ResourceType.ID) {
                ResourceTreeContentProvider treeContentProvider = new ResourceTreeContentProvider(groups);
                TreeGrid list = new TreeGrid((AbstractTreeStructure)treeContentProvider);
                new TreeGridSpeedSearch(list);
                list.addListSelectionListener(e -> {
                    this.showPreview(this.getSelectedItem());
                    ChooseResourceDialog.this.notifyResourcePickerListeners(this.getValueForLivePreview());
                });
                component = this.myList = list;
                this.configureList(ChooseResourceDialog.this.myGridMode);
            } else {
                final ResourceTableContentProvider model = new ResourceTableContentProvider(groups);
                FilteringTableModel<ResourceChooserItem> tableModel = new FilteringTableModel<ResourceChooserItem>(new AbstractTableModel(){

                    @Override
                    public int getRowCount() {
                        return model.getRowCount();
                    }

                    @Override
                    public int getColumnCount() {
                        return model.getColumnCount();
                    }

                    @Override
                    public Object getValueAt(int rowIndex, int columnIndex) {
                        return model.getValueAt(rowIndex, columnIndex);
                    }
                }, ResourceChooserItem.class);
                tableModel.refilter();
                this.myTable = new JBTable(tableModel);
                component = this.myTable;
                component.setName("nameTable");
                this.myTable.setFillsViewportHeight(true);
                this.myTable.setTableHeader(null);
                this.myTable.setBorder(null);
                TableColumnModel columnModel = this.myTable.getColumnModel();
                columnModel.getColumn(0).setHeaderValue("Key");
                columnModel.getColumn(1).setHeaderValue("Default Value");
                columnModel.getColumn(0).setCellRenderer((TableCellRenderer)new ColoredTableCellRenderer(){

                    protected void customizeCellRenderer(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                        boolean isHeader = false;
                        if (value2 instanceof ResourceChooserItem) {
                            ResourceChooserItem item = (ResourceChooserItem)value2;
                            String string = item.getName();
                            String filter2 = ChooseResourceDialog.this.mySearchField.getText();
                            if (!filter2.isEmpty()) {
                                int match = StringUtil.indexOfIgnoreCase((String)string, (String)filter2, (int)0);
                                if (match != -1) {
                                    this.append(string.substring(0, match));
                                    this.append(string.substring(match, match + filter2.length()), SEARCH_MATCH_ATTRIBUTES);
                                    this.append(string.substring(match + filter2.length()));
                                } else {
                                    this.append(string);
                                }
                            } else {
                                this.append(string);
                            }
                        } else {
                            isHeader = true;
                            this.append(value2.toString());
                        }
                        if (isHeader) {
                            this.setFont(StartupUiUtil.getLabelFont().deriveFont(1));
                            if (!isSelected) {
                                this.setBackground(UIUtil.getLabelBackground());
                            }
                        } else {
                            this.setFont(StartupUiUtil.getLabelFont());
                            if (!isSelected) {
                                this.setBackground(table2.getBackground());
                            }
                        }
                    }
                });
                columnModel.getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                        if (value2 instanceof ResourceChooserItem) {
                            value2 = StringUtil.shortenTextWithEllipsis((String)StringUtil.notNullize((String)((ResourceChooserItem)value2).getDefaultValue()), (int)80, (int)10);
                            this.setBackground(table2.getBackground());
                        } else {
                            this.setBackground(UIUtil.getLabelBackground());
                            value2 = "";
                        }
                        return super.getTableCellRendererComponent(table2, value2, isSelected, hasFocus, row, column);
                    }
                });
                this.myTable.setRowHeight(TABLE_CELL_HEIGHT);
                this.myTable.setStriped(false);
                this.myTable.setSelectionMode(0);
                this.myTable.getSelectionModel().addListSelectionListener(e -> {
                    this.showPreview(this.getSelectedItem());
                    ChooseResourceDialog.this.notifyResourcePickerListeners(this.getValueForLivePreview());
                });
                this.myTable.setBorder(BorderFactory.createEmptyBorder());
                TableSpeedSearch speedSearch = new TableSpeedSearch((JTable)this.myTable);
                speedSearch.setClearSearchOnNavigateNoMatch(true);
            }
            new DoubleClickListener(){

                protected boolean onDoubleClick(MouseEvent e) {
                    ResourceChooserItem selected = ResourcePanel.this.getSelectedItem();
                    if (selected != null) {
                        ChooseResourceDialog.this.myResultResourceName = selected.getResourceUrl();
                        ChooseResourceDialog.this.close(0);
                        return true;
                    }
                    return false;
                }
            }.installOn((Component)component);
            JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)component, (int)22, (int)31);
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            scrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            scrollPane.getVerticalScrollBar().setUnitIncrement(JBUIScale.scale((int)16));
            JScrollPane jScrollPane = scrollPane;
            if (jScrollPane == null) {
                ResourcePanel.$$$reportNull$$$0(3);
            }
            return jScrollPane;
        }

        boolean isFiltered() {
            if (this.myList != null) {
                return this.myList.isFiltered();
            }
            return this.myTable != null;
        }

        void setFilter(@Nullable Condition<ResourceChooserItem> condition) {
            if (this.myList != null) {
                this.myList.setFilter(condition);
                if (condition != null) {
                    this.myList.selectIfUnique();
                }
            } else if (this.myTable != null) {
                ((FilteringTableModel)this.myTable.getModel()).setFilter(condition);
                if (condition != null) {
                    TableModel model = this.myTable.getModel();
                    ResourceChooserItem single = null;
                    int rowCount = model.getRowCount();
                    for (int row = 0; row < rowCount; ++row) {
                        Object value2 = model.getValueAt(row, 0);
                        if (!(value2 instanceof ResourceChooserItem)) continue;
                        if (single == null) {
                            single = (ResourceChooserItem)value2;
                            continue;
                        }
                        single = null;
                        break;
                    }
                    if (single != null) {
                        this.setSelectedItem(single);
                    }
                }
            }
        }

        void selectFirst() {
            if (this.myList != null) {
                this.myList.selectFirst();
            } else if (this.myTable != null) {
                List first;
                List<Object> list = first = this.myGroups.length > 0 ? this.myGroups[0].getItems() : Collections.emptyList();
                if (!first.isEmpty()) {
                    this.setSelectedItem((ResourceChooserItem)first.get(0));
                    this.myTable.requestFocus();
                }
            }
        }

        private void showDrawableItem(ResourceChooserItem item) {
            if (this.myDrawablePanel == null) {
                this.myDrawablePanel = new ResourceDrawablePanel(ChooseResourceDialog.this.myConfiguration, ChooseResourceDialog.this.myFacet, ChooseResourceDialog.this.myIconFactory);
                this.myPreviewPanel.add((Component)((Object)this.myDrawablePanel), DRAWABLE);
            }
            CardLayout layout2 = (CardLayout)this.myPreviewPanel.getLayout();
            this.myDrawablePanel.select(item);
            layout2.show(this.myPreviewPanel, DRAWABLE);
        }

        private void showSampleItem(@NotNull ResourceChooserItem.SampleDataItem item) {
            if (item == null) {
                ResourcePanel.$$$reportNull$$$0(4);
            }
            if (this.mySampleImagePanel == null) {
                this.mySampleImagePanel = new SampleDrawablePanel(ChooseResourceDialog.this.myFacet.getModule());
                this.myPreviewPanel.add((Component)this.mySampleImagePanel, SAMPLE_DRAWABLE);
            }
            this.mySampleImagePanel.select(item);
            CardLayout layout2 = (CardLayout)this.myPreviewPanel.getLayout();
            layout2.show(this.myPreviewPanel, SAMPLE_DRAWABLE);
        }

        private void showTableItem(ResourceChooserItem item) {
            if (this.myTablePanel == null) {
                this.myTablePanel = new ResourceTablePanel(ChooseResourceDialog.this.getModule(), (Consumer<Integer>)((Consumer)arg_0 -> ((ChooseResourceDialog)ChooseResourceDialog.this).close(arg_0)), TABLE_CELL_HEIGHT);
                this.myPreviewPanel.add((Component)this.myTablePanel.getPanel(), TABLE);
            } else {
                this.myComponent.skipNextLayout();
            }
            CardLayout layout2 = (CardLayout)this.myPreviewPanel.getLayout();
            this.myTablePanel.select(item);
            layout2.show(this.myPreviewPanel, TABLE);
        }

        private void showEditorPanel() {
            if (this.myEditorPanel == null) {
                this.myReferenceComponent = new ResourceComponent(ChooseResourceDialog.this.myModule.getProject(), true);
                this.myReferenceComponent.addSwatchListener(e -> {
                    String attributeValue = this.myReferenceComponent.getValueText();
                    ResourceUrl attributeValueUrl = ResourceUrl.parse((String)attributeValue);
                    boolean isFrameworkValue = attributeValueUrl != null && attributeValueUrl.isFramework();
                    String nameSuggestion = attributeValueUrl != null ? attributeValueUrl.name : null;
                    ChooseResourceDialog dialog = ChooseResourceDialog.builder().setModule(this.myReferencePanel.getSelectedModule()).setTypes(ChooseResourceDialog.getAllowedTypes(this.myType)).setCurrentValue(attributeValue).setIsFrameworkValue(isFrameworkValue).setResourceNameVisibility(ResourceNameVisibility.FORCE).setResourceNameSuggestion(nameSuggestion).setConfiguration(ChooseResourceDialog.this.getConfiguration()).build();
                    if (ChooseResourceDialog.this.myResourcePickerListener != null) {
                        dialog.setResourcePickerListener(ChooseResourceDialog.this.myResourcePickerListener);
                    }
                    if (!ChooseResourceDialog.this.myContrastColorsWithDescription.isEmpty()) {
                        dialog.setContrastParameters((ImmutableMap<String, Color>)ChooseResourceDialog.this.myContrastColorsWithDescription, ChooseResourceDialog.this.myIsBackgroundColor, true);
                    }
                    dialog.show();
                    if (dialog.isOK()) {
                        String resourceName = dialog.getResourceName();
                        this.myReferenceComponent.setValueText(resourceName);
                        this.myReferenceComponent.repaint();
                    } else {
                        ChooseResourceDialog.this.notifyResourcePickerListeners(this.myReferenceComponent.getValueText());
                    }
                });
                this.myReferenceComponent.addTextDocumentListener(new DocumentListener(){

                    public void documentChanged(com.intellij.openapi.editor.event.DocumentEvent e) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            ResourcePanel.this.updateReferenceSwatchIcon();
                            ChooseResourceDialog.this.notifyResourcePickerListeners(ResourcePanel.this.myReferenceComponent.getValueText());
                        }, ModalityState.any());
                    }
                });
                this.myReferenceComponent.setCompletionStrings(ResourceHelper.getCompletionFromTypes(ChooseResourceDialog.this.myFacet, ChooseResourceDialog.getAllowedTypes(this.myType)));
                Box referenceComponentPanel = new Box(1);
                referenceComponentPanel.setName("ReferenceEditor");
                referenceComponentPanel.add(this.myReferenceComponent);
                referenceComponentPanel.add(Box.createVerticalGlue());
                this.myReferencePanel = new ResourceEditorTab(ChooseResourceDialog.this.myModule, "Reference", referenceComponentPanel, ResourceNameVisibility.FORCE, ResourceFolderType.VALUES, true, this.myType){

                    @Override
                    @Nullable
                    public ValidationInfo doValidate() {
                        ValidationInfo error = super.doValidate();
                        if (error == null) {
                            int minDirectoriesApi = ThemeEditorUtils.getMinFolderApi(this.getLocationSettings().getDirNames(), ChooseResourceDialog.this.myModule);
                            IAndroidTarget target = ChooseResourceDialog.this.getConfiguration().getRealTarget();
                            assert (target != null);
                            AndroidTargetData androidTargetData = AndroidTargetData.getTargetData(target, ChooseResourceDialog.this.myModule);
                            assert (androidTargetData != null);
                            error = ResourcePanel.this.myReferenceComponent.doValidate(minDirectoriesApi, androidTargetData);
                        }
                        return error;
                    }

                    @Override
                    @NotNull
                    public String doSave() {
                        String string = ChooseResourceDialog.this.saveValuesResource(ResourcePanel.this.myEditorPanel.getResourceName(), ResourcePanel.this.myReferenceComponent.getValueText(), this.getLocationSettings());
                        if (string == null) {
                            6.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog$ResourcePanel$6", "doSave"));
                    }
                };
                this.myEditorPanel = new EditResourcePanel(ChooseResourceDialog.this.myResourceNameSuggestion);
                this.myEditorPanel.addVariantActionListener(e -> ChooseResourceDialog.this.getSelectedPanel().editResourceItem(this.myEditorPanel.getSelectedVariant()));
                this.myEditorPanel.addTab(this.myReferencePanel);
                ChooseResourceDialog.this.ensurePickersInitialized();
                if (this.myType == ResourceType.COLOR) {
                    assert (ChooseResourceDialog.this.myColorPickerPanel != null);
                    this.myEditorPanel.addTab(ChooseResourceDialog.this.myColorPickerPanel);
                }
                if (ChooseResourceDialog.this.myStateListPicker != null && ChooseResourceDialog.this.myStateListPicker.getStateList() != null && this.myType == ChooseResourceDialog.this.myStateListPicker.getStateList().getType()) {
                    assert (ChooseResourceDialog.this.myStateListPickerPanel != null);
                    this.myEditorPanel.addTab(ChooseResourceDialog.this.myStateListPickerPanel);
                }
                this.myPreviewPanel.add((Component)((Object)this.myEditorPanel), EDITOR);
            }
            CardLayout layout2 = (CardLayout)this.myPreviewPanel.getLayout();
            layout2.show(this.myPreviewPanel, EDITOR);
        }

        private void updateReferenceSwatchIcon() {
            ResourceSwatchComponent.SwatchIcon icon = ChooseResourceDialog.this.getSwatchIcon(this.myReferenceComponent.getValueText());
            if (icon instanceof ResourceSwatchComponent.ColorIcon) {
                ResourceSwatchComponent.ColorIcon colorIcon = (ResourceSwatchComponent.ColorIcon)icon;
                this.myReferenceComponent.setWarning(ColorUtils.getContrastWarningMessage((Map<String, Color>)ChooseResourceDialog.this.myContrastColorsWithDescription, colorIcon.getColor(), ChooseResourceDialog.this.myIsBackgroundColor));
            } else {
                this.myReferenceComponent.setWarning(null);
            }
            this.myReferenceComponent.setSwatchIcon(icon);
            this.myReferenceComponent.repaint();
        }

        private void showNoPreview() {
            if (this.myNoPreviewComponent == null) {
                this.myNoPreviewComponent = new JLabel("No Preview");
                this.myNoPreviewComponent.setHorizontalAlignment(0);
                this.myNoPreviewComponent.setVerticalAlignment(0);
                this.myPreviewPanel.add((Component)this.myNoPreviewComponent, NONE);
            }
            CardLayout layout2 = (CardLayout)this.myPreviewPanel.getLayout();
            layout2.show(this.myPreviewPanel, NONE);
        }

        private void showHtml(String doc) {
            if (this.myHtmlTextArea == null) {
                this.myHtmlTextArea = new JTextPane();
                this.myHtmlTextArea.setEditable(false);
                this.myHtmlTextArea.setContentType("text/html");
                this.myHtmlTextArea.setMargin((Insets)JBUI.insets((int)8, (int)8, (int)8, (int)8));
                JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myHtmlTextArea, (boolean)true);
                this.myPreviewPanel.add((Component)scrollPane, TEXT);
            }
            doc = DefaultIgnorable.removeDefaultIgnorable(doc);
            this.myHtmlTextArea.setText(doc);
            HtmlBuilderHelper.fixFontStyles(this.myHtmlTextArea);
            this.myHtmlTextArea.getCaret().setDot(0);
            CardLayout layout2 = (CardLayout)this.myPreviewPanel.getLayout();
            layout2.show(this.myPreviewPanel, TEXT);
        }

        @NotNull
        public ResourceType getType() {
            ResourceType resourceType = this.myType;
            if (resourceType == null) {
                ResourcePanel.$$$reportNull$$$0(5);
            }
            return resourceType;
        }

        private boolean allowEditing(@Nullable ResourceChooserItem item) {
            if (item == null) {
                return false;
            }
            if (item.isFramework() || item.isAttr()) {
                return false;
            }
            LocalResourceRepository repository = ResourceRepositoryManager.getProjectResources(ChooseResourceDialog.this.myModule);
            assert (repository != null);
            if (!repository.hasResources(ResourceNamespace.TODO(), item.getType(), item.getName())) {
                return false;
            }
            ResourceType type = item.getType();
            if (type == ResourceType.COLOR) {
                return true;
            }
            if (type == ResourceType.DRAWABLE) {
                if (item.isReference()) {
                    return true;
                }
                Project project = ChooseResourceDialog.this.myModule.getProject();
                StateList stateList = ResourceHelper.resolveStateList((RenderResources)ChooseResourceDialog.this.getResourceResolver(), item.getResourceValue(), project);
                return stateList != null;
            }
            return false;
        }

        public void showPreview(@Nullable ResourceChooserItem item) {
            this.showPreview(item, this.allowEditing(item));
        }

        public void showPreview(@Nullable ResourceChooserItem element, boolean allowEditor) {
            if (element != null && element.isAttr()) {
                ResourceUrl url = ResourceUrl.parse((String)element.getResourceUrl());
                assert (url != null);
                String doc = AndroidJavaDocRenderer.render(ChooseResourceDialog.this.myModule, ChooseResourceDialog.this.getConfiguration(), url);
                this.showHtml(doc);
                return;
            }
            if (allowEditor) {
                if ((this.myType == ResourceType.COLOR || this.myType == ResourceType.DRAWABLE || this.myType == ResourceType.MIPMAP) && element != null) {
                    LocalResourceRepository repository = ResourceRepositoryManager.getProjectResources(ChooseResourceDialog.this.myModule);
                    assert (repository != null);
                    boolean inProject = repository.hasResources(ResourceNamespace.TODO(), element.getType(), element.getName());
                    if (inProject) {
                        this.showEditorPanel();
                        this.myEditorPanel.setResourceName(element.getName());
                        ResourceItem defaultValue = this.setupVariants();
                        if (defaultValue != null) {
                            this.editResourceItem(defaultValue);
                            return;
                        }
                    }
                }
                ChooseResourceDialog.this.ensurePickersInitialized();
                if (element == null && ChooseResourceDialog.this.myStateListPicker != null && ChooseResourceDialog.this.myStateListPicker.getStateList() != null && ChooseResourceDialog.this.myStateListPicker.getStateList().getType() == this.myType) {
                    assert (ChooseResourceDialog.this.myStateListPickerPanel != null);
                    this.showEditorPanel();
                    this.myEditorPanel.setSelectedTab(ChooseResourceDialog.this.myStateListPickerPanel);
                    return;
                }
                if (element == null && this.myType == ResourceType.COLOR) {
                    assert (ChooseResourceDialog.this.myColorPickerPanel != null);
                    this.showEditorPanel();
                    this.myEditorPanel.setSelectedTab(ChooseResourceDialog.this.myColorPickerPanel);
                    return;
                }
            }
            if (element == null || element.getType() == ResourceType.ID) {
                this.showNoPreview();
                return;
            }
            if (element.getType() == ResourceType.SAMPLE_DATA && element instanceof ResourceChooserItem.SampleDataItem && ((ResourceChooserItem.SampleDataItem)element).getResourceItem().getContentType() == SampleDataResourceItem.ContentType.IMAGE) {
                this.showSampleItem((ResourceChooserItem.SampleDataItem)element);
                return;
            }
            switch (this.myType) {
                case DRAWABLE: 
                case COLOR: 
                case MIPMAP: {
                    this.showDrawableItem(element);
                    return;
                }
                case STRING: 
                case DIMEN: 
                case BOOL: {
                    this.showTableItem(element);
                    return;
                }
            }
            String doc = AndroidJavaDocRenderer.render(ChooseResourceDialog.this.myModule, ChooseResourceDialog.this.getConfiguration(), element.getType(), element.getName(), element.isFramework());
            if (doc != null) {
                this.showHtml(doc);
            } else {
                this.showNoPreview();
            }
        }

        public void editResourceItem(@NotNull ResourceItem selected) {
            ResourceEditorTab resourceEditorTab;
            if (selected == null) {
                ResourcePanel.$$$reportNull$$$0(6);
            }
            ResourceValue resourceValue2 = selected.getResourceValue();
            assert (resourceValue2 != null);
            String value2 = resourceValue2.getValue();
            if (value2 != null && (value2.startsWith("@") || value2.startsWith("?"))) {
                this.myReferenceComponent.setValueText(value2);
                this.updateReferenceSwatchIcon();
                resourceEditorTab = this.myReferencePanel;
            } else {
                StateList stateList = ResourceHelper.resolveStateList((RenderResources)ChooseResourceDialog.this.getResourceResolver(), resourceValue2, ChooseResourceDialog.this.myModule.getProject());
                if (stateList != null) {
                    ChooseResourceDialog.this.ensurePickersInitialized();
                    assert (ChooseResourceDialog.this.myStateListPickerPanel != null);
                    assert (ChooseResourceDialog.this.myStateListPicker != null);
                    if (stateList.getType() != ChooseResourceDialog.this.myStateListPickerPanel.getLocationSettings().getType()) {
                        Logger.getInstance(ChooseResourceDialog.class).warn("StateList type mismatch " + stateList.getType() + " " + ChooseResourceDialog.this.myStateListPickerPanel.getLocationSettings().getType());
                        this.showPreview(this.getSelectedItem(), false);
                        return;
                    }
                    ChooseResourceDialog.this.myStateListPicker.setStateList(stateList);
                    if (ChooseResourceDialog.this.myStateListPickerPanel.getFullPanel().getParent() == null) {
                        this.myEditorPanel.addTab(ChooseResourceDialog.this.myStateListPickerPanel);
                    }
                    resourceEditorTab = ChooseResourceDialog.this.myStateListPickerPanel;
                } else {
                    Color color = ResourceHelper.parseColor(resourceValue2.getValue());
                    if (color != null) {
                        ChooseResourceDialog.this.ensurePickersInitialized();
                        assert (ChooseResourceDialog.this.myColorPickerPanel != null);
                        assert (ChooseResourceDialog.this.myColorPicker != null);
                        ChooseResourceDialog.this.myColorPicker.setColor(color);
                        resourceEditorTab = ChooseResourceDialog.this.myColorPickerPanel;
                    } else {
                        this.showPreview(this.getSelectedItem(), false);
                        return;
                    }
                }
            }
            this.myEditorPanel.setSelectedTab(resourceEditorTab);
            this.setLocationFromResourceItem(selected);
        }

        @Nullable
        public ValidationInfo doValidate() {
            boolean okActionEnabled;
            ValidationInfo error = null;
            ResourceEditorTab editor2 = this.getCurrentResourceEditor();
            if (editor2 != null) {
                String overwriteResource = "";
                if (editor2.getResourceNameVisibility() == ResourceNameVisibility.FORCE || editor2.getResourceNameVisibility() == ResourceNameVisibility.SHOW && !this.myEditorPanel.getResourceName().isEmpty()) {
                    ResourceItem defaultResourceItem;
                    String enteredName;
                    IdeResourceNameValidator validator = editor2.getValidator();
                    if (validator.doesResourceExist(enteredName = this.myEditorPanel.getResourceName())) {
                        ResourceType type = ChooseResourceDialog.this.getSelectedPanel().getType();
                        overwriteResource = String.format("Saving this %1$s will override existing resource %2$s.", StringUtil.toLowerCase((String)type.getDisplayName()), enteredName);
                    } else {
                        String errorText = validator.getErrorText(enteredName);
                        if (errorText != null) {
                            error = new ValidationInfo(errorText, (JComponent)this.myEditorPanel.getResourceNameField());
                        }
                    }
                    if (!overwriteResource.equals(this.myEditorPanel.getResourceNameMessage()) && (defaultResourceItem = this.setupVariants()) != null) {
                        this.setLocationFromResourceItem(defaultResourceItem);
                    }
                }
                if (!overwriteResource.equals(this.myEditorPanel.getResourceNameMessage())) {
                    this.myEditorPanel.setResourceNameMessage(overwriteResource);
                }
                if (error == null) {
                    error = editor2.doValidate();
                }
                okActionEnabled = error == null;
            } else {
                okActionEnabled = this.getSelectedItem() != null;
            }
            ChooseResourceDialog.this.setOKActionEnabled(okActionEnabled);
            return error;
        }

        private void setLocationFromResourceItem(@NotNull ResourceItem item) {
            VirtualFile virtualFile;
            if (item == null) {
                ResourcePanel.$$$reportNull$$$0(7);
            }
            if ((virtualFile = ResourceHelper.getSourceAsVirtualFile(item)) == null) {
                assert (false) : "Item's source can not be null when selecting a resource item";
                return;
            }
            for (ResourceEditorTab editor2 : this.myEditorPanel.getAllTabs()) {
                editor2.getLocationSettings().resetFromFile(virtualFile, ChooseResourceDialog.this.myModule.getProject());
            }
        }

        @Nullable
        private ResourceItem setupVariants() {
            LocalResourceRepository repository = ResourceRepositoryManager.getAppResources(ChooseResourceDialog.this.myFacet);
            List resources = repository.getResources(ResourceNamespace.TODO(), this.myType, this.myEditorPanel.getResourceName());
            ResourceItem defaultValue = (ResourceItem)ChooseResourceDialog.this.getConfiguration().getFullConfig().findMatchingConfigurable((Collection)resources);
            if (defaultValue == null && !resources.isEmpty()) {
                defaultValue = (ResourceItem)resources.get(0);
            }
            this.myEditorPanel.setVariant(resources, defaultValue);
            return defaultValue;
        }

        @Nullable
        public ResourceEditorTab getCurrentResourceEditor() {
            return this.myEditorPanel != null && this.myEditorPanel.isVisible() ? this.myEditorPanel.getSelectedTab() : null;
        }

        private boolean supportsGridMode() {
            return this.myType == ResourceType.COLOR || this.myType == ResourceType.DRAWABLE || this.myType == ResourceType.MIPMAP;
        }

        private void configureList(boolean gridView) {
            if (this.myList == null) {
                return;
            }
            if (gridView && this.supportsGridMode()) {
                this.configureGridList(this.myList);
            } else {
                this.configureVerticalList(this.myList);
            }
        }

        private void configureVerticalList(@NotNull TreeGrid<ResourceChooserItem> list) {
            if (list == null) {
                ResourcePanel.$$$reportNull$$$0(8);
            }
            ColoredListCellRenderer<ResourceChooserItem> listRenderer = new ColoredListCellRenderer<ResourceChooserItem>(){

                protected void customizeCellRenderer(@NotNull JList list, ResourceChooserItem value2, int index, boolean selected, boolean hasFocus) {
                    if (list == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    if (!hasFocus) {
                        this.setBorder(new AbstractBorder(){

                            @Override
                            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                                Color oldColor = g.getColor();
                                g.setColor((Color)LIST_DIVIDER_COLOR);
                                int thickness = 1;
                                g.fillRect(x, y + height - thickness, width, thickness);
                                g.setColor(oldColor);
                            }
                        });
                    }
                    this.setIpad((Insets)LIST_PADDING);
                    this.setIcon(ChooseResourceDialog.this.getIcon(value2, LIST_ICON_SIZE, LIST_CHECK_SIZE, list::repaint));
                    String string = value2.toString();
                    String filter2 = ChooseResourceDialog.this.mySearchField.getText();
                    if (!filter2.isEmpty()) {
                        int match = StringUtil.indexOfIgnoreCase((String)string, (String)filter2, (int)0);
                        if (match != -1) {
                            this.append(string.substring(0, match));
                            this.append(string.substring(match, match + filter2.length()), SEARCH_MATCH_ATTRIBUTES);
                            this.append(string.substring(match + filter2.length()));
                        } else {
                            this.append(string);
                        }
                    } else {
                        this.append(string);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog$ResourcePanel$7", "customizeCellRenderer"));
                }
            };
            list.setFixedCellWidth(10);
            list.setFixedCellHeight(LIST_CELL_HEIGHT);
            list.setCellRenderer((ListCellRenderer)listRenderer);
            list.setLayoutOrientation(0);
        }

        private void configureGridList(@NotNull TreeGrid<ResourceChooserItem> list) {
            if (list == null) {
                ResourcePanel.$$$reportNull$$$0(9);
            }
            DefaultListCellRenderer gridRenderer = new DefaultListCellRenderer(){
                private final int CHAR_WIDTH;
                private final int CHARS_PER_CELL;
                {
                    this.setHorizontalTextPosition(0);
                    this.setVerticalTextPosition(3);
                    this.setHorizontalAlignment(0);
                    this.CHAR_WIDTH = this.getFontMetrics(this.getFont()).charWidth('x');
                    this.CHARS_PER_CELL = GRID_CELL_SIZE / this.CHAR_WIDTH;
                }

                @Override
                public Component getListCellRendererComponent(JList list, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value2, index, isSelected, false);
                    if (!SystemInfo.isMac) {
                        this.setBackground(UIUtil.TRANSPARENT_COLOR);
                        if (isSelected) {
                            this.setBorder(GRID_SELECTION_BORDER);
                            this.setForeground(JBColor.foreground());
                        }
                    }
                    ResourceChooserItem rItem = (ResourceChooserItem)value2;
                    this.setIcon(ChooseResourceDialog.this.getIcon(rItem, GRID_ICON_SIZE, GRID_CHECK_SIZE, list::repaint));
                    this.highlightSearchResult(rItem);
                    return this;
                }

                private void highlightSearchResult(@NotNull ResourceChooserItem rItem) {
                    if (rItem == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    String name = rItem.getName();
                    String filter2 = ChooseResourceDialog.this.mySearchField.getText();
                    int match = -1;
                    if (!filter2.isEmpty()) {
                        match = StringUtil.indexOfIgnoreCase((String)name, (String)filter2, (int)0);
                    }
                    int breakPoint = -1;
                    if (name.length() > this.CHARS_PER_CELL) {
                        breakPoint = name.indexOf(95, this.CHARS_PER_CELL / 2);
                        breakPoint = breakPoint == -1 || breakPoint >= this.CHARS_PER_CELL || name.length() - breakPoint >= this.CHARS_PER_CELL ? this.CHARS_PER_CELL : ++breakPoint;
                    }
                    if (match != -1 || breakPoint != -1) {
                        HtmlBuilder builder = new HtmlBuilder();
                        builder.openHtmlBody();
                        builder.beginNoBr();
                        if (match == -1) {
                            builder.add(name, 0, breakPoint);
                            builder.newline();
                            builder.add(name, breakPoint, name.length());
                        } else if (breakPoint == -1) {
                            builder.add(name, 0, match);
                            builder.beginColor((Color)JBColor.BLUE);
                            builder.beginBold();
                            builder.add(name, match, match + filter2.length());
                            builder.endBold();
                            builder.endColor();
                            builder.add(name, match + filter2.length(), name.length());
                        } else {
                            if (breakPoint < match) {
                                builder.add(name, 0, breakPoint);
                                builder.newline();
                                builder.add(name, breakPoint, match);
                            } else {
                                builder.add(name, 0, match);
                            }
                            builder.beginColor((Color)JBColor.BLUE);
                            builder.beginBold();
                            builder.add(name, match, match + filter2.length());
                            builder.endBold();
                            builder.endColor();
                            if (breakPoint >= match && breakPoint < match + filter2.length()) {
                                builder.newline();
                                builder.add(name, match + filter2.length(), name.length());
                            } else if (match < breakPoint) {
                                builder.add(name, match + filter2.length(), breakPoint);
                                builder.newline();
                                builder.add(name, breakPoint, name.length());
                            }
                        }
                        builder.endNoBr();
                        builder.closeHtmlBody();
                        this.setText(builder.getHtml());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rItem", "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog$ResourcePanel$8", "highlightSearchResult"));
                }
            };
            list.setFixedCellWidth(GRID_CELL_SIZE);
            list.setFixedCellHeight(GRID_CELL_SIZE);
            list.setCellRenderer((ListCellRenderer)gridRenderer);
            list.setLayoutOrientation(2);
        }

        private void showNewResource(@NotNull ResourceEditorTab tab) {
            if (tab == null) {
                ResourcePanel.$$$reportNull$$$0(10);
            }
            this.setSelectedItem(null);
            this.showEditorPanel();
            this.myEditorPanel.setSelectedTab(tab);
            this.myEditorPanel.setResourceName("");
            for (ResourceEditorTab editor2 : this.myEditorPanel.getAllTabs()) {
                editor2.getLocationSettings().resetToDefault();
            }
        }

        private boolean select(@NotNull ResourceValue value2) {
            if (value2 == null) {
                ResourcePanel.$$$reportNull$$$0(11);
            }
            this.mySelectedValue = value2;
            boolean isAttr = value2 instanceof StyleItemResourceValue;
            for (ResourceChooserGroup group : this.myGroups) {
                for (ResourceChooserItem item : group.getItems()) {
                    if (isAttr) {
                        ResourceReference attr;
                        if (!item.isAttr() || (attr = ((StyleItemResourceValue)value2).getAttr()) == null || attr.getNamespace() == ResourceNamespace.ANDROID != item.isFramework() || !value2.getName().equals(item.getName())) continue;
                        this.setSelectedItem(item);
                        return true;
                    }
                    if (item.isAttr() || value2.isFramework() != item.isFramework() || !value2.getName().equals(item.getName())) continue;
                    this.setSelectedItem(item);
                    return true;
                }
            }
            return false;
        }

        public void expandAll() {
            if (this.myList != null) {
                this.myList.expandAll();
            }
        }

        public ResourceChooserItem getSelectedItem() {
            Object selected;
            int index;
            if (this.myList != null) {
                return (ResourceChooserItem)this.myList.getSelectedElement();
            }
            if (this.myTable != null && (index = this.myTable.getSelectionModel().getLeadSelectionIndex()) != -1 && (selected = this.myTable.getValueAt(index, 0)) instanceof ResourceChooserItem) {
                return (ResourceChooserItem)selected;
            }
            return null;
        }

        public void setSelectedItem(@Nullable ResourceChooserItem item) {
            if (this.myList != null) {
                this.myList.setSelectedElement((Object)item);
            } else if (this.myTable != null) {
                TableModel model = this.myTable.getModel();
                int rowCount = model.getRowCount();
                for (int row = 0; row < rowCount; ++row) {
                    Object object = model.getValueAt(row, 0);
                    if (object != item) continue;
                    this.myTable.getSelectionModel().setSelectionInterval(row, row);
                    Rectangle cellRect = this.myTable.getCellRect(row, 0, true);
                    this.myTable.scrollRectToVisible(cellRect);
                    break;
                }
            }
        }

        @Nullable
        public String getValueForLivePreview() {
            if (this.myType == ResourceType.COLOR && ChooseResourceDialog.this.myColorPicker != null && ChooseResourceDialog.this.myColorPicker.isShowing()) {
                return ResourceHelper.colorToString(ChooseResourceDialog.this.myColorPicker.getColor());
            }
            ResourceChooserItem item = this.getSelectedItem();
            return item != null ? item.getResourceUrl() : null;
        }

        public void setShowFiltered(boolean showFiltered) {
            if (this.myList != null) {
                this.myList.setExpandFiltered(showFiltered);
                if (!showFiltered) {
                    this.myList.expandOnly(0);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attrs";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groups";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog$ResourcePanel";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selected";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tab";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog$ResourcePanel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createListPanel";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createListPanel";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "showSampleItem";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "editResourceItem";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setLocationFromResourceItem";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "configureVerticalList";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "configureGridList";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "showNewResource";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "select";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum ResourceNameVisibility {
        SHOW,
        FORCE;

    }

    public static interface ResourcePickerListener {
        public void resourceChanged(@Nullable String var1);
    }

    public static class Builder {
        private Module myModule;
        private Configuration myConfiguration;
        private XmlTag myTag;
        private XmlFile myFile;
        private boolean myIsFrameworkValue;
        private String myCurrentValue;
        private EnumSet<ResourceType> myTypes;
        private ResourceNameVisibility myResourceNameVisibility = ResourceNameVisibility.SHOW;
        private String myResourceNameSuggestion;
        private boolean myHideLeftSideActions;
        @Nullable
        private ResourceType myDefaultType;
        private boolean myFilterColorStateLists;
        private boolean myShowSampleDataPicker;

        private Builder() {
        }

        public Builder setModule(@NotNull Module module) {
            if (module == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myModule = module;
            return this;
        }

        public Builder setTag(@Nullable XmlTag tag) {
            this.myTag = tag;
            if (this.myTag != null && this.myFile == null) {
                this.myFile = (XmlFile)this.myTag.getContainingFile();
            }
            return this;
        }

        public Builder setFile(@Nullable XmlFile file) {
            this.myFile = file;
            return this;
        }

        public Builder setIsFrameworkValue(boolean frameworkValue) {
            this.myIsFrameworkValue = frameworkValue;
            return this;
        }

        public Builder setCurrentValue(@Nullable String currentValue) {
            this.myCurrentValue = currentValue;
            return this;
        }

        public Builder setTypes(@NotNull Set<ResourceType> types) {
            if (types == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myTypes = EnumSet.copyOf(types);
            return this;
        }

        public Builder setResourceNameVisibility(@NotNull ResourceNameVisibility resourceNameVisibility) {
            if (resourceNameVisibility == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myResourceNameVisibility = resourceNameVisibility;
            return this;
        }

        public Builder setResourceNameSuggestion(@Nullable String resourceNameSuggestion) {
            if (resourceNameSuggestion != null && (resourceNameSuggestion.startsWith("@") || resourceNameSuggestion.startsWith("?") || resourceNameSuggestion.startsWith("#"))) {
                throw new IllegalArgumentException("invalid name suggestion " + resourceNameSuggestion);
            }
            this.myResourceNameSuggestion = resourceNameSuggestion;
            return this;
        }

        public Builder setHideLeftSideActions() {
            this.myHideLeftSideActions = true;
            return this;
        }

        public Builder setConfiguration(@Nullable Configuration configuration) {
            this.myConfiguration = configuration;
            return this;
        }

        @NotNull
        public Builder setFilterColorStateLists(boolean shouldFilterColorStateLists) {
            this.myFilterColorStateLists = shouldFilterColorStateLists;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder;
        }

        @NotNull
        public ChooseResourceDialog build() {
            Configuration configuration = this.myConfiguration;
            AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
            assert (facet != null);
            if (configuration == null) {
                if (this.myFile != null && this.myFile.getVirtualFile() != null) {
                    ConfigurationManager configurationManager = ConfigurationManager.getOrCreateInstance(this.myModule);
                    configuration = configurationManager.getConfiguration(this.myFile.getVirtualFile());
                }
                if (configuration == null) {
                    configuration = ThemeEditorUtils.getConfigurationForModule(this.myModule);
                }
            }
            ChooseResourceDialog chooseResourceDialog = new ChooseResourceDialog(facet, configuration, this.myTag, this.myTypes, this.myDefaultType, this.myCurrentValue, this.myIsFrameworkValue, this.myResourceNameVisibility, this.myResourceNameSuggestion, this.myHideLeftSideActions, this.myFilterColorStateLists, this.myShowSampleDataPicker);
            if (chooseResourceDialog == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return chooseResourceDialog;
        }

        @NotNull
        public Builder setDefaultType(@Nullable ResourceType defaultType) {
            this.myDefaultType = defaultType;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder;
        }

        @NotNull
        public Builder setShowSampleDataPicker(boolean picker) {
            this.myShowSampleDataPicker = picker;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "types";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceNameVisibility";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog$Builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/ui/resourcechooser/ChooseResourceDialog$Builder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setFilterColorStateLists";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setDefaultType";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setShowSampleDataPicker";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setModule";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setTypes";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setResourceNameVisibility";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

