/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.scopes;

import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import gnu.trove.TObjectIntHashMap;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileRootSearchScope
extends GlobalSearchScope {
    @NotNull
    private final TObjectIntHashMap<File> myDirRootPaths;
    @NotNull
    private final ProjectFileIndex myProjectFileIndex;

    public FileRootSearchScope(@NotNull Project project, @NotNull Collection<File> rootDirPaths) {
        if (project == null) {
            FileRootSearchScope.$$$reportNull$$$0(0);
        }
        if (rootDirPaths == null) {
            FileRootSearchScope.$$$reportNull$$$0(1);
        }
        super(project);
        this.myDirRootPaths = new TObjectIntHashMap();
        int i2 = 1;
        for (File root : rootDirPaths) {
            this.myDirRootPaths.put((Object)root, i2++);
        }
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
    }

    public boolean accept(@NotNull File file) {
        if (file == null) {
            FileRootSearchScope.$$$reportNull$$$0(2);
        }
        while (!file.exists()) {
            if (this.myDirRootPaths.containsKey((Object)file)) {
                return true;
            }
            file = file.getParentFile();
        }
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
        if (virtualFile != null) {
            return this.accept(virtualFile);
        }
        return false;
    }

    public boolean contains(@NotNull VirtualFile file) {
        VirtualFile sourceRootForFile;
        File path;
        if (file == null) {
            FileRootSearchScope.$$$reportNull$$$0(3);
        }
        if (this.myDirRootPaths.contains((Object)(path = VfsUtilCore.virtualToIoFile((VirtualFile)file)))) {
            return true;
        }
        if (this.myProjectFileIndex.isInContent(file) && (sourceRootForFile = this.myProjectFileIndex.getSourceRootForFile(file)) != null) {
            path = VfsUtilCore.virtualToIoFile((VirtualFile)sourceRootForFile);
            return this.myDirRootPaths.contains((Object)path);
        }
        VirtualFile classRootForFile = this.myProjectFileIndex.getClassRootForFile(file);
        if (classRootForFile != null) {
            path = VfsUtilCore.virtualToIoFile((VirtualFile)classRootForFile);
            return this.myDirRootPaths.contains((Object)path);
        }
        return false;
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        VirtualFile r2;
        VirtualFile r1;
        if (file1 == null) {
            FileRootSearchScope.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            FileRootSearchScope.$$$reportNull$$$0(5);
        }
        if (Comparing.equal((Object)(r1 = this.getFileRoot(file1)), (Object)(r2 = this.getFileRoot(file2)))) {
            return 0;
        }
        if (r1 == null) {
            return -1;
        }
        if (r2 == null) {
            return 1;
        }
        int i1 = this.myDirRootPaths.get((Object)VfsUtilCore.virtualToIoFile((VirtualFile)r1));
        int i2 = this.myDirRootPaths.get((Object)VfsUtilCore.virtualToIoFile((VirtualFile)r2));
        if (i1 == 0 && i2 == 0) {
            return 0;
        }
        if (i1 > 0 && i2 > 0) {
            return i2 - i1;
        }
        return i1 > 0 ? 1 : -1;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            FileRootSearchScope.$$$reportNull$$$0(6);
        }
        return true;
    }

    public boolean isSearchInLibraries() {
        return true;
    }

    @Nullable
    private VirtualFile getFileRoot(@NotNull VirtualFile file) {
        if (file == null) {
            FileRootSearchScope.$$$reportNull$$$0(7);
        }
        if (this.myProjectFileIndex.isInContent(file)) {
            return this.myProjectFileIndex.getSourceRootForFile(file);
        }
        return this.myProjectFileIndex.getClassRootForFile(file);
    }

    @NotNull
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            FileRootSearchScope.$$$reportNull$$$0(8);
        }
        if (scope instanceof FileRootSearchScope) {
            FileRootSearchScope fileRootSearchScope = this.merge((FileRootSearchScope)scope);
            if (fileRootSearchScope == null) {
                FileRootSearchScope.$$$reportNull$$$0(9);
            }
            return fileRootSearchScope;
        }
        GlobalSearchScope globalSearchScope = super.uniteWith(scope);
        if (globalSearchScope == null) {
            FileRootSearchScope.$$$reportNull$$$0(10);
        }
        return globalSearchScope;
    }

    @NotNull
    protected FileRootSearchScope merge(@NotNull FileRootSearchScope scope) {
        if (scope == null) {
            FileRootSearchScope.$$$reportNull$$$0(11);
        }
        FileRootSearchScope fileRootSearchScope = this.calculate(scope, true);
        if (fileRootSearchScope == null) {
            FileRootSearchScope.$$$reportNull$$$0(12);
        }
        return fileRootSearchScope;
    }

    @NotNull
    protected FileRootSearchScope exclude(@NotNull FileRootSearchScope scope) {
        if (scope == null) {
            FileRootSearchScope.$$$reportNull$$$0(13);
        }
        FileRootSearchScope fileRootSearchScope = this.calculate(scope, false);
        if (fileRootSearchScope == null) {
            FileRootSearchScope.$$$reportNull$$$0(14);
        }
        return fileRootSearchScope;
    }

    @NotNull
    private FileRootSearchScope calculate(@NotNull FileRootSearchScope scope, boolean merge) {
        if (scope == null) {
            FileRootSearchScope.$$$reportNull$$$0(15);
        }
        HashSet roots = Sets.newHashSet();
        this.myDirRootPaths.forEach(file -> {
            roots.add(file);
            return true;
        });
        scope.myDirRootPaths.forEach(file -> {
            if (merge) {
                roots.add(file);
            } else {
                roots.remove(file);
            }
            return true;
        });
        Project project = this.getProject();
        assert (project != null);
        FileRootSearchScope fileRootSearchScope = new FileRootSearchScope(project, roots);
        if (fileRootSearchScope == null) {
            FileRootSearchScope.$$$reportNull$$$0(16);
        }
        return fileRootSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDirPaths";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/testartifacts/scopes/FileRootSearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/testartifacts/scopes/FileRootSearchScope";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "uniteWith";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "exclude";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "calculate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFileRoot";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "uniteWith";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "exclude";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "calculate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

