/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.run.AndroidRunConfigurationType;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfiguration;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfigurationType;
import com.android.tools.idea.testartifacts.scopes.TestArtifactSearchScopes;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.execution.junit.JavaRuntimeConfigurationProducerBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidTestConfigurationProducer
extends JavaRunConfigurationProducerBase<AndroidTestRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        AndroidTestRunConfigurationType androidTestRunConfigurationType = AndroidTestRunConfigurationType.getInstance();
        if (androidTestRunConfigurationType == null) {
            AndroidTestConfigurationProducer.$$$reportNull$$$0(0);
        }
        return androidTestRunConfigurationType;
    }

    private boolean setupAllInPackageConfiguration(AndroidTestRunConfiguration configuration, PsiElement element, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        PsiPackage p = JavaRuntimeConfigurationProducerBase.checkPackage((PsiElement)element);
        if (p == null) {
            return false;
        }
        String packageName = p.getQualifiedName();
        this.setupConfiguration(configuration, (PsiElement)p, context, sourceElement);
        configuration.TESTING_TYPE = !packageName.isEmpty() ? 1 : 0;
        configuration.PACKAGE_NAME = packageName;
        configuration.setGeneratedName();
        return true;
    }

    private boolean setupClassConfiguration(AndroidTestRunConfiguration configuration, PsiElement element, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        PsiClass elementClass = AndroidPsiUtils.getPsiParentOfType(element, PsiClass.class, false);
        while (elementClass != null) {
            if (JUnitUtil.isTestClass((PsiClass)elementClass)) {
                this.setupConfiguration(configuration, (PsiElement)elementClass, context, sourceElement);
                configuration.TESTING_TYPE = 2;
                configuration.CLASS_NAME = JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)elementClass);
                configuration.setGeneratedName();
                return true;
            }
            elementClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)elementClass, PsiClass.class);
        }
        return false;
    }

    private boolean setupMethodConfiguration(AndroidTestRunConfiguration configuration, PsiElement element, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        PsiMethod elementMethod = AndroidPsiUtils.getPsiParentOfType(element, PsiMethod.class, false);
        while (elementMethod != null) {
            if (AndroidTestConfigurationProducer.isTestMethod(elementMethod)) {
                PsiClass c = elementMethod.getContainingClass();
                this.setupConfiguration(configuration, (PsiElement)elementMethod, context, sourceElement);
                assert (c != null);
                configuration.TESTING_TYPE = 3;
                configuration.CLASS_NAME = JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)c);
                configuration.METHOD_NAME = elementMethod.getName();
                configuration.setGeneratedName();
                return true;
            }
            elementMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)elementMethod, PsiMethod.class);
        }
        return false;
    }

    private void setupConfiguration(AndroidTestRunConfiguration configuration, PsiElement element, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        Module module = AndroidUtils.getAndroidModule(context);
        if (module == null) {
            return;
        }
        sourceElement.set((Object)element);
        this.setupConfigurationModule(context, configuration);
        TargetSelectionMode targetSelectionMode = AndroidUtils.getDefaultTargetSelectionMode(module, (ConfigurationType)AndroidTestRunConfigurationType.getInstance(), (ConfigurationType)AndroidRunConfigurationType.getInstance());
        if (targetSelectionMode != null) {
            configuration.getDeployTargetContext().setTargetSelectionMode(targetSelectionMode);
        }
    }

    private static boolean isTestMethod(PsiMethod method) {
        PsiClass testClass = method.getContainingClass();
        if (testClass != null && JUnitUtil.isTestClass((PsiClass)testClass)) {
            return new JUnitUtil.TestMethodFilter(testClass).value(method);
        }
        return false;
    }

    @Nullable
    public ConfigurationFromContext createConfigurationFromContext(@NotNull ConfigurationContext context) {
        if (context == null) {
            AndroidTestConfigurationProducer.$$$reportNull$$$0(1);
        }
        return AndroidUtils.getAndroidModule(context) == null ? null : super.createConfigurationFromContext(context);
    }

    protected boolean setupConfigurationFromContext(@NotNull AndroidTestRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Module module;
        if (configuration == null) {
            AndroidTestConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (context == null) {
            AndroidTestConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (sourceElement == null) {
            AndroidTestConfigurationProducer.$$$reportNull$$$0(4);
        }
        if ((module = AndroidUtils.getAndroidModule(context)) == null) {
            return false;
        }
        Location location = context.getLocation();
        if (location == null) {
            return false;
        }
        if ((location = JavaExecutionUtil.stepIntoSingleClass((Location)location)) == null) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return false;
        }
        AndroidModuleModel androidModel = AndroidModuleModel.get(facet);
        if (androidModel != null) {
            if (((AndroidFacetConfiguration)facet.getConfiguration()).getProjectType() != 2 && androidModel.getSelectedVariant().getAndroidTestArtifact() == null) {
                return false;
            }
            TestArtifactSearchScopes testScopes = TestArtifactSearchScopes.get(module);
            if (testScopes == null) {
                return false;
            }
            VirtualFile virtualFile = null;
            if (element instanceof PsiDirectory) {
                virtualFile = ((PsiDirectory)element).getVirtualFile();
            } else {
                PsiFile psiFile = element.getContainingFile();
                if (psiFile != null) {
                    virtualFile = psiFile.getVirtualFile();
                }
            }
            if (virtualFile == null) {
                return false;
            }
            if (!testScopes.isAndroidTestSource(virtualFile)) {
                return false;
            }
        }
        AndroidTestConfigurationProducer.setupInstrumentationTestRunner(configuration, facet);
        if (this.setupAllInPackageConfiguration(configuration, element, context, sourceElement)) {
            return true;
        }
        if (this.setupMethodConfiguration(configuration, element, context, sourceElement)) {
            return true;
        }
        return this.setupClassConfiguration(configuration, element, context, sourceElement);
    }

    private static void setupInstrumentationTestRunner(@NotNull AndroidTestRunConfiguration configuration, @NotNull AndroidFacet facet) {
        if (configuration == null) {
            AndroidTestConfigurationProducer.$$$reportNull$$$0(5);
        }
        if (facet == null) {
            AndroidTestConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (!GradleProjectInfo.getInstance(configuration.getProject()).isBuildWithGradle()) {
            configuration.INSTRUMENTATION_RUNNER_CLASS = StringUtil.notNullize((String)AndroidTestRunConfiguration.findInstrumentationRunner(facet));
        }
    }

    public boolean isConfigurationFromContext(@NotNull AndroidTestRunConfiguration configuration, @NotNull ConfigurationContext context) {
        if (configuration == null) {
            AndroidTestConfigurationProducer.$$$reportNull$$$0(7);
        }
        if (context == null) {
            AndroidTestConfigurationProducer.$$$reportNull$$$0(8);
        }
        Location location = context.getLocation();
        Module contextModule = AndroidUtils.getAndroidModule(context);
        if (contextModule == null || location == null) {
            return false;
        }
        if ((location = JavaExecutionUtil.stepIntoSingleClass((Location)location)) == null) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        VirtualFile directoryOrFile = element instanceof PsiDirectory ? ((PsiDirectory)element).getVirtualFile() : element.getContainingFile().getVirtualFile();
        TestArtifactSearchScopes testScopes = TestArtifactSearchScopes.get(contextModule);
        if (directoryOrFile != null && testScopes != null && !testScopes.isAndroidTestSource(directoryOrFile)) {
            return false;
        }
        PsiPackage psiPackage = JavaRuntimeConfigurationProducerBase.checkPackage((PsiElement)element);
        String packageName = psiPackage == null ? null : psiPackage.getQualifiedName();
        PsiClass elementClass = AndroidPsiUtils.getPsiParentOfType(element, PsiClass.class, false);
        String className = elementClass == null ? null : elementClass.getQualifiedName();
        PsiMethod elementMethod = AndroidPsiUtils.getPsiParentOfType(element, PsiMethod.class, false);
        String methodName = elementMethod == null ? null : elementMethod.getName();
        Module moduleInConfig = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
        if (!Comparing.equal((Object)contextModule, (Object)moduleInConfig)) {
            return false;
        }
        switch (configuration.TESTING_TYPE) {
            case 0: {
                return psiPackage != null && packageName.isEmpty();
            }
            case 1: {
                return packageName != null && packageName.equals(configuration.PACKAGE_NAME);
            }
            case 2: {
                return elementMethod == null && className != null && className.equals(configuration.CLASS_NAME);
            }
            case 3: {
                return methodName != null && methodName.equals(configuration.METHOD_NAME) && className != null && className.equals(configuration.CLASS_NAME);
            }
        }
        return false;
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        Project project;
        if (self == null) {
            AndroidTestConfigurationProducer.$$$reportNull$$$0(9);
        }
        if (other == null) {
            AndroidTestConfigurationProducer.$$$reportNull$$$0(10);
        }
        if (!GradleProjectInfo.getInstance(project = self.getConfiguration().getProject()).isBuildWithGradle()) {
            return false;
        }
        return other.getConfigurationType() instanceof JUnitConfigurationType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/testartifacts/instrumented/AndroidTestConfigurationProducer";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/testartifacts/instrumented/AndroidTestConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurationFromContext";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setupInstrumentationTestRunner";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "shouldReplace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

