/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.SdkConstants;
import com.android.prefs.AndroidLocation;
import com.android.repository.Revision;
import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.actions.NewAndroidComponentAction;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.model.NewModuleModel;
import com.android.tools.idea.npw.model.ProjectSyncInvoker;
import com.android.tools.idea.npw.model.RenderTemplateModel;
import com.android.tools.idea.npw.project.AndroidPackageUtils;
import com.android.tools.idea.npw.template.ChooseActivityTypeStep;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.ui.wizard.StudioWizardDialogBuilder;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import com.google.common.io.Files;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.NonEmptyActionGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.templates.github.ZipUtil;
import icons.AndroidIcons;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

public class TemplateManager {
    private static final Logger LOG = Logger.getInstance((String)("#" + TemplateManager.class.getName()));
    private static final String BUNDLED_TEMPLATE_PATH = "/plugins/android/lib/templates";
    private static final String[] DEVELOPMENT_TEMPLATE_PATHS = new String[]{"/../../tools/base/templates", "/android/tools-base/templates", "/community/android/tools-base/templates"};
    private static final String EXPLODED_AAR_PATH = "build/intermediates/exploded-aar";
    public static final String CATEGORY_OTHER = "Other";
    public static final String CATEGORY_ACTIVITY = "Activity";
    private static final String ACTION_ID_PREFIX = "template.create.";
    private static final Set<String> EXCLUDED_CATEGORIES = ImmutableSet.of((Object)"Application", (Object)"Applications");
    public static final Set<String> EXCLUDED_TEMPLATES = ImmutableSet.of();
    private static final String TEMPLATE_ZIP_NAME = "templates.zip";
    private Map<File, TemplateMetadata> myTemplateMap;
    private final Object CATEGORY_TABLE_LOCK = new Object();
    private Table<String, String, File> myCategoryTable;
    private File myAarCache;
    private static TemplateManager ourInstance = new TemplateManager();
    private DefaultActionGroup myTopGroup;

    private TemplateManager() {
    }

    public static TemplateManager getInstance() {
        return ourInstance;
    }

    @Nullable
    public static File getTemplateRootFolder() {
        File location;
        File folder;
        File rootFile;
        String homePath = FileUtil.toSystemIndependentName((String)PathManager.getHomePath());
        VirtualFile root = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)(homePath + BUNDLED_TEMPLATE_PATH)));
        if (root == null) {
            for (String path : DEVELOPMENT_TEMPLATE_PATHS) {
                root = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)(homePath + path)));
                if (root != null) break;
            }
        }
        if (root != null && TemplateManager.templateRootIsValid(rootFile = VfsUtilCore.virtualToIoFile((VirtualFile)root))) {
            return rootFile;
        }
        AndroidSdkData sdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        if (sdkData != null && (folder = new File(location = sdkData.getLocation(), "tools" + File.separator + "templates")).isDirectory()) {
            return folder;
        }
        return null;
    }

    @NotNull
    public static List<File> getExtraTemplateRootFolders() {
        List<File> folders = TemplateManager.getUserDefinedTemplateRootFolders();
        folders.addAll(TemplateManager.getAuxTemplateRootFolders());
        List<File> list = folders;
        if (list == null) {
            TemplateManager.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    private static List<File> getUserDefinedTemplateRootFolders() {
        File templatesFolder;
        ArrayList<File> folders = new ArrayList<File>();
        String homeFolder = AndroidLocation.getFolderWithoutWrites();
        if (homeFolder != null && ((Boolean)StudioFlags.NPW_USE_HOME_FOLDER_AS_EXTRA_TEMPLATE_ROOT_FOLDER.get()).booleanValue() && (templatesFolder = new File(homeFolder, "templates")).isDirectory()) {
            Collections.addAll(folders, templatesFolder);
        }
        ArrayList<File> arrayList = folders;
        if (arrayList == null) {
            TemplateManager.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    private static List<File> getAuxTemplateRootFolders() {
        ArrayList<File> folders = new ArrayList<File>();
        AndroidSdkData sdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        if (sdkData != null) {
            String[] addOns;
            File location = sdkData.getLocation();
            File extras = new File(location, "extras");
            if (extras.isDirectory()) {
                for (File vendor : TemplateManager.listFiles(extras)) {
                    if (!vendor.isDirectory()) continue;
                    for (File pkg : TemplateManager.listFiles(vendor)) {
                        File folder;
                        if (!pkg.isDirectory() || !(folder = new File(pkg, "templates")).isDirectory()) continue;
                        folders.add(folder);
                    }
                }
                File folder = new File(extras, "templates");
                if (folder.isDirectory()) {
                    folders.add(folder);
                }
            }
            if ((addOns = new File(location, "add-ons")).isDirectory()) {
                File[] fileArray = TemplateManager.listFiles((File)addOns);
                int n = fileArray.length;
                for (int vendor = 0; vendor < n; ++vendor) {
                    File folder;
                    File addOn = fileArray[vendor];
                    if (!addOn.isDirectory() || !(folder = new File(addOn, "templates")).isDirectory()) continue;
                    folders.add(folder);
                }
            }
        }
        String homePath = FileUtil.toSystemIndependentName((String)PathManager.getHomePath());
        VirtualFile root = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)(homePath + BUNDLED_TEMPLATE_PATH)));
        if (root == null) {
            for (String path : DEVELOPMENT_TEMPLATE_PATHS) {
                root = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)(homePath + path)));
                if (root != null) break;
            }
        }
        if (root == null) {
            LOG.error("Templates not found in: " + homePath + BUNDLED_TEMPLATE_PATH + " or " + homePath + Arrays.toString(DEVELOPMENT_TEMPLATE_PATHS));
        } else {
            File templateDir = new File(root.getCanonicalPath()).getAbsoluteFile();
            if (templateDir.isDirectory()) {
                folders.add(templateDir);
            }
        }
        ArrayList<File> arrayList = folders;
        if (arrayList == null) {
            TemplateManager.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    public List<File> getTemplates(@NotNull String folder) {
        File[] files2;
        if (folder == null) {
            TemplateManager.$$$reportNull$$$0(3);
        }
        ArrayList<File> templates = new ArrayList<File>();
        HashMap templateNames = Maps.newHashMap();
        File root = TemplateManager.getTemplateRootFolder();
        if (root != null && (files2 = new File(root, folder).listFiles()) != null) {
            for (File file : files2) {
                if (!file.isDirectory() || !new File(file, "template.xml").exists()) continue;
                templates.add(file);
                templateNames.put(file.getName(), file);
            }
        }
        for (File extra : TemplateManager.getExtraTemplateRootFolders()) {
            for (File file : TemplateManager.listFiles(new File(extra, folder))) {
                if (!file.isDirectory() || !new File(file, "template.xml").exists()) continue;
                File replaces = (File)templateNames.get(file.getName());
                if (replaces != null) {
                    int compare = this.compareTemplates(replaces, file);
                    if (compare <= 0) continue;
                    int index = templates.indexOf(replaces);
                    if (index != -1) {
                        templates.set(index, file);
                        continue;
                    }
                    templates.add(file);
                    continue;
                }
                templates.add(file);
            }
        }
        if (templates.size() > 1) {
            Collections.sort(templates, (file1, file2) -> file1.getName().compareTo(file2.getName()));
        }
        ArrayList<File> arrayList = templates;
        if (arrayList == null) {
            TemplateManager.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public List<TemplateHandle> getTemplateList(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            TemplateManager.$$$reportNull$$$0(5);
        }
        List<TemplateHandle> list = this.getTemplateList(formFactor, NewAndroidComponentAction.NEW_WIZARD_CATEGORIES, EXCLUDED_TEMPLATES);
        if (list == null) {
            TemplateManager.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public static List<File> getTemplatesFromDirectory(@NotNull File externalDirectory, boolean recursive) {
        File[] files2;
        if (externalDirectory == null) {
            TemplateManager.$$$reportNull$$$0(7);
        }
        ArrayList templates = Lists.newArrayList();
        if (new File(externalDirectory, "template.xml").exists()) {
            templates.add(externalDirectory);
        }
        if (recursive && (files2 = externalDirectory.listFiles()) != null) {
            for (File file : files2) {
                if (!file.isDirectory()) continue;
                templates.addAll(TemplateManager.getTemplatesFromDirectory(file, true));
            }
        }
        ArrayList arrayList = templates;
        if (arrayList == null) {
            TemplateManager.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    public List<File> getTemplateDirectoriesFromAars(@Nullable Project project) {
        ArrayList templateDirectories = Lists.newArrayList();
        if (project != null && project.getBaseDir() != null) {
            File aarRoot;
            if (this.myAarCache == null) {
                String prefix = project.getName();
                String suffix = "aar_cache";
                try {
                    this.myAarCache = FileUtil.createTempDirectory((String)prefix, (String)suffix);
                }
                catch (IOException e) {
                    LOG.error(String.format("Problem trying to create temp directory with prefix: '%1$s' suffix: '%2$s' path: '%3$s'", prefix, suffix, FileUtil.getTempDirectory()), (Throwable)e);
                    ArrayList arrayList = templateDirectories;
                    if (arrayList == null) {
                        TemplateManager.$$$reportNull$$$0(9);
                    }
                    return arrayList;
                }
            }
            if ((aarRoot = new File(project.getBasePath(), FileUtil.toSystemDependentName((String)EXPLODED_AAR_PATH))).isDirectory()) {
                for (File artifactPackage : TemplateManager.listFiles(aarRoot)) {
                    if (!artifactPackage.isDirectory() || artifactPackage.isHidden()) continue;
                    for (File artifactName : TemplateManager.listFiles(artifactPackage)) {
                        if (!artifactName.isDirectory() || artifactName.isHidden()) continue;
                        templateDirectories.addAll(this.getHighestVersionedTemplateRoot(artifactName));
                    }
                }
            }
        }
        ArrayList arrayList = templateDirectories;
        if (arrayList == null) {
            TemplateManager.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    private List<File> getHighestVersionedTemplateRoot(@NotNull File artifactNameRoot) {
        if (artifactNameRoot == null) {
            TemplateManager.$$$reportNull$$$0(11);
        }
        ArrayList templateDirectories = Lists.newArrayList();
        File highestVersionDir = null;
        Revision highestVersionNumber = null;
        for (File versionDir : TemplateManager.listFiles(artifactNameRoot)) {
            Revision revision;
            if (!versionDir.isDirectory() || versionDir.isHidden()) continue;
            try {
                revision = Revision.parseRevision((String)versionDir.getName());
            }
            catch (NumberFormatException e) {
                revision = Revision.NOT_SPECIFIED;
            }
            if (highestVersionNumber != null && revision.compareTo(highestVersionNumber) <= 0) continue;
            highestVersionNumber = revision;
            highestVersionDir = versionDir;
        }
        if (highestVersionDir != null) {
            File zipFile;
            String name = artifactNameRoot.getName() + "-" + highestVersionNumber.toString();
            File inflated = new File(this.myAarCache, name);
            if (!inflated.isDirectory() && (zipFile = new File(highestVersionDir, TEMPLATE_ZIP_NAME)).isFile()) {
                try {
                    ZipUtil.unzip(null, (File)inflated, (File)zipFile, null, null, (boolean)true);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            if (inflated.isDirectory()) {
                templateDirectories.add(inflated);
            }
        }
        ArrayList arrayList = templateDirectories;
        if (arrayList == null) {
            TemplateManager.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<File> getTemplatesInCategory(@NotNull String category) {
        if (category == null) {
            TemplateManager.$$$reportNull$$$0(13);
        }
        Object object = this.CATEGORY_TABLE_LOCK;
        // MONITORENTER : object
        Table<String, String, File> table2 = this.getCategoryTable();
        if (table2.containsRow((Object)category)) {
            ArrayList arrayList = Lists.newArrayList(table2.row((Object)category).values());
            // MONITOREXIT : object
            if (arrayList != null) return arrayList;
            TemplateManager.$$$reportNull$$$0(14);
            return arrayList;
        }
        ArrayList arrayList = Lists.newArrayList();
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        TemplateManager.$$$reportNull$$$0(15);
        return arrayList;
    }

    @Nullable
    public ActionGroup getTemplateCreationMenu(@Nullable Project project) {
        this.refreshDynamicTemplateMenu(project);
        return this.myTopGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshDynamicTemplateMenu(@Nullable Project project) {
        Object object = this.CATEGORY_TABLE_LOCK;
        synchronized (object) {
            if (this.myTopGroup == null) {
                this.myTopGroup = new DefaultActionGroup("AndroidTemplateGroup", false);
            } else {
                this.myTopGroup.removeAll();
            }
            this.myTopGroup.addSeparator();
            ActionManager am = ActionManager.getInstance();
            for (final String category : this.getCategoryTable(true, project).rowKeySet()) {
                if (EXCLUDED_CATEGORIES.contains(category)) continue;
                NonEmptyActionGroup categoryGroup = new NonEmptyActionGroup(){

                    public void update(AnActionEvent e) {
                        TemplateManager.updateAction(e, category, this.getChildrenCount() > 0, false);
                    }
                };
                categoryGroup.setPopup(true);
                this.fillCategory(categoryGroup, category, am);
                this.myTopGroup.add((AnAction)categoryGroup);
                TemplateManager.setPresentation(category, (AnAction)categoryGroup);
            }
        }
    }

    private static void updateAction(AnActionEvent event, String text, boolean visible, boolean disableIfNotReady) {
        IdeView view = (IdeView)event.getData(LangDataKeys.IDE_VIEW);
        Module module = (Module)event.getData(LangDataKeys.MODULE);
        AndroidFacet facet = module != null ? AndroidFacet.getInstance(module) : null;
        Presentation presentation = event.getPresentation();
        boolean isProjectReady = facet != null && ((AndroidFacetConfiguration)facet.getConfiguration()).getModel() != null;
        presentation.setText(text + (isProjectReady ? "" : " (Project not ready)"));
        presentation.setVisible(visible && view != null && facet != null && facet.requiresAndroidModel());
        presentation.setEnabled(disableIfNotReady ? isProjectReady : true);
    }

    private void fillCategory(NonEmptyActionGroup categoryGroup, String category, ActionManager am) {
        Map categoryRow = this.myCategoryTable.row((Object)category);
        if (CATEGORY_ACTIVITY.equals(category)) {
            AnAction galleryAction = new AnAction(){

                public void update(AnActionEvent e) {
                    TemplateManager.updateAction(e, "Gallery...", true, true);
                }

                public void actionPerformed(AnActionEvent e) {
                    ProjectSyncInvoker.DefaultProjectSyncInvoker projectSyncInvoker = new ProjectSyncInvoker.DefaultProjectSyncInvoker();
                    DataContext dataContext = e.getDataContext();
                    Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
                    assert (module != null);
                    VirtualFile targetFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
                    assert (targetFile != null);
                    VirtualFile targetDirectory = targetFile;
                    if (!targetDirectory.isDirectory()) {
                        targetDirectory = targetFile.getParent();
                        assert (targetDirectory != null);
                    }
                    AndroidFacet facet = AndroidFacet.getInstance(module);
                    assert (facet != null && ((AndroidFacetConfiguration)facet.getConfiguration()).getModel() != null);
                    List<NamedModuleTemplate> moduleTemplates = AndroidPackageUtils.getModuleTemplates(facet, targetDirectory);
                    assert (!moduleTemplates.isEmpty());
                    String initialPackageSuggestion = AndroidPackageUtils.getPackageForPath(facet, moduleTemplates, targetDirectory);
                    Project project = facet.getModule().getProject();
                    RenderTemplateModel renderModel = new RenderTemplateModel(facet, null, initialPackageSuggestion, moduleTemplates.get(0), AndroidBundle.message("android.wizard.activity.add", FormFactor.MOBILE.id), projectSyncInvoker, true);
                    NewModuleModel moduleModel = new NewModuleModel(project, projectSyncInvoker);
                    ChooseActivityTypeStep chooseActivityTypeStep = new ChooseActivityTypeStep(moduleModel, renderModel, FormFactor.MOBILE, targetDirectory);
                    ModelWizard wizard = new ModelWizard.Builder(new ModelWizardStep[0]).addStep(chooseActivityTypeStep).build();
                    new StudioWizardDialogBuilder(wizard, "New Android Activity").build().show();
                }
            };
            categoryGroup.add(galleryAction);
            categoryGroup.addSeparator();
            TemplateManager.setPresentation(category, galleryAction);
        }
        for (String templateName : categoryRow.keySet()) {
            if (EXCLUDED_TEMPLATES.contains(templateName)) continue;
            TemplateMetadata metadata = this.getTemplateMetadata((File)this.myCategoryTable.get((Object)category, (Object)templateName));
            int minSdkVersion2 = metadata == null ? 0 : metadata.getMinSdk();
            int minBuildSdkApi = metadata == null ? 0 : metadata.getMinBuildApi();
            NewAndroidComponentAction templateAction = new NewAndroidComponentAction(category, templateName, minSdkVersion2, minBuildSdkApi);
            String actionId = ACTION_ID_PREFIX + category + templateName;
            am.unregisterAction(actionId);
            am.registerAction(actionId, (AnAction)templateAction);
            categoryGroup.add((AnAction)templateAction);
        }
    }

    private static void setPresentation(String category, AnAction categoryGroup) {
        Presentation presentation = categoryGroup.getTemplatePresentation();
        presentation.setIcon(AndroidIcons.Android);
        presentation.setText(category);
    }

    private Table<String, String, File> getCategoryTable() {
        return this.getCategoryTable(false, null);
    }

    private Table<String, String, File> getCategoryTable(boolean forceReload, @Nullable Project project) {
        if (this.myCategoryTable == null || forceReload) {
            if (this.myTemplateMap != null) {
                this.myTemplateMap.clear();
            }
            this.myCategoryTable = TreeBasedTable.create();
            for (File categoryDirectory : TemplateManager.listFiles(TemplateManager.getTemplateRootFolder())) {
                for (File newTemplate : TemplateManager.listFiles(categoryDirectory)) {
                    this.addTemplateToTable(newTemplate, false);
                }
            }
            for (File rootDirectory : TemplateManager.getUserDefinedTemplateRootFolders()) {
                for (File categoryDirectory : TemplateManager.listFiles(rootDirectory)) {
                    File[] fileArray = TemplateManager.listFiles(categoryDirectory);
                    int n = fileArray.length;
                    for (int j = 0; j < n; ++j) {
                        File newTemplate = fileArray[j];
                        this.addTemplateToTable(newTemplate, true);
                    }
                }
            }
            for (File rootDirectory : TemplateManager.getAuxTemplateRootFolders()) {
                for (File categoryDirectory : TemplateManager.listFiles(rootDirectory)) {
                    for (File newTemplate : TemplateManager.listFiles(categoryDirectory)) {
                        this.addTemplateToTable(newTemplate, false);
                    }
                }
            }
            for (File aarDirectory : this.getTemplateDirectoriesFromAars(project)) {
                for (File newTemplate : TemplateManager.listFiles(aarDirectory)) {
                    this.addTemplateToTable(newTemplate, false);
                }
            }
        }
        return this.myCategoryTable;
    }

    private void addTemplateToTable(@NotNull File newTemplate, boolean userDefinedTemplate) {
        TemplateMetadata newMetadata;
        if (newTemplate == null) {
            TemplateManager.$$$reportNull$$$0(16);
        }
        if ((newMetadata = this.getTemplateMetadata(newTemplate, userDefinedTemplate)) != null) {
            String title = newMetadata.getTitle();
            if (title == null || newMetadata.getCategory() == null && this.myCategoryTable.columnKeySet().contains(title) && this.myCategoryTable.get((Object)CATEGORY_OTHER, (Object)title) == null) {
                return;
            }
            String category = newMetadata.getCategory() != null ? newMetadata.getCategory() : CATEGORY_OTHER;
            File existingTemplate = (File)this.myCategoryTable.get((Object)category, (Object)title);
            if (existingTemplate == null || this.compareTemplates(existingTemplate, newTemplate) > 0) {
                this.myCategoryTable.put((Object)category, (Object)title, (Object)newTemplate);
            }
        }
    }

    private int compareTemplates(@NotNull File file1, @NotNull File file2) {
        if (file1 == null) {
            TemplateManager.$$$reportNull$$$0(17);
        }
        if (file2 == null) {
            TemplateManager.$$$reportNull$$$0(18);
        }
        TemplateMetadata template1 = this.getTemplateMetadata(file1);
        TemplateMetadata template2 = this.getTemplateMetadata(file2);
        if (template1 == null) {
            return 1;
        }
        if (template2 == null) {
            return -1;
        }
        int delta = template2.getRevision() - template1.getRevision();
        if (delta == 0) {
            delta = (int)(file2.lastModified() - file1.lastModified());
        }
        return delta;
    }

    private List<TemplateHandle> getTemplateList(@NotNull FormFactor formFactor, @NotNull Set<String> categories, @NotNull Set<String> excluded) {
        if (formFactor == null) {
            TemplateManager.$$$reportNull$$$0(19);
        }
        if (categories == null) {
            TemplateManager.$$$reportNull$$$0(20);
        }
        if (excluded == null) {
            TemplateManager.$$$reportNull$$$0(21);
        }
        ArrayList templates = Lists.newArrayList();
        for (String category : categories) {
            templates.addAll(this.getTemplateList(formFactor, category, excluded));
        }
        if (formFactor == FormFactor.WEAR) {
            templates.addAll(this.getTemplateList(formFactor, "Wear", excluded));
        }
        if (formFactor == FormFactor.CAR) {
            templates.addAll(this.getTemplateList(formFactor, "Android Auto", excluded));
        }
        Collections.sort(templates, (o1, o2) -> {
            TemplateMetadata m1 = o1.getMetadata();
            TemplateMetadata m2 = o2.getMetadata();
            return StringUtil.naturalCompare((String)m1.getTitle(), (String)m2.getTitle());
        });
        return templates;
    }

    private List<TemplateHandle> getTemplateList(@NotNull FormFactor formFactor, @NotNull String category, @Nullable Set<String> excluded) {
        if (formFactor == null) {
            TemplateManager.$$$reportNull$$$0(22);
        }
        if (category == null) {
            TemplateManager.$$$reportNull$$$0(23);
        }
        List<File> templates = this.getTemplatesInCategory(category);
        ArrayList<TemplateHandle> metadataList = new ArrayList<TemplateHandle>(templates.size());
        for (File template : templates) {
            TemplateHandle templateHandle = new TemplateHandle(template);
            TemplateMetadata metadata = templateHandle.getMetadata();
            if (!metadata.isSupported() || excluded != null && excluded.contains(metadata.getTitle()) || !formFactor.id.equalsIgnoreCase(metadata.getFormFactor())) continue;
            metadataList.add(templateHandle);
        }
        return metadataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public File getTemplateFile(@Nullable String category, @Nullable String templateName) {
        Object object = this.CATEGORY_TABLE_LOCK;
        synchronized (object) {
            return (File)this.getCategoryTable().get((Object)category, (Object)templateName);
        }
    }

    @Nullable
    public TemplateMetadata getTemplateMetadata(@Nullable String category, @Nullable String templateName) {
        File templateDir = this.getTemplateFile(category, templateName);
        return templateDir != null ? this.getTemplateMetadata(templateDir) : null;
    }

    @Nullable
    public TemplateMetadata getTemplateMetadata(@NotNull File templateRoot) {
        if (templateRoot == null) {
            TemplateManager.$$$reportNull$$$0(24);
        }
        return this.getTemplateMetadata(templateRoot, false);
    }

    @Nullable
    private TemplateMetadata getTemplateMetadata(@NotNull File templateRoot, boolean userDefinedTemplate) {
        if (templateRoot == null) {
            TemplateManager.$$$reportNull$$$0(25);
        }
        if (this.myTemplateMap != null) {
            TemplateMetadata metadata = this.myTemplateMap.get(templateRoot);
            if (metadata != null) {
                return metadata;
            }
        } else {
            this.myTemplateMap = Maps.newHashMap();
        }
        try {
            File templateFile = new File(templateRoot, "template.xml");
            if (templateFile.isFile()) {
                String xml = Files.toString((File)templateFile, (Charset)Charsets.UTF_8);
                Document doc = userDefinedTemplate ? XmlUtils.parseDocument((String)xml, (boolean)true) : XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
                if (doc != null && doc.getDocumentElement() != null) {
                    TemplateMetadata metadata = new TemplateMetadata(doc);
                    this.myTemplateMap.put(templateRoot, metadata);
                    return metadata;
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        return null;
    }

    public static boolean templatesAreValid() {
        try {
            File templateRootFolder = TemplateManager.getTemplateRootFolder();
            if (templateRootFolder == null) {
                return false;
            }
            return TemplateManager.templateRootIsValid(templateRootFolder);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static File getWrapperLocation(@NotNull File templateRootFolder) {
        if (templateRootFolder == null) {
            TemplateManager.$$$reportNull$$$0(26);
        }
        return new File(templateRootFolder, SdkConstants.FD_GRADLE_WRAPPER);
    }

    public static boolean templateRootIsValid(@NotNull File templateRootFolder) {
        if (templateRootFolder == null) {
            TemplateManager.$$$reportNull$$$0(27);
        }
        return new File(TemplateManager.getWrapperLocation(templateRootFolder), "gradlew").exists();
    }

    private static File[] listFiles(@NotNull File root) {
        if (root == null) {
            TemplateManager.$$$reportNull$$$0(28);
        }
        return FileOpUtils.create().listFiles(root);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/templates/TemplateManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 5: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formFactor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalDirectory";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactNameRoot";
                break;
            }
            case 13: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTemplate";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "categories";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excluded";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateRoot";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateRootFolder";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraTemplateRootFolders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserDefinedTemplateRootFolders";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuxTemplateRootFolders";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/templates/TemplateManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplates";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateList";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplatesFromDirectory";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateDirectoriesFromAars";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighestVersionedTemplateRoot";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplatesInCategory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTemplates";
                break;
            }
            case 5: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateList";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTemplatesFromDirectory";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getHighestVersionedTemplateRoot";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTemplatesInCategory";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addTemplateToTable";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "compareTemplates";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateMetadata";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getWrapperLocation";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "templateRootIsValid";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "listFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

