/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.ddmlib.IDevice;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.android.tools.idea.stats.AndroidStudioUsageTracker$WhenMappings;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.android.tools.idea.stats.ToolWindowTrackerService;
import com.google.common.base.Strings;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.google.wireless.android.sdk.stats.ProductDetails;
import com.google.wireless.android.sdk.stats.StudioProjectChange;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\b\u0010\u0017\u001a\u00020\u0012H\u0002R\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/stats/AndroidStudioUsageTracker;", "", "()V", "productDetails", "Lcom/google/wireless/android/sdk/stats/ProductDetails;", "productDetails$annotations", "getProductDetails", "()Lcom/google/wireless/android/sdk/stats/ProductDetails;", "currentIdeTheme", "Lcom/google/wireless/android/sdk/stats/ProductDetails$IdeTheme;", "deviceToDeviceInfo", "Lcom/google/wireless/android/sdk/stats/DeviceInfo;", "device", "Lcom/android/ddmlib/IDevice;", "deviceToDeviceInfoApilLevelOnly", "lifecycleChannelFromUpdateSettings", "Lcom/google/wireless/android/sdk/stats/ProductDetails$SoftwareLifeCycleChannel;", "runDailyReports", "", "runHourlyReports", "setup", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "subscribeToEvents", "ProjectLifecycleTracker", "intellij.android.core"})
public final class AndroidStudioUsageTracker {
    public static final AndroidStudioUsageTracker INSTANCE;

    @JvmStatic
    public static /* synthetic */ void productDetails$annotations() {
    }

    @NotNull
    public static final ProductDetails getProductDetails() {
        ApplicationInfo application = ApplicationInfo.getInstance();
        ProductDetails.Builder builder = ProductDetails.newBuilder().setProduct(ProductDetails.ProductKind.STUDIO);
        ApplicationInfo applicationInfo = application;
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfo, (String)"application");
        ProductDetails productDetails = builder.setBuild(applicationInfo.getBuild().asString()).setVersion(application.getStrictVersion()).setOsArchitecture(CommonMetricsData.getOsArchitecture()).setChannel(INSTANCE.lifecycleChannelFromUpdateSettings()).setTheme(INSTANCE.currentIdeTheme()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)productDetails, (String)"ProductDetails.newBuilde\u2026Theme())\n        .build()");
        return productDetails;
    }

    @JvmStatic
    public static final void setup(@NotNull ScheduledExecutorService scheduler) {
        Intrinsics.checkParameterIsNotNull((Object)scheduler, (String)"scheduler");
        scheduler.scheduleWithFixedDelay(setup.1.INSTANCE, 0L, 1L, TimeUnit.DAYS);
        scheduler.scheduleWithFixedDelay(setup.2.INSTANCE, 0L, 1L, TimeUnit.HOURS);
        INSTANCE.subscribeToEvents();
    }

    private final void subscribeToEvents() {
        Application app;
        Application application = app = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
        MessageBusConnection messageBusConnection = application.getMessageBus().connect();
        Intrinsics.checkExpressionValueIsNotNull((Object)messageBusConnection, (String)"app.messageBus.connect()");
        MessageBusConnection connection = messageBusConnection;
        connection.subscribe(ProjectLifecycleListener.TOPIC, (Object)new ProjectLifecycleTracker());
    }

    private final void runDailyReports() {
        AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.PING).setKind(AndroidStudioEvent.EventKind.STUDIO_PING).setProductDetails(AndroidStudioUsageTracker.getProductDetails()).setMachineDetails(CommonMetricsData.getMachineDetails((File)new File(PathManager.getHomePath()))).setJvmDetails(CommonMetricsData.getJvmDetails());
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"AndroidStudioEvent.newBu\u2026onMetricsData.jvmDetails)");
        UsageTracker.log((AndroidStudioEvent.Builder)builder);
    }

    private final void runHourlyReports() {
        AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.SYSTEM).setKind(AndroidStudioEvent.EventKind.STUDIO_PROCESS_STATS).setJavaProcessStats(CommonMetricsData.getJavaProcessStats());
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"AndroidStudioEvent.newBu\u2026icsData.javaProcessStats)");
        UsageTracker.log((AndroidStudioEvent.Builder)builder);
    }

    @JvmStatic
    @NotNull
    public static final DeviceInfo deviceToDeviceInfo(@NotNull IDevice device) {
        Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
        DeviceInfo deviceInfo = DeviceInfo.newBuilder().setAnonymizedSerialNumber(AnonymizerUtil.anonymizeUtf8((String)device.getSerialNumber())).setBuildTags(Strings.nullToEmpty((String)device.getProperty("ro.build.tags"))).setBuildType(Strings.nullToEmpty((String)device.getProperty("ro.build.type"))).setBuildVersionRelease(Strings.nullToEmpty((String)device.getProperty("ro.build.version.release"))).setBuildApiLevelFull(Strings.nullToEmpty((String)device.getProperty("ro.build.version.sdk"))).setCpuAbi(CommonMetricsData.applicationBinaryInterfaceFromString((String)device.getProperty("ro.product.cpu.abi"))).setManufacturer(Strings.nullToEmpty((String)device.getProperty("ro.product.manufacturer"))).setDeviceType(device.isEmulator() ? DeviceInfo.DeviceType.LOCAL_EMULATOR : DeviceInfo.DeviceType.LOCAL_PHYSICAL).setModel(Strings.nullToEmpty((String)device.getProperty("ro.product.model"))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)deviceInfo, (String)"DeviceInfo.newBuilder()\n\u2026P_DEVICE_MODEL))).build()");
        return deviceInfo;
    }

    private final ProductDetails.IdeTheme currentIdeTheme() {
        return UIUtil.isUnderDarcula() ? ProductDetails.IdeTheme.DARCULA : (UIUtil.isUnderGTKLookAndFeel() ? ProductDetails.IdeTheme.GTK : (UIUtil.isUnderIntelliJLaF() ? (UIUtil.isUnderWin10LookAndFeel() ? ProductDetails.IdeTheme.LIGHT_WIN_NATIVE : (UIUtil.isUnderDefaultMacTheme() ? ProductDetails.IdeTheme.LIGHT_MAC_NATIVE : ProductDetails.IdeTheme.LIGHT)) : ProductDetails.IdeTheme.UNKNOWN_THEME));
    }

    @JvmStatic
    @NotNull
    public static final DeviceInfo deviceToDeviceInfoApilLevelOnly(@NotNull IDevice device) {
        Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
        DeviceInfo deviceInfo = DeviceInfo.newBuilder().setBuildApiLevelFull(Strings.nullToEmpty((String)device.getProperty("ro.build.version.sdk"))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)deviceInfo, (String)"DeviceInfo.newBuilder()\n\u2026I_LEVEL)))\n      .build()");
        return deviceInfo;
    }

    private final ProductDetails.SoftwareLifeCycleChannel lifecycleChannelFromUpdateSettings() {
        ProductDetails.SoftwareLifeCycleChannel softwareLifeCycleChannel;
        UpdateSettings updateSettings = UpdateSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)updateSettings, (String)"UpdateSettings.getInstance()");
        switch (AndroidStudioUsageTracker$WhenMappings.$EnumSwitchMapping$0[updateSettings.getSelectedChannelStatus().ordinal()]) {
            case 1: {
                softwareLifeCycleChannel = ProductDetails.SoftwareLifeCycleChannel.CANARY;
                break;
            }
            case 2: {
                softwareLifeCycleChannel = ProductDetails.SoftwareLifeCycleChannel.DEV;
                break;
            }
            case 3: {
                softwareLifeCycleChannel = ProductDetails.SoftwareLifeCycleChannel.BETA;
                break;
            }
            case 4: {
                softwareLifeCycleChannel = ProductDetails.SoftwareLifeCycleChannel.STABLE;
                break;
            }
            default: {
                softwareLifeCycleChannel = ProductDetails.SoftwareLifeCycleChannel.UNKNOWN_LIFE_CYCLE_CHANNEL;
            }
        }
        return softwareLifeCycleChannel;
    }

    private AndroidStudioUsageTracker() {
    }

    static {
        AndroidStudioUsageTracker androidStudioUsageTracker;
        INSTANCE = androidStudioUsageTracker = new AndroidStudioUsageTracker();
    }

    public static final /* synthetic */ void access$runDailyReports(AndroidStudioUsageTracker $this) {
        $this.runDailyReports();
    }

    public static final /* synthetic */ void access$runHourlyReports(AndroidStudioUsageTracker $this) {
        $this.runHourlyReports();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/stats/AndroidStudioUsageTracker$ProjectLifecycleTracker;", "Lcom/intellij/openapi/project/impl/ProjectLifecycleListener;", "()V", "afterProjectClosed", "", "project", "Lcom/intellij/openapi/project/Project;", "beforeProjectLoaded", "projectComponentsInitialized", "intellij.android.core"})
    private static final class ProjectLifecycleTracker
    implements ProjectLifecycleListener {
        public void beforeProjectLoaded(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)projectManager, (String)"ProjectManager.getInstance()");
            int projectsOpen = projectManager.getOpenProjects().length;
            AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.STUDIO_PROJECT_OPENED).setStudioProjectChange(StudioProjectChange.newBuilder().setProjectsOpen(projectsOpen));
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"AndroidStudioEvent.newBu\u2026ojectsOpen(projectsOpen))");
            UsageTracker.log((AndroidStudioEvent.Builder)builder);
        }

        public void afterProjectClosed(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)projectManager, (String)"ProjectManager.getInstance()");
            int projectsOpen = projectManager.getOpenProjects().length;
            AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.STUDIO_PROJECT_CLOSED).setStudioProjectChange(StudioProjectChange.newBuilder().setProjectsOpen(projectsOpen));
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"AndroidStudioEvent.newBu\u2026ojectsOpen(projectsOpen))");
            UsageTracker.log((AndroidStudioEvent.Builder)builder);
        }

        public void projectComponentsInitialized(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            ToolWindowTrackerService service = ToolWindowTrackerService.Companion.getInstance(project);
            ToolWindowManagerEx.getInstanceEx((Project)project).addToolWindowManagerListener((ToolWindowManagerListener)service, (Disposable)project);
        }
    }
}

