/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard.legacy;

import com.android.repository.api.Downloader;
import com.android.repository.api.License;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.wizard.AndroidSdkLicenseTemporaryData;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStepWithDescription;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.treeStructure.Tree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LicenseAgreementStep
extends DynamicWizardStepWithDescription {
    private final AndroidSdkHandler mySdkHandler;
    private JTextPane myLicenseTextField;
    private Tree myChangeTree;
    private JRadioButton myDeclineRadioButton;
    private JRadioButton myAcceptRadioButton;
    private DefaultTreeModel myTreeModel;
    private Map<String, Boolean> myAcceptances;
    private Set<String> myVisibleLicenses;
    private String myCurrentLicense;
    private Set<License> myLicenses;
    private final File mySdkRoot;

    public LicenseAgreementStep(@NotNull Disposable disposable) {
        if (disposable == null) {
            LicenseAgreementStep.$$$reportNull$$$0(0);
        }
        super(disposable);
        this.myTreeModel = new DefaultTreeModel(null);
        this.myAcceptances = Maps.newHashMap();
        this.myVisibleLicenses = Sets.newHashSet();
        this.myLicenses = Sets.newHashSet();
        Splitter splitter = new Splitter(false, 0.3f);
        splitter.setHonorComponentsMinimumSize(true);
        this.myChangeTree = new Tree();
        splitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myChangeTree));
        this.myLicenseTextField = new JTextPane();
        splitter.setSecondComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myLicenseTextField));
        this.myDeclineRadioButton = new JBRadioButton("Decline");
        this.myAcceptRadioButton = new JBRadioButton("Accept");
        ButtonGroup optionsGroup = new ButtonGroup();
        optionsGroup.add(this.myDeclineRadioButton);
        optionsGroup.add(this.myAcceptRadioButton);
        JPanel optionsPanel = new JPanel(new FlowLayout(4));
        optionsPanel.add(this.myDeclineRadioButton);
        optionsPanel.add(this.myAcceptRadioButton);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)splitter, "Center");
        mainPanel.add((Component)optionsPanel, "South");
        this.setBodyComponent(mainPanel);
        this.mySdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        this.mySdkRoot = this.mySdkHandler.getLocation();
    }

    @Override
    public void init() {
        super.init();
        this.myChangeTree.setModel((TreeModel)this.myTreeModel);
        this.myChangeTree.setShowsRootHandles(false);
        this.myLicenseTextField.setEditable(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.myDeclineRadioButton);
        group.add(this.myAcceptRadioButton);
        this.myDeclineRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LicenseAgreementStep.this.myAcceptances.put(LicenseAgreementStep.this.myCurrentLicense, Boolean.FALSE);
                LicenseAgreementStep.this.invokeUpdate(null);
                LicenseAgreementStep.this.myChangeTree.repaint();
            }
        });
        this.myAcceptRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LicenseAgreementStep.this.myAcceptances.put(LicenseAgreementStep.this.myCurrentLicense, Boolean.TRUE);
                LicenseAgreementStep.this.invokeUpdate(null);
                LicenseAgreementStep.this.myChangeTree.repaint();
            }
        });
        this.myChangeTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode selected = (DefaultMutableTreeNode)LicenseAgreementStep.this.myChangeTree.getLastSelectedPathComponent();
                if (selected != null && selected.isRoot()) {
                    return;
                }
                if (selected != null && !selected.isLeaf()) {
                    License license = (License)selected.getUserObject();
                    LicenseAgreementStep.this.myLicenseTextField.setText(license.getValue());
                    LicenseAgreementStep.this.myCurrentLicense = license.getId();
                } else if (selected != null && !selected.isRoot()) {
                    Change change = (Change)selected.getUserObject();
                    LicenseAgreementStep.this.myLicenseTextField.setText(change.license.getValue());
                    LicenseAgreementStep.this.myCurrentLicense = change.license.getId();
                }
                if (((Boolean)LicenseAgreementStep.this.myAcceptances.get(LicenseAgreementStep.this.myCurrentLicense)).booleanValue()) {
                    LicenseAgreementStep.this.myAcceptRadioButton.setSelected(true);
                } else {
                    LicenseAgreementStep.this.myDeclineRadioButton.setSelected(true);
                }
                LicenseAgreementStep.this.myLicenseTextField.setCaretPosition(0);
            }
        });
        this.myChangeTree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (row == 0) {
                    this.append("Licenses", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value2;
                if (!leaf) {
                    License license = (License)node.getUserObject();
                    this.appendLicenseText(license, license.getId());
                } else {
                    Change change = (Change)node.getUserObject();
                    if (change == null) {
                        return;
                    }
                    this.appendLicenseText(change.license, change.toString());
                    this.setIcon(change.getIcon());
                }
            }

            private void appendLicenseText(@Nullable License license, String text) {
                boolean notAccepted;
                boolean bl = notAccepted = license != null && (Boolean)LicenseAgreementStep.this.myAcceptances.get(license.getId()) == false;
                if (notAccepted) {
                    this.append("*", SimpleTextAttributes.ERROR_ATTRIBUTES);
                    this.append(text, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                } else {
                    this.append(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/sdk/wizard/legacy/LicenseAgreementStep$4", "customizeCellRenderer"));
            }
        });
        this.setChanges(this.createChangesList());
    }

    @Override
    public boolean isStepVisible() {
        return this.myState.listSize(WizardConstants.INSTALL_REQUESTS_KEY) > 0 && !this.myLicenses.isEmpty();
    }

    @Override
    public boolean validate() {
        for (String licenseRef : this.myVisibleLicenses) {
            if (this.myAcceptances.get(licenseRef).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public String getStepName() {
        if ("License Agreement" == null) {
            LicenseAgreementStep.$$$reportNull$$$0(1);
        }
        return "License Agreement";
    }

    @Override
    @NotNull
    protected String getStepTitle() {
        if ("License Agreement" == null) {
            LicenseAgreementStep.$$$reportNull$$$0(2);
        }
        return "License Agreement";
    }

    @Override
    @Nullable
    protected String getStepDescription() {
        return "Read and agree to the licenses for the components which will be installed";
    }

    private void expandTree() {
        for (int i2 = 0; i2 < this.myChangeTree.getRowCount(); ++i2) {
            this.myChangeTree.expandRow(i2);
        }
    }

    private List<Change> createChangesList() {
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
        RepoManager sdkManager = this.mySdkHandler.getSdkManager((ProgressIndicator)progress);
        sdkManager.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, (ProgressIndicator)progress, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance());
        Map remotePackages = sdkManager.getPackages().getRemotePackages();
        ArrayList toReturn = Lists.newArrayList();
        List<String> requestedPackages = this.myState.get(WizardConstants.INSTALL_REQUESTS_KEY);
        if (requestedPackages != null) {
            for (String path : requestedPackages) {
                RemotePackage p = (RemotePackage)remotePackages.get(path);
                License license = p.getLicense();
                if (license == null) {
                    license = AndroidSdkLicenseTemporaryData.INSTANCE.getLicense(p.getTypeDetails() instanceof DetailsTypes.ApiDetailsType && ((DetailsTypes.ApiDetailsType)p.getTypeDetails()).getAndroidVersion().isPreview());
                }
                this.myLicenses.add(license);
                if (license.checkAccepted(this.mySdkRoot, this.mySdkHandler.getFileOp())) continue;
                toReturn.add(new Change(ChangeType.INSTALL, (RepoPackage)p, license));
            }
        }
        return toReturn;
    }

    private void setChanges(List<Change> changes) {
        HashMap licenseNodeMap = Maps.newHashMap();
        this.myVisibleLicenses.clear();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        DefaultMutableTreeNode firstChild = null;
        for (Change change : changes) {
            String licenseRef = change.license.getId();
            this.myVisibleLicenses.add(licenseRef);
            if (!licenseNodeMap.containsKey(licenseRef)) {
                DefaultMutableTreeNode n = new DefaultMutableTreeNode(change.license);
                if (firstChild == null) {
                    firstChild = n;
                }
                licenseNodeMap.put(licenseRef, n);
                this.myAcceptances.put(licenseRef, Boolean.FALSE);
                root.add(n);
            }
            ((DefaultMutableTreeNode)licenseNodeMap.get(licenseRef)).add(new DefaultMutableTreeNode(change));
        }
        this.myTreeModel = new DefaultTreeModel(root);
        this.myChangeTree.setModel((TreeModel)this.myTreeModel);
        this.expandTree();
        if (firstChild != null) {
            this.myChangeTree.setSelectionPath(new TreePath(firstChild.getPath()));
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myChangeTree;
    }

    public void performFinishingActions() {
        for (License license : this.myLicenses) {
            license.setAccepted(this.mySdkRoot, this.mySdkHandler.getFileOp());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/sdk/wizard/legacy/LicenseAgreementStep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/sdk/wizard/legacy/LicenseAgreementStep";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class Change {
        public ChangeType myType;
        public RepoPackage myPackage;
        public License license;

        public Change(@NotNull ChangeType type, @NotNull RepoPackage packageDescription, @NotNull License license) {
            if (type == null) {
                Change.$$$reportNull$$$0(0);
            }
            if (packageDescription == null) {
                Change.$$$reportNull$$$0(1);
            }
            if (license == null) {
                Change.$$$reportNull$$$0(2);
            }
            this.myType = type;
            this.myPackage = packageDescription;
            this.license = license;
        }

        public String toString() {
            return this.myPackage.getDisplayName();
        }

        public Icon getIcon() {
            switch (this.myType) {
                case INSTALL: {
                    return AllIcons.Actions.Download;
                }
                case UPDATE: {
                    return AllIcons.Actions.Refresh;
                }
                case REMOVE: {
                    return AllIcons.Actions.Cancel;
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "packageDescription";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "license";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/sdk/wizard/legacy/LicenseAgreementStep$Change";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static enum ChangeType {
        INSTALL,
        UPDATE,
        REMOVE;

    }
}

