/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install.patch;

import com.android.repository.api.Downloader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.installer.AbstractInstaller;
import com.android.repository.impl.meta.Archive;
import com.android.repository.io.FileOp;
import com.android.repository.util.InstallerUtil;
import com.android.tools.idea.sdk.install.patch.PatchInstallerUtil;
import com.android.tools.idea.sdk.install.patch.PatchOperation;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FullInstaller
extends AbstractInstaller
implements PatchOperation {
    private static final String UNZIP_DIR_FN = "unzip";
    private LocalPackage myExisting;
    private LocalPackage myPatcher;
    private File myUnzippedPackage;
    private File myGeneratedPatch;

    FullInstaller(@Nullable LocalPackage existing2, @NotNull RemotePackage p, @NotNull RepoManager mgr, @NotNull Downloader downloader, @NotNull FileOp fop) {
        if (p == null) {
            FullInstaller.$$$reportNull$$$0(0);
        }
        if (mgr == null) {
            FullInstaller.$$$reportNull$$$0(1);
        }
        if (downloader == null) {
            FullInstaller.$$$reportNull$$$0(2);
        }
        if (fop == null) {
            FullInstaller.$$$reportNull$$$0(3);
        }
        super(p, mgr, downloader, fop);
        this.myExisting = existing2;
        this.myPatcher = PatchInstallerUtil.getDependantPatcher(this.getPackage(), this.getRepoManager());
        if (this.myPatcher == null) {
            this.myPatcher = PatchInstallerUtil.getLatestPatcher(this.getRepoManager());
        }
    }

    protected boolean doComplete(@Nullable File installTemp, @NotNull ProgressIndicator progress) {
        if (progress == null) {
            FullInstaller.$$$reportNull$$$0(4);
        }
        if (this.myPatcher == null) {
            return false;
        }
        return PatchInstallerUtil.installPatch(this, this.myGeneratedPatch, this.mFop, progress);
    }

    protected boolean doPrepare(@NotNull File installTempPath, @NotNull ProgressIndicator progress) {
        if (installTempPath == null) {
            FullInstaller.$$$reportNull$$$0(5);
        }
        if (progress == null) {
            FullInstaller.$$$reportNull$$$0(6);
        }
        if (!this.downloadAndUnzip(installTempPath, this.getDownloader(), progress.createSubProgress(0.5))) {
            progress.setFraction(1.0);
            return false;
        }
        this.myUnzippedPackage = new File(installTempPath, UNZIP_DIR_FN);
        File[] children = this.mFop.listFiles(this.myUnzippedPackage);
        if (children.length == 1) {
            this.myUnzippedPackage = children[0];
        }
        this.myGeneratedPatch = PatchInstallerUtil.generatePatch(this, installTempPath, this.mFop, progress.createSubProgress(1.0));
        progress.setFraction(1.0);
        return this.myGeneratedPatch != null;
    }

    private boolean downloadAndUnzip(@NotNull File installTempPath, @NotNull Downloader downloader, @NotNull ProgressIndicator progress) {
        URL url;
        if (installTempPath == null) {
            FullInstaller.$$$reportNull$$$0(7);
        }
        if (downloader == null) {
            FullInstaller.$$$reportNull$$$0(8);
        }
        if (progress == null) {
            FullInstaller.$$$reportNull$$$0(9);
        }
        if ((url = InstallerUtil.resolveCompleteArchiveUrl((RemotePackage)this.getPackage(), (ProgressIndicator)progress)) == null) {
            progress.logWarning("No compatible archive found!");
            return false;
        }
        Archive archive = this.getPackage().getArchive();
        assert (archive != null);
        try {
            File downloadLocation = new File(installTempPath, url.getFile());
            String checksum = archive.getComplete().getChecksum();
            downloader.downloadFullyWithCaching(url, downloadLocation, checksum, progress.createSubProgress(0.5));
            progress.setFraction(0.5);
            if (progress.isCanceled()) {
                progress.setFraction(1.0);
                return false;
            }
            if (!this.mFop.exists(downloadLocation)) {
                progress.setFraction(1.0);
                progress.logWarning("Failed to download package!");
                return false;
            }
            File unzip = new File(installTempPath, UNZIP_DIR_FN);
            this.mFop.mkdirs(unzip);
            InstallerUtil.unzip((File)downloadLocation, (File)unzip, (FileOp)this.mFop, (long)archive.getComplete().getSize(), (ProgressIndicator)progress.createSubProgress(1.0));
            progress.setFraction(1.0);
            if (progress.isCanceled()) {
                return false;
            }
            this.mFop.delete(downloadLocation);
            return true;
        }
        catch (IOException e) {
            StringBuilder message = new StringBuilder("An error occurred while preparing SDK package ").append(this.getPackage().getDisplayName());
            String exceptionMessage = e.getMessage();
            if (exceptionMessage != null && !exceptionMessage.isEmpty()) {
                message.append(": ").append(exceptionMessage);
            } else {
                message.append(".");
            }
            progress.logWarning(message.toString(), (Throwable)e);
            progress.setFraction(1.0);
            return false;
        }
    }

    @Override
    @Nullable
    public LocalPackage getExisting() {
        return this.myExisting;
    }

    @Override
    @NotNull
    public LocalPackage getPatcher(@NotNull ProgressIndicator progressIndicator) {
        if (progressIndicator == null) {
            FullInstaller.$$$reportNull$$$0(10);
        }
        LocalPackage localPackage = this.myPatcher;
        if (localPackage == null) {
            FullInstaller.$$$reportNull$$$0(11);
        }
        return localPackage;
    }

    @Override
    @NotNull
    public File getNewFilesRoot() {
        File file = this.myUnzippedPackage;
        if (file == null) {
            FullInstaller.$$$reportNull$$$0(12);
        }
        return file;
    }

    @Override
    @NotNull
    public String getNewVersionName() {
        String string = this.getPackage().getDisplayName() + " Version " + this.getPackage().getVersion();
        if (string == null) {
            FullInstaller.$$$reportNull$$$0(13);
        }
        return string;
    }

    protected void cleanup(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            FullInstaller.$$$reportNull$$$0(14);
        }
        super.cleanup(progress);
        this.mFop.deleteFileOrFolder(this.getLocation(progress));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mgr";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fop";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installTempPath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/sdk/install/patch/FullInstaller";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/sdk/install/patch/FullInstaller";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatcher";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewFilesRoot";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewVersionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doComplete";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doPrepare";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "downloadAndUnzip";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPatcher";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "cleanup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

