/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.SdkConstants;
import com.android.repository.Revision;
import com.google.common.io.Closeables;
import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VersionCheck {
    private static final Logger LOG = Logger.getInstance(VersionCheck.class);
    public static final Revision MIN_TOOLS_REV = new Revision(24, 0, 2, 0);
    private static final Pattern SOURCE_PROPERTY_PATTERN = Pattern.compile("^Pkg.Revision=(.*)$");

    private VersionCheck() {
    }

    public static boolean isCompatibleVersion(@NotNull File sdkDir) {
        if (sdkDir == null) {
            VersionCheck.$$$reportNull$$$0(0);
        }
        if (!sdkDir.isDirectory()) {
            return false;
        }
        return VersionCheck.isCompatibleVersion(sdkDir.getAbsolutePath());
    }

    public static boolean isCompatibleVersion(@Nullable String sdkPath) {
        if (sdkPath == null) {
            return false;
        }
        return VersionCheck.checkVersion(sdkPath).isCompatibleVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    public static VersionCheckResult checkVersion(@NotNull String sdkPath) {
        Revision toolsRevision;
        block15: {
            String line;
            if (sdkPath == null) {
                VersionCheck.$$$reportNull$$$0(1);
            }
            File toolsDir = new File(sdkPath, SdkConstants.OS_SDK_TOOLS_FOLDER);
            toolsRevision = new Revision(Integer.MAX_VALUE);
            BufferedReader reader = null;
            File sourceProperties2333333332 = new File(toolsDir, "source.properties");
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sourceProperties2333333332), StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                Matcher m = SOURCE_PROPERTY_PATTERN.matcher(line);
                if (!m.matches()) continue;
                try {
                    toolsRevision = Revision.parseRevision((String)m.group(1));
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            try {
                Closeables.close((Closeable)reader, (boolean)true);
            }
            catch (IOException sourceProperties2333333332) {}
            break block15;
            catch (IOException e) {
                try {
                    String msg = String.format("Failed to read file: '%1$s' for Android SDK at '%2$s'", "source.properties", sdkPath);
                    LOG.info(msg, (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        Closeables.close(reader, (boolean)true);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    Closeables.close((Closeable)reader, (boolean)true);
                }
                catch (IOException iOException) {}
            }
        }
        VersionCheckResult versionCheckResult = new VersionCheckResult(toolsRevision);
        if (versionCheckResult == null) {
            VersionCheck.$$$reportNull$$$0(2);
        }
        return versionCheckResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkDir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/sdk/VersionCheck";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/sdk/VersionCheck";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "checkVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isCompatibleVersion";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkVersion";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class VersionCheckResult {
        @NotNull
        private final Revision myRevision;
        private final boolean myCompatibleVersion;

        VersionCheckResult(@NotNull Revision revision) {
            if (revision == null) {
                VersionCheckResult.$$$reportNull$$$0(0);
            }
            this.myRevision = revision;
            this.myCompatibleVersion = VersionCheckResult.isCompatible(revision);
        }

        private static boolean isCompatible(@NotNull Revision revision) {
            if (revision == null) {
                VersionCheckResult.$$$reportNull$$$0(1);
            }
            if (revision.getMajor() == Integer.MAX_VALUE) {
                return false;
            }
            return revision.compareTo(MIN_TOOLS_REV, Revision.PreviewComparison.IGNORE) >= 0;
        }

        @NotNull
        public Revision getRevision() {
            Revision revision = this.myRevision;
            if (revision == null) {
                VersionCheckResult.$$$reportNull$$$0(2);
            }
            return revision;
        }

        public boolean isCompatibleVersion() {
            return this.myCompatibleVersion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/sdk/VersionCheck$VersionCheckResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/sdk/VersionCheck$VersionCheckResult";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevision";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isCompatible";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

