/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.startup.AndroidSdkInitializer;
import com.google.common.base.Joiner;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.EmulatorHost;
import com.google.wireless.android.sdk.stats.Hypervisor;
import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.util.EnumSet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemInfoStatsMonitor {
    private static final Logger LOG = Logger.getInstance(SystemInfoStatsMonitor.class);
    private static final int UPLOAD_INTERVAL_HOURS = 6;
    private static final Revision LOWEST_TOOLS_REVISION_HYPERV = new Revision(25, 0, 3);
    private static final Revision LOWEST_TOOLS_REVISION_CPU_INFO = new Revision(25, 1, 1);
    private static final int EMULATOR_CHECK_ERROR_EXIT_CODE = 100;
    private AndroidSdkHandler mySdkHandler = null;
    private ScheduledFuture<?> myUploadTask = null;
    private Hypervisor.HyperVState myHyperVState = Hypervisor.HyperVState.UNKNOWN_HYPERV_STATE;
    private EnumSet<CpuInfoFlags> myCpuInfo = EnumSet.noneOf(CpuInfoFlags.class);

    public void start() {
        if (!AnalyticsSettings.getOptedIn()) {
            return;
        }
        this.myUploadTask = JobScheduler.getScheduler().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                SystemInfoStatsMonitor.this.updateAndUploadStats();
            }
        }, 5L, 360L, TimeUnit.MINUTES);
    }

    private void updateAndUploadStats() {
        if (!AnalyticsSettings.getOptedIn()) {
            this.myUploadTask.cancel(true);
            return;
        }
        if (this.mySdkHandler == null) {
            this.mySdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        }
        if (SystemInfo.isWindows) {
            this.updateHyperVState();
        }
        this.updateCpuInfo();
        this.sendStats();
    }

    private void sendStats() {
        if (this.myHyperVState == Hypervisor.HyperVState.UNKNOWN_HYPERV_STATE || this.myHyperVState != Hypervisor.HyperVState.HYPERV_CHECK_ERROR) {
            // empty if block
        }
        if (this.myCpuInfo.contains((Object)CpuInfoFlags.UNKNOWN) || !this.myCpuInfo.contains((Object)CpuInfoFlags.ERROR)) {
            // empty if block
        }
        UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.SYSTEM).setKind(AndroidStudioEvent.EventKind.HYPERVISOR).setHypervisor(Hypervisor.newBuilder().setHyperVState(this.myHyperVState)));
        UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.SYSTEM).setKind(AndroidStudioEvent.EventKind.EMULATOR_HOST).setEmulatorHost(EmulatorHost.newBuilder().setCpuManufacturer(Joiner.on((char)',').join(this.myCpuInfo))));
    }

    private void updateHyperVState() {
        if (this.myHyperVState != Hypervisor.HyperVState.UNKNOWN_HYPERV_STATE && this.myHyperVState != Hypervisor.HyperVState.HYPERV_CHECK_ERROR) {
            return;
        }
        this.myHyperVState = SystemInfoStatsMonitor.calcHyperVState(this.mySdkHandler);
    }

    private void updateCpuInfo() {
        if (!(this.myCpuInfo.isEmpty() || this.myCpuInfo.contains((Object)CpuInfoFlags.ERROR) || this.myCpuInfo.contains((Object)CpuInfoFlags.UNKNOWN))) {
            return;
        }
        this.myCpuInfo = SystemInfoStatsMonitor.calcCpuInfo(this.mySdkHandler);
    }

    @NotNull
    private static File getEmulatorCheckBinary(@NotNull AndroidSdkHandler handler) {
        if (handler == null) {
            SystemInfoStatsMonitor.$$$reportNull$$$0(0);
        }
        File file = AvdManagerConnection.getAvdManagerConnection(handler).getEmulatorCheckBinary();
        if (file == null) {
            SystemInfoStatsMonitor.$$$reportNull$$$0(1);
        }
        return file;
    }

    @Nullable
    private static Integer runEmulatorCheck(@NotNull String argument, @NotNull Revision lowestToolsRevisiion, @NotNull AndroidSdkHandler handler) throws ExecutionException {
        LocalPackage toolsPackage;
        if (argument == null) {
            SystemInfoStatsMonitor.$$$reportNull$$$0(2);
        }
        if (lowestToolsRevisiion == null) {
            SystemInfoStatsMonitor.$$$reportNull$$$0(3);
        }
        if (handler == null) {
            SystemInfoStatsMonitor.$$$reportNull$$$0(4);
        }
        if ((toolsPackage = handler.getLocalPackage("tools", (ProgressIndicator)new StudioLoggerProgressIndicator(AndroidSdkInitializer.class))) == null) {
            throw new ExecutionException("No SDK tools package");
        }
        Revision toolsRevision = toolsPackage.getVersion();
        if (toolsRevision.compareTo(lowestToolsRevisiion) < 0) {
            return null;
        }
        File checkBinary = SystemInfoStatsMonitor.getEmulatorCheckBinary(handler);
        if (!checkBinary.isFile()) {
            throw new ExecutionException("No emulator-check binary in the SDK tools package");
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{checkBinary.getPath(), argument});
        CapturingAnsiEscapesAwareProcessHandler process = new CapturingAnsiEscapesAwareProcessHandler(commandLine);
        ProcessOutput output = process.runProcess();
        int exitCode = output.getExitCode();
        if (exitCode == 100) {
            throw new ExecutionException(String.format("Emulator-check failed to check for '%s' with a generic error code %d", argument, 100));
        }
        return exitCode;
    }

    @NotNull
    private static Hypervisor.HyperVState calcHyperVState(@NotNull AndroidSdkHandler handler) {
        Integer res;
        block7: {
            Hypervisor.HyperVState hyperVState;
            if (handler == null) {
                SystemInfoStatsMonitor.$$$reportNull$$$0(5);
            }
            try {
                res = SystemInfoStatsMonitor.runEmulatorCheck("hyper-v", LOWEST_TOOLS_REVISION_HYPERV, handler);
                if (res != null) break block7;
                hyperVState = Hypervisor.HyperVState.UNKNOWN_HYPERV_STATE;
            }
            catch (ExecutionException e) {
                LOG.warn("Exception during Hyper-V state calculation", (Throwable)e);
                Hypervisor.HyperVState hyperVState2 = Hypervisor.HyperVState.HYPERV_CHECK_ERROR;
                if (hyperVState2 == null) {
                    SystemInfoStatsMonitor.$$$reportNull$$$0(8);
                }
                return hyperVState2;
            }
            if (hyperVState == null) {
                SystemInfoStatsMonitor.$$$reportNull$$$0(6);
            }
            return hyperVState;
        }
        Hypervisor.HyperVState hyperVState = SystemInfoStatsMonitor.exitCodeToHyperVState(res);
        if (hyperVState == null) {
            SystemInfoStatsMonitor.$$$reportNull$$$0(7);
        }
        return hyperVState;
    }

    private static Hypervisor.HyperVState exitCodeToHyperVState(int exitCode) {
        switch (exitCode) {
            case 0: {
                return Hypervisor.HyperVState.HYPERV_ABSENT;
            }
            case 1: {
                return Hypervisor.HyperVState.HYPERV_INSTALLED;
            }
            case 2: {
                return Hypervisor.HyperVState.HYPERV_RUNNING;
            }
            case 100: {
                return Hypervisor.HyperVState.HYPERV_CHECK_ERROR;
            }
        }
        return Hypervisor.HyperVState.UNKNOWN_HYPERV_STATE;
    }

    @NotNull
    private static EnumSet<CpuInfoFlags> calcCpuInfo(@NotNull AndroidSdkHandler handler) {
        Integer res;
        block7: {
            EnumSet<CpuInfoFlags> enumSet;
            if (handler == null) {
                SystemInfoStatsMonitor.$$$reportNull$$$0(9);
            }
            try {
                res = SystemInfoStatsMonitor.runEmulatorCheck("cpu-info", LOWEST_TOOLS_REVISION_CPU_INFO, handler);
                if (res != null) break block7;
                enumSet = EnumSet.of(CpuInfoFlags.UNKNOWN);
            }
            catch (ExecutionException e) {
                LOG.warn("Exception during CPU information calculation", (Throwable)e);
                EnumSet<CpuInfoFlags> enumSet2 = EnumSet.of(CpuInfoFlags.ERROR);
                if (enumSet2 == null) {
                    SystemInfoStatsMonitor.$$$reportNull$$$0(12);
                }
                return enumSet2;
            }
            if (enumSet == null) {
                SystemInfoStatsMonitor.$$$reportNull$$$0(10);
            }
            return enumSet;
        }
        EnumSet<CpuInfoFlags> enumSet = CpuInfoFlags.fromExitCode(res);
        if (enumSet == null) {
            SystemInfoStatsMonitor.$$$reportNull$$$0(11);
        }
        return enumSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/sdk/SystemInfoStatsMonitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lowestToolsRevisiion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/sdk/SystemInfoStatsMonitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmulatorCheckBinary";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "calcHyperVState";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "calcCpuInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEmulatorCheckBinary";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runEmulatorCheck";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calcHyperVState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calcCpuInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum CpuInfoFlags {
        ERROR(0),
        AMD(1),
        INTEL(2),
        OTHER_CPU(4),
        IN_VM(8),
        SUPPORTS_VIRT(16),
        UNKNOWN(0x40000000);

        private final int myValue;

        private CpuInfoFlags(int value2) {
            this.myValue = value2;
        }

        public static EnumSet<CpuInfoFlags> fromExitCode(int code) {
            if (code == 0) {
                return EnumSet.of(ERROR);
            }
            EnumSet<CpuInfoFlags> result2 = EnumSet.noneOf(CpuInfoFlags.class);
            for (CpuInfoFlags flag : CpuInfoFlags.values()) {
                if (flag == ERROR || (code & flag.myValue) == 0) continue;
                result2.add(flag);
                code &= ~flag.myValue;
            }
            if (code != 0) {
                LOG.warn(String.format("CpuInfoFlags.fromExitCode(): unknown flag values '0x%x'", code));
            }
            return result2;
        }
    }
}

