/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sampledata.datasource;

import com.google.common.collect.ImmutableList;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class CombinerDataSource
implements Function<OutputStream, Exception> {
    private final ImmutableList<String> myCombined;

    public CombinerDataSource(@NotNull InputStream inputA, @NotNull InputStream inputB) {
        ImmutableList combined;
        if (inputA == null) {
            CombinerDataSource.$$$reportNull$$$0(0);
        }
        if (inputB == null) {
            CombinerDataSource.$$$reportNull$$$0(1);
        }
        try {
            List linesA = CharStreams.readLines((Readable)new InputStreamReader(inputA, StandardCharsets.UTF_8));
            List linesB = CharStreams.readLines((Readable)new InputStreamReader(inputB, StandardCharsets.UTF_8));
            Collections.shuffle(linesA);
            Collections.shuffle(linesB);
            assert (!linesA.isEmpty() && !linesB.isEmpty());
            int len = Math.max(linesA.size(), linesB.size());
            ImmutableList.Builder combinedBuilder = ImmutableList.builder();
            int indexA = 0;
            int indexB = 0;
            for (int i2 = 0; i2 < len; ++i2) {
                if (indexA == linesA.size()) {
                    indexA = 0;
                }
                if (indexB == linesB.size()) {
                    indexB = 0;
                }
                combinedBuilder.add((Object)((String)linesA.get(indexA) + " " + (String)linesB.get(indexB)));
                ++indexA;
                ++indexB;
            }
            combined = combinedBuilder.build();
        }
        catch (IOException ignored) {
            combined = ImmutableList.of();
        }
        this.myCombined = combined;
    }

    @Override
    public Exception apply(OutputStream stream) {
        PrintStream printStream = new PrintStream(stream);
        this.myCombined.forEach(printStream::println);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "inputA";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "inputB";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/sampledata/datasource/CombinerDataSource";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

