/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.InstallException;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.InstallResult;
import com.android.tools.idea.run.RetryingInstaller;
import com.android.tools.idea.run.RetryingInstallerResult;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.tasks.SplitApkDeployTaskContext;
import com.android.tools.idea.run.util.LaunchStatus;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class SplitApkDeployTask
implements LaunchTask {
    private static final String ID = "DEPLOY_SPLIT_APK";
    private static final Pattern DEVICE_NOT_FOUND_ERROR = Pattern.compile("device '.*' not found");
    @NotNull
    private final Project myProject;
    @NotNull
    private final SplitApkDeployTaskContext myContext;
    private final boolean myDontKill;

    public SplitApkDeployTask(@NotNull Project project, @NotNull SplitApkDeployTaskContext context) {
        if (project == null) {
            SplitApkDeployTask.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SplitApkDeployTask.$$$reportNull$$$0(1);
        }
        this(project, context, false);
    }

    public SplitApkDeployTask(@NotNull Project project, @NotNull SplitApkDeployTaskContext context, boolean dontKill) {
        if (project == null) {
            SplitApkDeployTask.$$$reportNull$$$0(2);
        }
        if (context == null) {
            SplitApkDeployTask.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myContext = context;
        this.myDontKill = dontKill;
    }

    @NotNull
    public SplitApkDeployTaskContext getContext() {
        SplitApkDeployTaskContext splitApkDeployTaskContext = this.myContext;
        if (splitApkDeployTaskContext == null) {
            SplitApkDeployTask.$$$reportNull$$$0(4);
        }
        return splitApkDeployTaskContext;
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Installing APKs" == null) {
            SplitApkDeployTask.$$$reportNull$$$0(5);
        }
        return "Installing APKs";
    }

    @Override
    public int getDuration() {
        return 20;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        List<File> apks;
        SplitApkInstaller installer;
        RetryingInstaller retryingInstaller;
        RetryingInstallerResult installResult;
        if (device == null) {
            SplitApkDeployTask.$$$reportNull$$$0(6);
        }
        if (launchStatus == null) {
            SplitApkDeployTask.$$$reportNull$$$0(7);
        }
        if (printer == null) {
            SplitApkDeployTask.$$$reportNull$$$0(8);
        }
        ArrayList installOptions = Lists.newArrayList();
        installOptions.add("-t");
        if (device.supportsFeature(IDevice.HardwareFeature.EMBEDDED)) {
            installOptions.add("-g");
        }
        if (this.myContext.isPatchBuild()) {
            installOptions.add("-p");
            installOptions.add(this.myContext.getApplicationId());
        }
        if (this.myDontKill) {
            installOptions.add("--dont-kill");
        }
        if ((installResult = (retryingInstaller = new RetryingInstaller(this.myProject, device, installer = new SplitApkInstaller(printer, apks = this.myContext.getArtifacts(), installOptions), this.myContext.getApplicationId(), printer, launchStatus)).install()).isSuccess()) {
            printer.stdout(String.format("Split APKs installed in %s", StringUtil.formatDuration((long)installResult.getLastInstallDuration().toMillis())));
        }
        this.myContext.notifyInstall(this.myProject, device, installResult.isSuccess());
        return installResult.isSuccess();
    }

    @Override
    @NotNull
    public String getId() {
        if (ID == null) {
            SplitApkDeployTask.$$$reportNull$$$0(9);
        }
        return ID;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/tasks/SplitApkDeployTask";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/tasks/SplitApkDeployTask";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class SplitApkInstaller
    implements RetryingInstaller.Installer {
        private final ConsolePrinter myPrinter;
        private final List<File> myApks;
        private final List<String> myInstallOptions;

        SplitApkInstaller(@NotNull ConsolePrinter printer, @NotNull List<File> apks, @NotNull List<String> installOptions) {
            if (printer == null) {
                SplitApkInstaller.$$$reportNull$$$0(0);
            }
            if (apks == null) {
                SplitApkInstaller.$$$reportNull$$$0(1);
            }
            if (installOptions == null) {
                SplitApkInstaller.$$$reportNull$$$0(2);
            }
            this.myPrinter = printer;
            this.myApks = apks;
            this.myInstallOptions = installOptions;
        }

        @Override
        @NotNull
        public InstallResult installApp(@NotNull IDevice device, @NotNull LaunchStatus launchStatus) {
            InstallResult installResult;
            block6: {
                if (device == null) {
                    SplitApkInstaller.$$$reportNull$$$0(3);
                }
                if (launchStatus == null) {
                    SplitApkInstaller.$$$reportNull$$$0(4);
                }
                String cmd = SplitApkInstaller.getAdbInstallCommand(this.myApks, this.myInstallOptions);
                try {
                    this.myPrinter.stdout(cmd);
                    InstantRunManager.LOG.info(cmd);
                    device.installPackages(this.myApks, true, this.myInstallOptions, 5L, TimeUnit.MINUTES);
                    installResult = new InstallResult(InstallResult.FailureCode.NO_ERROR, null, null);
                    if (installResult != null) break block6;
                }
                catch (InstallException e) {
                    InstallResult.FailureCode failureCode = InstallResult.FailureCode.UNTYPED_ERROR;
                    if (e.getMessage() != null && DEVICE_NOT_FOUND_ERROR.matcher(e.getMessage()).matches()) {
                        failureCode = InstallResult.FailureCode.DEVICE_NOT_FOUND;
                    }
                    InstallResult installResult2 = new InstallResult(failureCode, e.getMessage(), null);
                    if (installResult2 == null) {
                        SplitApkInstaller.$$$reportNull$$$0(6);
                    }
                    return installResult2;
                }
                SplitApkInstaller.$$$reportNull$$$0(5);
            }
            return installResult;
        }

        @NotNull
        private static String getAdbInstallCommand(@NotNull List<File> apks, @NotNull List<String> installOptions) {
            if (apks == null) {
                SplitApkInstaller.$$$reportNull$$$0(7);
            }
            if (installOptions == null) {
                SplitApkInstaller.$$$reportNull$$$0(8);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("$ adb install-multiple -r ");
            if (!installOptions.isEmpty()) {
                sb.append(Joiner.on((char)' ').join(installOptions));
                sb.append(' ');
            }
            for (File f : apks) {
                sb.append(f.getPath());
                sb.append(' ');
            }
            String string = sb.toString();
            if (string == null) {
                SplitApkInstaller.$$$reportNull$$$0(9);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "printer";
                    break;
                }
                case 1: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "apks";
                    break;
                }
                case 2: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "installOptions";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "device";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "launchStatus";
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/run/tasks/SplitApkDeployTask$SplitApkInstaller";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/run/tasks/SplitApkDeployTask$SplitApkInstaller";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "installApp";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAdbInstallCommand";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "installApp";
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getAdbInstallCommand";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

