/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.fd.DeployType;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunStatsService;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.FullApkInstaller;
import com.android.tools.idea.run.InstalledApkCache;
import com.android.tools.idea.run.InstalledPatchCache;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.tools.ir.client.InstantRunClient;
import com.google.common.base.Preconditions;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeployApkTask
implements LaunchTask {
    private static final String ID = "DEPLOY_APK";
    private static final Logger LOG = Logger.getInstance(DeployApkTask.class);
    private final Project myProject;
    private final Collection<ApkInfo> myApks;
    private final LaunchOptions myLaunchOptions;
    @Nullable
    private final InstantRunContext myInstantRunContext;

    public DeployApkTask(@NotNull Project project, @NotNull LaunchOptions launchOptions, @NotNull Collection<ApkInfo> apks) {
        if (project == null) {
            DeployApkTask.$$$reportNull$$$0(0);
        }
        if (launchOptions == null) {
            DeployApkTask.$$$reportNull$$$0(1);
        }
        if (apks == null) {
            DeployApkTask.$$$reportNull$$$0(2);
        }
        this(project, launchOptions, apks, null);
    }

    public DeployApkTask(@NotNull Project project, @NotNull LaunchOptions launchOptions, @NotNull Collection<ApkInfo> apks, @Nullable InstantRunContext instantRunContext) {
        if (project == null) {
            DeployApkTask.$$$reportNull$$$0(3);
        }
        if (launchOptions == null) {
            DeployApkTask.$$$reportNull$$$0(4);
        }
        if (apks == null) {
            DeployApkTask.$$$reportNull$$$0(5);
        }
        Preconditions.checkArgument((boolean)apks.stream().allMatch(x -> x.getFiles().size() == 1));
        this.myProject = project;
        this.myLaunchOptions = launchOptions;
        this.myApks = apks;
        this.myInstantRunContext = instantRunContext;
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Installing APK" == null) {
            DeployApkTask.$$$reportNull$$$0(6);
        }
        return "Installing APK";
    }

    @Override
    public int getDuration() {
        return 20;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        if (device == null) {
            DeployApkTask.$$$reportNull$$$0(7);
        }
        if (launchStatus == null) {
            DeployApkTask.$$$reportNull$$$0(8);
        }
        if (printer == null) {
            DeployApkTask.$$$reportNull$$$0(9);
        }
        printer = new SkipEmptyLinesConsolePrinter(printer);
        FullApkInstaller installer = new FullApkInstaller(this.myProject, this.myLaunchOptions, (InstalledApkCache)ServiceManager.getService(InstalledApkCache.class), printer);
        for (ApkInfo apk : this.myApks) {
            if (!apk.getFile().exists()) {
                String message = "The APK file " + apk.getFile().getPath() + " does not exist on disk.";
                printer.stderr(message);
                LOG.warn(message);
                return false;
            }
            String pkgName = apk.getApplicationId();
            if (!installer.uploadAndInstallApk(device, pkgName, apk.getFile(), launchStatus)) {
                return false;
            }
            if (this.myInstantRunContext != null) continue;
            try {
                InstantRunClient.transferBuildIdToDevice((IDevice)device, (String)"", (String)pkgName, null);
            }
            catch (Throwable throwable) {}
        }
        if (this.myInstantRunContext == null) {
            InstantRunStatsService.get(this.myProject).notifyNonInstantRunDeployType(device);
        } else {
            InstantRunStatsService.get(this.myProject).notifyDeployType(DeployType.FULLAPK, this.myInstantRunContext, device);
        }
        this.trackInstallation(device);
        return true;
    }

    @Override
    @NotNull
    public String getId() {
        if (ID == null) {
            DeployApkTask.$$$reportNull$$$0(10);
        }
        return ID;
    }

    @Override
    @NotNull
    public Collection<ApkInfo> getApkInfos() {
        Collection<ApkInfo> collection = this.myApks;
        if (collection == null) {
            DeployApkTask.$$$reportNull$$$0(11);
        }
        return collection;
    }

    public static void cacheManifestInstallationData(@NotNull IDevice device, @NotNull InstantRunContext context) {
        if (device == null) {
            DeployApkTask.$$$reportNull$$$0(12);
        }
        if (context == null) {
            DeployApkTask.$$$reportNull$$$0(13);
        }
        InstalledPatchCache patchCache = (InstalledPatchCache)ServiceManager.getService(InstalledPatchCache.class);
        patchCache.setInstalledManifestResourcesHash(device, context.getApplicationId(), context.getManifestResourcesHash());
    }

    private void trackInstallation(@NotNull IDevice device) {
        if (device == null) {
            DeployApkTask.$$$reportNull$$$0(14);
        }
        UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.DEPLOYMENT).setKind(AndroidStudioEvent.EventKind.DEPLOYMENT_APK).setDeviceInfo(AndroidStudioUsageTracker.deviceToDeviceInfo(device)), this.myProject));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchOptions";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apks";
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/tasks/DeployApkTask";
                break;
            }
            case 7: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/tasks/DeployApkTask";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getApkInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "cacheManifestInstallationData";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "trackInstallation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SkipEmptyLinesConsolePrinter
    implements ConsolePrinter {
        private ConsolePrinter myPrinter;

        public SkipEmptyLinesConsolePrinter(ConsolePrinter printer) {
            this.myPrinter = printer;
        }

        @Override
        public void stdout(@NotNull String message) {
            if (message == null) {
                SkipEmptyLinesConsolePrinter.$$$reportNull$$$0(0);
            }
            if (!StringUtil.isEmptyOrSpaces((String)message)) {
                this.myPrinter.stdout(StringUtil.trimTrailing((String)message, (char)'\n'));
            }
        }

        @Override
        public void stderr(@NotNull String message) {
            if (message == null) {
                SkipEmptyLinesConsolePrinter.$$$reportNull$$$0(1);
            }
            if (!StringUtil.isEmptyOrSpaces((String)message)) {
                this.myPrinter.stderr(StringUtil.trimTrailing((String)message, (char)'\n'));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "message";
            objectArray2[1] = "com/android/tools/idea/run/tasks/DeployApkTask$SkipEmptyLinesConsolePrinter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "stdout";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "stderr";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

