/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.IdDisplay;
import com.android.tools.idea.avdmanager.AvdManagerUtils;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.run.AvdComboBox;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.editor.DeployTargetConfigurable;
import com.android.tools.idea.run.editor.DeployTargetConfigurableContext;
import com.android.tools.idea.run.editor.EmulatorTargetProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmulatorTargetConfigurable
implements DeployTargetConfigurable<EmulatorTargetProvider.State> {
    private final Project myProject;
    private final Disposable myParentDisposable;
    private final DeployTargetConfigurableContext myContext;
    private JPanel myPanel;
    private JBLabel myMinSdkInfoMessageLabel;
    private ComboboxWithBrowseButton myAvdComboWithButton;
    private AvdComboBox myAvdCombo;
    private String myIncorrectPreferredAvd;

    public EmulatorTargetConfigurable(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull DeployTargetConfigurableContext context) {
        if (project == null) {
            EmulatorTargetConfigurable.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            EmulatorTargetConfigurable.$$$reportNull$$$0(1);
        }
        if (context == null) {
            EmulatorTargetConfigurable.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myParentDisposable = parentDisposable;
        this.myContext = context;
        this.$$$setupUI$$$();
        this.myMinSdkInfoMessageLabel.setBorder((Border)JBUI.Borders.emptyTop((int)10));
        this.myMinSdkInfoMessageLabel.setIcon(AllIcons.General.BalloonWarning);
        context.addModuleChangeListener(e -> this.myAvdCombo.startUpdatingAvds(ModalityState.current()));
    }

    private void createUIComponents() {
        this.myAvdCombo = new AvdComboBox(this.myProject, true, false){

            @Override
            public Module getModule() {
                return EmulatorTargetConfigurable.this.myContext.getModule();
            }
        };
        this.myAvdCombo.startUpdatingAvds(ModalityState.current());
        JComboBox avdComboBox = this.myAvdCombo.getComboBox();
        avdComboBox.setRenderer(SimpleListCellRenderer.create((label, value2, index) -> {
            if (value2 instanceof IdDisplay) {
                label.setText(((IdDisplay)value2).getDisplay());
            } else {
                label.setText(String.format("<html><font color='red'>Unknown AVD %1$s</font></html>", value2 == null ? "" : value2.toString()));
            }
        }));
        avdComboBox.addActionListener(e -> this.resetAvdCompatibilityWarningLabel());
        this.myAvdComboWithButton = new ComboboxWithBrowseButton(avdComboBox);
        Disposer.register((Disposable)this.myParentDisposable, (Disposable)this.myAvdCombo);
    }

    @Override
    @Nullable
    public JComponent createComponent() {
        return this.myPanel;
    }

    @Override
    public void resetFrom(@NotNull EmulatorTargetProvider.State state, int uniqueID) {
        if (state == null) {
            EmulatorTargetConfigurable.$$$reportNull$$$0(3);
        }
        JComboBox combo = this.myAvdCombo.getComboBox();
        String avd = state.PREFERRED_AVD;
        if (avd != null) {
            Object item = EmulatorTargetConfigurable.findAvdWithName(combo, avd);
            if (item != null) {
                combo.setSelectedItem(item);
            } else {
                combo.setSelectedItem(null);
                this.myIncorrectPreferredAvd = avd;
            }
        }
        this.resetAvdCompatibilityWarningLabel();
    }

    @Override
    public void applyTo(@NotNull EmulatorTargetProvider.State state, int uniqueID) {
        if (state == null) {
            EmulatorTargetConfigurable.$$$reportNull$$$0(4);
        }
        state.PREFERRED_AVD = "";
        JComboBox combo = this.myAvdCombo.getComboBox();
        IdDisplay preferredAvd = (IdDisplay)combo.getSelectedItem();
        state.PREFERRED_AVD = preferredAvd == null ? (this.myIncorrectPreferredAvd != null ? this.myIncorrectPreferredAvd : "") : preferredAvd.getId();
    }

    private void resetAvdCompatibilityWarningLabel() {
        String warning = this.getAvdCompatibilityWarning();
        if (warning != null) {
            this.myMinSdkInfoMessageLabel.setVisible(true);
            this.myMinSdkInfoMessageLabel.setText(warning);
        } else {
            this.myMinSdkInfoMessageLabel.setVisible(false);
        }
    }

    @Nullable
    private String getAvdCompatibilityWarning() {
        IdDisplay selectedItem = (IdDisplay)this.myAvdCombo.getComboBox().getSelectedItem();
        if (selectedItem != null) {
            String selectedAvdName = selectedItem.getId();
            Module module = this.myContext.getModule();
            if (module == null) {
                return null;
            }
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) {
                return null;
            }
            AvdManager avdManager = AvdManagerUtils.getAvdManagerSilently(facet);
            if (avdManager == null) {
                return null;
            }
            AvdInfo avd = avdManager.getAvd(selectedAvdName, false);
            if (avd == null || avd.getSystemImage() == null) {
                return null;
            }
            AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
            if (platform == null) {
                return null;
            }
            AndroidVersion minSdk = AndroidModuleInfo.getInstance(facet).getRuntimeMinSdkVersion();
            LaunchCompatibility compatibility = LaunchCompatibility.canRunOnAvd(minSdk, platform.getTarget(), avd.getSystemImage());
            if (compatibility.isCompatible() == ThreeState.NO) {
                return String.format("'%1$s' may be incompatible with your configuration (%2$s)", selectedAvdName, StringUtil.notNullize((String)compatibility.getReason()));
            }
        }
        return null;
    }

    @Nullable
    private static Object findAvdWithName(@NotNull JComboBox avdCombo, @NotNull String avdName) {
        if (avdCombo == null) {
            EmulatorTargetConfigurable.$$$reportNull$$$0(5);
        }
        if (avdName == null) {
            EmulatorTargetConfigurable.$$$reportNull$$$0(6);
        }
        int n = avdCombo.getItemCount();
        for (int i2 = 0; i2 < n; ++i2) {
            Object item = avdCombo.getItemAt(i2);
            if (!(item instanceof IdDisplay) || !avdName.equals(((IdDisplay)item).getId())) continue;
            return item;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "avdCombo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "avdName";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/run/editor/EmulatorTargetConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "resetFrom";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "applyTo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findAvdWithName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Prefer Android Virtual Device:");
        jBLabel2.setDisplayedMnemonic('P');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.myAvdComboWithButton;
        jPanel.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, new Dimension(300, -1), null, null));
        this.myMinSdkInfoMessageLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/AndroidBundle").getString("deployment.target.settings.min.sdk.info.message"));
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 2, 0, 1, 0, 0, null, null, null, 1));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

