/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.actions.DevicePickerHelpAction;
import com.android.tools.idea.actions.DevicePickerHelpActionKt;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.concurrent.EdtExecutor;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.LaunchCompatibilityChecker;
import com.android.tools.idea.run.LaunchableAndroidDevice;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetConfigurable;
import com.android.tools.idea.run.editor.DeployTargetConfigurableContext;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.android.tools.idea.run.editor.DevicePicker;
import com.android.tools.idea.run.editor.HelpHandler;
import com.android.tools.idea.run.editor.RealizedDeployTarget;
import com.android.tools.idea.run.editor.ShowChooserTargetProvider;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.wireless.android.sdk.stats.AdbAssistantStats;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Alarm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeployTargetPickerDialog
extends DialogWrapper
implements HelpHandler {
    private static final int DEVICE_TAB_INDEX = 0;
    private static final int FIRST_CUSTOM_DEPLOY_TARGET_INDEX = 1;
    private final int myContextId;
    @NotNull
    private final AndroidFacet myFacet;
    private final List<DeployTargetInfo> myDeployTargetInfos;
    private final DevicePicker myDevicePicker;
    private final ListenableFuture<AndroidDebugBridge> myAdbFuture;
    private final SettableFuture<Void> myRefreshAvdsFuture;
    private JPanel myContentPane;
    private JBTabbedPane myTabbedPane;
    private JPanel myDevicesPanel;
    private DeployTarget myDeployTarget;
    private List<AndroidDevice> mySelectedDevices;

    public DeployTargetPickerDialog(int runContextId, @NotNull AndroidFacet facet, @NotNull DeviceCount deviceCount, @NotNull List<DeployTargetProvider<DeployTargetState>> deployTargetProviders, @NotNull Map<String, DeployTargetState> deployTargetStates, @NotNull LaunchCompatibilityChecker compatibilityChecker) {
        if (facet == null) {
            DeployTargetPickerDialog.$$$reportNull$$$0(0);
        }
        if (deviceCount == null) {
            DeployTargetPickerDialog.$$$reportNull$$$0(1);
        }
        if (deployTargetProviders == null) {
            DeployTargetPickerDialog.$$$reportNull$$$0(2);
        }
        if (deployTargetStates == null) {
            DeployTargetPickerDialog.$$$reportNull$$$0(3);
        }
        if (compatibilityChecker == null) {
            DeployTargetPickerDialog.$$$reportNull$$$0(4);
        }
        super(facet.getModule().getProject(), true);
        this.$$$setupUI$$$();
        this.myRefreshAvdsFuture = SettableFuture.create();
        this.myFacet = facet;
        this.myContextId = runContextId;
        this.myDevicePicker = new DevicePicker(this.getDisposable(), runContextId, facet, deviceCount, compatibilityChecker, this);
        this.myDevicesPanel.add((Component)this.myDevicePicker.getComponent(), "Center");
        this.myDevicesPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.myDevicePicker.installDoubleClickListener(new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                Action okAction = DeployTargetPickerDialog.this.getOKAction();
                if (okAction.isEnabled()) {
                    okAction.actionPerformed(null);
                    return true;
                }
                return false;
            }
        });
        Module module = facet.getModule();
        this.myDeployTargetInfos = new ArrayList<DeployTargetInfo>(deployTargetProviders.size());
        for (DeployTargetProvider<DeployTargetState> provider : deployTargetProviders) {
            DeployTargetState state = deployTargetStates.get(provider.getId());
            if (state == null) continue;
            DeployTargetConfigurable<DeployTargetState> configurable = provider.createConfigurable(module.getProject(), this.getDisposable(), new Context(module));
            this.myDeployTargetInfos.add(new DeployTargetInfo(provider, state, configurable));
            JComponent component = configurable.createComponent();
            if (component != null) {
                this.myTabbedPane.add((Component)component);
            }
            configurable.resetFrom(state, this.myContextId);
        }
        File adb = AndroidSdkUtils.getAdb(this.myFacet.getModule().getProject());
        if (adb == null) {
            throw new IllegalArgumentException("Unable to locate adb");
        }
        this.myAdbFuture = AdbService.getInstance().getDebugBridge(adb);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            this.myDevicePicker.refreshAvdsNow(null);
            this.myRefreshAvdsFuture.set(null);
        });
        DeployTargetState state = deployTargetStates.get(ShowChooserTargetProvider.ID);
        this.setDoNotAskOption(new UseSameDevicesOption((ShowChooserTargetProvider.State)state));
        this.setTitle("Select Deployment Target");
        this.setModal(true);
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        final JBLoadingPanel loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.getDisposable());
        loadingPanel.add((Component)(this.myDeployTargetInfos.isEmpty() ? this.myDevicesPanel : this.myContentPane));
        if (this.myAdbFuture.isDone()) {
            if (!this.myRefreshAvdsFuture.isDone()) {
                loadingPanel.startLoading();
                this.sayLookingForAvds(loadingPanel);
            }
        } else {
            loadingPanel.setLoadingText("Initializing ADB");
            loadingPanel.startLoading();
            Futures.addCallback(this.myAdbFuture, (FutureCallback)new FutureCallback<AndroidDebugBridge>(){

                public void onSuccess(AndroidDebugBridge result2) {
                    Logger.getInstance(DeployTargetPickerDialog.class).info("Successfully obtained debug bridge");
                    if (DeployTargetPickerDialog.this.myRefreshAvdsFuture.isDone()) {
                        loadingPanel.stopLoading();
                    } else {
                        DeployTargetPickerDialog.this.sayLookingForAvds(loadingPanel);
                    }
                }

                public void onFailure(@Nullable Throwable t) {
                    loadingPanel.stopLoading();
                    Logger.getInstance(DeployTargetPickerDialog.class).info("Unable to obtain debug bridge", t);
                }
            }, (Executor)EdtExecutor.INSTANCE);
        }
        return loadingPanel;
    }

    private void sayLookingForAvds(final JBLoadingPanel thePanel) {
        thePanel.setLoadingText("Looking for virtual devices");
        Futures.addCallback(this.myRefreshAvdsFuture, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void vv) {
                Logger.getInstance(DeployTargetPickerDialog.class).info("Successfully obtained list of AVDs");
                thePanel.stopLoading();
            }

            public void onFailure(@Nullable Throwable tt) {
                Logger.getInstance(DeployTargetPickerDialog.class).info("Unable to obtain list of AVDs", tt);
                thePanel.stopLoading();
            }
        });
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "deploy.picker.dialog";
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myDevicePicker.getPreferredFocusedComponent();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        int selectedIndex = this.myTabbedPane.getSelectedIndex();
        if (this.isDeviceTab(selectedIndex)) {
            return this.myDevicePicker.validate();
        }
        if (this.isCustomDeployTargetTab(selectedIndex)) {
            DeployTargetInfo info = this.myDeployTargetInfos.get(selectedIndex - 1);
            info.myConfigurable.applyTo(info.myState, this.myContextId);
            List<ValidationError> errors = info.myState.validate(this.myFacet);
            if (!errors.isEmpty()) {
                return new ValidationInfo(errors.get(0).getMessage(), null);
            }
        }
        return super.doValidate();
    }

    @NotNull
    protected Alarm.ThreadToUse getValidationThreadToUse() {
        Alarm.ThreadToUse threadToUse = Alarm.ThreadToUse.SWING_THREAD;
        if (threadToUse == null) {
            DeployTargetPickerDialog.$$$reportNull$$$0(5);
        }
        return threadToUse;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void doOKAction() {
        int selectedIndex = this.myTabbedPane.getSelectedIndex();
        if (this.isDeviceTab(selectedIndex)) {
            this.mySelectedDevices = this.myDevicePicker.getSelectedDevices();
            if (!this.canLaunchDevices(this.mySelectedDevices)) {
                this.myDeployTarget = null;
                return;
            }
            this.myDeployTarget = new RealizedDeployTarget(null, null, this.launchDevices(this.mySelectedDevices));
        } else if (this.isCustomDeployTargetTab(selectedIndex)) {
            DeployTargetInfo info = this.myDeployTargetInfos.get(selectedIndex - 1);
            this.mySelectedDevices = Collections.emptyList();
            this.myDeployTarget = new RealizedDeployTarget(info.myProvider, info.myState, null);
        }
        super.doOKAction();
    }

    @Nullable
    protected String getHelpId() {
        return "android.deploy.target.picker";
    }

    protected void doHelpAction() {
        this.launchDiagnostics(AdbAssistantStats.Trigger.DONT_SEE_DEVICE);
    }

    @Override
    public void launchDiagnostics(AdbAssistantStats.Trigger trigger) {
        UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.ADB_ASSISTANT_STATS).setAdbAssistantStats(AdbAssistantStats.newBuilder().setTrigger(trigger)), this.myFacet.getModule().getProject()));
        DevicePickerHelpAction action2 = (DevicePickerHelpAction)DevicePickerHelpActionKt.getAction();
        ApplicationManager.getApplication().invokeLater(() -> {
            action2.actionPerformed(AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)new DataContext(){

                @Nullable
                public Object getData(String dataId) {
                    if (dataId.equalsIgnoreCase(CommonDataKeys.PROJECT.getName())) {
                        return DeployTargetPickerDialog.this.myFacet.getModule().getProject();
                    }
                    return null;
                }
            }));
            if (action2.closeDialog()) {
                this.doCancelAction();
            }
        });
    }

    private boolean canLaunchDevices(@NotNull List<AndroidDevice> devices) {
        String title;
        if (devices == null) {
            DeployTargetPickerDialog.$$$reportNull$$$0(6);
        }
        HashSet requiredPackages = Sets.newHashSet();
        for (AndroidDevice device : devices) {
            Object avd;
            AvdInfo info;
            if (!(device instanceof LaunchableAndroidDevice) || !AvdManagerConnection.isSystemImageDownloadProblem((info = ((LaunchableAndroidDevice)(avd = (LaunchableAndroidDevice)device)).getAvdInfo()).getStatus())) continue;
            requiredPackages.add(AvdManagerConnection.getRequiredSystemImagePath(info));
        }
        if (requiredPackages.isEmpty()) {
            return true;
        }
        StringBuilder message = new StringBuilder();
        if (requiredPackages.size() == 1) {
            title = "Download System Image";
            message.append("The system image: ").append((String)Iterables.getOnlyElement((Iterable)requiredPackages)).append(" is missing.\n\n");
            message.append("Download it now?");
        } else {
            title = "Download System Images";
            message.append("The following system images are missing:\n");
            for (String packageName : requiredPackages) {
                message.append(packageName).append("\n");
            }
            message.append("\nDownload them now?");
        }
        int response = Messages.showOkCancelDialog((String)message.toString(), (String)title, (Icon)Messages.getQuestionIcon());
        if (response != 0) {
            return false;
        }
        ModelWizardDialog sdkQuickfixWizard = SdkQuickfixUtils.createDialogForPaths(this.myFacet.getModule().getProject(), requiredPackages);
        if (sdkQuickfixWizard == null) {
            return false;
        }
        sdkQuickfixWizard.show();
        this.myDevicePicker.refreshAvds(null);
        if (!sdkQuickfixWizard.isOK()) {
            return false;
        }
        AvdManagerConnection manager = AvdManagerConnection.getDefaultAvdManagerConnection();
        for (AndroidDevice device : devices) {
            String problem;
            if (!(device instanceof LaunchableAndroidDevice)) continue;
            LaunchableAndroidDevice avd = (LaunchableAndroidDevice)device;
            AvdInfo info = avd.getAvdInfo();
            try {
                AvdInfo reloadedAvdInfo = manager.reloadAvd(info);
                problem = reloadedAvdInfo.getErrorMessage();
            }
            catch (AndroidLocation.AndroidLocationException e) {
                problem = "AVD cannot be loaded";
            }
            if (problem == null) continue;
            Messages.showErrorDialog((Project)this.myFacet.getModule().getProject(), (String)problem, (String)"Emulator Launch Failed");
            return false;
        }
        return true;
    }

    @NotNull
    private DeviceFutures launchDevices(@NotNull List<AndroidDevice> devices) {
        if (devices == null) {
            DeployTargetPickerDialog.$$$reportNull$$$0(7);
        }
        if (devices.isEmpty()) {
            throw new IllegalStateException("Incorrect validation? No device was selected in device picker.");
        }
        for (AndroidDevice device : devices) {
            if (device.isRunning()) continue;
            Project project = this.myFacet.getModule().getProject();
            device.launch(project);
        }
        DeviceFutures deviceFutures = new DeviceFutures(devices);
        if (deviceFutures == null) {
            DeployTargetPickerDialog.$$$reportNull$$$0(8);
        }
        return deviceFutures;
    }

    @Nullable
    public DeployTarget getSelectedDeployTarget() {
        return this.myDeployTarget;
    }

    @NotNull
    public List<AndroidDevice> getSelectedDevices() {
        List<AndroidDevice> list = this.mySelectedDevices;
        if (list == null) {
            DeployTargetPickerDialog.$$$reportNull$$$0(9);
        }
        return list;
    }

    private boolean isDeviceTab(int index) {
        return this.myDeployTargetInfos.isEmpty() || index == 0;
    }

    private boolean isCustomDeployTargetTab(int index) {
        return index >= 1 && index - 1 < this.myDeployTargetInfos.size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceCount";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployTargetProviders";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployTargetStates";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compatibilityChecker";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/editor/DeployTargetPickerDialog";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/editor/DeployTargetPickerDialog";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidationThreadToUse";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "launchDevices";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDevices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canLaunchDevices";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "launchDevices";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBTabbedPane jBTabbedPane;
        JPanel jPanel2;
        this.myContentPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTabbedPane = jBTabbedPane = new JBTabbedPane();
        jPanel2.add((Component)jBTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDevicesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jBTabbedPane.addTab("Devices", null, jPanel, null);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private static class UseSameDevicesOption
    implements DialogWrapper.DoNotAskOption {
        @NotNull
        private final ShowChooserTargetProvider.State myState;

        UseSameDevicesOption(@NotNull ShowChooserTargetProvider.State state) {
            if (state == null) {
                UseSameDevicesOption.$$$reportNull$$$0(0);
            }
            this.myState = state;
        }

        public boolean isToBeShown() {
            return !this.myState.USE_LAST_SELECTED_DEVICE;
        }

        public void setToBeShown(boolean toBeShown, int exitCode) {
            this.myState.USE_LAST_SELECTED_DEVICE = !toBeShown;
        }

        public boolean canBeHidden() {
            return true;
        }

        public boolean shouldSaveOptionsOnCancel() {
            return true;
        }

        @NotNull
        public String getDoNotShowMessage() {
            if ("Use same selection for future launches" == null) {
                UseSameDevicesOption.$$$reportNull$$$0(1);
            }
            return "Use same selection for future launches";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/run/editor/DeployTargetPickerDialog$UseSameDevicesOption";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/run/editor/DeployTargetPickerDialog$UseSameDevicesOption";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDoNotShowMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class Context
    implements DeployTargetConfigurableContext {
        private final Module myModule;

        Context(@NotNull Module module) {
            if (module == null) {
                Context.$$$reportNull$$$0(0);
            }
            this.myModule = module;
        }

        @Override
        @NotNull
        public Module getModule() {
            Module module = this.myModule;
            if (module == null) {
                Context.$$$reportNull$$$0(1);
            }
            return module;
        }

        @Override
        public void addModuleChangeListener(@NotNull ActionListener listener2) {
            if (listener2 == null) {
                Context.$$$reportNull$$$0(2);
            }
        }

        @Override
        public void removeModuleChangeListener(@NotNull ActionListener listener2) {
            if (listener2 == null) {
                Context.$$$reportNull$$$0(3);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/run/editor/DeployTargetPickerDialog$Context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/run/editor/DeployTargetPickerDialog$Context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addModuleChangeListener";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "removeModuleChangeListener";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DeployTargetInfo {
        @NotNull
        public final DeployTargetProvider<DeployTargetState> myProvider;
        @NotNull
        public final DeployTargetState myState;
        @NotNull
        public final DeployTargetConfigurable<DeployTargetState> myConfigurable;

        DeployTargetInfo(@NotNull DeployTargetProvider<DeployTargetState> provider, @NotNull DeployTargetState state, @NotNull DeployTargetConfigurable<DeployTargetState> configurable) {
            if (provider == null) {
                DeployTargetInfo.$$$reportNull$$$0(0);
            }
            if (state == null) {
                DeployTargetInfo.$$$reportNull$$$0(1);
            }
            if (configurable == null) {
                DeployTargetInfo.$$$reportNull$$$0(2);
            }
            this.myProvider = provider;
            this.myState = state;
            this.myConfigurable = configurable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "provider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "state";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "configurable";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/run/editor/DeployTargetPickerDialog$DeployTargetInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

