/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.ddmlib.IDevice;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.ddms.DeviceNameProperties;
import com.android.tools.idea.ddms.DeviceNamePropertiesFetcher;
import com.android.tools.idea.ddms.DeviceNamePropertiesProvider;
import com.android.tools.idea.run.deployment.ConnectedDevicesWorkerDelegate;
import com.android.tools.idea.run.deployment.DefaultCallback;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.PhysicalDevice;
import com.android.tools.idea.run.deployment.VirtualDevice;
import com.android.tools.idea.run.deployment.VirtualDevicesWorkerDelegate;
import com.android.tools.idea.run.deployment.Worker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

class AsyncDevicesGetter {
    private final Worker<Map<VirtualDevice, AvdInfo>> myVirtualDevicesWorker;
    private final Worker<Collection<IDevice>> myConnectedDevicesWorker;
    private final DeviceNamePropertiesProvider myDevicePropertiesProvider;

    AsyncDevicesGetter(@NotNull Disposable parent) {
        if (parent == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(0);
        }
        this.myVirtualDevicesWorker = new Worker();
        this.myConnectedDevicesWorker = new Worker();
        this.myDevicePropertiesProvider = new DeviceNamePropertiesFetcher(new DefaultCallback<DeviceNameProperties>(), parent);
    }

    @NotNull
    List<Device> get(@NotNull Project project) {
        if (project == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(1);
        }
        Map virtualDevices = this.myVirtualDevicesWorker.get(VirtualDevicesWorkerDelegate::new, Collections.emptyMap());
        Supplier supplier = () -> new ConnectedDevicesWorkerDelegate(project);
        ArrayList connectedDevices = new ArrayList(this.myConnectedDevicesWorker.get(supplier, Collections.emptyList()));
        ArrayList<Device> devices = new ArrayList<Device>(virtualDevices.size() + connectedDevices.size());
        virtualDevices.keySet().stream().map(device -> AsyncDevicesGetter.newVirtualDeviceIfItsConnected(device, virtualDevices, connectedDevices)).forEach(devices::add);
        connectedDevices.stream().map(connectedDevice -> this.myDevicePropertiesProvider.get((IDevice)connectedDevice)).map(PhysicalDevice::new).forEach(devices::add);
        ArrayList<Device> arrayList = devices;
        if (arrayList == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    static Device newVirtualDeviceIfItsConnected(@NotNull VirtualDevice virtualDevice, @NotNull Map<VirtualDevice, AvdInfo> virtualDevices, @NotNull Iterable<IDevice> connectedDevices) {
        if (virtualDevice == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(3);
        }
        if (virtualDevices == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(4);
        }
        if (connectedDevices == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(5);
        }
        String name = virtualDevices.get(virtualDevice).getName();
        Iterator<IDevice> i2 = connectedDevices.iterator();
        while (i2.hasNext()) {
            if (!Objects.equals(i2.next().getAvdName(), name)) continue;
            i2.remove();
            VirtualDevice virtualDevice2 = new VirtualDevice(true, virtualDevice.getName(), virtualDevice.getSnapshots());
            if (virtualDevice2 == null) {
                AsyncDevicesGetter.$$$reportNull$$$0(6);
            }
            return virtualDevice2;
        }
        assert (!virtualDevice.isConnected());
        VirtualDevice virtualDevice3 = virtualDevice;
        if (virtualDevice3 == null) {
            AsyncDevicesGetter.$$$reportNull$$$0(7);
        }
        return virtualDevice3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/deployment/AsyncDevicesGetter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualDevice";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualDevices";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectedDevices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/deployment/AsyncDevicesGetter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "newVirtualDeviceIfItsConnected";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "newVirtualDeviceIfItsConnected";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

