/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.run.DeviceStateCache;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstalledApkCache
implements Disposable {
    private final DeviceStateCache<CacheData> myCache = new DeviceStateCache(this);
    private String myDiagnosticOutput;

    public void dispose() {
    }

    public boolean isInstalled(@NotNull IDevice device, @NotNull File apk, @NotNull String pkgName, @Nullable Integer userId) throws IOException {
        CacheData state;
        if (device == null) {
            InstalledApkCache.$$$reportNull$$$0(0);
        }
        if (apk == null) {
            InstalledApkCache.$$$reportNull$$$0(1);
        }
        if (pkgName == null) {
            InstalledApkCache.$$$reportNull$$$0(2);
        }
        if ((state = this.myCache.get(device, pkgName)) == null) {
            return false;
        }
        InstallState currentState = this.getInstallState(device, pkgName);
        return currentState != null && ((CacheData)state).installState.lastUpdateTime.equals(currentState.lastUpdateTime) && state.hash.equals((Object)InstalledApkCache.hash(apk)) && (userId == null || currentState.users.contains(userId));
    }

    public void setInstalled(@NotNull IDevice device, @NotNull File apk, @NotNull String pkgName) throws IOException {
        InstallState installState;
        if (device == null) {
            InstalledApkCache.$$$reportNull$$$0(3);
        }
        if (apk == null) {
            InstalledApkCache.$$$reportNull$$$0(4);
        }
        if (pkgName == null) {
            InstalledApkCache.$$$reportNull$$$0(5);
        }
        if ((installState = this.getInstallState(device, pkgName)) == null) {
            String msg = String.format("Unexpected error: package manager reports that package %1$s has not been installed: %2$s", pkgName, StringUtil.notNullize((String)this.myDiagnosticOutput));
            Logger.getInstance(InstalledApkCache.class).warn(msg);
            return;
        }
        this.myCache.put(device, pkgName, new CacheData(installState, InstalledApkCache.hash(apk)));
    }

    @NotNull
    private static HashCode hash(@NotNull File apk) throws IOException {
        if (apk == null) {
            InstalledApkCache.$$$reportNull$$$0(6);
        }
        HashCode hashCode = Files.hash((File)apk, (HashFunction)Hashing.goodFastHash((int)32));
        if (hashCode == null) {
            InstalledApkCache.$$$reportNull$$$0(7);
        }
        return hashCode;
    }

    void deviceDisconnected(IDevice device) {
        this.myCache.deviceDisconnected(device);
    }

    @Nullable
    public InstallState getInstallState(@NotNull IDevice device, @NotNull String pkgName) {
        String output;
        if (device == null) {
            InstalledApkCache.$$$reportNull$$$0(8);
        }
        if (pkgName == null) {
            InstalledApkCache.$$$reportNull$$$0(9);
        }
        boolean deviceHasPackage = false;
        this.myDiagnosticOutput = null;
        try {
            output = this.executeShellCommand(device, "dumpsys package " + pkgName, 500L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            this.myDiagnosticOutput = String.format("Error executing 'dumpsys package %1$s:\n%2$s'", pkgName, e.getMessage());
            return null;
        }
        Iterable lines = Splitter.on((String)"\n").split((CharSequence)output);
        for (String line : lines) {
            if (!(line = line.trim()).startsWith("Package [")) continue;
            int startIndex = line.indexOf(91);
            int endIndex = line.indexOf(93);
            if (startIndex <= 0 || endIndex <= startIndex) break;
            deviceHasPackage = pkgName.equals(line.substring(startIndex + 1, endIndex));
            break;
        }
        if (!deviceHasPackage) {
            this.myDiagnosticOutput = String.format("Expected string 'Package [%1$s]' not found in output: %2$s", pkgName, output);
            return null;
        }
        String lastUpdateTime = "";
        HashSet users = Sets.newHashSet();
        for (String line : lines) {
            if ((line = line.trim()).startsWith("lastUpdateTime")) {
                lastUpdateTime = line;
            }
            if (!line.startsWith("User ") || !line.contains("installed=true")) continue;
            int endIndex = line.indexOf(58);
            try {
                users.add(Integer.parseInt(line.substring("User ".length(), endIndex)));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return new InstallState(lastUpdateTime, users);
    }

    /*
     * WARNING - void declaration
     */
    protected String executeShellCommand(@NotNull IDevice device, @NotNull String cmd, long timeout, @NotNull TimeUnit timeUnit) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, InterruptedException {
        void timeUnit2;
        if (device == null) {
            InstalledApkCache.$$$reportNull$$$0(10);
        }
        if (cmd == null) {
            InstalledApkCache.$$$reportNull$$$0(11);
        }
        if (timeUnit == null) {
            InstalledApkCache.$$$reportNull$$$0(12);
        }
        CountDownLatch latch = new CountDownLatch(1);
        CollectingOutputReceiver receiver = new CollectingOutputReceiver(latch);
        device.executeShellCommand(cmd, (IShellOutputReceiver)receiver);
        latch.await(timeout, (TimeUnit)timeUnit2);
        return receiver.getOutput();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apk";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkgName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/InstalledApkCache";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeUnit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/InstalledApkCache";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "hash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInstalled";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setInstalled";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hash";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInstallState";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "executeShellCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CacheData {
        @NotNull
        private final InstallState installState;
        @NotNull
        private final HashCode hash;

        private CacheData(@NotNull InstallState installState, @NotNull HashCode hash2) {
            if (installState == null) {
                CacheData.$$$reportNull$$$0(0);
            }
            if (hash2 == null) {
                CacheData.$$$reportNull$$$0(1);
            }
            this.installState = installState;
            this.hash = hash2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "installState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "hash";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/run/InstalledApkCache$CacheData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class InstallState {
        @NotNull
        public final String lastUpdateTime;
        @NotNull
        public final Set<Integer> users;

        public InstallState(@NotNull String lastUpdateTime, @NotNull Set<Integer> users) {
            if (lastUpdateTime == null) {
                InstallState.$$$reportNull$$$0(0);
            }
            if (users == null) {
                InstallState.$$$reportNull$$$0(1);
            }
            this.lastUpdateTime = lastUpdateTime;
            this.users = users;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "lastUpdateTime";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "users";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/run/InstalledApkCache$InstallState";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

