/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.DeviceChooser;
import com.android.tools.idea.run.DeviceChooserDialog;
import com.android.tools.idea.run.DeviceCount;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceSelectionUtils {
    @NotNull
    private static final Logger LOG = Logger.getInstance(DeviceSelectionUtils.class);
    @NonNls
    private static final String ANDROID_TARGET_DEVICES_PROPERTY = "AndroidTargetDevices";

    @Nullable
    public static Collection<IDevice> chooseRunningDevice(final @NotNull AndroidFacet facet, final @NotNull Predicate<IDevice> deviceFilter, final @NotNull DeviceCount deviceCount) {
        List<IDevice> compatibleDevices;
        if (facet == null) {
            DeviceSelectionUtils.$$$reportNull$$$0(0);
        }
        if (deviceFilter == null) {
            DeviceSelectionUtils.$$$reportNull$$$0(1);
        }
        if (deviceCount == null) {
            DeviceSelectionUtils.$$$reportNull$$$0(2);
        }
        if ((compatibleDevices = DeviceSelectionUtils.getAllCompatibleDevices(deviceFilter)).isEmpty()) {
            return ImmutableList.of();
        }
        if (compatibleDevices.size() == 1) {
            return compatibleDevices;
        }
        final AtomicReference devicesRef = new AtomicReference();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                devicesRef.set(DeviceSelectionUtils.chooseDevicesManually(facet, (Predicate<IDevice>)deviceFilter, deviceCount));
            }
        });
        return ((IDevice[])devicesRef.get()).length > 0 ? ImmutableList.copyOf((Object[])((Object[])devicesRef.get())) : null;
    }

    @NotNull
    public static List<IDevice> getAllCompatibleDevices(Predicate<IDevice> deviceFilter) {
        ArrayList<IDevice> compatibleDevices = new ArrayList<IDevice>();
        AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
        if (bridge != null) {
            IDevice[] devices;
            for (IDevice device : devices = bridge.getDevices()) {
                if (!deviceFilter.apply((Object)device)) continue;
                compatibleDevices.add(device);
            }
        }
        ArrayList<IDevice> arrayList = compatibleDevices;
        if (arrayList == null) {
            DeviceSelectionUtils.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<IDevice> getOnlineDevices(@Nullable Collection<IDevice> devices) {
        if (devices == null) {
            List<IDevice> list = Collections.emptyList();
            if (list == null) {
                DeviceSelectionUtils.$$$reportNull$$$0(4);
            }
            return list;
        }
        ArrayList online = Lists.newArrayListWithExpectedSize((int)devices.size());
        for (IDevice device : devices) {
            if (!device.isOnline()) continue;
            online.add(device);
        }
        ArrayList arrayList = online;
        if (arrayList == null) {
            DeviceSelectionUtils.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private static IDevice[] chooseDevicesManually(@NotNull AndroidFacet facet, @NotNull Predicate<IDevice> filter2, @NotNull DeviceCount deviceCount) {
        Project project;
        String value2;
        if (facet == null) {
            DeviceSelectionUtils.$$$reportNull$$$0(6);
        }
        if (filter2 == null) {
            DeviceSelectionUtils.$$$reportNull$$$0(7);
        }
        if (deviceCount == null) {
            DeviceSelectionUtils.$$$reportNull$$$0(8);
        }
        String[] selectedSerials = (value2 = PropertiesComponent.getInstance((Project)(project = facet.getModule().getProject())).getValue(ANDROID_TARGET_DEVICES_PROPERTY)) != null ? DeviceSelectionUtils.deserialize(value2) : null;
        AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
        if (platform == null) {
            LOG.error("Android platform not set for module: " + facet.getModule().getName());
            if (DeviceChooser.EMPTY_DEVICE_ARRAY == null) {
                DeviceSelectionUtils.$$$reportNull$$$0(9);
            }
            return DeviceChooser.EMPTY_DEVICE_ARRAY;
        }
        DeviceChooserDialog chooser = new DeviceChooserDialog(facet, platform.getTarget(), deviceCount.isMultiple(), selectedSerials, filter2);
        chooser.show();
        IDevice[] devices = chooser.getSelectedDevices();
        if (chooser.getExitCode() != 0 || devices.length == 0) {
            if (DeviceChooser.EMPTY_DEVICE_ARRAY == null) {
                DeviceSelectionUtils.$$$reportNull$$$0(10);
            }
            return DeviceChooser.EMPTY_DEVICE_ARRAY;
        }
        PropertiesComponent.getInstance((Project)project).setValue(ANDROID_TARGET_DEVICES_PROPERTY, DeviceSelectionUtils.serialize(devices));
        if (devices == null) {
            DeviceSelectionUtils.$$$reportNull$$$0(11);
        }
        return devices;
    }

    @NotNull
    public static String serialize(@NotNull IDevice[] devices) {
        if (devices == null) {
            DeviceSelectionUtils.$$$reportNull$$$0(12);
        }
        StringBuilder builder = new StringBuilder();
        int n = devices.length;
        for (int i2 = 0; i2 < n; ++i2) {
            builder.append(devices[i2].getSerialNumber());
            if (i2 >= n - 1) continue;
            builder.append(' ');
        }
        String string = builder.toString();
        if (string == null) {
            DeviceSelectionUtils.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private static String[] deserialize(@NotNull String s) {
        if (s == null) {
            DeviceSelectionUtils.$$$reportNull$$$0(14);
        }
        String[] stringArray = s.split(" ");
        if (stringArray == null) {
            DeviceSelectionUtils.$$$reportNull$$$0(15);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceFilter";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceCount";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/DeviceSelectionUtils";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devices";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/DeviceSelectionUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCompatibleDevices";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOnlineDevices";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseDevicesManually";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "serialize";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "chooseRunningDevice";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "chooseDevicesManually";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

