/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.ddms.DeviceNameRendererEx;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.LaunchCompatibility;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import icons.AndroidIcons;
import java.awt.Color;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConnectedAndroidDevice
implements AndroidDevice {
    private static final ExtensionPointName<DeviceNameRendererEx> EP_NAME = ExtensionPointName.create((String)"com.android.run.deviceNameRenderer");
    @NotNull
    private final IDevice myDevice;
    @Nullable
    private final String myAvdName;
    @Nullable
    private final DeviceNameRendererEx myDeviceNameRenderer;
    private volatile String myDeviceManufacturer;
    private volatile String myDeviceBuild;
    private volatile String myDeviceModel;

    public ConnectedAndroidDevice(@NotNull IDevice device, @Nullable List<AvdInfo> avdInfos) {
        if (device == null) {
            ConnectedAndroidDevice.$$$reportNull$$$0(0);
        }
        this.myDevice = device;
        AvdInfo avdInfo = ConnectedAndroidDevice.getAvdInfo(device, avdInfos);
        this.myAvdName = avdInfo == null ? null : AvdManagerConnection.getAvdDisplayName(avdInfo);
        this.myDeviceNameRenderer = ConnectedAndroidDevice.getRendererExtension(device);
    }

    @Nullable
    private static AvdInfo getAvdInfo(@NotNull IDevice device, @Nullable List<AvdInfo> avdInfos) {
        if (device == null) {
            ConnectedAndroidDevice.$$$reportNull$$$0(1);
        }
        if (avdInfos != null && device.isEmulator()) {
            for (AvdInfo info : avdInfos) {
                if (!info.getName().equals(device.getAvdName())) continue;
                return info;
            }
        }
        return null;
    }

    @Override
    public boolean isRunning() {
        return true;
    }

    @Override
    public boolean isVirtual() {
        return this.myDevice.isEmulator();
    }

    @Override
    @NotNull
    public AndroidVersion getVersion() {
        AndroidVersion androidVersion = this.myDevice.getVersion();
        if (androidVersion == null) {
            ConnectedAndroidDevice.$$$reportNull$$$0(2);
        }
        return androidVersion;
    }

    @Override
    public int getDensity() {
        return this.myDevice.getDensity();
    }

    @Override
    @NotNull
    public List<Abi> getAbis() {
        List abis = this.myDevice.getAbis();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String abi : abis) {
            Abi a = Abi.getEnum((String)abi);
            if (a == null) continue;
            builder.add((Object)a);
        }
        ImmutableList immutableList = builder.build();
        if (immutableList == null) {
            ConnectedAndroidDevice.$$$reportNull$$$0(3);
        }
        return immutableList;
    }

    @Override
    @NotNull
    public String getSerial() {
        String avdName;
        if (this.myDevice.isEmulator() && (avdName = this.myDevice.getAvdName()) != null) {
            String string = avdName;
            if (string == null) {
                ConnectedAndroidDevice.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = this.myDevice.getSerialNumber();
        if (string == null) {
            ConnectedAndroidDevice.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public boolean supportsFeature(@NotNull IDevice.HardwareFeature feature) {
        if (feature == null) {
            ConnectedAndroidDevice.$$$reportNull$$$0(6);
        }
        return this.myDevice.supportsFeature(feature);
    }

    @Override
    @NotNull
    public String getName() {
        if (this.myDeviceNameRenderer != null) {
            String string = this.myDeviceNameRenderer.getName(this.myDevice);
            if (string == null) {
                ConnectedAndroidDevice.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = this.myAvdName == null ? this.getDeviceName() : this.myAvdName;
        if (string == null) {
            ConnectedAndroidDevice.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    public boolean renderLabel(@NotNull SimpleColoredComponent renderer, boolean isCompatible, @Nullable String searchPrefix) {
        if (renderer == null) {
            ConnectedAndroidDevice.$$$reportNull$$$0(9);
        }
        if (this.myDeviceNameRenderer != null) {
            this.myDeviceNameRenderer.render(this.myDevice, (ColoredTextContainer)renderer);
            return true;
        }
        renderer.setIcon(this.myDevice.isEmulator() ? AndroidIcons.Ddms.EmulatorDevice : AndroidIcons.Ddms.RealDevice);
        IDevice.DeviceState state = this.myDevice.getState();
        if (state != IDevice.DeviceState.ONLINE) {
            StringBuilder buf = new StringBuilder();
            buf.append(String.format("%1$s [%2$s", this.myDevice.getSerialNumber(), state));
            if (state == IDevice.DeviceState.UNAUTHORIZED) {
                buf.append(" - Press 'OK' in the 'Allow USB Debugging' dialog on your device");
            }
            buf.append("] ");
            renderer.append(buf.toString(), SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
            return true;
        }
        if (this.myDeviceManufacturer != null && this.myDeviceModel != null && this.myDeviceBuild != null) {
            SimpleTextAttributes attr = isCompatible ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES;
            String name = this.getName();
            if (name.isEmpty()) {
                name = "Unknown";
            }
            SearchUtil.appendFragments((String)searchPrefix, (String)name, (int)attr.getStyle(), (Color)attr.getFgColor(), (Color)attr.getBgColor(), (SimpleColoredComponent)renderer);
            String build2 = this.getDeviceBuild();
            if (!build2.isEmpty()) {
                renderer.append(" (" + build2 + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            return true;
        }
        renderer.append("...");
        return false;
    }

    @NotNull
    private String getDeviceName() {
        StringBuilder name = new StringBuilder(20);
        name.append(this.getDeviceManufacturer());
        if (name.length() > 0) {
            name.append(' ');
        }
        name.append(this.getDeviceModel());
        String string = name.toString();
        if (string == null) {
            ConnectedAndroidDevice.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    public void prepareToRenderLabel() {
        assert (!this.isDispatchThread());
        this.getDeviceManufacturer();
        this.getDeviceModel();
        this.getDeviceBuild();
    }

    @NotNull
    private String getDeviceManufacturer() {
        if (this.myDeviceManufacturer == null) {
            assert (!this.isDispatchThread());
            this.myDeviceManufacturer = DevicePropertyUtil.getManufacturer(this.myDevice, "");
        }
        String string = this.myDeviceManufacturer;
        if (string == null) {
            ConnectedAndroidDevice.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private String getDeviceModel() {
        if (this.myDeviceModel == null) {
            assert (!this.isDispatchThread());
            this.myDeviceModel = DevicePropertyUtil.getModel(this.myDevice, "");
        }
        String string = this.myDeviceModel;
        if (string == null) {
            ConnectedAndroidDevice.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private String getDeviceBuild() {
        if (this.myDeviceBuild == null) {
            assert (!this.isDispatchThread());
            this.myDeviceBuild = DevicePropertyUtil.getBuild(this.myDevice);
        }
        String string = this.myDeviceBuild;
        if (string == null) {
            ConnectedAndroidDevice.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    @NotNull
    public ListenableFuture<IDevice> launch(@NotNull Project project) {
        if (project == null) {
            ConnectedAndroidDevice.$$$reportNull$$$0(14);
        }
        ListenableFuture<IDevice> listenableFuture = this.getLaunchedDevice();
        if (listenableFuture == null) {
            ConnectedAndroidDevice.$$$reportNull$$$0(15);
        }
        return listenableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<IDevice> getLaunchedDevice() {
        ListenableFuture listenableFuture = Futures.immediateFuture((Object)this.myDevice);
        if (listenableFuture == null) {
            ConnectedAndroidDevice.$$$reportNull$$$0(16);
        }
        return listenableFuture;
    }

    @NotNull
    public IDevice getDevice() {
        IDevice iDevice = this.myDevice;
        if (iDevice == null) {
            ConnectedAndroidDevice.$$$reportNull$$$0(17);
        }
        return iDevice;
    }

    @Nullable
    private static DeviceNameRendererEx getRendererExtension(@NotNull IDevice device) {
        Application application;
        if (device == null) {
            ConnectedAndroidDevice.$$$reportNull$$$0(18);
        }
        if ((application = ApplicationManager.getApplication()) == null || application.isUnitTestMode()) {
            return null;
        }
        for (DeviceNameRendererEx extensionRenderer : (DeviceNameRendererEx[])EP_NAME.getExtensions()) {
            if (!extensionRenderer.isApplicable(device)) continue;
            return extensionRenderer;
        }
        return null;
    }

    @Override
    @NotNull
    public LaunchCompatibility canRun(@NotNull AndroidVersion minSdkVersion2, @NotNull IAndroidTarget projectTarget, @NotNull EnumSet<IDevice.HardwareFeature> requiredFeatures, @Nullable Set<String> supportedAbis) {
        if (minSdkVersion2 == null) {
            ConnectedAndroidDevice.$$$reportNull$$$0(19);
        }
        if (projectTarget == null) {
            ConnectedAndroidDevice.$$$reportNull$$$0(20);
        }
        if (requiredFeatures == null) {
            ConnectedAndroidDevice.$$$reportNull$$$0(21);
        }
        LaunchCompatibility launchCompatibility = LaunchCompatibility.canRunOnDevice(minSdkVersion2, projectTarget, requiredFeatures, supportedAbis, this);
        if (launchCompatibility == null) {
            ConnectedAndroidDevice.$$$reportNull$$$0(22);
        }
        return launchCompatibility;
    }

    private boolean isDispatchThread() {
        Application application = ApplicationManager.getApplication();
        return application != null && application.isDispatchThread();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/ConnectedAndroidDevice";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minSdkVersion";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectTarget";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredFeatures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/ConnectedAndroidDevice";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbis";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerial";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceManufacturer";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceModel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceBuild";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "launch";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLaunchedDevice";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevice";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "canRun";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAvdInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 22: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "supportsFeature";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "renderLabel";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "launch";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getRendererExtension";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

