/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.IdDisplay;
import com.android.tools.idea.avdmanager.AvdManagerUtils;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashSet;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.jetbrains.android.actions.RunAndroidAvdManagerAction;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AvdComboBox
extends ComboboxWithBrowseButton {
    private final boolean myAddEmptyElement;
    private final boolean myShowNotLaunchedOnly;
    private final Alarm myAlarm = new Alarm((Disposable)this);
    private IdDisplay[] myOldAvds = new IdDisplay[0];
    private final Project myProject;

    public AvdComboBox(@Nullable Project project, boolean addEmptyElement, boolean showNotLaunchedOnly) {
        this.myProject = project;
        this.myAddEmptyElement = addEmptyElement;
        this.myShowNotLaunchedOnly = showNotLaunchedOnly;
        this.addActionListener(e -> {
            AndroidPlatform platform = this.findAndroidPlatform();
            AvdComboBox avdComboBox = this;
            if (platform == null) {
                Messages.showErrorDialog((Component)((Object)avdComboBox), (String)"Cannot find any configured Android SDK");
                return;
            }
            RunAndroidAvdManagerAction action2 = new RunAndroidAvdManagerAction();
            action2.openAvdManager(this.myProject);
            AvdInfo selected = action2.getSelected();
            if (selected != null) {
                this.getComboBox().setSelectedItem(IdDisplay.create((String)selected.getName(), (String)""));
            }
        });
        this.setMinimumSize(new Dimension(JBUIScale.scale((int)100), this.getMinimumSize().height));
    }

    public void startUpdatingAvds(@NotNull ModalityState modalityState) {
        if (modalityState == null) {
            AvdComboBox.$$$reportNull$$$0(0);
        }
        if (!this.getComboBox().isPopupVisible()) {
            this.doUpdateAvds();
        }
        this.addUpdatingRequest(modalityState);
    }

    private void addUpdatingRequest(@NotNull ModalityState modalityState) {
        if (modalityState == null) {
            AvdComboBox.$$$reportNull$$$0(1);
        }
        if (this.myAlarm.isDisposed()) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> this.startUpdatingAvds(modalityState), 500, modalityState);
    }

    public void dispose() {
        this.myAlarm.cancelAllRequests();
        super.dispose();
    }

    private void doUpdateAvds() {
        Object[] newAvds;
        Module module = this.getModule();
        if (module == null || module.isDisposed()) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null) {
            AndroidDebugBridge debugBridge;
            HashSet filteringSet = new HashSet();
            if (this.myShowNotLaunchedOnly && (debugBridge = AndroidSdkUtils.getDebugBridge(facet.getModule().getProject())) != null) {
                for (IDevice device : debugBridge.getDevices()) {
                    String avdName = device.getAvdName();
                    if (avdName == null || avdName.isEmpty()) continue;
                    filteringSet.add(avdName);
                }
            }
            ArrayList<IdDisplay> newAvdList = new ArrayList<IdDisplay>();
            if (this.myAddEmptyElement) {
                newAvdList.add(IdDisplay.create((String)"", (String)""));
            }
            for (AvdInfo avd : this.getAllAvds(facet)) {
                String displayName = (String)avd.getProperties().get("avd.ini.displayname");
                String avdName = displayName == null || displayName.isEmpty() ? avd.getName() : displayName;
                if (filteringSet.contains(avdName)) continue;
                newAvdList.add(IdDisplay.create((String)avd.getName(), (String)avdName));
            }
            newAvds = (IdDisplay[])ArrayUtil.toObjectArray(newAvdList, IdDisplay.class);
        } else {
            newAvds = new IdDisplay[]{};
        }
        if (!Arrays.equals(this.myOldAvds, newAvds)) {
            this.myOldAvds = newAvds;
            Object selected = this.getComboBox().getSelectedItem();
            this.getComboBox().setModel(new DefaultComboBoxModel<Object>(newAvds));
            this.getComboBox().setSelectedItem(selected);
        }
    }

    @NotNull
    public List<AvdInfo> getAllAvds(AndroidFacet facet) {
        AvdManager manager = AvdManagerUtils.getAvdManagerSilently(facet);
        Object object = manager != null && AvdManagerUtils.reloadAvds(manager, facet.getModule().getProject()) ? Arrays.asList(manager.getAllAvds()) : ImmutableList.of();
        if (object == null) {
            AvdComboBox.$$$reportNull$$$0(2);
        }
        return object;
    }

    @Nullable
    public abstract Module getModule();

    @Nullable
    private AndroidPlatform findAndroidPlatform() {
        AndroidPlatform platform = this.findAndroidPlatformFromModule();
        if (platform != null) {
            return platform;
        }
        for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
            platform = AndroidPlatform.getInstance(sdk);
            if (platform == null) continue;
            return platform;
        }
        return null;
    }

    @Nullable
    private AndroidPlatform findAndroidPlatformFromModule() {
        Module module = this.getModule();
        return module != null ? AndroidPlatform.getInstance(module) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/AvdComboBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/AvdComboBox";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAvds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startUpdatingAvds";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addUpdatingRequest";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

