/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellEnabledDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.logcat.output.LogcatOutputSettings;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.run.ApplicationLogListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import java.io.OutputStream;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProcessHandler
extends ProcessHandler {
    private static final Logger LOG = Logger.getInstance(AndroidProcessHandler.class);
    private static final long TIMEOUT_MS = 10000L;
    private static final String SIMPLE_FORMAT = AndroidLogcatFormatter.createCustomFormat(false, false, false, true);
    @NotNull
    private final Object deviceClientLock;
    @NotNull
    private final String myApplicationId;
    @GuardedBy(value="deviceClientLock")
    @NotNull
    private final Set<String> myDevices;
    @GuardedBy(value="deviceClientLock")
    @NotNull
    private final Set<Client> myClients;
    @NotNull
    private final LogcatOutputCapture myLogcatOutputCapture;
    @GuardedBy(value="deviceClientLock")
    private long myDeviceAdded;
    private boolean myNoKill;
    @NotNull
    private final AndroidDebugBridge.IDeviceChangeListener deviceChangeListener;
    @NotNull
    private final AndroidDebugBridge.IClientChangeListener clientChangeListener;

    private AndroidProcessHandler(@NotNull String applicationId2) {
        if (applicationId2 == null) {
            AndroidProcessHandler.$$$reportNull$$$0(0);
        }
        this.deviceClientLock = new Object();
        this.myApplicationId = applicationId2;
        this.myDevices = Sets.newConcurrentHashSet();
        this.myClients = Sets.newConcurrentHashSet();
        this.myLogcatOutputCapture = new LogcatOutputCapture(applicationId2);
        this.deviceChangeListener = new DeviceChangeListener();
        this.clientChangeListener = new ClientChangeListener();
    }

    private void addListenersToAdb() {
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this.clientChangeListener);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.deviceChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTargetDevice(@NotNull IDevice device) {
        if (device == null) {
            AndroidProcessHandler.$$$reportNull$$$0(1);
        }
        Object object = this.deviceClientLock;
        synchronized (object) {
            this.myDevices.add(device.getSerialNumber());
            this.setMinDeviceApiLevel(device.getVersion());
            if (!this.addClientIfAvailable(device)) {
                this.notifyTextAvailable("Client not ready yet..", ProcessOutputTypes.STDOUT);
            }
            LOG.info("Adding device " + device.getName() + " to monitor for launched app: " + this.myApplicationId);
            this.myDeviceAdded = System.currentTimeMillis();
        }
    }

    @GuardedBy(value="deviceClientLock")
    private boolean addClientIfAvailable(@NotNull IDevice device) {
        Client client;
        if (device == null) {
            AndroidProcessHandler.$$$reportNull$$$0(2);
        }
        if ((client = device.getClient(this.myApplicationId)) != null) {
            this.addClient(client);
            return true;
        }
        return false;
    }

    @GuardedBy(value="deviceClientLock")
    private void addClient(@NotNull Client client) {
        if (client == null) {
            AndroidProcessHandler.$$$reportNull$$$0(3);
        }
        if (!this.myClients.add(client)) {
            return;
        }
        IDevice device = client.getDevice();
        this.notifyTextAvailable("Connected to process " + client.getClientData().getPid() + " on device " + device.getName() + "\n", ProcessOutputTypes.STDOUT);
        this.myLogcatOutputCapture.startCapture(device, client, (arg_0, arg_1) -> ((AndroidProcessHandler)this).notifyTextAvailable(arg_0, arg_1));
    }

    private void setMinDeviceApiLevel(@NotNull AndroidVersion deviceVersion) {
        AndroidVersion apiLevel;
        if (deviceVersion == null) {
            AndroidProcessHandler.$$$reportNull$$$0(4);
        }
        if ((apiLevel = (AndroidVersion)this.getUserData(AndroidSessionInfo.ANDROID_DEVICE_API_LEVEL)) == null || apiLevel.compareTo(deviceVersion) > 0) {
            this.putUserData(AndroidSessionInfo.ANDROID_DEVICE_API_LEVEL, deviceVersion);
        }
    }

    @GuardedBy(value="deviceClientLock")
    private boolean isListeningToDevices() {
        return !this.myDevices.isEmpty();
    }

    public boolean detachIsDefault() {
        return false;
    }

    public boolean isSilentlyDestroyOnClose() {
        return true;
    }

    public OutputStream getProcessInput() {
        return null;
    }

    protected void detachProcessImpl() {
        this.notifyProcessDetached();
        this.cleanup();
    }

    protected void destroyProcessImpl() {
        this.notifyProcessTerminated(0);
        this.killProcesses();
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killProcesses() {
        if (this.myNoKill) {
            return;
        }
        AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
        if (bridge == null) {
            return;
        }
        for (IDevice device : bridge.getDevices()) {
            boolean deviceIsContained;
            Object object = this.deviceClientLock;
            synchronized (object) {
                deviceIsContained = this.myDevices.contains(device.getSerialNumber());
            }
            if (!deviceIsContained) continue;
            try {
                device.executeShellCommand("am force-stop " + this.myApplicationId, (IShellOutputReceiver)new NullOutputReceiver());
            }
            catch (Exception exception) {
                // empty catch block
            }
            Client client = device.getClient(this.myApplicationId);
            if (client == null) continue;
            client.kill();
        }
    }

    public void setNoKill() {
        this.myNoKill = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        Object object = this.deviceClientLock;
        synchronized (object) {
            this.myDevices.clear();
            this.myClients.clear();
        }
        this.myLogcatOutputCapture.stopAll();
        AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this.clientChangeListener);
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.deviceChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopMonitoring(@NotNull IDevice device) {
        if (device == null) {
            AndroidProcessHandler.$$$reportNull$$$0(5);
        }
        this.myLogcatOutputCapture.stopCapture(device);
        Object object = this.deviceClientLock;
        synchronized (object) {
            this.myDevices.remove(device.getSerialNumber());
            if (this.myDevices.isEmpty()) {
                this.detachProcess();
            }
        }
    }

    private boolean isMatchingClient(@NotNull Client client) {
        if (client == null) {
            AndroidProcessHandler.$$$reportNull$$$0(6);
        }
        return StringUtil.equals((CharSequence)this.myApplicationId, (CharSequence)client.getClientData().getClientDescription()) || StringUtil.equals((CharSequence)this.myApplicationId, (CharSequence)client.getClientData().getPackageName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<IDevice> getDevices() {
        HashSet devices = Sets.newHashSet();
        Object object = this.deviceClientLock;
        synchronized (object) {
            for (Client client : this.myClients) {
                devices.add(client.getDevice());
            }
        }
        ArrayList arrayList = Lists.newArrayList((Iterable)devices);
        if (arrayList == null) {
            AndroidProcessHandler.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Client getClient(@NotNull IDevice device) {
        if (device == null) {
            AndroidProcessHandler.$$$reportNull$$$0(8);
        }
        String serial = device.getSerialNumber();
        Object object = this.deviceClientLock;
        synchronized (object) {
            for (Client client : this.myClients) {
                if (!StringUtil.equals((CharSequence)client.getDevice().getSerialNumber(), (CharSequence)serial)) continue;
                return client;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Set<Client> getClients() {
        Object object = this.deviceClientLock;
        // MONITORENTER : object
        HashSet<Client> hashSet = new HashSet<Client>(this.myClients);
        // MONITOREXIT : object
        if (hashSet != null) return hashSet;
        AndroidProcessHandler.$$$reportNull$$$0(9);
        return hashSet;
    }

    private void print(@NotNull String s) {
        if (s == null) {
            AndroidProcessHandler.$$$reportNull$$$0(10);
        }
        this.notifyTextAvailable(s + "\n", ProcessOutputTypes.STDOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.deviceClientLock;
        synchronized (object) {
            this.myDevices.clear();
            this.myClients.clear();
        }
        this.myLogcatOutputCapture.stopAll();
    }

    @VisibleForTesting
    protected void clientChanged(@NotNull Client client, int changeMask) {
        if (client == null) {
            AndroidProcessHandler.$$$reportNull$$$0(11);
        }
        this.clientChangeListener.clientChanged(client, changeMask);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationId";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 3: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceVersion";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/AndroidProcessHandler";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/AndroidProcessHandler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevices";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getClients";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addTargetDevice";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addClientIfAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addClient";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setMinDeviceApiLevel";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "stopMonitoring";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isMatchingClient";
                break;
            }
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getClient";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "clientChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder {
        private String applicationId;
        private boolean shouldAddListeners = true;

        @NotNull
        public Builder setApplicationId(@NotNull String appId) {
            if (appId == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.applicationId = appId;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder monitorRemoteProcesses(boolean shouldMonitorRemoteProcesses) {
            this.shouldAddListeners = shouldMonitorRemoteProcesses;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder;
        }

        @NotNull
        public AndroidProcessHandler build() {
            if (this.applicationId == null) {
                throw new IllegalStateException("applicationId not set");
            }
            AndroidProcessHandler handler = new AndroidProcessHandler(this.applicationId);
            if (this.shouldAddListeners) {
                handler.addListenersToAdb();
            }
            AndroidProcessHandler androidProcessHandler = handler;
            if (androidProcessHandler == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return androidProcessHandler;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "appId";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/run/AndroidProcessHandler$Builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/run/AndroidProcessHandler$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setApplicationId";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "monitorRemoteProcesses";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setApplicationId";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ClientChangeListener
    implements AndroidDebugBridge.IClientChangeListener {
        private ClientChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clientChanged(@NotNull Client client, int changeMask) {
            if (client == null) {
                ClientChangeListener.$$$reportNull$$$0(0);
            }
            Object object = AndroidProcessHandler.this.deviceClientLock;
            synchronized (object) {
                if (!AndroidProcessHandler.this.isListeningToDevices()) {
                    return;
                }
                if ((changeMask & 1) != 1) {
                    return;
                }
                if (!AndroidProcessHandler.this.myDevices.contains(client.getDevice().getSerialNumber())) {
                    return;
                }
                if (AndroidProcessHandler.this.isMatchingClient(client)) {
                    LOG.debug("Adding client for {}", new Object[]{AndroidProcessHandler.this.myApplicationId});
                    AndroidProcessHandler.this.addClient(client);
                }
                if (AndroidProcessHandler.this.isMatchingClient(client) && !client.isValid()) {
                    AndroidProcessHandler.this.print("Process " + client.getClientData().getPid() + " is not valid anymore!");
                    AndroidProcessHandler.this.stopMonitoring(client.getDevice());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/idea/run/AndroidProcessHandler$ClientChangeListener", "clientChanged"));
        }
    }

    private class DeviceChangeListener
    implements AndroidDebugBridge.IDeviceChangeListener {
        private DeviceChangeListener() {
        }

        public void deviceConnected(@NotNull IDevice device) {
            if (device == null) {
                DeviceChangeListener.$$$reportNull$$$0(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deviceDisconnected(@NotNull IDevice device) {
            if (device == null) {
                DeviceChangeListener.$$$reportNull$$$0(1);
            }
            Object object = AndroidProcessHandler.this.deviceClientLock;
            synchronized (object) {
                AndroidProcessHandler.this.print("Device " + device.getName() + "disconnected, monitoring stopped.");
                AndroidProcessHandler.this.stopMonitoring(device);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deviceChanged(@NotNull IDevice device, int changeMask) {
            if (device == null) {
                DeviceChangeListener.$$$reportNull$$$0(2);
            }
            Object object = AndroidProcessHandler.this.deviceClientLock;
            synchronized (object) {
                if (!AndroidProcessHandler.this.isListeningToDevices()) {
                    return;
                }
                if ((changeMask & 2) != 2) {
                    return;
                }
                if (!AndroidProcessHandler.this.myDevices.contains(device.getSerialNumber())) {
                    return;
                }
                if (AndroidProcessHandler.this.addClientIfAvailable(device)) {
                    return;
                }
                if (!AndroidProcessHandler.this.myClients.isEmpty()) {
                    LOG.debug("Non-empty list of clients for {}. Stopping monitoring of clients since they're dead", new Object[]{AndroidProcessHandler.this.myApplicationId});
                    for (Client c : AndroidProcessHandler.this.myClients) {
                        if (!device.equals(c.getDevice())) continue;
                        AndroidProcessHandler.this.stopMonitoring(device);
                        AndroidProcessHandler.this.print("Application terminated.");
                        return;
                    }
                }
                if (System.currentTimeMillis() - AndroidProcessHandler.this.myDeviceAdded > 10000L) {
                    AndroidProcessHandler.this.print("Timed out waiting for process to appear on " + device.getName());
                    AndroidProcessHandler.this.stopMonitoring(device);
                } else {
                    AndroidProcessHandler.this.print("Waiting for process to come online");
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "device";
            objectArray2[1] = "com/android/tools/idea/run/AndroidProcessHandler$DeviceChangeListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deviceConnected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deviceDisconnected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deviceChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class LogcatOutputCapture {
        @NotNull
        private final String myApplicationId;
        @GuardedBy(value="myLock")
        @NotNull
        private final Map<IDevice, AndroidLogcatService.LogcatListener> myLogListeners;
        @NotNull
        private final Object myLock;

        LogcatOutputCapture(@NotNull String applicationId2) {
            if (applicationId2 == null) {
                LogcatOutputCapture.$$$reportNull$$$0(0);
            }
            this.myLogListeners = new HashMap<IDevice, AndroidLogcatService.LogcatListener>();
            this.myLock = new Object();
            this.myApplicationId = applicationId2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startCapture(@NotNull IDevice device, @NotNull Client client, @NotNull BiConsumer<String, Key> consumer) {
            AndroidLogcatService.LogcatListener previousListener;
            if (device == null) {
                LogcatOutputCapture.$$$reportNull$$$0(1);
            }
            if (client == null) {
                LogcatOutputCapture.$$$reportNull$$$0(2);
            }
            if (consumer == null) {
                LogcatOutputCapture.$$$reportNull$$$0(3);
            }
            if (!((Boolean)StudioFlags.RUNDEBUG_LOGCAT_CONSOLE_OUTPUT_ENABLED.get()).booleanValue()) {
                return;
            }
            if (!LogcatOutputSettings.getInstance().isRunOutputEnabled()) {
                return;
            }
            LOG.info(String.format("startCapture(\"%s\")", device.getName()));
            MyLogcatListener logListener = new MyLogcatListener(this.myApplicationId, client.getClientData().getPid(), device, consumer);
            AndroidLogcatService.getInstance().addListener(device, logListener, true);
            Object object = this.myLock;
            synchronized (object) {
                previousListener = this.myLogListeners.put(device, logListener);
            }
            if (previousListener != null) {
                LOG.warn(String.format("The device \"%s\" already has a registered logcat listener for application \"%s\". Removing it", device.getName(), this.myApplicationId));
                AndroidLogcatService.getInstance().removeListener(device, previousListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopCapture(@NotNull IDevice device) {
            AndroidLogcatService.LogcatListener previousListener;
            if (device == null) {
                LogcatOutputCapture.$$$reportNull$$$0(4);
            }
            LOG.info(String.format("stopCapture(\"%s\")", device.getName()));
            Object object = this.myLock;
            synchronized (object) {
                previousListener = this.myLogListeners.remove(device);
            }
            if (previousListener != null) {
                AndroidLogcatService.getInstance().removeListener(device, previousListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopAll() {
            ArrayList<Map.Entry<IDevice, AndroidLogcatService.LogcatListener>> listeners;
            LOG.info("stopAll()");
            Iterator iterator = this.myLock;
            synchronized (iterator) {
                listeners = new ArrayList<Map.Entry<IDevice, AndroidLogcatService.LogcatListener>>(this.myLogListeners.entrySet());
                this.myLogListeners.clear();
            }
            for (Map.Entry entry : listeners) {
                AndroidLogcatService.getInstance().removeListener((IDevice)entry.getKey(), (AndroidLogcatService.LogcatListener)entry.getValue());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "applicationId";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "device";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "client";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/run/AndroidProcessHandler$LogcatOutputCapture";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startCapture";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "stopCapture";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private final class MyLogcatListener
        extends ApplicationLogListener {
            private final AndroidLogcatFormatter myFormatter;
            private final IShellEnabledDevice myDevice;
            private final AtomicBoolean myIsFirstMessage;
            private final BiConsumer<String, Key> myConsumer;

            private MyLogcatListener(String packageName, @NotNull int pid, @NotNull IDevice device, BiConsumer<String, Key> consumer) {
                if (packageName == null) {
                    MyLogcatListener.$$$reportNull$$$0(0);
                }
                if (device == null) {
                    MyLogcatListener.$$$reportNull$$$0(1);
                }
                if (consumer == null) {
                    MyLogcatListener.$$$reportNull$$$0(2);
                }
                super(packageName, pid);
                this.myFormatter = new AndroidLogcatFormatter(ZoneId.systemDefault(), new AndroidLogcatPreferences());
                this.myDevice = device;
                this.myIsFirstMessage = new AtomicBoolean(true);
                this.myConsumer = consumer;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected String formatLogLine(@NotNull LogCatMessage line) {
                if (line == null) {
                    MyLogcatListener.$$$reportNull$$$0(3);
                }
                String message = this.myFormatter.formatMessage(SIMPLE_FORMAT, line.getHeader(), line.getMessage());
                Object object = LogcatOutputCapture.this.myLock;
                synchronized (object) {
                    switch (LogcatOutputCapture.this.myLogListeners.size()) {
                        case 0: 
                        case 1: {
                            return message;
                        }
                    }
                    return '[' + this.myDevice.getName() + "]: " + message;
                }
            }

            @Override
            protected void notifyTextAvailable(@NotNull String message, @NotNull Key key) {
                if (message == null) {
                    MyLogcatListener.$$$reportNull$$$0(4);
                }
                if (key == null) {
                    MyLogcatListener.$$$reportNull$$$0(5);
                }
                if (this.myIsFirstMessage.compareAndSet(true, false)) {
                    this.myConsumer.accept("Capturing and displaying logcat messages from application. This behavior can be disabled in the \"Logcat output\" section of the \"Debugger\" settings page.\n", ProcessOutputTypes.STDOUT);
                }
                this.myConsumer.accept(message, key);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "packageName";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "device";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "consumer";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "line";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/run/AndroidProcessHandler$LogcatOutputCapture$MyLogcatListener";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "formatLogLine";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "notifyTextAvailable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

