/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resourceExplorer.viewmodel;

import com.android.tools.idea.resourceExplorer.importer.ImportersProvider;
import com.android.tools.idea.resourceExplorer.importer.QualifierMatcher;
import com.android.tools.idea.resourceExplorer.importer.SynchronizationListener;
import com.android.tools.idea.resourceExplorer.importer.SynchronizationManager;
import com.android.tools.idea.resourceExplorer.importer.SynchronizationStatus;
import com.android.tools.idea.resourceExplorer.model.DesignAsset;
import com.android.tools.idea.resourceExplorer.model.DesignAssetKt;
import com.android.tools.idea.resourceExplorer.model.DesignAssetListModel;
import com.android.tools.idea.resourceExplorer.model.DesignAssetSet;
import com.android.tools.idea.resourceExplorer.view.DesignAssetExplorer;
import com.android.tools.idea.resourceExplorer.viewmodel.ExternalBrowserViewModelKt;
import com.android.tools.idea.resourceExplorer.viewmodel.ResourceFileHelper;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Dimension;
import java.awt.Image;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fJ\"\u0010\u0018\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u000e\u0010#\u001a\u00020$2\u0006\u0010!\u001a\u00020\"J\u000e\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\"J\u000e\u0010'\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/tools/idea/resourceExplorer/viewmodel/ExternalBrowserViewModel;", "Lcom/android/tools/idea/resourceExplorer/view/DesignAssetExplorer;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "fileHelper", "Lcom/android/tools/idea/resourceExplorer/viewmodel/ResourceFileHelper;", "importersProvider", "Lcom/android/tools/idea/resourceExplorer/importer/ImportersProvider;", "synchronizationManager", "Lcom/android/tools/idea/resourceExplorer/importer/SynchronizationManager;", "(Lorg/jetbrains/android/facet/AndroidFacet;Lcom/android/tools/idea/resourceExplorer/viewmodel/ResourceFileHelper;Lcom/android/tools/idea/resourceExplorer/importer/ImportersProvider;Lcom/android/tools/idea/resourceExplorer/importer/SynchronizationManager;)V", "_matcher", "Lcom/android/tools/idea/resourceExplorer/importer/QualifierMatcher;", "designAssetListModel", "Lcom/android/tools/idea/resourceExplorer/model/DesignAssetListModel;", "getDesignAssetListModel", "()Lcom/android/tools/idea/resourceExplorer/model/DesignAssetListModel;", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFacet", "()Lorg/jetbrains/android/facet/AndroidFacet;", "consumeMatcher", "", "matcher", "getPreview", "Lcom/google/common/util/concurrent/ListenableFuture;", "Ljava/awt/Image;", "asset", "Lcom/android/tools/idea/resourceExplorer/model/DesignAsset;", "dimension", "Ljava/awt/Dimension;", "getStatusLabel", "", "assetSet", "Lcom/android/tools/idea/resourceExplorer/model/DesignAssetSet;", "getSynchronizationStatus", "Lcom/android/tools/idea/resourceExplorer/importer/SynchronizationStatus;", "importDesignAssetSet", "selectedValue", "setDirectory", "intellij.android.core"})
public final class ExternalBrowserViewModel
implements DesignAssetExplorer {
    @NotNull
    private final DesignAssetListModel designAssetListModel;
    private VirtualFile directory;
    private QualifierMatcher _matcher;
    @NotNull
    private final AndroidFacet facet;
    private final ResourceFileHelper fileHelper;
    private final ImportersProvider importersProvider;
    private final SynchronizationManager synchronizationManager;

    @NotNull
    public DesignAssetListModel getDesignAssetListModel() {
        return this.designAssetListModel;
    }

    public final void consumeMatcher(@NotNull QualifierMatcher matcher) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)matcher, (String)"matcher");
            this._matcher = matcher;
            VirtualFile virtualFile = this.directory;
            if (virtualFile == null) break block0;
            VirtualFile virtualFile2 = virtualFile;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile it = virtualFile2;
            boolean bl3 = false;
            this.setDirectory(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setDirectory(@NotNull VirtualFile directory) {
        void $this$sortedBy$iv;
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        if (!directory.isValid() || !directory.isDirectory()) {
            ExternalBrowserViewModelKt.access$getLOG$p().error(directory.getPath() + " is not a valid directory");
            return;
        }
        this.directory = directory;
        Iterable iterable = DesignAssetKt.getAssetSets(directory, this.importersProvider.getSupportedFileTypes(), this._matcher);
        DesignAssetListModel designAssetListModel = this.getDesignAssetListModel();
        boolean $i$f$sortedBy = false;
        void var4_5 = $this$sortedBy$iv;
        boolean bl = false;
        Comparator comparator2 = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                DesignAssetSet $dstr$name$_u24__u24 = (DesignAssetSet)a;
                boolean bl2 = false;
                String name = $dstr$name$_u24__u24.component1();
                $dstr$name$_u24__u24 = (DesignAssetSet)b;
                Comparable comparable = (Comparable)((Object)name);
                bl2 = false;
                String string = name = $dstr$name$_u24__u24.component1();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
            }
        };
        List list = CollectionsKt.sortedWith((Iterable)var4_5, (Comparator)comparator2);
        designAssetListModel.setAssets(list);
    }

    public final void importDesignAssetSet(@NotNull DesignAssetSet selectedValue) {
        Intrinsics.checkParameterIsNotNull((Object)selectedValue, (String)"selectedValue");
        Iterable $this$forEach$iv = selectedValue.getDesignAssets();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DesignAsset asset = (DesignAsset)element$iv;
            boolean bl = false;
            this.fileHelper.copyInProjectResources(asset, selectedValue.getName(), this.facet);
        }
    }

    @Override
    @NotNull
    public ListenableFuture<? extends Image> getPreview(@NotNull DesignAsset asset, @NotNull Dimension dimension2) {
        Intrinsics.checkParameterIsNotNull((Object)asset, (String)"asset");
        Intrinsics.checkParameterIsNotNull((Object)dimension2, (String)"dimension");
        String string = asset.getFile().getExtension();
        if (string == null) {
            ListenableFuture listenableFuture = Futures.immediateFuture(null);
            Intrinsics.checkExpressionValueIsNotNull((Object)listenableFuture, (String)"Futures.immediateFuture(null)");
            return listenableFuture;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"asset.file.extension ?: \u2026res.immediateFuture(null)");
        String extension = string;
        ListenableFuture<? extends Image> listenableFuture = (ListenableFuture<? extends Image>)CollectionsKt.firstOrNull(this.importersProvider.getImportersForExtension(extension));
        if (listenableFuture == null || (listenableFuture = listenableFuture.getSourcePreview(asset)) == null || (listenableFuture = listenableFuture.getImage(asset.getFile(), this.facet.getModule(), dimension2)) == null) {
            ListenableFuture listenableFuture2 = Futures.immediateFuture(null);
            listenableFuture = listenableFuture2;
            Intrinsics.checkExpressionValueIsNotNull((Object)listenableFuture2, (String)"Futures.immediateFuture(null)");
        }
        return listenableFuture;
    }

    @NotNull
    public final SynchronizationStatus getSynchronizationStatus(@NotNull DesignAssetSet assetSet) {
        Intrinsics.checkParameterIsNotNull((Object)assetSet, (String)"assetSet");
        return this.synchronizationManager.getSynchronizationStatus(assetSet);
    }

    @Override
    @NotNull
    public String getStatusLabel(@NotNull DesignAssetSet assetSet) {
        Intrinsics.checkParameterIsNotNull((Object)assetSet, (String)"assetSet");
        return this.getSynchronizationStatus(assetSet).name();
    }

    @NotNull
    public final AndroidFacet getFacet() {
        return this.facet;
    }

    public ExternalBrowserViewModel(@NotNull AndroidFacet facet, @NotNull ResourceFileHelper fileHelper, @NotNull ImportersProvider importersProvider, @NotNull SynchronizationManager synchronizationManager) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)facet), (String)"facet");
        Intrinsics.checkParameterIsNotNull((Object)fileHelper, (String)"fileHelper");
        Intrinsics.checkParameterIsNotNull((Object)importersProvider, (String)"importersProvider");
        Intrinsics.checkParameterIsNotNull((Object)synchronizationManager, (String)"synchronizationManager");
        this.facet = facet;
        this.fileHelper = fileHelper;
        this.importersProvider = importersProvider;
        this.synchronizationManager = synchronizationManager;
        this.designAssetListModel = new DesignAssetListModel();
        this._matcher = new QualifierMatcher(null, 1, null);
        this.synchronizationManager.addListener(new SynchronizationListener(){

            @Override
            public void resourceAdded(@NotNull VirtualFile file) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                this.getDesignAssetListModel().refresh();
            }

            @Override
            public void resourceRemoved(@NotNull VirtualFile file) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                this.getDesignAssetListModel().refresh();
            }
        });
    }
}

