/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resourceExplorer.view;

import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.concurrent.EdtExecutor;
import com.android.tools.idea.resourceExplorer.FutureUtilsKt;
import com.android.tools.idea.resourceExplorer.model.DesignAssetSet;
import com.android.tools.idea.resourceExplorer.view.DesignAssetCellRenderer;
import com.android.tools.idea.resourceExplorer.view.DesignAssetCellRendererKt;
import com.android.tools.idea.resourceExplorer.view.DrawableResourceCellRenderer;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0087\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b*\u0001 \u0018\u00002\u00020\u0001Br\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012@\u0010\u0004\u001a<\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\r0\f0\u0005\u0012!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\u000f\u00a2\u0006\u0002\u0010\u0013J#\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00120$H\u0002\u00a2\u0006\u0002\u0010%J \u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J2\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0018\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u00020\u0010H\u0002J \u00101\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u0010H\u0002J\u0018\u00102\u001a\u00020\r2\u0006\u00103\u001a\u00020\r2\u0006\u0010'\u001a\u00020\u0010H\u0002J\u0010\u00104\u001a\u00020-2\u0006\u00105\u001a\u00020\u0018H\u0002J&\u00106\u001a\u00020\u00122\f\u00107\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002RN\u0010\u0014\u001aB\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\r0\r \u0016* \u0012\f\u0012\n \u0016*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\r0\r\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000RH\u0010\u0004\u001a<\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\r0\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/android/tools/idea/resourceExplorer/view/DrawableResourceCellRenderer;", "Lcom/android/tools/idea/resourceExplorer/view/DesignAssetCellRenderer;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "imageProvider", "Lkotlin/Function2;", "Ljava/awt/Dimension;", "Lkotlin/ParameterName;", "name", "size", "Lcom/android/tools/idea/resourceExplorer/model/DesignAssetSet;", "designAssetSet", "Lcom/google/common/util/concurrent/ListenableFuture;", "Ljava/awt/Image;", "refreshListCallback", "Lkotlin/Function1;", "", "index", "", "(Lcom/intellij/openapi/Disposable;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)V", "assetToImage", "Lcom/google/common/cache/Cache;", "kotlin.jvm.PlatformType", "contentRatio", "", "drawablePreview", "Ljavax/swing/JLabel;", "imageIcon", "Ljavax/swing/ImageIcon;", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "createUpdate", "com/android/tools/idea/resourceExplorer/view/DrawableResourceCellRenderer$createUpdate$1", "identity", "", "runnable", "Lkotlin/Function0;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Lcom/android/tools/idea/resourceExplorer/view/DrawableResourceCellRenderer$createUpdate$1;", "fetchImage", "targetSize", "getContent", "Ljavax/swing/JComponent;", "width", "height", "isSelected", "", "getScale", "target", "source", "queueImageFetch", "scaleToFitIfNeeded", "image", "shouldScale", "scale", "useImage", "previewFuture", "intellij.android.core"})
public final class DrawableResourceCellRenderer
extends DesignAssetCellRenderer {
    private final ImageIcon imageIcon;
    private final double contentRatio = 0.2;
    private final Cache<DesignAssetSet, Image> assetToImage;
    private final MergingUpdateQueue updateQueue;
    private final JLabel drawablePreview;
    private final Function2<Dimension, DesignAssetSet, ListenableFuture<? extends Image>> imageProvider;
    private final Function1<Integer, Unit> refreshListCallback;

    @Override
    @Nullable
    public JComponent getContent(@NotNull DesignAssetSet designAssetSet, int width, int height, boolean isSelected, int index) {
        Intrinsics.checkParameterIsNotNull((Object)designAssetSet, (String)"designAssetSet");
        Image image = (Image)this.assetToImage.getIfPresent((Object)designAssetSet);
        int targetSize = (int)((double)height * (1.0 - this.contentRatio * (double)2));
        if (targetSize > 0) {
            if (image == null) {
                image = this.queueImageFetch(designAssetSet, index, targetSize);
            } else {
                int imageHeight = image.getHeight(null);
                double scale = this.getScale(targetSize, imageHeight);
                if (Intrinsics.areEqual((Object)image, (Object)DesignAssetCellRendererKt.access$getEMPTY_ICON$p()) ^ true && this.shouldScale(scale)) {
                    BufferedImage bufferedImage = ImageUtil.toBufferedImage((Image)image);
                    Intrinsics.checkExpressionValueIsNotNull((Object)bufferedImage, (String)"ImageUtil.toBufferedImage(image)");
                    BufferedImage bufferedImage2 = bufferedImage;
                    image = ImageUtils.lowQualityFastScale((BufferedImage)bufferedImage2, (double)scale, (double)scale);
                    this.queueImageFetch(designAssetSet, index, targetSize);
                }
            }
            this.imageIcon.setImage(image);
        }
        return this.drawablePreview;
    }

    private final boolean shouldScale(double scale) {
        double d = 1.0 - this.contentRatio;
        double d2 = 1.0 + this.contentRatio;
        double d3 = scale;
        return !(d3 >= d) || !(d3 <= d2);
    }

    private final double getScale(int target, int source) {
        return (double)Math.round((double)(target * 100) / (double)source) / 100.0;
    }

    private final Image queueImageFetch(DesignAssetSet designAssetSet, int index, int targetSize) {
        this.updateQueue.queue((Update)this.createUpdate(index, (Function0<Unit>)((Function0)new Function0<Unit>(this, targetSize, designAssetSet, index){
            final /* synthetic */ DrawableResourceCellRenderer this$0;
            final /* synthetic */ int $targetSize;
            final /* synthetic */ DesignAssetSet $designAssetSet;
            final /* synthetic */ int $index;

            public final void invoke() {
                DrawableResourceCellRenderer.access$fetchImage(this.this$0, this.$targetSize, this.$designAssetSet, this.$index);
            }
            {
                this.this$0 = drawableResourceCellRenderer;
                this.$targetSize = n;
                this.$designAssetSet = designAssetSet;
                this.$index = n2;
                super(0);
            }
        })));
        return DesignAssetCellRendererKt.access$getEMPTY_ICON$p();
    }

    private final createUpdate.1 createUpdate(Object identity, Function0<Unit> runnable) {
        return new Update(runnable, identity, identity){
            final /* synthetic */ Function0 $runnable;
            final /* synthetic */ Object $identity;

            public boolean canEat(@Nullable Update update2) {
                return Intrinsics.areEqual((Object)((Object)this), (Object)update2);
            }

            public void run() {
                this.$runnable.invoke();
            }
            {
                this.$runnable = $captured_local_variable$0;
                this.$identity = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
    }

    private final void fetchImage(int targetSize, DesignAssetSet designAssetSet, int index) {
        JBDimension jBDimension = JBUI.size((int)targetSize);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBDimension, (String)"JBUI.size(targetSize)");
        ListenableFuture listenableFuture = (ListenableFuture)this.imageProvider.invoke((Object)jBDimension, (Object)designAssetSet);
        ExecutorService executorService = PooledThreadExecutor.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"PooledThreadExecutor.INSTANCE");
        ListenableFuture previewFuture2 = FutureUtilsKt.transform(listenableFuture, executorService, (Function1)new Function1<Image, Image>(this, targetSize){
            final /* synthetic */ DrawableResourceCellRenderer this$0;
            final /* synthetic */ int $targetSize;

            @NotNull
            public final Image invoke(@Nullable Image image) {
                if (image == null) {
                    return DesignAssetCellRendererKt.access$getEMPTY_ICON$p();
                }
                return DrawableResourceCellRenderer.access$scaleToFitIfNeeded(this.this$0, image, this.$targetSize);
            }
            {
                this.this$0 = drawableResourceCellRenderer;
                this.$targetSize = n;
                super(1);
            }
        });
        previewFuture2.addListener(new Runnable(this, previewFuture2, designAssetSet, index){
            final /* synthetic */ DrawableResourceCellRenderer this$0;
            final /* synthetic */ ListenableFuture $previewFuture;
            final /* synthetic */ DesignAssetSet $designAssetSet;
            final /* synthetic */ int $index;

            public final void run() {
                DrawableResourceCellRenderer.access$useImage(this.this$0, this.$previewFuture, this.$designAssetSet, this.$index);
            }
            {
                this.this$0 = drawableResourceCellRenderer;
                this.$previewFuture = listenableFuture;
                this.$designAssetSet = designAssetSet;
                this.$index = n;
            }
        }, (Executor)EdtExecutor.INSTANCE);
    }

    private final void useImage(ListenableFuture<Image> previewFuture2, DesignAssetSet designAssetSet, int index) {
        Image image;
        try {
            image = previewFuture2.isCancelled() ? (Image)DesignAssetCellRendererKt.access$getEMPTY_ICON$p() : (Image)previewFuture2.get();
        }
        catch (Exception e) {
            DesignAssetCellRendererKt.access$getLOG$p().error(designAssetSet.getName() + " couldn't be rendered", (Throwable)e);
            image = DesignAssetCellRendererKt.access$getEMPTY_ICON$p();
        }
        Image finalImage = image;
        this.assetToImage.put((Object)designAssetSet, (Object)finalImage);
        this.refreshListCallback.invoke((Object)index);
    }

    private final Image scaleToFitIfNeeded(Image image, int targetSize) {
        int imageHeight = image.getHeight(null);
        double scale = this.getScale(targetSize, imageHeight);
        if (this.shouldScale(scale)) {
            int newWidth = (int)((double)image.getWidth(null) * scale);
            int newHeight = (int)((double)imageHeight * scale);
            if (newWidth > 0 && newHeight > 0) {
                Image image2 = ImageUtil.toBufferedImage((Image)image).getScaledInstance(newWidth, newHeight, 4);
                Intrinsics.checkExpressionValueIsNotNull((Object)image2, (String)"ImageUtil.toBufferedImag\u2026fferedImage.SCALE_SMOOTH)");
                return image2;
            }
        }
        return image;
    }

    public DrawableResourceCellRenderer(@NotNull Disposable parentDisposable, @NotNull Function2<? super Dimension, ? super DesignAssetSet, ? extends ListenableFuture<? extends Image>> imageProvider, @NotNull Function1<? super Integer, Unit> refreshListCallback) {
        JLabel jLabel;
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkParameterIsNotNull(imageProvider, (String)"imageProvider");
        Intrinsics.checkParameterIsNotNull(refreshListCallback, (String)"refreshListCallback");
        this.imageProvider = imageProvider;
        this.refreshListCallback = refreshListCallback;
        this.imageIcon = new ImageIcon(DesignAssetCellRendererKt.access$getEMPTY_ICON$p());
        this.contentRatio = 0.2;
        this.assetToImage = CacheBuilder.newBuilder().softValues().maximumSize(200L).build();
        this.updateQueue = new MergingUpdateQueue("DrawableResourceCellRenderer", 1000, true, null, parentDisposable, null, false);
        JLabel jLabel2 = new JLabel(this.imageIcon);
        DrawableResourceCellRenderer drawableResourceCellRenderer = this;
        boolean bl = false;
        boolean bl2 = false;
        JLabel $this$apply = jLabel2;
        boolean bl3 = false;
        $this$apply.setBorder(JBUI.Borders.empty((int)18));
        drawableResourceCellRenderer.drawablePreview = jLabel = jLabel2;
    }

    public static final /* synthetic */ void access$fetchImage(DrawableResourceCellRenderer $this, int targetSize, DesignAssetSet designAssetSet, int index) {
        $this.fetchImage(targetSize, designAssetSet, index);
    }

    public static final /* synthetic */ Image access$scaleToFitIfNeeded(DrawableResourceCellRenderer $this, Image image, int targetSize) {
        return $this.scaleToFitIfNeeded(image, targetSize);
    }

    public static final /* synthetic */ void access$useImage(DrawableResourceCellRenderer $this, ListenableFuture previewFuture2, DesignAssetSet designAssetSet, int index) {
        $this.useImage((ListenableFuture<Image>)previewFuture2, designAssetSet, index);
    }
}

