/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resourceExplorer.sketchImporter.ui;

import com.android.tools.idea.resourceExplorer.sketchImporter.converter.SketchLibrary;
import com.android.tools.idea.resourceExplorer.sketchImporter.parser.document.SketchDocument;
import com.android.tools.idea.resourceExplorer.sketchImporter.parser.document.SketchForeignStyle;
import com.android.tools.idea.resourceExplorer.sketchImporter.parser.document.SketchForeignSymbol;
import com.android.tools.idea.resourceExplorer.sketchImporter.parser.document.SketchSharedStyle;
import com.android.tools.idea.resourceExplorer.sketchImporter.parser.document.SketchSharedSymbol;
import com.android.tools.idea.resourceExplorer.sketchImporter.parser.interfaces.SketchLayer;
import com.android.tools.idea.resourceExplorer.sketchImporter.parser.interfaces.SketchLayerable;
import com.android.tools.idea.resourceExplorer.sketchImporter.parser.interfaces.SketchSymbol;
import com.android.tools.idea.resourceExplorer.sketchImporter.parser.meta.SketchMeta;
import com.android.tools.idea.resourceExplorer.sketchImporter.parser.pages.SketchPage;
import com.android.tools.idea.resourceExplorer.sketchImporter.parser.pages.SketchStyle;
import com.android.tools.idea.resourceExplorer.sketchImporter.parser.pages.SketchSymbolMaster;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SketchFile {
    private SketchDocument myDocument;
    private SketchMeta myMeta;
    private List<SketchPage> myPages = new ArrayList<SketchPage>();
    private SketchLibrary myLibrary = new SketchLibrary();

    public void addPage(@NotNull SketchPage page) {
        if (page == null) {
            SketchFile.$$$reportNull$$$0(0);
        }
        this.myPages.add(page);
        this.myLibrary.addSymbols(SketchFile.getAllSymbolMasters(page));
    }

    @NotNull
    private static ImmutableList<SketchStyle> getAllStyles(@NotNull SketchDocument document) {
        SketchSharedStyle[] sharedStyles;
        if (document == null) {
            SketchFile.$$$reportNull$$$0(1);
        }
        ImmutableList.Builder styles2 = new ImmutableList.Builder();
        SketchForeignStyle[] foreignStyles = document.getForeignLayerStyles();
        if (foreignStyles != null) {
            for (SketchForeignStyle sketchForeignStyle : foreignStyles) {
            }
        }
        if ((sharedStyles = document.getLayerStyles()) != null) {
            for (SketchSharedStyle sharedStyle : sharedStyles) {
                styles2.add((Object)sharedStyle.getValue());
            }
        }
        ImmutableList immutableList = styles2.build();
        if (immutableList == null) {
            SketchFile.$$$reportNull$$$0(2);
        }
        return immutableList;
    }

    @NotNull
    private static ImmutableList<SketchSymbolMaster> getAllSymbolMasters(@NotNull SketchDocument document) {
        SketchSharedSymbol[] sharedSymbols;
        if (document == null) {
            SketchFile.$$$reportNull$$$0(3);
        }
        ImmutableList.Builder masters = new ImmutableList.Builder();
        SketchForeignSymbol[] foreignSymbols = document.getForeignSymbols();
        if (foreignSymbols != null) {
            for (SketchForeignSymbol foreignSymbol : foreignSymbols) {
                masters.add((Object)foreignSymbol.getSymbolMaster());
            }
        }
        if ((sharedSymbols = document.getLayerSymbols()) != null) {
            for (SketchSharedSymbol sketchSharedSymbol : sharedSymbols) {
            }
        }
        ImmutableList immutableList = masters.build();
        if (immutableList == null) {
            SketchFile.$$$reportNull$$$0(4);
        }
        return immutableList;
    }

    @NotNull
    private static ImmutableList<SketchSymbolMaster> getAllSymbolMasters(@NotNull SketchPage page) {
        if (page == null) {
            SketchFile.$$$reportNull$$$0(5);
        }
        ImmutableList.Builder masters = new ImmutableList.Builder();
        for (SketchLayer layer : page.getLayers()) {
            masters.addAll(SketchFile.getSymbolMasters(layer));
        }
        ImmutableList immutableList = masters.build();
        if (immutableList == null) {
            SketchFile.$$$reportNull$$$0(6);
        }
        return immutableList;
    }

    @NotNull
    private static ImmutableList<SketchSymbolMaster> getSymbolMasters(@NotNull SketchLayer layer) {
        if (layer == null) {
            SketchFile.$$$reportNull$$$0(7);
        }
        ImmutableList.Builder masters = new ImmutableList.Builder();
        if (layer instanceof SketchLayerable) {
            if (layer instanceof SketchSymbolMaster) {
                masters.add((Object)((SketchSymbolMaster)layer));
            }
            for (SketchLayer subLayer : ((SketchLayerable)((Object)layer)).getLayers()) {
                masters.addAll(SketchFile.getSymbolMasters(subLayer));
            }
        }
        ImmutableList immutableList = masters.build();
        if (immutableList == null) {
            SketchFile.$$$reportNull$$$0(8);
        }
        return immutableList;
    }

    @NotNull
    public List<SketchPage> getPages() {
        List<SketchPage> list = this.myPages;
        if (list == null) {
            SketchFile.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public SketchDocument getDocument() {
        SketchDocument sketchDocument = this.myDocument;
        if (sketchDocument == null) {
            SketchFile.$$$reportNull$$$0(10);
        }
        return sketchDocument;
    }

    public void setDocument(@NotNull SketchDocument document) {
        if (document == null) {
            SketchFile.$$$reportNull$$$0(11);
        }
        this.myDocument = document;
        this.myLibrary.addSymbols(SketchFile.getAllSymbolMasters(document));
        this.myLibrary.addStyles(SketchFile.getAllStyles(document));
    }

    @NotNull
    public SketchMeta getMeta() {
        SketchMeta sketchMeta = this.myMeta;
        if (sketchMeta == null) {
            SketchFile.$$$reportNull$$$0(12);
        }
        return sketchMeta;
    }

    public void setMeta(@NotNull SketchMeta meta) {
        if (meta == null) {
            SketchFile.$$$reportNull$$$0(13);
        }
        this.myMeta = meta;
    }

    @Nullable
    public SketchLayer findLayer(@NotNull String objectId) {
        if (objectId == null) {
            SketchFile.$$$reportNull$$$0(14);
        }
        for (SketchPage page : this.myPages) {
            SketchLayer foundLayer = SketchFile.findLayer(objectId, page);
            if (foundLayer == null) continue;
            return foundLayer;
        }
        return null;
    }

    @Nullable
    public SketchSymbol findSymbol(@NotNull String symbolId) {
        if (symbolId == null) {
            SketchFile.$$$reportNull$$$0(15);
        }
        for (SketchPage page : this.myPages) {
            SketchSymbol foundSymbol = SketchFile.findSymbol(symbolId, page);
            if (foundSymbol == null) continue;
            return foundSymbol;
        }
        return null;
    }

    @NotNull
    public SketchLibrary getLibrary() {
        SketchLibrary sketchLibrary = this.myLibrary;
        if (sketchLibrary == null) {
            SketchFile.$$$reportNull$$$0(16);
        }
        return sketchLibrary;
    }

    @Nullable
    private static SketchLayer findLayer(@NotNull String objectId, @NotNull SketchLayer currentLayer) {
        if (objectId == null) {
            SketchFile.$$$reportNull$$$0(17);
        }
        if (currentLayer == null) {
            SketchFile.$$$reportNull$$$0(18);
        }
        if (currentLayer.getObjectId().equals(objectId)) {
            return currentLayer;
        }
        if (currentLayer instanceof SketchLayerable) {
            for (SketchLayer layer : ((SketchLayerable)((Object)currentLayer)).getLayers()) {
                SketchLayer foundLayer = SketchFile.findLayer(objectId, layer);
                if (foundLayer == null) continue;
                return foundLayer;
            }
        }
        return null;
    }

    @Nullable
    private static SketchSymbol findSymbol(@NotNull String symbolId, @NotNull SketchLayer currentLayer) {
        if (symbolId == null) {
            SketchFile.$$$reportNull$$$0(19);
        }
        if (currentLayer == null) {
            SketchFile.$$$reportNull$$$0(20);
        }
        if (currentLayer instanceof SketchSymbol && ((SketchSymbol)currentLayer).getSymbolId().equals(symbolId)) {
            return (SketchSymbol)currentLayer;
        }
        if (currentLayer instanceof SketchLayerable) {
            for (SketchLayer layer : ((SketchLayerable)((Object)currentLayer)).getLayers()) {
                SketchSymbol foundSymbol = SketchFile.findSymbol(symbolId, layer);
                if (foundSymbol == null) continue;
                return foundSymbol;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "page";
                break;
            }
            case 1: 
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/resourceExplorer/sketchImporter/ui/SketchFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectId";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolId";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentLayer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/resourceExplorer/sketchImporter/ui/SketchFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllStyles";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSymbolMasters";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbolMasters";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPages";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMeta";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibrary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addPage";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAllStyles";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 16: {
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllSymbolMasters";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolMasters";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setDocument";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setMeta";
                break;
            }
            case 14: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findLayer";
                break;
            }
            case 15: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findSymbol";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

