/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resourceExplorer.sketchImporter.ui;

import com.android.tools.idea.resourceExplorer.model.DesignAsset;
import com.android.tools.idea.resourceExplorer.model.DesignAssetSet;
import com.android.tools.idea.resourceExplorer.plugin.DesignAssetRendererManager;
import com.android.tools.idea.resourceExplorer.sketchImporter.converter.builders.DrawableFileGenerator;
import com.android.tools.idea.resourceExplorer.sketchImporter.converter.models.AssetModel;
import com.android.tools.idea.resourceExplorer.sketchImporter.converter.models.ColorAssetModel;
import com.android.tools.idea.resourceExplorer.sketchImporter.converter.models.DrawableAssetModel;
import com.android.tools.idea.resourceExplorer.sketchImporter.converter.models.StudioResourcesModel;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u001b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J*\u0010\"\u001a$\u0012 \u0012\u001e\u0012\f\u0012\n &*\u0004\u0018\u00010%0%\u0012\f\u0012\n &*\u0004\u0018\u00010'0'0$0#H\u0004J\u0014\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0004J\u0010\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u000bJ\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000b0#J\b\u0010-\u001a\u00020.H&R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00020\u0018X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006/"}, d2={"Lcom/android/tools/idea/resourceExplorer/sketchImporter/ui/ResourcesPresenter;", "", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "(Lorg/jetbrains/android/facet/AndroidFacet;)V", "drawableFileGenerator", "Lcom/android/tools/idea/resourceExplorer/sketchImporter/converter/builders/DrawableFileGenerator;", "getFacet", "()Lorg/jetbrains/android/facet/AndroidFacet;", "filesToAssets", "", "Lcom/intellij/testFramework/LightVirtualFile;", "Lcom/android/tools/idea/resourceExplorer/sketchImporter/converter/models/DrawableAssetModel;", "getFilesToAssets", "()Ljava/util/Map;", "importAll", "", "getImportAll", "()Z", "setImportAll", "(Z)V", "rendererManager", "Lcom/android/tools/idea/resourceExplorer/plugin/DesignAssetRendererManager;", "resources", "Lcom/android/tools/idea/resourceExplorer/sketchImporter/converter/models/StudioResourcesModel;", "getResources", "()Lcom/android/tools/idea/resourceExplorer/sketchImporter/converter/models/StudioResourcesModel;", "fetchImage", "Lcom/google/common/util/concurrent/ListenableFuture;", "Ljava/awt/Image;", "dimension", "Ljava/awt/Dimension;", "designAssetSet", "Lcom/android/tools/idea/resourceExplorer/model/DesignAssetSet;", "generateColorsList", "", "Lkotlin/Pair;", "Ljava/awt/Color;", "kotlin.jvm.PlatformType", "", "generateDrawableFiles", "getAsset", "Lcom/android/tools/idea/resourceExplorer/sketchImporter/converter/models/AssetModel;", "file", "getExportableFiles", "populateView", "", "intellij.android.core"})
public abstract class ResourcesPresenter {
    private boolean importAll;
    private final DrawableFileGenerator drawableFileGenerator;
    private final DesignAssetRendererManager rendererManager;
    @NotNull
    private final AndroidFacet facet;

    public final boolean getImportAll() {
        return this.importAll;
    }

    public final void setImportAll(boolean bl) {
        this.importAll = bl;
    }

    @NotNull
    protected abstract StudioResourcesModel getResources();

    @NotNull
    protected abstract Map<LightVirtualFile, DrawableAssetModel> getFilesToAssets();

    @NotNull
    public final ListenableFuture<? extends Image> fetchImage(@NotNull Dimension dimension2, @NotNull DesignAssetSet designAssetSet) {
        Intrinsics.checkParameterIsNotNull((Object)dimension2, (String)"dimension");
        Intrinsics.checkParameterIsNotNull((Object)designAssetSet, (String)"designAssetSet");
        VirtualFile file = ((DesignAsset)CollectionsKt.first(designAssetSet.getDesignAssets())).getFile();
        return this.rendererManager.getViewer(file).getImage(file, this.facet.getModule(), dimension2);
    }

    public abstract void populateView();

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Map<LightVirtualFile, DrawableAssetModel> generateDrawableFiles() {
        Map map2;
        ImmutableList<DrawableAssetModel> immutableList = this.getResources().getDrawableAssets();
        if (immutableList != null) {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = (Iterable)immutableList;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map3 = destination$iv$iv;
                DrawableAssetModel it = (DrawableAssetModel)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)this.drawableFileGenerator.generateDrawableFile(it), (Object)it);
                boolean bl2 = false;
                map3.put(pair.getFirst(), pair.getSecond());
            }
            map2 = destination$iv$iv;
        } else {
            map2 = MapsKt.emptyMap();
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LightVirtualFile> getExportableFiles() {
        List list;
        Set<LightVirtualFile> files2 = this.getFilesToAssets().keySet();
        if (this.importAll) {
            list = CollectionsKt.toList((Iterable)files2);
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = files2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                LightVirtualFile it = (LightVirtualFile)element$iv$iv;
                boolean bl = false;
                DrawableAssetModel drawableAssetModel = this.getFilesToAssets().get(it);
                if (!(drawableAssetModel != null ? drawableAssetModel.isExportable() : false)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<Pair<Color, String>> generateColorsList() {
        List list;
        ImmutableList<ColorAssetModel> immutableList = this.getResources().getColorAssets();
        if (immutableList != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)immutableList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ColorAssetModel colorAssetModel = (ColorAssetModel)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v1 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                Pair pair = TuplesKt.to((Object)v1.getColor(), (Object)it.getName());
                collection.add(pair);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public final AssetModel getAsset(@NotNull LightVirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.getFilesToAssets().get(file);
    }

    @NotNull
    protected final AndroidFacet getFacet() {
        return this.facet;
    }

    public ResourcesPresenter(@NotNull AndroidFacet facet) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)facet), (String)"facet");
        this.facet = facet;
        this.importAll = true;
        Module module = this.facet.getModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"facet.module");
        this.drawableFileGenerator = new DrawableFileGenerator(module.getProject());
        this.rendererManager = DesignAssetRendererManager.Companion.getInstance();
    }
}

