/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resourceExplorer.sketchImporter.parser;

import com.android.tools.idea.resourceExplorer.sketchImporter.converter.models.ResizingConstraint;
import com.android.tools.idea.resourceExplorer.sketchImporter.parser.deserializers.ColorDeserializer;
import com.android.tools.idea.resourceExplorer.sketchImporter.parser.deserializers.ConstraintDeserializer;
import com.android.tools.idea.resourceExplorer.sketchImporter.parser.deserializers.PointDeserializer;
import com.android.tools.idea.resourceExplorer.sketchImporter.parser.deserializers.SketchDocumentDeserializer;
import com.android.tools.idea.resourceExplorer.sketchImporter.parser.deserializers.SketchLayerDeserializer;
import com.android.tools.idea.resourceExplorer.sketchImporter.parser.deserializers.SketchMetaDeserializer;
import com.android.tools.idea.resourceExplorer.sketchImporter.parser.document.SketchDocument;
import com.android.tools.idea.resourceExplorer.sketchImporter.parser.interfaces.SketchLayer;
import com.android.tools.idea.resourceExplorer.sketchImporter.parser.meta.SketchMeta;
import com.android.tools.idea.resourceExplorer.sketchImporter.parser.pages.SketchPage;
import com.android.tools.idea.resourceExplorer.sketchImporter.parser.pages.SketchPoint2D;
import com.android.tools.idea.resourceExplorer.sketchImporter.ui.SketchFile;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SketchParser {
    private static final Logger LOG = Logger.getInstance(SketchParser.class);
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(SketchDocument.class, (Object)new SketchDocumentDeserializer()).registerTypeAdapter(SketchMeta.class, (Object)new SketchMetaDeserializer()).registerTypeAdapter(SketchLayer.class, (Object)new SketchLayerDeserializer()).registerTypeAdapter(Color.class, (Object)new ColorDeserializer()).registerTypeAdapter(SketchPoint2D.class, (Object)new PointDeserializer()).registerTypeAdapter(ResizingConstraint.class, (Object)new ConstraintDeserializer()).create();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static SketchFile read(@NotNull String path) {
        if (path == null) {
            SketchParser.$$$reportNull$$$0(0);
        }
        try (ZipFile zip = new ZipFile(path);){
            SketchFile sketchFile2 = new SketchFile();
            Enumeration<? extends ZipEntry> e = zip.entries();
            block21: while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                String entryName = entry.getName();
                if (!FilenameUtils.getExtension((String)entryName).equals("json")) continue;
                switch (entryName) {
                    case "document.json": {
                        SketchDocument document = (SketchDocument)SketchParser.parseJson(zip.getInputStream(entry), SketchDocument.class);
                        if (document == null) continue block21;
                        sketchFile2.setDocument(document);
                        continue block21;
                    }
                    case "meta.json": {
                        SketchMeta meta = (SketchMeta)SketchParser.parseJson(zip.getInputStream(entry), SketchMeta.class);
                        if (meta == null) continue block21;
                        sketchFile2.setMeta(meta);
                        continue block21;
                    }
                    case "user.json": {
                        continue block21;
                    }
                }
                SketchPage page = (SketchPage)SketchParser.parseJson(zip.getInputStream(entry), SketchPage.class);
                if (page == null) continue;
                sketchFile2.addPage(page);
            }
            SketchFile sketchFile = sketchFile2;
            return sketchFile;
        }
        catch (Exception e) {
            LOG.warn("Failed to read from sketch file: " + path + ".", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static <T> T parseJson(@NotNull InputStream in, @NotNull Type typeOfT) {
        if (in == null) {
            SketchParser.$$$reportNull$$$0(1);
        }
        if (typeOfT == null) {
            SketchParser.$$$reportNull$$$0(2);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            Object object = gson.fromJson((Reader)reader, typeOfT);
            return (T)object;
        }
        catch (Exception e) {
            LOG.warn("Could not read JSON from input stream.", (Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeOfT";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/resourceExplorer/sketchImporter/parser/SketchParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "parseJson";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

