/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resourceExplorer.sketchImporter.converter.builders;

import java.text.DecimalFormat;
import org.jetbrains.annotations.NotNull;

public class PathStringBuilder {
    private static final char MOVE_CURSOR_COMMAND_ABSOLUTE = 'M';
    private static final char LINE_COMMAND_ABSOLUTE = 'L';
    private static final char BEZIER_CURVE_COMMAND_ABSOLUTE = 'C';
    private static final char QUADRATIC_CURVE_COMMAND_ABSOLUTE = 'Q';
    private static final char CLOSE_PATH_COMMAND = 'z';
    private static final String COORDINATES_PRECISION = "#.##";
    @NotNull
    private StringBuilder stringBuilder = new StringBuilder();

    @NotNull
    public String build() {
        String string = this.stringBuilder.toString();
        if (string == null) {
            PathStringBuilder.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void createBezierCurve(@NotNull double[] coordinates) {
        if (coordinates == null) {
            PathStringBuilder.$$$reportNull$$$0(1);
        }
        this.appendCommand('C');
        this.appendPointCoordinates(coordinates[0], coordinates[1]);
        this.appendPointCoordinates(coordinates[2], coordinates[3]);
        this.appendPointCoordinates(coordinates[4], coordinates[5]);
    }

    public void createQuadCurve(double controlPointX, double controlPointY, double endPointX, double endPointY) {
        this.appendCommand('Q');
        this.appendPointCoordinates(controlPointX, controlPointY);
        this.appendPointCoordinates(endPointX, endPointY);
    }

    public void createLine(double x, double y) {
        this.appendCommand('L');
        this.appendPointCoordinates(x, y);
    }

    public void startPath(double x, double y) {
        this.appendCommand('M');
        this.appendPointCoordinates(x, y);
    }

    public void endPath() {
        this.appendCommand('z');
    }

    private void appendCommand(char command) {
        this.stringBuilder.append(command);
    }

    private void appendPointCoordinates(double x, double y) {
        this.stringBuilder.append(PathStringBuilder.trimDoubles(x)).append(",").append(PathStringBuilder.trimDoubles(y)).append(" ");
    }

    @NotNull
    private static String trimDoubles(double number) {
        DecimalFormat df = new DecimalFormat(COORDINATES_PRECISION);
        String string = df.format(number);
        if (string == null) {
            PathStringBuilder.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/resourceExplorer/sketchImporter/converter/builders/PathStringBuilder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coordinates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/resourceExplorer/sketchImporter/converter/builders/PathStringBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "trimDoubles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createBezierCurve";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

