/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resourceExplorer.plugin;

import com.android.tools.idea.resourceExplorer.importer.DesignAssetImporter;
import com.android.tools.idea.resourceExplorer.model.DesignAsset;
import com.android.tools.idea.resourceExplorer.plugin.ConfigurationDoneCallback;
import com.android.tools.idea.resourceExplorer.plugin.DesignAssetRenderer;
import com.android.tools.idea.resourceExplorer.plugin.DesignAssetRendererManager;
import com.android.tools.idea.resourceExplorer.plugin.ResourceImporter;
import com.android.tools.idea.resourceExplorer.plugin.SVGAssetRenderer;
import com.android.tools.idea.resourceExplorer.plugin.SketchImporterKt;
import com.android.tools.idea.resourceExplorer.sketchImporter.parser.SketchParser;
import com.android.tools.idea.resourceExplorer.sketchImporter.ui.SketchImporterPresenter;
import com.android.tools.idea.resourceExplorer.sketchImporter.ui.SketchImporterView;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J'\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0016\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/resourceExplorer/plugin/SketchImporter;", "Lcom/android/tools/idea/resourceExplorer/plugin/ResourceImporter;", "()V", "getConfigurationPanel", "Ljavax/swing/JPanel;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "callback", "Lcom/android/tools/idea/resourceExplorer/plugin/ConfigurationDoneCallback;", "getFilePath", "", "project", "Lcom/intellij/openapi/project/Project;", "getImportPreview", "Lcom/android/tools/idea/resourceExplorer/plugin/DesignAssetRenderer;", "asset", "Lcom/android/tools/idea/resourceExplorer/model/DesignAsset;", "getPresentableName", "getSourcePreview", "getSupportedFileTypes", "", "showImportDialog", "", "view", "Lcom/android/tools/idea/resourceExplorer/sketchImporter/ui/SketchImporterView;", "showInvalidSketchFileNotification", "path", "version", "", "(Ljava/lang/String;Ljava/lang/Double;Lcom/intellij/openapi/project/Project;)V", "userCanEditQualifiers", "", "intellij.android.core"})
public final class SketchImporter
implements ResourceImporter {
    @Override
    @NotNull
    public String getPresentableName() {
        return "Sketch Importer";
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public JPanel getConfigurationPanel(@NotNull AndroidFacet facet, @NotNull ConfigurationDoneCallback callback) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)facet, (String)"facet");
            Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
            v0 = facet.getModule();
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"facet.module");
            v1 = v0.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"facet.module.project");
            sketchFilePath = this.getFilePath(v1);
            if (sketchFilePath == null) break block2;
            sketchFile = SketchParser.read(sketchFilePath);
            if (sketchFile == null) ** GOTO lbl-1000
            v2 = sketchFile.getMeta();
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"sketchFile.meta");
            if (v2.getAppVersion() < 50.0) lbl-1000:
            // 2 sources

            {
                v3 = (v4 = sketchFile) != null && (v4 = v4.getMeta()) != null ? Double.valueOf(v4.getAppVersion()) : null;
                v5 = facet.getModule();
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"facet.module");
                v6 = v5.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"facet.module.project");
                this.showInvalidSketchFileNotification(sketchFilePath, v3, v6);
            } else {
                view = new SketchImporterView();
                view.setPresenter(new SketchImporterPresenter(view, sketchFile, new DesignAssetImporter(), facet));
                v7 = facet.getModule();
                Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"facet.module");
                v8 = v7.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"facet.module.project");
                this.showImportDialog(v8, view);
            }
        }
        callback.configurationDone();
        return null;
    }

    private final void showImportDialog(Project project, SketchImporterView view) {
        DialogBuilder dialogBuilder = new DialogBuilder(project);
        boolean bl = false;
        boolean bl2 = false;
        DialogBuilder $this$apply = dialogBuilder;
        boolean bl3 = false;
        $this$apply.setCenterPanel((JComponent)view);
        $this$apply.addDisposable((Disposable)view);
        $this$apply.setOkOperation(new Runnable($this$apply, view){
            final /* synthetic */ DialogBuilder $this_apply;
            final /* synthetic */ SketchImporterView $view$inlined;
            {
                this.$this_apply = dialogBuilder;
                this.$view$inlined = sketchImporterView;
            }

            public final void run() {
                this.$view$inlined.getPresenter().importFilesIntoProject();
                this.$this_apply.getDialogWrapper().close(0);
            }
        });
        $this$apply.setTitle("Choose the assets you would like to import");
        dialogBuilder.showModal(true);
    }

    @Override
    public boolean userCanEditQualifiers() {
        return true;
    }

    @Override
    @NotNull
    public Set<String> getSupportedFileTypes() {
        return SketchImporterKt.access$getSupportedFileTypes$p();
    }

    @Override
    @Nullable
    public DesignAssetRenderer getSourcePreview(@NotNull DesignAsset asset) {
        Intrinsics.checkParameterIsNotNull((Object)asset, (String)"asset");
        return DesignAssetRendererManager.Companion.getInstance().getViewer(SVGAssetRenderer.class);
    }

    @Override
    @Nullable
    public DesignAssetRenderer getImportPreview(@NotNull DesignAsset asset) {
        Intrinsics.checkParameterIsNotNull((Object)asset, (String)"asset");
        return this.getSourcePreview(asset);
    }

    private final String getFilePath(Project project) {
        VirtualFile[] files2;
        FileChooserDescriptor fileDescriptor = FileChooserDescriptorFactory.createSingleFileDescriptor((String)((String)CollectionsKt.first((Iterable)SketchImporterKt.access$getSupportedFileTypes$p())));
        VirtualFile[] virtualFileArray = FileChooser.chooseFiles((FileChooserDescriptor)fileDescriptor, (Project)project, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"FileChooser.chooseFiles(\u2026escriptor, project, null)");
        VirtualFile[] virtualFileArray2 = files2 = virtualFileArray;
        boolean bl = false;
        if (virtualFileArray2.length == 0) {
            return null;
        }
        VirtualFile virtualFile = files2[0];
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"files[0]");
        return FileUtil.toSystemDependentName((String)virtualFile.getPath());
    }

    private final void showInvalidSketchFileNotification(String path, Double version2, Project project) {
        String fileName = FilenameUtils.getName((String)path);
        String generalInfo = "Please make sure you use Sketch 50.0 or higher to save your sketch file.";
        String versionInfo = version2 == null ? fileName + " seems to not be a valid Sketch file or has been saved with a version of Sketch older than 43.0." : fileName + " seems to have been saved using Sketch " + version2 + '.';
        String notificationContent = generalInfo + "<br/>" + versionInfo;
        String notificationTitle = "Invalid sketch file";
        new Notification("Invalid Sketch file", null, notificationTitle, fileName, notificationContent, NotificationType.ERROR, null).notify(project);
    }

    @Override
    public boolean supportsBatchImport() {
        return ResourceImporter.DefaultImpls.supportsBatchImport(this);
    }

    @Override
    @NotNull
    public List<DesignAsset> processFiles(@NotNull List<? extends File> files2) {
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        return ResourceImporter.DefaultImpls.processFiles(this, files2);
    }
}

