/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resourceExplorer;

import com.android.resources.ResourceUrl;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.resourceExplorer.view.ResourceDragHandlerKt;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.PasteAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Producer;
import java.awt.datatransfer.Transferable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\"\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/resourceExplorer/ResourcePasteProvider;", "Lcom/intellij/ide/PasteProvider;", "()V", "findNearestXmlTag", "Lcom/intellij/psi/xml/XmlTag;", "psiElement", "Lcom/intellij/psi/PsiElement;", "getResourceUrl", "Lcom/android/resources/ResourceUrl;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isPasteEnabled", "", "isPastePossible", "pasteAtCaret", "", "caret", "Lcom/intellij/openapi/editor/Caret;", "resourceReference", "", "performForImageView", "xmlTag", "performForXml", "performPaste", "intellij.android.core"})
public final class ResourcePasteProvider
implements PasteProvider {
    public void performPaste(@NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        Object object = CommonDataKeys.CARET.getData(dataContext);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"CommonDataKeys.CARET.getData(dataContext)!!");
        Caret caret = (Caret)object;
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"CommonDataKeys.PSI_FILE.\u2026ta(dataContext) ?: return");
        PsiFile psiFile2 = psiFile;
        boolean $i$f$runReadAction = false;
        PsiElement psiElement = (PsiElement)ApplicationManager.getApplication().runReadAction(new Computable<T>(psiFile2, caret){
            final /* synthetic */ PsiFile $psiFile$inlined;
            final /* synthetic */ Caret $caret$inlined;
            {
                this.$psiFile$inlined = psiFile;
                this.$caret$inlined = caret;
            }

            public final T compute() {
                boolean bl = false;
                return (T)this.$psiFile$inlined.findElementAt(this.$caret$inlined.getOffset());
            }
        });
        FileType fileType = psiFile2.getFileType();
        if (Intrinsics.areEqual((Object)fileType, (Object)XmlFileType.INSTANCE)) {
            this.performForXml(psiElement, dataContext, caret);
        }
    }

    private final void performForXml(PsiElement psiElement, DataContext dataContext, Caret caret) {
        if (psiElement instanceof XmlElement) {
            Object object = this.getResourceUrl(dataContext);
            if (object == null || (object = object.toString()) == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getResourceUrl(dataContext)?.toString() ?: return");
            Object resourceReference = object;
            XmlTag xmlTag = this.findNearestXmlTag(psiElement);
            if (xmlTag == null) {
                return;
            }
            XmlTag xmlTag2 = xmlTag;
            String string = xmlTag2.getName();
            switch (string.hashCode()) {
                case 1125864064: {
                    if (string.equals("ImageView")) {
                        this.performForImageView(xmlTag2, (String)resourceReference);
                        break;
                    }
                }
                default: {
                    this.pasteAtCaret(caret, (String)resourceReference);
                }
            }
        }
    }

    private final void pasteAtCaret(Caret caret, String resourceReference) {
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable<T>(caret, resourceReference){
            final /* synthetic */ Caret $caret$inlined;
            final /* synthetic */ String $resourceReference$inlined;
            {
                this.$caret$inlined = caret;
                this.$resourceReference$inlined = string;
            }

            public final T compute() {
                boolean bl = false;
                Editor editor2 = this.$caret$inlined.getEditor();
                Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"caret.editor");
                editor2.getDocument().insertString(this.$caret$inlined.getOffset(), (CharSequence)this.$resourceReference$inlined);
                return (T)Unit.INSTANCE;
            }
        });
        caret.setSelection(caret.getOffset(), caret.getOffset() + resourceReference.length());
        caret.moveToOffset(caret.getOffset() + resourceReference.length());
    }

    /*
     * WARNING - void declaration
     */
    private final XmlTag findNearestXmlTag(PsiElement psiElement) {
        void currentElement;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = psiElement;
        while ((PsiElement)currentElement.element != null && !((PsiElement)currentElement.element instanceof XmlTag)) {
            void var4_4 = currentElement;
            boolean $i$f$runReadAction = false;
            Object object = ApplicationManager.getApplication().runReadAction(new Computable<T>((Ref.ObjectRef)currentElement){
                final /* synthetic */ Ref.ObjectRef $currentElement$inlined;
                {
                    this.$currentElement$inlined = objectRef;
                }

                public final T compute() {
                    boolean bl = false;
                    PsiElement psiElement = (PsiElement)this.$currentElement$inlined.element;
                    return (T)(psiElement != null ? psiElement.getParent() : null);
                }
            });
            var4_4.element = (PsiElement)object;
        }
        PsiElement psiElement2 = (PsiElement)currentElement.element;
        if (!(psiElement2 instanceof XmlTag)) {
            psiElement2 = null;
        }
        return (XmlTag)psiElement2;
    }

    private final void performForImageView(XmlTag xmlTag, String resourceReference) {
        boolean $i$f$runReadAction = false;
        boolean dependsOnAppCompat = Intrinsics.areEqual((Object)((Boolean)ApplicationManager.getApplication().runReadAction(new Computable<T>(xmlTag){
            final /* synthetic */ XmlTag $xmlTag$inlined;
            {
                this.$xmlTag$inlined = xmlTag;
            }

            public final T compute() {
                boolean bl = false;
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)this.$xmlTag$inlined));
                return (T)(module != null ? Boolean.valueOf(DependencyManagementUtil.dependsOnAppCompat(module)) : null);
            }
        })), (Object)true);
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable<T>(dependsOnAppCompat, xmlTag, resourceReference){
            final /* synthetic */ boolean $dependsOnAppCompat$inlined;
            final /* synthetic */ XmlTag $xmlTag$inlined;
            final /* synthetic */ String $resourceReference$inlined;
            {
                this.$dependsOnAppCompat$inlined = bl;
                this.$xmlTag$inlined = xmlTag;
                this.$resourceReference$inlined = string;
            }

            public final T compute() {
                boolean bl = false;
                if (this.$dependsOnAppCompat$inlined) {
                    this.$xmlTag$inlined.setAttribute("srcCompat", "http://schemas.android.com/apk/res-auto", this.$resourceReference$inlined);
                    this.$xmlTag$inlined.setAttribute("src", "http://schemas.android.com/apk/res/android", null);
                } else {
                    this.$xmlTag$inlined.setAttribute("srcCompat", "http://schemas.android.com/apk/res-auto", null);
                    this.$xmlTag$inlined.setAttribute("src", "http://schemas.android.com/apk/res/android", this.$resourceReference$inlined);
                }
                TemplateUtils.reformatAndRearrange(this.$xmlTag$inlined.getProject(), (PsiElement)this.$xmlTag$inlined);
                return (T)Unit.INSTANCE;
            }
        });
    }

    private final ResourceUrl getResourceUrl(DataContext dataContext) {
        Object object = (Producer)PasteAction.TRANSFERABLE_PROVIDER.getData(dataContext);
        return (ResourceUrl)(object != null && (object = (Transferable)object.produce()) != null ? object.getTransferData(ResourceDragHandlerKt.RESOURCE_URL_FLAVOR) : null);
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        if (!((Boolean)StudioFlags.RESOURCE_MANAGER_ENABLED.get()).booleanValue()) {
            return false;
        }
        Object object = (Producer)PasteAction.TRANSFERABLE_PROVIDER.getData(dataContext);
        return object != null && (object = (Transferable)object.produce()) != null ? object.isDataFlavorSupported(ResourceDragHandlerKt.RESOURCE_URL_FLAVOR) : false;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        return this.isPastePossible(dataContext);
    }
}

