/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res.aar;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.DuplicateDataException;
import com.android.ide.common.resources.MergingException;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceMerger;
import com.android.ide.common.resources.ResourceRepositories;
import com.android.ide.common.resources.ResourceSet;
import com.android.ide.common.resources.ResourceTable;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.ide.common.xml.AndroidManifestParser;
import com.android.ide.common.xml.ManifestData;
import com.android.resources.ResourceType;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.aar.RDotTxtParser;
import com.android.utils.ILogger;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AarSourceResourceRepository
extends LocalResourceRepository
implements SingleNamespaceResourceRepository {
    private static final Logger LOG = Logger.getInstance(AarSourceResourceRepository.class);
    protected final ResourceTable myFullTable;
    @Nullable
    private Map<String, Integer> myAarDeclaredIds;
    @NotNull
    private final File myResourceDirectory;
    @NotNull
    private final ResourceNamespace myNamespace;
    @Nullable
    private final String myLibraryName;
    @NotNull
    private final NullableLazyValue<String> myManifestPackageName;

    protected AarSourceResourceRepository(@NotNull File resourceDirectory, @NotNull ResourceNamespace namespace, @Nullable String libraryName) {
        if (resourceDirectory == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(0);
        }
        if (namespace == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(1);
        }
        super(resourceDirectory.getName());
        this.myFullTable = new ResourceTable();
        this.myResourceDirectory = resourceDirectory;
        this.myNamespace = namespace;
        this.myLibraryName = libraryName;
        this.myManifestPackageName = NullableLazyValue.createValue(() -> {
            File manifest = new File(this.myResourceDirectory.getParentFile(), "AndroidManifest.xml");
            if (!manifest.exists()) {
                return null;
            }
            try {
                ManifestData manifestData = AndroidManifestParser.parse((Path)manifest.toPath());
                return manifestData.getPackage();
            }
            catch (IOException e) {
                LOG.error("Failed to read manifest " + manifest.getAbsolutePath() + " for library " + this.myLibraryName, (Throwable)e);
                return null;
            }
        });
    }

    @NotNull
    public static AarSourceResourceRepository create(@NotNull File resourceDirectory, @Nullable String libraryName) {
        if (resourceDirectory == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(2);
        }
        AarSourceResourceRepository aarSourceResourceRepository = AarSourceResourceRepository.create(resourceDirectory, ResourceNamespace.RES_AUTO, libraryName);
        if (aarSourceResourceRepository == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(3);
        }
        return aarSourceResourceRepository;
    }

    @NotNull
    private static AarSourceResourceRepository create(@NotNull File resourceDirectory, @NotNull ResourceNamespace namespace, @Nullable String libraryName) {
        if (resourceDirectory == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(4);
        }
        if (namespace == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(5);
        }
        AarSourceResourceRepository repository = new AarSourceResourceRepository(resourceDirectory, namespace, libraryName);
        try {
            ResourceMerger resourceMerger = AarSourceResourceRepository.createResourceMerger(resourceDirectory, namespace, libraryName);
            ResourceRepositories.updateTableFromMerger((ResourceMerger)resourceMerger, (ResourceTable)repository.getFullTable());
        }
        catch (Exception e) {
            LOG.error("Failed to initialize resources", (Throwable)e);
        }
        repository.loadRTxt(resourceDirectory.getParentFile());
        AarSourceResourceRepository aarSourceResourceRepository = repository;
        if (aarSourceResourceRepository == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(6);
        }
        return aarSourceResourceRepository;
    }

    @NotNull
    public static AarSourceResourceRepository createForTest(@NotNull File resourceDirectory, @NotNull ResourceNamespace namespace, @Nullable String libraryName) {
        if (resourceDirectory == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(7);
        }
        if (namespace == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(8);
        }
        assert (ApplicationManager.getApplication() == null || ApplicationManager.getApplication().isUnitTestMode());
        AarSourceResourceRepository aarSourceResourceRepository = AarSourceResourceRepository.create(resourceDirectory, namespace, libraryName);
        if (aarSourceResourceRepository == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(9);
        }
        return aarSourceResourceRepository;
    }

    protected void loadRTxt(@NotNull File directory) {
        File rDotTxt;
        if (directory == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(10);
        }
        if ((rDotTxt = new File(directory, "R.txt")).exists()) {
            this.myAarDeclaredIds = RDotTxtParser.getIds(rDotTxt);
        }
    }

    @NotNull
    public File getResourceDirectory() {
        File file = this.myResourceDirectory;
        if (file == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(11);
        }
        return file;
    }

    @NotNull
    public final ResourceNamespace getNamespace() {
        ResourceNamespace resourceNamespace = this.myNamespace;
        if (resourceNamespace == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(12);
        }
        return resourceNamespace;
    }

    @Override
    @Nullable
    public final String getLibraryName() {
        return this.myLibraryName;
    }

    @Nullable
    public String getPackageName() {
        if (this.myNamespace.getPackageName() != null) {
            return this.myNamespace.getPackageName();
        }
        return (String)this.myManifestPackageName.getValue();
    }

    private static ResourceMerger createResourceMerger(File file, ResourceNamespace namespace, String libraryName) {
        LogWrapper logger = new LogWrapper(LOG).alwaysLogAsDebug(true).allowVerbose(false);
        ResourceMerger merger = new ResourceMerger(0);
        ResourceSet resourceSet = new ResourceSet(file.getName(), namespace, libraryName, false);
        File rDotTxt = new File(file.getParent(), "R.txt");
        if (!rDotTxt.exists()) {
            resourceSet.setShouldParseResourceIds(true);
        }
        resourceSet.addSource(file);
        resourceSet.setTrackSourcePositions(false);
        try {
            resourceSet.loadFromFiles((ILogger)logger);
        }
        catch (DuplicateDataException e) {
            assert (false);
        }
        catch (MergingException e) {
            LOG.warn((Throwable)e);
        }
        merger.addDataSet(resourceSet);
        return merger;
    }

    @NotNull
    protected ResourceTable getFullTable() {
        ResourceTable resourceTable = this.myFullTable;
        if (resourceTable == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(13);
        }
        return resourceTable;
    }

    @Nullable
    @Contract(value="_, _, true -> !null")
    protected ListMultimap<String, ResourceItem> getMap(@NotNull ResourceNamespace namespace, @NotNull ResourceType type, boolean create2) {
        ListMultimap multimap;
        if (namespace == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(14);
        }
        if (type == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(15);
        }
        if ((multimap = (ListMultimap)this.myFullTable.get((Object)namespace, (Object)type)) == null && create2) {
            multimap = ArrayListMultimap.create();
            this.myFullTable.put((Object)namespace, (Object)type, (Object)multimap);
        }
        return multimap;
    }

    @Nullable
    public Map<String, Integer> getAllDeclaredIds() {
        return this.myAarDeclaredIds;
    }

    @Override
    @NotNull
    protected Set<VirtualFile> computeResourceDirs() {
        Set<VirtualFile> set = Collections.emptySet();
        if (set == null) {
            AarSourceResourceRepository.$$$reportNull$$$0(16);
        }
        return set;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + '@' + Integer.toHexString(System.identityHashCode((Object)this)) + " for " + this.myResourceDirectory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceDirectory";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/aar/AarSourceResourceRepository";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/aar/AarSourceResourceRepository";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createForTest";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceDirectory";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullTable";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "computeResourceDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createForTest";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadRTxt";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

