/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.AndroidRClassBase;
import com.android.tools.idea.res.LocalResourceRepository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.android.augment.ResourceRepositoryInnerRClass;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceRepositoryRClass
extends AndroidRClassBase {
    private static final Logger LOG = Logger.getInstance(ResourceRepositoryRClass.class);
    @NotNull
    protected final Module myModule;
    @NotNull
    private final ResourcesSource mySource;

    public ResourceRepositoryRClass(@NotNull PsiManager psiManager, @NotNull Module module, @NotNull ResourcesSource source) {
        if (psiManager == null) {
            ResourceRepositoryRClass.$$$reportNull$$$0(0);
        }
        if (module == null) {
            ResourceRepositoryRClass.$$$reportNull$$$0(1);
        }
        if (source == null) {
            ResourceRepositoryRClass.$$$reportNull$$$0(2);
        }
        super(psiManager, source.getPackageName());
        this.mySource = source;
        this.myModule = module;
        this.setModuleInfo(module, this.mySource.isForTest());
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            ResourceRepositoryRClass.$$$reportNull$$$0(3);
        }
        return module;
    }

    @Override
    @NotNull
    protected PsiClass[] doGetInnerClasses() {
        if (DumbService.isDumb((Project)this.getProject())) {
            LOG.debug("R_CLASS_AUGMENT: empty because of dumb mode");
            if (PsiClass.EMPTY_ARRAY == null) {
                ResourceRepositoryRClass.$$$reportNull$$$0(4);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
        if (facet == null) {
            LOG.debug("R_CLASS_AUGMENT: empty because no facet");
            if (PsiClass.EMPTY_ARRAY == null) {
                ResourceRepositoryRClass.$$$reportNull$$$0(5);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        Set types = this.mySource.getResourceRepository().getResourceTypes(this.mySource.getResourceNamespace());
        ArrayList<ResourceRepositoryInnerRClass> result2 = new ArrayList<ResourceRepositoryInnerRClass>();
        for (ResourceType type : types) {
            if (!type.getHasInnerClass()) continue;
            result2.add(new ResourceRepositoryInnerRClass(facet, type, this.mySource, this));
        }
        LOG.debug("R_CLASS_AUGMENT: " + result2.size() + " classes added");
        PsiClass[] psiClassArray = result2.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            ResourceRepositoryRClass.$$$reportNull$$$0(6);
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    protected Object[] getInnerClassesDependencies() {
        Object[] objectArray = new Object[]{this.mySource.getResourceRepository()};
        if (objectArray == null) {
            ResourceRepositoryRClass.$$$reportNull$$$0(7);
        }
        return objectArray;
    }

    @Nullable
    public String getQualifiedName() {
        String packageName = this.mySource.getPackageName();
        return packageName == null ? "R" : packageName + "." + "R";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/ResourceRepositoryRClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/ResourceRepositoryRClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetInnerClasses";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClassesDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ResourcesSource {
        @Nullable
        public String getPackageName();

        @NotNull
        public LocalResourceRepository getResourceRepository();

        @NotNull
        public ResourceNamespace getResourceNamespace();

        default public boolean isForTest() {
            return false;
        }
    }
}

