/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.builder.model.AaptOptions;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.builder.model.level2.Library;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.projectmodel.ExternalLibrary;
import com.android.tools.idea.AndroidProjectModelUtils;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ModuleResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepository;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.TestAppResourceRepository;
import com.android.tools.idea.res.aar.AarResourceRepositoryCache;
import com.android.tools.idea.res.aar.AarSourceResourceRepository;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceRepositoryManager
implements Disposable {
    private static final Key<ResourceRepositoryManager> KEY = Key.create((String)ResourceRepositoryManager.class.getName());
    private static final Logger LOG = Logger.getInstance(ResourceRepositoryManager.class);
    private static final Object APP_RESOURCES_LOCK = new Object();
    private static final Object PROJECT_RESOURCES_LOCK = new Object();
    private static final Object MODULE_RESOURCES_LOCK = new Object();
    private static final Object TEST_APP_RESOURCES_LOCK = new Object();
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final AaptOptions.Namespacing myNamespacing;
    @Nullable
    private ResourceVisibilityLookup.Provider myResourceVisibilityProvider;
    @Nullable
    private ResourceNamespace myCachedNamespace;
    private AppResourceRepository myAppResources;
    private ProjectResourceRepository myProjectResources;
    private LocalResourceRepository myModuleResources;
    private LocalResourceRepository myTestAppResources;
    private Map<ExternalLibrary, AarSourceResourceRepository> myLibraryResourceMap;
    private final Object myLibraryLock;

    @NotNull
    public static ResourceRepositoryManager getOrCreateInstance(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(0);
        }
        AaptOptions.Namespacing namespacing = AndroidProjectModelUtils.getNamespacing(facet);
        ResourceRepositoryManager instance = (ResourceRepositoryManager)facet.getUserData(KEY);
        if (instance != null && instance.myNamespacing != namespacing) {
            if (facet.replace(KEY, instance, null)) {
                Disposer.dispose((Disposable)instance);
            }
            instance = null;
        }
        if (instance == null) {
            instance = (ResourceRepositoryManager)facet.putUserDataIfAbsent(KEY, new ResourceRepositoryManager(facet, namespacing));
        }
        ResourceRepositoryManager resourceRepositoryManager = instance;
        if (resourceRepositoryManager == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(1);
        }
        return resourceRepositoryManager;
    }

    @Nullable
    public static ResourceRepositoryManager getOrCreateInstance(@NotNull Module module) {
        AndroidFacet facet;
        if (module == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(2);
        }
        return (facet = AndroidFacet.getInstance(module)) == null ? null : ResourceRepositoryManager.getOrCreateInstance(facet);
    }

    @Nullable
    public static ResourceRepositoryManager getInstance(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(3);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return null;
        }
        return ResourceRepositoryManager.getOrCreateInstance(facet);
    }

    @Nullable
    public static LocalResourceRepository getAppResources(@NotNull Module module) {
        AndroidFacet facet;
        if (module == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(4);
        }
        return (facet = AndroidFacet.getInstance(module)) != null ? ResourceRepositoryManager.getAppResources(facet) : null;
    }

    @NotNull
    public static LocalResourceRepository getAppResources(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(5);
        }
        LocalResourceRepository localResourceRepository = ResourceRepositoryManager.getOrCreateInstance(facet).getAppResources(true);
        if (localResourceRepository == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(6);
        }
        return localResourceRepository;
    }

    @Nullable
    public static LocalResourceRepository getProjectResources(@NotNull Module module) {
        AndroidFacet facet;
        if (module == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(7);
        }
        return (facet = AndroidFacet.getInstance(module)) != null ? ResourceRepositoryManager.getProjectResources(facet) : null;
    }

    @NotNull
    public static LocalResourceRepository getProjectResources(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(8);
        }
        LocalResourceRepository localResourceRepository = ResourceRepositoryManager.getOrCreateInstance(facet).getProjectResources(true);
        if (localResourceRepository == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(9);
        }
        return localResourceRepository;
    }

    @Nullable
    public static LocalResourceRepository getModuleResources(@NotNull Module module) {
        AndroidFacet facet;
        if (module == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(10);
        }
        return (facet = AndroidFacet.getInstance(module)) != null ? ResourceRepositoryManager.getModuleResources(facet) : null;
    }

    @NotNull
    public static LocalResourceRepository getModuleResources(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(11);
        }
        LocalResourceRepository localResourceRepository = ResourceRepositoryManager.getOrCreateInstance(facet).getModuleResources(true);
        if (localResourceRepository == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(12);
        }
        return localResourceRepository;
    }

    private ResourceRepositoryManager(@NotNull AndroidFacet facet, @NotNull AaptOptions.Namespacing namespacing) {
        if (facet == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(13);
        }
        if (namespacing == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(14);
        }
        this.myLibraryLock = new Object();
        this.myFacet = facet;
        this.myNamespacing = namespacing;
        Disposer.register((Disposable)facet, (Disposable)this);
    }

    public static boolean testAndClearTempResourceCached(@NotNull Project project) {
        if (project == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(15);
        }
        if (project.getUserData(AppResourceRepository.TEMPORARY_RESOURCE_CACHE) != Boolean.TRUE) {
            return false;
        }
        project.putUserData(AppResourceRepository.TEMPORARY_RESOURCE_CACHE, null);
        return true;
    }

    @NotNull
    public static Collection<Library> findAarLibraries(@NotNull AndroidFacet facet) {
        AndroidModuleModel androidModel;
        if (facet == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(16);
        }
        ArrayList<Library> libraries = new ArrayList<Library>();
        if (facet.requiresAndroidModel() && (androidModel = AndroidModuleModel.get(facet)) != null) {
            List<AndroidFacet> dependentFacets = AndroidUtils.getAllAndroidDependencies(facet.getModule(), true);
            ResourceRepositoryManager.addGradleLibraries(libraries, androidModel);
            for (AndroidFacet dependentFacet : dependentFacets) {
                AndroidModuleModel dependentGradleModel = AndroidModuleModel.get(dependentFacet);
                if (dependentGradleModel == null) continue;
                ResourceRepositoryManager.addGradleLibraries(libraries, dependentGradleModel);
            }
        }
        ArrayList<Library> arrayList = libraries;
        if (arrayList == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    private static void addGradleLibraries(@NotNull List<Library> list, @NotNull AndroidModuleModel androidModuleModel) {
        if (list == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(18);
        }
        if (androidModuleModel == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(19);
        }
        list.addAll(androidModuleModel.getSelectedMainCompileLevel2Dependencies().getAndroidLibraries());
    }

    @Contract(value="true -> !null")
    @Nullable
    public LocalResourceRepository getAppResources(boolean createIfNecessary) {
        return (LocalResourceRepository)((Object)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = APP_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myAppResources == null && createIfNecessary) {
                    this.myAppResources = AppResourceRepository.create(this.myFacet, this.getLibraryResources());
                    Disposer.register((Disposable)this, (Disposable)this.myAppResources);
                }
                return this.myAppResources;
            }
        }));
    }

    @Contract(value="true -> !null")
    @Nullable
    public LocalResourceRepository getProjectResources(boolean createIfNecessary) {
        return (LocalResourceRepository)((Object)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = PROJECT_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myProjectResources == null && createIfNecessary) {
                    this.myProjectResources = ProjectResourceRepository.create(this.myFacet);
                    Disposer.register((Disposable)this, (Disposable)this.myProjectResources);
                }
                return this.myProjectResources;
            }
        }));
    }

    @Contract(value="true -> !null")
    @Nullable
    public LocalResourceRepository getModuleResources(boolean createIfNecessary) {
        return (LocalResourceRepository)((Object)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = MODULE_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myModuleResources == null && createIfNecessary) {
                    this.myModuleResources = ModuleResourceRepository.forMainResources(this.myFacet);
                    Disposer.register((Disposable)this, (Disposable)this.myModuleResources);
                }
                return this.myModuleResources;
            }
        }));
    }

    @NotNull
    public LocalResourceRepository getTestAppResources() {
        LocalResourceRepository localResourceRepository = (LocalResourceRepository)((Object)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = TEST_APP_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myTestAppResources == null) {
                    this.myTestAppResources = this.computeTestAppResources();
                    Disposer.register((Disposable)this, (Disposable)this.myTestAppResources);
                }
                return this.myTestAppResources;
            }
        }));
        if (localResourceRepository == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(20);
        }
        return localResourceRepository;
    }

    @NotNull
    private LocalResourceRepository computeTestAppResources() {
        LocalResourceRepository moduleTestResources = ModuleResourceRepository.forTestResources(this.myFacet);
        if (this.getNamespacing() == AaptOptions.Namespacing.REQUIRED) {
            LocalResourceRepository localResourceRepository = moduleTestResources;
            if (localResourceRepository == null) {
                ResourceRepositoryManager.$$$reportNull$$$0(21);
            }
            return localResourceRepository;
        }
        AndroidModuleModel model = AndroidModuleModel.get(this.myFacet);
        if (model == null) {
            LocalResourceRepository localResourceRepository = moduleTestResources;
            if (localResourceRepository == null) {
                ResourceRepositoryManager.$$$reportNull$$$0(22);
            }
            return localResourceRepository;
        }
        TestAppResourceRepository testAppResourceRepository = TestAppResourceRepository.create(this.myFacet, moduleTestResources, model);
        if (testAppResourceRepository == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(23);
        }
        return testAppResourceRepository;
    }

    @Nullable
    public ResourceRepository getFrameworkResources(boolean needLocales) {
        AndroidPlatform androidPlatform = AndroidPlatform.getInstance(this.myFacet.getModule());
        if (androidPlatform == null) {
            return null;
        }
        return androidPlatform.getSdkData().getTargetData(androidPlatform.getTarget()).getFrameworkResources(needLocales);
    }

    @NotNull
    public List<LocalResourceRepository> getAppResourcesForNamespace(@NotNull ResourceNamespace namespace) {
        if (namespace == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(24);
        }
        AppResourceRepository appRepository = (AppResourceRepository)this.getAppResources(true);
        if (this.getNamespacing() == AaptOptions.Namespacing.DISABLED) {
            ImmutableList immutableList = ImmutableList.of((Object)((Object)appRepository));
            if (immutableList == null) {
                ResourceRepositoryManager.$$$reportNull$$$0(25);
            }
            return immutableList;
        }
        List<LocalResourceRepository> list = appRepository.getRepositoriesForNamespace(namespace);
        if (list == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(26);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetResources() {
        this.resetVisibility();
        this.resetLibraries();
        Object object = MODULE_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myModuleResources != null) {
                Disposer.dispose((Disposable)this.myModuleResources);
                this.myModuleResources = null;
            }
        }
        object = PROJECT_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myProjectResources != null) {
                Disposer.dispose((Disposable)this.myProjectResources);
                this.myProjectResources = null;
            }
        }
        object = APP_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myAppResources != null) {
                Disposer.dispose((Disposable)this.myAppResources);
                this.myAppResources = null;
            }
        }
    }

    public void dispose() {
    }

    public void resetAllCaches() {
        this.resetResources();
        ConfigurationManager.getOrCreateInstance(this.myFacet.getModule()).getResolverCache().reset();
        ResourceFolderRegistry.getInstance(this.myFacet.getModule().getProject()).reset();
        AarResourceRepositoryCache.getInstance().clear();
    }

    private void resetVisibility() {
        this.myResourceVisibilityProvider = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetLibraries() {
        Object object = this.myLibraryLock;
        synchronized (object) {
            this.myLibraryResourceMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRoots() {
        this.resetVisibility();
        this.getProjectResources(false);
        ProjectResourceRepository projectResources = (ProjectResourceRepository)this.getProjectResources(false);
        if (projectResources != null) {
            projectResources.updateRoots();
            AppResourceRepository appResources = (AppResourceRepository)this.getAppResources(false);
            if (appResources != null) {
                Map<ExternalLibrary, AarSourceResourceRepository> oldLibraryResourceMap;
                appResources.invalidateCache(projectResources);
                Object object = this.myLibraryLock;
                synchronized (object) {
                    oldLibraryResourceMap = this.myLibraryResourceMap;
                    this.myLibraryResourceMap = null;
                }
                appResources.updateRoots(this.getLibraryResources());
                if (oldLibraryResourceMap != null) {
                    oldLibraryResourceMap.size();
                }
            }
        }
    }

    @NotNull
    public AaptOptions.Namespacing getNamespacing() {
        AaptOptions.Namespacing namespacing = this.myNamespacing;
        if (namespacing == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(27);
        }
        return namespacing;
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        if (this.myNamespacing == AaptOptions.Namespacing.DISABLED) {
            ResourceNamespace resourceNamespace = ResourceNamespace.RES_AUTO;
            if (resourceNamespace == null) {
                ResourceRepositoryManager.$$$reportNull$$$0(28);
            }
            return resourceNamespace;
        }
        String packageName = AndroidManifestUtils.getPackageName(this.myFacet);
        if (packageName == null) {
            ResourceNamespace resourceNamespace = ResourceNamespace.RES_AUTO;
            if (resourceNamespace == null) {
                ResourceRepositoryManager.$$$reportNull$$$0(29);
            }
            return resourceNamespace;
        }
        if (this.myCachedNamespace == null || !packageName.equals(this.myCachedNamespace.getPackageName())) {
            this.myCachedNamespace = ResourceNamespace.fromPackageName((String)packageName);
        }
        ResourceNamespace resourceNamespace = this.myCachedNamespace;
        if (resourceNamespace == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(30);
        }
        return resourceNamespace;
    }

    @NotNull
    public ResourceNamespace getTestNamespace() {
        ResourceNamespace resourceNamespace = ResourceNamespace.TODO();
        if (resourceNamespace == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(31);
        }
        return resourceNamespace;
    }

    @Nullable
    public ResourceVisibilityLookup.Provider getResourceVisibilityProvider() {
        if (this.myResourceVisibilityProvider == null) {
            if (!this.myFacet.requiresAndroidModel() || ((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getModel() == null) {
                return null;
            }
            this.myResourceVisibilityProvider = new ResourceVisibilityLookup.Provider();
        }
        return this.myResourceVisibilityProvider;
    }

    @NotNull
    public ResourceVisibilityLookup getResourceVisibility() {
        ResourceVisibilityLookup.Provider provider;
        AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
        if (androidModel != null && (provider = this.getResourceVisibilityProvider()) != null) {
            IdeAndroidProject androidProject = androidModel.getAndroidProject();
            IdeVariant variant = androidModel.getSelectedVariant();
            ResourceVisibilityLookup resourceVisibilityLookup = provider.get((AndroidProject)androidProject, (Variant)variant);
            if (resourceVisibilityLookup == null) {
                ResourceRepositoryManager.$$$reportNull$$$0(32);
            }
            return resourceVisibilityLookup;
        }
        ResourceVisibilityLookup resourceVisibilityLookup = ResourceVisibilityLookup.NONE;
        if (resourceVisibilityLookup == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(33);
        }
        return resourceVisibilityLookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Multimap<String, VirtualFile> getAllResourceDirs() {
        Object object = APP_RESOURCES_LOCK;
        // MONITORENTER : object
        this.getAppResources(true);
        Multimap<String, VirtualFile> multimap = this.myAppResources.getAllResourceDirs();
        // MONITOREXIT : object
        if (multimap != null) return multimap;
        ResourceRepositoryManager.$$$reportNull$$$0(34);
        return multimap;
    }

    @Nullable
    public LocalResourceRepository findLibraryResources(@NotNull ExternalLibrary library) {
        if (library == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(35);
        }
        return this.getLibraryResourceMap().get(library);
    }

    @NotNull
    public List<AarSourceResourceRepository> getLibraryResources() {
        ImmutableList immutableList = ImmutableList.copyOf(this.getLibraryResourceMap().values());
        if (immutableList == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(36);
        }
        return immutableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Map<ExternalLibrary, AarSourceResourceRepository> getLibraryResourceMap() {
        Object object = this.myLibraryLock;
        // MONITORENTER : object
        if (this.myLibraryResourceMap == null) {
            this.myLibraryResourceMap = this.computeLibraryResourceMap();
        }
        Map<ExternalLibrary, AarSourceResourceRepository> map2 = this.myLibraryResourceMap;
        // MONITOREXIT : object
        if (map2 != null) return map2;
        ResourceRepositoryManager.$$$reportNull$$$0(37);
        return map2;
    }

    @NotNull
    private Map<ExternalLibrary, AarSourceResourceRepository> computeLibraryResourceMap() {
        Collection<ExternalLibrary> libraries = AndroidProjectModelUtils.findDependenciesWithResources(this.myFacet.getModule()).values();
        LinkedHashMap<ExternalLibrary, AarSourceResourceRepository> result2 = new LinkedHashMap<ExternalLibrary, AarSourceResourceRepository>(libraries.size());
        for (ExternalLibrary library : libraries) {
            AarSourceResourceRepository aarRepository;
            if (this.myNamespacing == AaptOptions.Namespacing.DISABLED) {
                if (library.getResFolder() == null) continue;
                File resFolder = library.getResFolder().toFile();
                if (resFolder == null) {
                    LOG.warn("Cannot find res folder for " + library.getAddress());
                    continue;
                }
                aarRepository = AarResourceRepositoryCache.getInstance().getSourceRepository(resFolder, library.getAddress());
            } else {
                PathString resApkPath = library.getResApkFile();
                if (resApkPath == null) {
                    LOG.warn("No res.apk for " + library.getAddress());
                    continue;
                }
                File resApkFile = resApkPath.toFile();
                if (resApkFile == null) {
                    LOG.warn("Cannot find res.apk for " + library.getAddress());
                    continue;
                }
                aarRepository = AarResourceRepositoryCache.getInstance().getProtoRepository(resApkFile, library.getAddress());
            }
            result2.put(library, aarRepository);
        }
        Map<ExternalLibrary, AarSourceResourceRepository> map2 = Collections.unmodifiableMap(result2);
        if (map2 == null) {
            ResourceRepositoryManager.$$$reportNull$$$0(38);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 12: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 12: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 12: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/ResourceRepositoryManager";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespacing";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModuleModel";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/ResourceRepositoryManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateInstance";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppResources";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectResources";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleResources";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findAarLibraries";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestAppResources";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "computeTestAppResources";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppResourcesForNamespace";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespacing";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestNamespace";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceVisibility";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllResourceDirs";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryResources";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryResourceMap";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "computeLibraryResourceMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateInstance";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 12: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAppResources";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getProjectResources";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getModuleResources";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "testAndClearTempResourceCached";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findAarLibraries";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addGradleLibraries";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAppResourcesForNamespace";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryResources";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 12: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

