/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.idea.res.ResourceFolderRepositoryFileCacheService;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.utils.concurrency.CacheUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceFolderRegistry {
    private final Cache<VirtualFile, ResourceFolderRepository> myNamespacedCache = ResourceFolderRegistry.buildCache();
    private final Cache<VirtualFile, ResourceFolderRepository> myNonNamespacedCache = ResourceFolderRegistry.buildCache();

    @NotNull
    private static Cache<VirtualFile, ResourceFolderRepository> buildCache() {
        Cache cache = CacheBuilder.newBuilder().weakValues().build();
        if (cache == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(0);
        }
        return cache;
    }

    @NotNull
    public static ResourceFolderRegistry getInstance(@NotNull Project project) {
        if (project == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(1);
        }
        ResourceFolderRegistry resourceFolderRegistry = (ResourceFolderRegistry)ServiceManager.getService((Project)project, ResourceFolderRegistry.class);
        if (resourceFolderRegistry == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(2);
        }
        return resourceFolderRegistry;
    }

    public void reset() {
        this.myNamespacedCache.invalidateAll();
        this.myNonNamespacedCache.invalidateAll();
    }

    @NotNull
    public ResourceFolderRepository get(@NotNull AndroidFacet facet, @NotNull VirtualFile dir) {
        if (facet == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(3);
        }
        if (dir == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(4);
        }
        ResourceFolderRepository resourceFolderRepository = (ResourceFolderRepository)((Object)ReadAction.compute(() -> this.get(facet, dir, ResourceRepositoryManager.getOrCreateInstance(facet).getNamespace())));
        if (resourceFolderRepository == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(5);
        }
        return resourceFolderRepository;
    }

    @NotNull
    ResourceFolderRepository get(@NotNull AndroidFacet facet, @NotNull VirtualFile dir, @NotNull ResourceNamespace namespace) {
        if (facet == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(6);
        }
        if (dir == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(7);
        }
        if (namespace == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(8);
        }
        Cache<VirtualFile, ResourceFolderRepository> cache = namespace == ResourceNamespace.RES_AUTO ? this.myNonNamespacedCache : this.myNamespacedCache;
        ResourceFolderRepository repository = (ResourceFolderRepository)((Object)CacheUtils.getAndUnwrap(cache, (Object)dir, () -> ResourceFolderRepository.create(facet, dir, namespace)));
        assert (repository.getNamespace().equals((Object)namespace));
        ResourceFolderRepository resourceFolderRepository = repository;
        if (resourceFolderRepository == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(9);
        }
        return resourceFolderRepository;
    }

    @Nullable
    public CachedRepositories getCached(@NotNull VirtualFile directory) {
        if (directory == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(10);
        }
        ResourceFolderRepository namespaced = (ResourceFolderRepository)((Object)this.myNamespacedCache.getIfPresent((Object)directory));
        ResourceFolderRepository nonNamespaced = (ResourceFolderRepository)((Object)this.myNonNamespacedCache.getIfPresent((Object)directory));
        return namespaced == null && nonNamespaced == null ? null : new CachedRepositories(namespaced, nonNamespaced);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/ResourceFolderRegistry";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCache";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/ResourceFolderRegistry";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCached";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CachedRepositories {
        @Nullable
        public final ResourceFolderRepository namespaced;
        @Nullable
        public final ResourceFolderRepository nonNamespaced;

        public CachedRepositories(@Nullable ResourceFolderRepository namespaced, @Nullable ResourceFolderRepository nonNamespaced) {
            this.namespaced = namespaced;
            this.nonNamespaced = nonNamespaced;
        }
    }

    public static class PopulateCachesTask
    extends DumbModeTask {
        @NotNull
        private final Project myProject;

        public PopulateCachesTask(@NotNull Project project) {
            if (project == null) {
                PopulateCachesTask.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        public void performInDumbMode(@NotNull ProgressIndicator indicator) {
            List facets;
            if (indicator == null) {
                PopulateCachesTask.$$$reportNull$$$0(1);
            }
            if ((facets = ProjectFacetManager.getInstance((Project)this.myProject).getFacets(AndroidFacet.ID)).isEmpty()) {
                return;
            }
            indicator.setText("Indexing resources");
            indicator.setIndeterminate(false);
            Map<VirtualFile, AndroidFacet> resDirectories = AndroidResourceUtil.getResourceDirectoriesForFacets(facets);
            if (resDirectories.isEmpty()) {
                return;
            }
            Path projectCacheRoot = ResourceFolderRepositoryFileCacheService.get().getProjectDir(this.myProject);
            if (projectCacheRoot == null) {
                return;
            }
            try {
                FileUtil.ensureExists((File)projectCacheRoot.toFile());
            }
            catch (IOException e) {
                return;
            }
            Application application = ApplicationManager.getApplication();
            assert (!application.isWriteAccessAllowed());
            int numDone = 0;
            int maxThreads = Math.min(4, Runtime.getRuntime().availableProcessors());
            ExecutorService parallelExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"ResourceFolderRegistry", (int)maxThreads);
            ArrayList<Future<ResourceFolderRepository>> repositoryJobs = new ArrayList<Future<ResourceFolderRepository>>();
            for (Map.Entry<VirtualFile, AndroidFacet> entry : resDirectories.entrySet()) {
                AndroidFacet facet = entry.getValue();
                VirtualFile dir = entry.getKey();
                ResourceFolderRegistry registry = ResourceFolderRegistry.getInstance(this.myProject);
                repositoryJobs.add(parallelExecutor.submit(() -> registry.get(facet, dir)));
            }
            for (Future future2 : repositoryJobs) {
                if (indicator.isCanceled()) break;
                indicator.setFraction((double)numDone / (double)resDirectories.size());
                try {
                    future2.get();
                }
                catch (ExecutionException facet) {
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                ++numDone;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/res/ResourceFolderRegistry$PopulateCachesTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performInDumbMode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

