/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ArrayResourceValueImpl;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.AttrResourceValueImpl;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.DensityBasedResourceValueImpl;
import com.android.ide.common.rendering.api.PluralsResourceValueImpl;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValueImpl;
import com.android.ide.common.rendering.api.StyleResourceValueImpl;
import com.android.ide.common.rendering.api.StyleableResourceValueImpl;
import com.android.ide.common.rendering.api.TextResourceValueImpl;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ValueXmlHelper;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.res.PsiResourceFile;
import com.android.tools.idea.res.ResourceHelper;
import com.google.common.base.MoreObjects;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.reference.SoftReference;
import com.intellij.xml.util.XmlUtil;
import java.util.Collections;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiResourceItem
implements ResourceItem {
    @NotNull
    private final String myName;
    @NotNull
    private final ResourceType myType;
    @NotNull
    private final ResourceNamespace myNamespace;
    @Nullable
    private ResourceValue myResourceValue;
    @Nullable
    private PsiResourceFile mySourceFile;
    @Nullable
    private final SoftReference<XmlTag> myOriginalTag;
    @NotNull
    private final SoftReference<PsiFile> myOriginalFile;
    @Nullable
    private final Object smartPsiPointerLock;
    @Nullable
    private SmartPsiElementPointer<XmlTag> myTagPointer;
    @Nullable
    private SmartPsiElementPointer<PsiFile> myFilePointer;

    private PsiResourceItem(@NotNull String name, @NotNull ResourceType type, @NotNull ResourceNamespace namespace, @Nullable XmlTag tag, @NotNull PsiFile file, boolean calledFromPsiListener) {
        if (name == null) {
            PsiResourceItem.$$$reportNull$$$0(0);
        }
        if (type == null) {
            PsiResourceItem.$$$reportNull$$$0(1);
        }
        if (namespace == null) {
            PsiResourceItem.$$$reportNull$$$0(2);
        }
        if (file == null) {
            PsiResourceItem.$$$reportNull$$$0(3);
        }
        this.myName = name;
        this.myType = type;
        this.myNamespace = namespace;
        this.myOriginalTag = tag == null ? null : new SoftReference((Object)tag);
        this.myOriginalFile = new SoftReference((Object)file);
        if (calledFromPsiListener) {
            this.smartPsiPointerLock = new Object();
            Application application = ApplicationManager.getApplication();
            application.executeOnPooledThread(() -> application.runReadAction(this::createSmartPointers));
        } else {
            this.smartPsiPointerLock = null;
            this.createSmartPointers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSmartPointers() {
        SmartPsiElementPointer<XmlTag> tagPointer = this.myOriginalTag == null ? null : PsiResourceItem.createSmartPointer(this.myOriginalTag);
        SmartPsiElementPointer<PsiFile> filePointer = PsiResourceItem.createSmartPointer(this.myOriginalFile);
        if (this.smartPsiPointerLock == null) {
            this.myTagPointer = tagPointer;
            this.myFilePointer = filePointer;
        } else {
            Object object = this.smartPsiPointerLock;
            synchronized (object) {
                this.myTagPointer = tagPointer;
                this.myFilePointer = filePointer;
            }
        }
    }

    @Nullable
    private static <T extends PsiElement> SmartPsiElementPointer<T> createSmartPointer(@NotNull SoftReference<T> elementReference) {
        PsiElement element;
        if (elementReference == null) {
            PsiResourceItem.$$$reportNull$$$0(4);
        }
        if ((element = (PsiElement)elementReference.get()) == null) {
            return null;
        }
        return SmartPointerManager.createPointer((PsiElement)element);
    }

    @NotNull
    public static PsiResourceItem forXmlTag(@NotNull String name, @NotNull ResourceType type, @NotNull ResourceNamespace namespace, @NotNull XmlTag tag, boolean calledFromPsiListener) {
        if (name == null) {
            PsiResourceItem.$$$reportNull$$$0(5);
        }
        if (type == null) {
            PsiResourceItem.$$$reportNull$$$0(6);
        }
        if (namespace == null) {
            PsiResourceItem.$$$reportNull$$$0(7);
        }
        if (tag == null) {
            PsiResourceItem.$$$reportNull$$$0(8);
        }
        PsiResourceItem psiResourceItem = new PsiResourceItem(name, type, namespace, tag, tag.getContainingFile(), calledFromPsiListener);
        if (psiResourceItem == null) {
            PsiResourceItem.$$$reportNull$$$0(9);
        }
        return psiResourceItem;
    }

    @NotNull
    public static PsiResourceItem forFile(@NotNull String name, @NotNull ResourceType type, @NotNull ResourceNamespace namespace, @NotNull PsiFile file, boolean calledFromPsiListener) {
        if (name == null) {
            PsiResourceItem.$$$reportNull$$$0(10);
        }
        if (type == null) {
            PsiResourceItem.$$$reportNull$$$0(11);
        }
        if (namespace == null) {
            PsiResourceItem.$$$reportNull$$$0(12);
        }
        if (file == null) {
            PsiResourceItem.$$$reportNull$$$0(13);
        }
        PsiResourceItem psiResourceItem = new PsiResourceItem(name, type, namespace, null, file, calledFromPsiListener);
        if (psiResourceItem == null) {
            PsiResourceItem.$$$reportNull$$$0(14);
        }
        return psiResourceItem;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            PsiResourceItem.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public ResourceType getType() {
        ResourceType resourceType = this.myType;
        if (resourceType == null) {
            PsiResourceItem.$$$reportNull$$$0(16);
        }
        return resourceType;
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        ResourceNamespace resourceNamespace = this.myNamespace;
        if (resourceNamespace == null) {
            PsiResourceItem.$$$reportNull$$$0(17);
        }
        return resourceNamespace;
    }

    @Nullable
    public String getLibraryName() {
        return null;
    }

    @NotNull
    public ResourceReference getReferenceToSelf() {
        ResourceReference resourceReference = new ResourceReference(this.myNamespace, this.myType, this.myName);
        if (resourceReference == null) {
            PsiResourceItem.$$$reportNull$$$0(18);
        }
        return resourceReference;
    }

    @NotNull
    public FolderConfiguration getConfiguration() {
        PsiResourceFile source = this.getSourceFile();
        assert (source != null) : "getConfiguration called on a PsiResourceItem with no source";
        FolderConfiguration folderConfiguration = source.getFolderConfiguration();
        if (folderConfiguration == null) {
            PsiResourceItem.$$$reportNull$$$0(19);
        }
        return folderConfiguration;
    }

    @NotNull
    public String getKey() {
        String qualifiers = this.getConfiguration().getQualifierString();
        if (!qualifiers.isEmpty()) {
            String string = this.myType.getName() + '-' + qualifiers + '/' + this.myName;
            if (string == null) {
                PsiResourceItem.$$$reportNull$$$0(20);
            }
            return string;
        }
        String string = this.myType.getName() + '/' + this.myName;
        if (string == null) {
            PsiResourceItem.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Nullable
    public PsiResourceFile getSourceFile() {
        if (this.mySourceFile != null) {
            return this.mySourceFile;
        }
        PsiFile psiFile = this.getPsiFile();
        if (psiFile == null) {
            return null;
        }
        PsiElement parent = AndroidPsiUtils.getPsiParentSafely((PsiElement)psiFile);
        if (!(parent instanceof PsiDirectory)) {
            return null;
        }
        String name = ((PsiDirectory)parent).getName();
        ResourceFolderType folderType = ResourceFolderType.getFolderType((String)name);
        if (folderType == null) {
            return null;
        }
        FolderConfiguration configuration = FolderConfiguration.getConfigForFolder((String)name);
        if (configuration == null) {
            return null;
        }
        return new PsiResourceFile(psiFile, Collections.singletonList(this), folderType, configuration);
    }

    public void setSourceFile(@Nullable PsiResourceFile sourceFile) {
        this.mySourceFile = sourceFile;
    }

    @Nullable
    public ResourceValue getResourceValue() {
        if (this.myResourceValue == null) {
            XmlTag tag = this.getTag();
            if (tag == null) {
                String path;
                PsiResourceFile source = this.getSourceFile();
                assert (source != null) : "getResourceValue called on a PsiResourceItem with no source";
                ResourceType type = this.getType();
                Density density = type == ResourceType.DRAWABLE || type == ResourceType.MIPMAP ? this.getFolderDensity() : null;
                VirtualFile virtualFile = source.getVirtualFile();
                String string = path = virtualFile == null ? null : VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile).getAbsolutePath();
                this.myResourceValue = density != null ? new DensityBasedResourceValueImpl(this.myNamespace, this.myType, this.myName, path, density, null) : new ResourceValueImpl(this.myNamespace, this.myType, this.myName, path, null);
            } else {
                this.myResourceValue = this.parseXmlToResourceValue(tag);
            }
        }
        return this.myResourceValue;
    }

    @Nullable
    public PathString getSource() {
        PsiFile psiFile = this.getPsiFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        return virtualFile == null ? null : new PathString(VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile));
    }

    public boolean isFileBased() {
        return this.myOriginalTag == null;
    }

    @Nullable
    private Density getFolderDensity() {
        FolderConfiguration configuration = this.getConfiguration();
        DensityQualifier densityQualifier = configuration.getDensityQualifier();
        if (densityQualifier != null) {
            return densityQualifier.getValue();
        }
        return null;
    }

    @Nullable
    private ResourceValue parseXmlToResourceValue(final @Nullable XmlTag tag) {
        Object value2;
        if (tag == null || !tag.isValid()) {
            return null;
        }
        switch (this.myType) {
            case STYLE: {
                String parent = PsiResourceItem.getAttributeValue(tag, "parent");
                value2 = PsiResourceItem.parseStyleValue(tag, new StyleResourceValueImpl(this.myNamespace, this.myType, this.myName, parent, null));
                break;
            }
            case STYLEABLE: {
                value2 = this.parseDeclareStyleable(tag, new StyleableResourceValueImpl(this.myNamespace, this.myType, this.myName, null, null));
                break;
            }
            case ATTR: {
                value2 = PsiResourceItem.parseAttrValue(tag, new AttrResourceValueImpl(this.myNamespace, this.myType, this.myName, null));
                break;
            }
            case ARRAY: {
                value2 = PsiResourceItem.parseArrayValue(tag, new ArrayResourceValueImpl(this.myNamespace, this.myType, this.myName, null){

                    protected int getDefaultIndex() {
                        String index = tag.getAttributeValue("index", "http://schemas.android.com/tools");
                        if (index != null) {
                            return Integer.parseInt(index);
                        }
                        return super.getDefaultIndex();
                    }
                });
                break;
            }
            case PLURALS: {
                value2 = PsiResourceItem.parsePluralsValue(tag, new PluralsResourceValueImpl(this.myNamespace, this.myType, this.myName, null, null){

                    public String getValue() {
                        String value2;
                        String quantity = tag.getAttributeValue("quantity", "http://schemas.android.com/tools");
                        if (quantity != null && (value2 = this.getValue(quantity)) != null) {
                            return value2;
                        }
                        return super.getValue();
                    }
                });
                break;
            }
            case STRING: {
                value2 = PsiResourceItem.parseTextValue(tag, new PsiTextResourceValue(this.myNamespace, this.myType, this.myName, null, null, null));
                break;
            }
            default: {
                value2 = PsiResourceItem.parseValue(tag, new ResourceValueImpl(this.myNamespace, this.myType, this.myName, null));
            }
        }
        value2.setNamespaceResolver(ResourceHelper.getNamespaceResolver((XmlElement)tag));
        return value2;
    }

    @Nullable
    private static String getAttributeValue(@NotNull XmlTag tag, @NotNull String attributeName) {
        if (tag == null) {
            PsiResourceItem.$$$reportNull$$$0(22);
        }
        if (attributeName == null) {
            PsiResourceItem.$$$reportNull$$$0(23);
        }
        return tag.getAttributeValue(attributeName);
    }

    @NotNull
    private StyleableResourceValueImpl parseDeclareStyleable(@NotNull XmlTag tag, @NotNull StyleableResourceValueImpl declareStyleable) {
        if (tag == null) {
            PsiResourceItem.$$$reportNull$$$0(24);
        }
        if (declareStyleable == null) {
            PsiResourceItem.$$$reportNull$$$0(25);
        }
        for (XmlTag child : tag.getSubTags()) {
            ResourceReference resolvedAttr;
            ResourceUrl url;
            String name = PsiResourceItem.getAttributeValue(child, "name");
            if (StringUtil.isEmpty((String)name) || (url = ResourceUrl.parseAttrReference((String)name)) == null || (resolvedAttr = url.resolve(this.getNamespace(), ResourceHelper.getNamespaceResolver((XmlElement)tag))) == null) continue;
            AttrResourceValue attr = PsiResourceItem.parseAttrValue(child, new AttrResourceValueImpl(resolvedAttr, null));
            declareStyleable.addValue(attr);
        }
        StyleableResourceValueImpl styleableResourceValueImpl = declareStyleable;
        if (styleableResourceValueImpl == null) {
            PsiResourceItem.$$$reportNull$$$0(26);
        }
        return styleableResourceValueImpl;
    }

    @NotNull
    private static StyleResourceValueImpl parseStyleValue(@NotNull XmlTag tag, @NotNull StyleResourceValueImpl styleValue) {
        if (tag == null) {
            PsiResourceItem.$$$reportNull$$$0(27);
        }
        if (styleValue == null) {
            PsiResourceItem.$$$reportNull$$$0(28);
        }
        for (XmlTag child : tag.getSubTags()) {
            String name = PsiResourceItem.getAttributeValue(child, "name");
            if (StringUtil.isEmpty((String)name)) continue;
            String value2 = ValueXmlHelper.unescapeResourceString((String)ResourceHelper.getTextContent(child), (boolean)true, (boolean)true);
            StyleItemResourceValueImpl itemValue = new StyleItemResourceValueImpl(styleValue.getNamespace(), name, value2, styleValue.getLibraryName());
            itemValue.setNamespaceResolver(ResourceHelper.getNamespaceResolver((XmlElement)child));
            styleValue.addItem((StyleItemResourceValue)itemValue);
        }
        StyleResourceValueImpl styleResourceValueImpl = styleValue;
        if (styleResourceValueImpl == null) {
            PsiResourceItem.$$$reportNull$$$0(29);
        }
        return styleResourceValueImpl;
    }

    @NotNull
    private static AttrResourceValue parseAttrValue(@NotNull XmlTag attrTag, @NotNull AttrResourceValueImpl attrValue) {
        if (attrTag == null) {
            PsiResourceItem.$$$reportNull$$$0(30);
        }
        if (attrValue == null) {
            PsiResourceItem.$$$reportNull$$$0(31);
        }
        attrValue.setDescription(PsiResourceItem.getDescription(attrTag));
        EnumSet<AttributeFormat> formats = EnumSet.noneOf(AttributeFormat.class);
        String formatString = PsiResourceItem.getAttributeValue(attrTag, "format");
        if (formatString != null) {
            formats.addAll(AttributeFormat.parse((String)formatString));
        }
        for (XmlTag child : attrTag.getSubTags()) {
            String tagName = child.getName();
            if ("enum".equals(tagName)) {
                formats.add(AttributeFormat.ENUM);
            } else if ("flag".equals(tagName)) {
                formats.add(AttributeFormat.FLAGS);
            }
            String name = PsiResourceItem.getAttributeValue(child, "name");
            if (name == null) continue;
            Integer numericValue = null;
            String value2 = PsiResourceItem.getAttributeValue(child, "value");
            if (value2 != null) {
                try {
                    numericValue = Long.decode(value2).intValue();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            attrValue.addValue(name, numericValue, PsiResourceItem.getDescription(child));
        }
        attrValue.setFormats(formats);
        AttrResourceValueImpl attrResourceValueImpl = attrValue;
        if (attrResourceValueImpl == null) {
            PsiResourceItem.$$$reportNull$$$0(32);
        }
        return attrResourceValueImpl;
    }

    @Nullable
    private static String getDescription(@NotNull XmlTag tag) {
        String text;
        XmlComment comment;
        if (tag == null) {
            PsiResourceItem.$$$reportNull$$$0(33);
        }
        if ((comment = XmlUtil.findPreviousComment((PsiElement)tag)) != null && !StringUtil.isEmpty((String)(text = comment.getCommentText()))) {
            return text.trim();
        }
        return null;
    }

    @NotNull
    private static ArrayResourceValueImpl parseArrayValue(@NotNull XmlTag tag, @NotNull ArrayResourceValueImpl arrayValue) {
        if (tag == null) {
            PsiResourceItem.$$$reportNull$$$0(34);
        }
        if (arrayValue == null) {
            PsiResourceItem.$$$reportNull$$$0(35);
        }
        for (XmlTag child : tag.getSubTags()) {
            String text = ValueXmlHelper.unescapeResourceString((String)ResourceHelper.getTextContent(child), (boolean)true, (boolean)true);
            if (text == null) continue;
            arrayValue.addElement(text);
        }
        ArrayResourceValueImpl arrayResourceValueImpl = arrayValue;
        if (arrayResourceValueImpl == null) {
            PsiResourceItem.$$$reportNull$$$0(36);
        }
        return arrayResourceValueImpl;
    }

    @NotNull
    private static PluralsResourceValueImpl parsePluralsValue(@NotNull XmlTag tag, @NotNull PluralsResourceValueImpl value2) {
        if (tag == null) {
            PsiResourceItem.$$$reportNull$$$0(37);
        }
        if (value2 == null) {
            PsiResourceItem.$$$reportNull$$$0(38);
        }
        for (XmlTag child : tag.getSubTags()) {
            String quantity = child.getAttributeValue("quantity");
            if (quantity == null) continue;
            String text = ValueXmlHelper.unescapeResourceString((String)ResourceHelper.getTextContent(child), (boolean)true, (boolean)true);
            value2.addPlural(quantity, text);
        }
        PluralsResourceValueImpl pluralsResourceValueImpl = value2;
        if (pluralsResourceValueImpl == null) {
            PsiResourceItem.$$$reportNull$$$0(39);
        }
        return pluralsResourceValueImpl;
    }

    @NotNull
    private static ResourceValueImpl parseValue(@NotNull XmlTag tag, @NotNull ResourceValueImpl value2) {
        if (tag == null) {
            PsiResourceItem.$$$reportNull$$$0(40);
        }
        if (value2 == null) {
            PsiResourceItem.$$$reportNull$$$0(41);
        }
        String text = ResourceHelper.getTextContent(tag);
        text = ValueXmlHelper.unescapeResourceString((String)text, (boolean)true, (boolean)true);
        value2.setValue(text);
        ResourceValueImpl resourceValueImpl = value2;
        if (resourceValueImpl == null) {
            PsiResourceItem.$$$reportNull$$$0(42);
        }
        return resourceValueImpl;
    }

    @NotNull
    private static PsiTextResourceValue parseTextValue(@NotNull XmlTag tag, @NotNull PsiTextResourceValue value2) {
        if (tag == null) {
            PsiResourceItem.$$$reportNull$$$0(43);
        }
        if (value2 == null) {
            PsiResourceItem.$$$reportNull$$$0(44);
        }
        String text = ResourceHelper.getTextContent(tag);
        text = ValueXmlHelper.unescapeResourceString((String)text, (boolean)true, (boolean)true);
        value2.setValue(text);
        PsiTextResourceValue psiTextResourceValue = value2;
        if (psiTextResourceValue == null) {
            PsiResourceItem.$$$reportNull$$$0(45);
        }
        return psiTextResourceValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public XmlTag getTag() {
        if (this.smartPsiPointerLock == null) {
            return this.myOriginalTag == null ? null : (this.myTagPointer == null ? (XmlTag)this.myOriginalTag.get() : (XmlTag)this.myTagPointer.getElement());
        }
        Object object = this.smartPsiPointerLock;
        synchronized (object) {
            return this.myOriginalTag == null ? null : (this.myTagPointer == null ? (XmlTag)this.myOriginalTag.get() : (XmlTag)this.myTagPointer.getElement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    PsiFile getPsiFile() {
        if (this.smartPsiPointerLock == null) {
            return this.myFilePointer == null ? (PsiFile)this.myOriginalFile.get() : (PsiFile)this.myFilePointer.getElement();
        }
        Object object = this.smartPsiPointerLock;
        synchronized (object) {
            return this.myFilePointer == null ? (PsiFile)this.myOriginalFile.get() : (PsiFile)this.myFilePointer.getElement();
        }
    }

    public boolean wasTag(@NotNull XmlTag tag) {
        if (tag == null) {
            PsiResourceItem.$$$reportNull$$$0(46);
        }
        return this.myOriginalTag != null && tag == this.myOriginalTag.get() || tag == this.getTag();
    }

    public boolean recomputeValue() {
        if (this.myResourceValue == null) {
            return false;
        }
        this.myResourceValue = null;
        return true;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public String toString() {
        PsiFile file;
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).add("name", (Object)this.myName).add("namespace", (Object)this.myNamespace).add("type", (Object)this.myType);
        XmlTag tag = this.getTag();
        if (tag != null) {
            helper.add("tag", (Object)ResourceHelper.getTextContent(tag));
        }
        if ((file = this.getPsiFile()) != null) {
            helper.add("file", (Object)file.getName());
        }
        return helper.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 29: 
            case 32: 
            case 36: 
            case 39: 
            case 42: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 29: 
            case 32: 
            case 36: 
            case 39: 
            case 42: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementReference";
                break;
            }
            case 8: 
            case 22: 
            case 24: 
            case 27: 
            case 33: 
            case 34: 
            case 37: 
            case 40: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 29: 
            case 32: 
            case 36: 
            case 39: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/PsiResourceItem";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declareStyleable";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleValue";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrTag";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrValue";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayValue";
                break;
            }
            case 38: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/PsiResourceItem";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "forXmlTag";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "forFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceToSelf";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDeclareStyleable";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "parseStyleValue";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAttrValue";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "parseArrayValue";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePluralsValue";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "parseValue";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTextValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createSmartPointer";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "forXmlTag";
                break;
            }
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 29: 
            case 32: 
            case 36: 
            case 39: 
            case 42: 
            case 45: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "forFile";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValue";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "parseDeclareStyleable";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "parseStyleValue";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "parseAttrValue";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "parseArrayValue";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "parsePluralsValue";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "parseValue";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "parseTextValue";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "wasTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 29: 
            case 32: 
            case 36: 
            case 39: 
            case 42: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PsiTextResourceValue
    extends TextResourceValueImpl {
        public PsiTextResourceValue(@NotNull ResourceNamespace namespace, @NotNull ResourceType type, @Nullable String name, @Nullable String textValue, @Nullable String rawXmlValue, String libraryName) {
            if (namespace == null) {
                PsiTextResourceValue.$$$reportNull$$$0(0);
            }
            if (type == null) {
                PsiTextResourceValue.$$$reportNull$$$0(1);
            }
            if (name == null) {
                PsiTextResourceValue.$$$reportNull$$$0(2);
            }
            super(namespace, type, name, textValue, rawXmlValue, libraryName);
        }

        public String getRawXmlValue() {
            XmlTag tag = PsiResourceItem.this.getTag();
            if (tag == null || !tag.isValid()) {
                return this.getValue();
            }
            if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                return tag.getValue().getText();
            }
            return (String)ApplicationManager.getApplication().runReadAction(() -> tag.getValue().getText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "namespace";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/res/PsiResourceItem$PsiTextResourceValue";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

