/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceTable;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.DataBindingInfo;
import com.android.tools.idea.res.LocalResourceRepository;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultiResourceRepository
extends LocalResourceRepository {
    @GuardedBy(value="ITEM_MAP_LOCK")
    private List<? extends LocalResourceRepository> myChildren;
    @GuardedBy(value="ITEM_MAP_LOCK")
    private final Multimap<ResourceNamespace, LocalResourceRepository> myRepositoriesByNamespace;
    @GuardedBy(value="ITEM_MAP_LOCK")
    private long[] myModificationCounts;
    @GuardedBy(value="ITEM_MAP_LOCK")
    private ResourceTable myFullTable;
    @GuardedBy(value="ITEM_MAP_LOCK")
    private final ResourceTable myCachedMaps;
    @GuardedBy(value="ITEM_MAP_LOCK")
    private Map<String, DataBindingInfo> myDataBindingResourceFiles;
    @GuardedBy(value="ITEM_MAP_LOCK")
    private long myDataBindingResourceFilesModificationCount;

    MultiResourceRepository(@NotNull String displayName) {
        if (displayName == null) {
            MultiResourceRepository.$$$reportNull$$$0(0);
        }
        super(displayName);
        this.myRepositoriesByNamespace = HashMultimap.create();
        this.myCachedMaps = new ResourceTable();
        this.myDataBindingResourceFiles = new HashMap<String, DataBindingInfo>();
        this.myDataBindingResourceFilesModificationCount = Long.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setChildren(@NotNull List<? extends LocalResourceRepository> children) {
        if (children == null) {
            MultiResourceRepository.$$$reportNull$$$0(1);
        }
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            LocalResourceRepository resources;
            if (this.myChildren != null) {
                int i2 = this.myChildren.size();
                while (--i2 >= 0) {
                    resources = this.myChildren.get(i2);
                    resources.removeParent(this);
                }
            }
            this.setModificationCount(ourModificationCounter.incrementAndGet());
            this.myChildren = children;
            this.myModificationCounts = new long[children.size()];
            if (children.size() == 1) {
                LocalResourceRepository child = children.get(0);
                child.setModificationCount(this.getModificationCount());
            }
            int i3 = this.myChildren.size();
            while (--i3 >= 0) {
                resources = this.myChildren.get(i3);
                resources.addParent(this);
                this.myModificationCounts[i3] = resources.getModificationCount();
            }
            this.myFullTable = null;
            this.myCachedMaps.clear();
            this.myRepositoriesByNamespace.clear();
            MultiResourceRepository.populateNamespaceMap(this, this.myRepositoriesByNamespace);
        }
        this.invalidateParentCaches();
    }

    @GuardedBy(value="ITEM_MAP_LOCK")
    private static void populateNamespaceMap(@NotNull LocalResourceRepository repository, @NotNull Multimap<ResourceNamespace, LocalResourceRepository> result2) {
        if (repository == null) {
            MultiResourceRepository.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            MultiResourceRepository.$$$reportNull$$$0(3);
        }
        if (repository instanceof SingleNamespaceResourceRepository) {
            ResourceNamespace namespace = ((SingleNamespaceResourceRepository)repository).getNamespace();
            result2.put((Object)namespace, (Object)repository);
        } else if (repository instanceof MultiResourceRepository) {
            for (LocalResourceRepository localResourceRepository : ((MultiResourceRepository)repository).myChildren) {
                MultiResourceRepository.populateNamespaceMap(localResourceRepository, result2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final List<LocalResourceRepository> getChildren() {
        Object object = ITEM_MAP_LOCK;
        // MONITORENTER : object
        ImmutableList immutableList = this.myChildren == null ? Collections.emptyList() : ImmutableList.copyOf(this.myChildren);
        // MONITOREXIT : object
        if (immutableList != null) return immutableList;
        MultiResourceRepository.$$$reportNull$$$0(4);
        return immutableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final List<LocalResourceRepository> getRepositoriesForNamespace(@NotNull ResourceNamespace namespace) {
        if (namespace == null) {
            MultiResourceRepository.$$$reportNull$$$0(5);
        }
        Object object = ITEM_MAP_LOCK;
        // MONITORENTER : object
        ImmutableList immutableList = ImmutableList.copyOf((Collection)this.myRepositoriesByNamespace.get((Object)namespace));
        // MONITOREXIT : object
        if (immutableList != null) return immutableList;
        MultiResourceRepository.$$$reportNull$$$0(6);
        return immutableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getModificationCount() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myChildren.size() == 1) {
                return this.myChildren.get(0).getModificationCount();
            }
            boolean changed = false;
            int i2 = this.myChildren.size();
            while (--i2 >= 0) {
                LocalResourceRepository resources = this.myChildren.get(i2);
                long rev = resources.getModificationCount();
                if (rev == this.myModificationCounts[i2]) continue;
                this.myModificationCounts[i2] = rev;
                changed = true;
            }
            if (changed) {
                this.setModificationCount(ourModificationCounter.incrementAndGet());
            }
            return super.getModificationCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public DataBindingInfo getDataBindingInfoForLayout(String layoutName) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (LocalResourceRepository localResourceRepository : this.myChildren) {
                DataBindingInfo info = localResourceRepository.getDataBindingInfoForLayout(layoutName);
                if (info == null) continue;
                return info;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Map<String, DataBindingInfo> getDataBindingResourceFiles() {
        Object object = ITEM_MAP_LOCK;
        // MONITORENTER : object
        long modificationCount = this.getModificationCount();
        if (this.myDataBindingResourceFilesModificationCount == modificationCount) {
            Map<String, DataBindingInfo> map2 = this.myDataBindingResourceFiles;
            // MONITOREXIT : object
            if (map2 != null) return map2;
            MultiResourceRepository.$$$reportNull$$$0(7);
            return map2;
        }
        HashMap<String, DataBindingInfo> selected = new HashMap<String, DataBindingInfo>();
        Iterator<? extends LocalResourceRepository> iterator = this.myChildren.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.myDataBindingResourceFiles = Collections.unmodifiableMap(selected);
                this.myDataBindingResourceFilesModificationCount = modificationCount;
                Map<String, DataBindingInfo> map3 = this.myDataBindingResourceFiles;
                // MONITOREXIT : object
                if (map3 != null) return map3;
                MultiResourceRepository.$$$reportNull$$$0(8);
                return map3;
            }
            LocalResourceRepository localResourceRepository = iterator.next();
            Map<String, DataBindingInfo> childFiles = localResourceRepository.getDataBindingResourceFiles();
            if (childFiles == null) continue;
            selected.putAll(childFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Set<ResourceNamespace> getNamespaces() {
        Object object = ITEM_MAP_LOCK;
        // MONITORENTER : object
        ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)this.myRepositoriesByNamespace.keySet());
        // MONITOREXIT : object
        if (immutableSet != null) return immutableSet;
        MultiResourceRepository.$$$reportNull$$$0(9);
        return immutableSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected ResourceTable getFullTable() {
        Object object = ITEM_MAP_LOCK;
        // MONITORENTER : object
        if (this.myFullTable == null) {
            if (this.myChildren.size() == 1) {
                this.myFullTable = this.myChildren.get(0).getFullTablePackageAccessible();
            } else {
                this.myFullTable = new ResourceTable();
                for (ResourceNamespace namespace : this.getNamespaces()) {
                    for (ResourceType type : ResourceType.values()) {
                        ListMultimap<String, ResourceItem> map2 = this.getMap(namespace, type, false);
                        if (map2 == null) continue;
                        this.myFullTable.put((Object)namespace, (Object)type, map2);
                    }
                }
            }
        }
        ResourceTable resourceTable = this.myFullTable;
        // MONITOREXIT : object
        if (resourceTable != null) return resourceTable;
        MultiResourceRepository.$$$reportNull$$$0(10);
        return resourceTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected ListMultimap<String, ResourceItem> getMap(@NotNull ResourceNamespace namespace, @NotNull ResourceType type, boolean create2) {
        if (namespace == null) {
            MultiResourceRepository.$$$reportNull$$$0(11);
        }
        if (type == null) {
            MultiResourceRepository.$$$reportNull$$$0(12);
        }
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ListMultimap map2 = (ListMultimap)this.myCachedMaps.get((Object)namespace, (Object)type);
            if (map2 != null) {
                return map2;
            }
            if (this.myChildren.size() == 1) {
                LocalResourceRepository child = this.myChildren.get(0);
                if (child instanceof MultiResourceRepository) {
                    return ((MultiResourceRepository)child).getMap(namespace, type);
                }
                return (ListMultimap)child.getFullTablePackageAccessible().get((Object)namespace, (Object)type);
            }
            map2 = ArrayListMultimap.create();
            HashSet<LocalResourceRepository> visited = new HashSet<LocalResourceRepository>();
            HashMultimap seenQualifiers = HashMultimap.create();
            this.merge(visited, namespace, type, (SetMultimap<String, String>)seenQualifiers, (ListMultimap<String, ResourceItem>)map2);
            this.myCachedMaps.put((Object)namespace, (Object)type, (Object)map2);
            return map2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doMerge(@NotNull Set<LocalResourceRepository> visited, @NotNull ResourceNamespace namespace, @NotNull ResourceType type, @NotNull SetMultimap<String, String> seenQualifiers, @NotNull ListMultimap<String, ResourceItem> result2) {
        if (visited == null) {
            MultiResourceRepository.$$$reportNull$$$0(13);
        }
        if (namespace == null) {
            MultiResourceRepository.$$$reportNull$$$0(14);
        }
        if (type == null) {
            MultiResourceRepository.$$$reportNull$$$0(15);
        }
        if (seenQualifiers == null) {
            MultiResourceRepository.$$$reportNull$$$0(16);
        }
        if (result2 == null) {
            MultiResourceRepository.$$$reportNull$$$0(17);
        }
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            int i2 = this.myChildren.size();
            while (--i2 >= 0) {
                this.myChildren.get(i2).merge(visited, namespace, type, seenQualifiers, result2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        if (namespace == null) {
            MultiResourceRepository.$$$reportNull$$$0(18);
        }
        if (type == null) {
            MultiResourceRepository.$$$reportNull$$$0(19);
        }
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myChildren.size() == 1) {
                return this.myChildren.get(0).hasResources(namespace, type);
            }
            if (this instanceof SingleNamespaceResourceRepository) {
                if (namespace.equals((Object)((SingleNamespaceResourceRepository)this).getNamespace())) {
                    for (LocalResourceRepository localResourceRepository : this.myChildren) {
                        if (!localResourceRepository.hasResources(namespace, type)) continue;
                        return true;
                    }
                }
                return false;
            }
            Collection repositories = this.myRepositoriesByNamespace.get((Object)namespace);
            for (LocalResourceRepository repository : repositories) {
                if (!repository.hasResources(namespace, type)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            int i2 = this.myChildren.size();
            while (--i2 >= 0) {
                LocalResourceRepository resources = this.myChildren.get(i2);
                resources.removeParent(this);
                Disposer.dispose((Disposable)resources);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCache(@NotNull LocalResourceRepository repository) {
        if (repository == null) {
            MultiResourceRepository.$$$reportNull$$$0(20);
        }
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            assert (this.myChildren.contains((Object)repository)) : repository;
            this.myCachedMaps.clear();
            this.myFullTable = null;
            this.setModificationCount(ourModificationCounter.incrementAndGet());
            this.invalidateParentCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCache(@NotNull LocalResourceRepository repository, @NotNull ResourceNamespace namespace, ResourceType ... types) {
        if (repository == null) {
            MultiResourceRepository.$$$reportNull$$$0(21);
        }
        if (namespace == null) {
            MultiResourceRepository.$$$reportNull$$$0(22);
        }
        if (types == null) {
            MultiResourceRepository.$$$reportNull$$$0(23);
        }
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            assert (this.myChildren.contains((Object)repository)) : repository;
            for (ResourceType type : types) {
                this.myCachedMaps.remove((Object)namespace, (Object)type);
            }
            this.myFullTable = null;
            this.setModificationCount(ourModificationCounter.incrementAndGet());
            this.invalidateParentCaches(namespace, types);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isScanPending(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            MultiResourceRepository.$$$reportNull$$$0(24);
        }
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            assert (ApplicationManager.getApplication().isUnitTestMode());
            int i2 = this.myChildren.size();
            while (--i2 >= 0) {
                LocalResourceRepository resources = this.myChildren.get(i2);
                if (!resources.isScanPending(psiFile)) continue;
                return true;
            }
            return false;
        }
    }

    @Override
    public void sync() {
        super.sync();
        for (LocalResourceRepository childRepository : this.getChildren()) {
            childRepository.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    protected Set<VirtualFile> computeResourceDirs() {
        Object object = ITEM_MAP_LOCK;
        // MONITORENTER : object
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
        Iterator<? extends LocalResourceRepository> iterator = this.myChildren.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                HashSet<VirtualFile> hashSet = result2;
                // MONITOREXIT : object
                if (hashSet != null) return hashSet;
                MultiResourceRepository.$$$reportNull$$$0(25);
                return hashSet;
            }
            LocalResourceRepository localResourceRepository = iterator.next();
            result2.addAll(localResourceRepository.computeResourceDirs());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLeafResourceRepositories(@NotNull Collection<SingleNamespaceResourceRepository> result2) {
        if (result2 == null) {
            MultiResourceRepository.$$$reportNull$$$0(26);
        }
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (ResourceRepository resourceRepository : this.myChildren) {
                resourceRepository.getLeafResourceRepositories(result2);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 3: 
            case 17: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/MultiResourceRepository";
                break;
            }
            case 5: 
            case 11: 
            case 14: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 12: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seenQualifiers";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/MultiResourceRepository";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoriesForNamespace";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataBindingResourceFiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaces";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullTable";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "computeResourceDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setChildren";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "populateNamespaceMap";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 25: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoriesForNamespace";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getMap";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doMerge";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "hasResources";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "invalidateCache";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isScanPending";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getLeafResourceRepositories";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

