/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.resources.DataBindingResourceType;
import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceType;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.res.DataBindingInfo;
import com.android.tools.idea.res.MergedDataBindingInfo;
import com.android.tools.idea.res.PsiDataBindingResourceItem;
import com.android.tools.idea.res.PsiResourceFile;
import com.android.tools.idea.res.PsiResourceItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutDataBindingInfo
implements DataBindingInfo {
    @NotNull
    private final Map<DataBindingResourceType, Map<String, PsiDataBindingResourceItem>> myItems;
    private String myClassName;
    private String myNonConfigurationClassName;
    private String myPackageName;
    private final PsiResourceFile myPsiResourceFile;
    private PsiClass myPsiClass;
    private long myLayoutModificationCount;
    private long myBindingModificationCount;
    private boolean myClassNameSpecifiedByUser;
    private final AndroidFacet myFacet;
    @NotNull
    private final String myConfigurationName;
    private MergedDataBindingInfo myMergedInfo;

    public LayoutDataBindingInfo(@NotNull AndroidFacet facet, @NotNull PsiResourceFile psiResourceFile, @NotNull String className, @NotNull String packageName, boolean classNameSpecifiedByUser) {
        if (facet == null) {
            LayoutDataBindingInfo.$$$reportNull$$$0(0);
        }
        if (psiResourceFile == null) {
            LayoutDataBindingInfo.$$$reportNull$$$0(1);
        }
        if (className == null) {
            LayoutDataBindingInfo.$$$reportNull$$$0(2);
        }
        if (packageName == null) {
            LayoutDataBindingInfo.$$$reportNull$$$0(3);
        }
        this.myItems = new EnumMap<DataBindingResourceType, Map<String, PsiDataBindingResourceItem>>(DataBindingResourceType.class);
        this.myFacet = facet;
        this.myNonConfigurationClassName = className;
        this.myClassName = className;
        this.myPackageName = packageName;
        this.myClassNameSpecifiedByUser = classNameSpecifiedByUser;
        this.myPsiResourceFile = psiResourceFile;
        PsiDirectory parent = this.myPsiResourceFile.getPsiFile().getParent();
        this.myConfigurationName = parent != null ? parent.getName() : "";
    }

    @Override
    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    void update(String className, String packageName, boolean classNameSpecifiedByUser, long modificationCount) {
        if (StringUtil.equals((CharSequence)this.myNonConfigurationClassName, (CharSequence)className) && StringUtil.equals((CharSequence)this.myPackageName, (CharSequence)packageName) && classNameSpecifiedByUser == this.myClassNameSpecifiedByUser) {
            return;
        }
        this.myNonConfigurationClassName = className;
        this.myPackageName = packageName;
        this.myLayoutModificationCount = modificationCount;
    }

    public void replaceItems(@NotNull List<PsiDataBindingResourceItem> newItems, long modificationCount) {
        if (newItems == null) {
            LayoutDataBindingInfo.$$$reportNull$$$0(4);
        }
        EnumMap<DataBindingResourceType, Map> itemsByType = new EnumMap<DataBindingResourceType, Map>(DataBindingResourceType.class);
        for (PsiDataBindingResourceItem item : newItems) {
            DataBindingResourceType type = item.getType();
            Map itemsByName = itemsByType.computeIfAbsent(type, t -> new HashMap());
            itemsByName.put(item.getName(), item);
        }
        if (!itemsByType.equals(this.myItems)) {
            this.myItems.clear();
            this.myItems.putAll(itemsByType);
            this.myLayoutModificationCount = modificationCount;
        }
    }

    public void setMergedInfo(MergedDataBindingInfo mergedInfo) {
        if (this.myMergedInfo == mergedInfo) {
            return;
        }
        ++this.myBindingModificationCount;
        this.myMergedInfo = mergedInfo;
        this.myClassName = mergedInfo != null ? LayoutDataBindingInfo.calculateConfigurationName(this.myConfigurationName, this.myNonConfigurationClassName) : this.myNonConfigurationClassName;
    }

    private static String calculateConfigurationName(String configurationName, String nonConfigurationClassName) {
        if (StringUtil.isEmpty((String)configurationName)) {
            return nonConfigurationClassName + "Impl";
        }
        if (configurationName.startsWith("layout-")) {
            return nonConfigurationClassName + DataBindingUtil.convertToJavaClassName(configurationName.substring("layout-".length())) + "Impl";
        }
        if (configurationName.startsWith("layout")) {
            return nonConfigurationClassName + "Impl";
        }
        return nonConfigurationClassName + DataBindingUtil.convertToJavaClassName(configurationName) + "Impl";
    }

    @Override
    public String getClassName() {
        return this.myClassName;
    }

    @Override
    public String getPackageName() {
        return this.myPackageName;
    }

    @Override
    public Project getProject() {
        return this.myPsiResourceFile.getPsiFile().getProject();
    }

    @Override
    public String getQualifiedName() {
        return this.myPackageName + "." + this.myClassName;
    }

    String getNonConfigurationClassName() {
        return this.myNonConfigurationClassName;
    }

    String getFileName() {
        return this.myPsiResourceFile.getName();
    }

    @Override
    public PsiElement getNavigationElement() {
        return this.myPsiResourceFile.getPsiFile();
    }

    @Override
    public PsiFile getPsiFile() {
        return this.myPsiResourceFile.getPsiFile();
    }

    @Override
    public PsiClass getPsiClass() {
        return this.myPsiClass;
    }

    @Override
    public void setPsiClass(PsiClass psiClass) {
        this.myPsiClass = psiClass;
    }

    @Override
    @NotNull
    public Map<String, PsiDataBindingResourceItem> getItems(@NotNull DataBindingResourceType type) {
        Map<String, PsiDataBindingResourceItem> itemsByName;
        if (type == null) {
            LayoutDataBindingInfo.$$$reportNull$$$0(5);
        }
        Map<Object, Object> map2 = (itemsByName = this.myItems.get(type)) == null ? Collections.emptyMap() : itemsByName;
        if (map2 == null) {
            LayoutDataBindingInfo.$$$reportNull$$$0(6);
        }
        return map2;
    }

    @Override
    @NotNull
    public List<DataBindingInfo.ViewWithId> getViewsWithIds() {
        ArrayList<DataBindingInfo.ViewWithId> result2 = new ArrayList<DataBindingInfo.ViewWithId>();
        for (ResourceItem item : this.myPsiResourceFile) {
            String name;
            PsiResourceItem psiResourceItem;
            XmlTag tag;
            if (!ResourceType.ID.equals((Object)item.getType()) || !(item instanceof PsiResourceItem) || (tag = (psiResourceItem = (PsiResourceItem)item).getTag()) == null || StringUtil.isEmpty((String)(name = item.getName()))) continue;
            result2.add(new DataBindingInfo.ViewWithId(DataBindingUtil.convertToJavaFieldName(name.trim()), tag));
        }
        ArrayList<DataBindingInfo.ViewWithId> arrayList = result2;
        if (arrayList == null) {
            LayoutDataBindingInfo.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Override
    @Nullable
    public Module getModule() {
        return ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myPsiResourceFile.getPsiFile());
    }

    @Override
    public long getModificationCount() {
        return this.myLayoutModificationCount + this.myBindingModificationCount;
    }

    @Override
    public boolean isMerged() {
        return false;
    }

    @Override
    @Nullable
    public DataBindingInfo getMergedInfo() {
        return this.myMergedInfo;
    }

    @NotNull
    public String getConfigurationName() {
        String string = this.myConfigurationName;
        if (string == null) {
            LayoutDataBindingInfo.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiResourceFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newItems";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/LayoutDataBindingInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/LayoutDataBindingInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewsWithIds";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replaceItems";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getItems";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

