/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.DataFile;
import com.android.ide.common.resources.DataItem;
import com.android.ide.common.resources.DuplicateDataException;
import com.android.ide.common.resources.MergingException;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceMergerItem;
import com.android.ide.common.resources.ResourceSet;
import com.android.ide.common.resources.ResourceTable;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.res.aar.AarSourceResourceRepository;
import com.android.utils.ILogger;
import com.android.utils.XmlUtils;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ObjectIntHashMap;
import gnu.trove.THashSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardCopyOption;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public final class FrameworkResourceRepository
extends AarSourceResourceRepository {
    private static final ResourceNamespace ANDROID_NAMESPACE = ResourceNamespace.ANDROID;
    private static final String CACHE_DIRECTORY = "caches/framework_resources";
    private static final String CACHE_FILE_HEADER = "Framework resource cache";
    private static final String CACHE_FILE_FORMAT_VERSION = "3";
    private static final String ANDROID_PLUGIN_ID = "org.jetbrains.android";
    private static final int ATTR_GROUP_MAX_CHARACTERS = 40;
    private static final Logger LOG = Logger.getInstance(FrameworkResourceRepository.class);
    private static final String[] WELL_KNOWN_NAMESPACES = new String[]{"android", "http://schemas.android.com/apk/res/android", "xliff", "urn:oasis:names:tc:xliff:document:1.2", "tools", "http://schemas.android.com/tools", "aapt", "http://schemas.android.com/aapt"};
    private final boolean myWithLocaleResources;
    private final Map<ResourceType, Set<ResourceItem>> myPublicResources;
    private Future myCacheCreatedFuture;
    private boolean myLoadedFromCache;

    private FrameworkResourceRepository(@NotNull File resFolder, boolean withLocaleResources) {
        if (resFolder == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(0);
        }
        super(resFolder, ANDROID_NAMESPACE, null);
        this.myPublicResources = new EnumMap<ResourceType, Set<ResourceItem>>(ResourceType.class);
        this.myWithLocaleResources = withLocaleResources;
    }

    @NotNull
    public static FrameworkResourceRepository create(@NotNull File resFolder, boolean withLocaleResources, boolean usePersistentCache) {
        if (resFolder == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(1);
        }
        FrameworkResourceRepository repository = new FrameworkResourceRepository(resFolder, withLocaleResources);
        if (usePersistentCache && repository.loadFromPersistentCache()) {
            FrameworkResourceRepository frameworkResourceRepository = repository;
            if (frameworkResourceRepository == null) {
                FrameworkResourceRepository.$$$reportNull$$$0(2);
            }
            return frameworkResourceRepository;
        }
        FrameworkResourceSet resourceSet = new FrameworkResourceSet(resFolder, withLocaleResources);
        try {
            LogWrapper logger = new LogWrapper(LOG).alwaysLogAsDebug(true).allowVerbose(false);
            resourceSet.loadFromFiles((ILogger)logger);
        }
        catch (DuplicateDataException e) {
            assert (false);
        }
        catch (MergingException e) {
            LOG.warn((Throwable)e);
        }
        ResourceTable resourceTable = repository.getFullTable();
        ListMultimap resourceItems = resourceSet.getDataMap();
        for (String key : resourceItems.keys()) {
            List items2 = resourceItems.get((Object)key);
            int i2 = items2.size();
            while (--i2 >= 0) {
                ResourceItem item = (ResourceItem)items2.get(i2);
                ListMultimap multimap = resourceTable.getOrPutEmpty(item.getNamespace(), item.getType());
                if (multimap.containsEntry((Object)item.getName(), (Object)item)) continue;
                multimap.put((Object)item.getName(), (Object)item);
            }
        }
        repository.assignAttrDescriptions();
        repository.assignAttrGroups();
        repository.loadPublicResources();
        if (usePersistentCache) {
            repository.createPersistentCacheAsynchronously();
        }
        FrameworkResourceRepository frameworkResourceRepository = repository;
        if (frameworkResourceRepository == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(3);
        }
        return frameworkResourceRepository;
    }

    private void createPersistentCacheAsynchronously() {
        this.myCacheCreatedFuture = ApplicationManager.getApplication().executeOnPooledThread(this::createPersistentCache);
    }

    @NotNull
    public Collection<ResourceItem> getPublicResources(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        if (namespace == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(4);
        }
        if (type == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(5);
        }
        if (!namespace.equals((Object)ANDROID_NAMESPACE)) {
            Set<ResourceItem> set = Collections.emptySet();
            if (set == null) {
                FrameworkResourceRepository.$$$reportNull$$$0(6);
            }
            return set;
        }
        Set<ResourceItem> resourceItems = this.myPublicResources.get(type);
        Set<Object> set = resourceItems == null ? Collections.emptySet() : resourceItems;
        if (set == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(7);
        }
        return set;
    }

    public boolean isPublic(@NotNull ResourceType type, @NotNull String name) {
        List items2;
        if (type == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(8);
        }
        if (name == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(9);
        }
        if ((items2 = this.getResources(ANDROID_NAMESPACE, type, name)).isEmpty()) {
            return false;
        }
        Set<ResourceItem> publicSet = this.myPublicResources.get(type);
        return publicSet != null && publicSet.contains(items2.get(0));
    }

    @NotNull
    static File getCacheFile(File resourceDir, boolean withLocaleResources) {
        String dirHash = Hashing.md5().hashUnencodedChars((CharSequence)resourceDir.getAbsolutePath()).toString();
        String filename = String.format("%s%s.bin", dirHash, withLocaleResources ? "_L" : "");
        File file = new File(new File(PathManager.getSystemPath(), CACHE_DIRECTORY), filename);
        if (file == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(10);
        }
        return file;
    }

    void waitUntilPersistentCacheCreated() throws ExecutionException, InterruptedException {
        this.myCacheCreatedFuture.get();
    }

    boolean isLoadedFromCache() {
        return this.myLoadedFromCache;
    }

    private void assignAttrDescriptions() {
        Collection items2 = this.getResources(ANDROID_NAMESPACE, ResourceType.ATTR).values();
        for (ResourceItem item : items2) {
            Node node = ((ResourceMergerItem)item).getValue();
            if (node == null) continue;
            FrameworkResourceRepository.setDescriptionAttribute(node);
            NodeList nodes = node.getChildNodes();
            int n = nodes.getLength();
            for (int i2 = 0; i2 < n; ++i2) {
                FrameworkResourceRepository.setDescriptionAttribute(nodes.item(i2));
            }
        }
    }

    private static void setDescriptionAttribute(@NotNull Node node) {
        String description;
        if (node == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(11);
        }
        if (node instanceof Element && (description = XmlUtils.getPreviousCommentText((Node)node)) != null) {
            ((Element)node).setAttribute("_description", description);
        }
    }

    private void assignAttrGroups() {
        List items2 = this.getResources(ANDROID_NAMESPACE, ResourceType.STYLEABLE, "Theme");
        if (items2.size() != 1) {
            return;
        }
        Node anchorNode = ((ResourceMergerItem)items2.get(0)).getValue();
        if (anchorNode == null) {
            return;
        }
        String groupName = null;
        Node resourcesNode = anchorNode.getParentNode();
        ArrayDeque<Node> queue = new ArrayDeque<Node>();
        FrameworkResourceRepository.insertChildrenInQueue(resourcesNode, queue);
        while (!queue.isEmpty()) {
            Node node = (Node)queue.removeFirst();
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            switch (element.getTagName()) {
                case "declare-styleable": {
                    FrameworkResourceRepository.insertChildrenInQueue(element, queue);
                    break;
                }
                case "eat-comment": {
                    String newAttrGroup = FrameworkResourceRepository.getCommentBeforeEatComment(element);
                    if (newAttrGroup == null || newAttrGroup.length() > 40 || newAttrGroup.startsWith("TODO:")) break;
                    groupName = newAttrGroup;
                    break;
                }
                case "attr": {
                    if (groupName == null) break;
                    if (groupName.endsWith(".")) {
                        groupName = groupName.substring(0, groupName.length() - 1);
                    }
                    element.setAttribute("_groupName", groupName);
                }
            }
        }
    }

    private static void insertChildrenInQueue(@NotNull Node node, @NotNull Deque<Node> queue) {
        if (node == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(12);
        }
        if (queue == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(13);
        }
        NodeList nodes = node.getChildNodes();
        int i2 = nodes.getLength();
        while (--i2 >= 0) {
            queue.addFirst(nodes.item(i2));
        }
    }

    @Nullable
    private static String getCommentBeforeEatComment(@NotNull Node eatCommentElement) {
        if (eatCommentElement == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(14);
        }
        Comment comment = XmlUtils.getPreviousComment((Node)eatCommentElement);
        for (int i2 = 0; i2 < 2 && comment != null; ++i2) {
            String text = StringUtil.trim((String)comment.getNodeValue());
            if (!StringUtil.isEmpty((String)text) && text.charAt(0) != '=' && text.charAt(0) != '*') {
                return text;
            }
            comment = XmlUtils.getPreviousComment((Node)comment);
        }
        return null;
    }

    private void loadPublicResources() {
        File valuesFolder = new File(this.getResourceDirectory(), "values");
        File publicXmlFile = new File(valuesFolder, "public.xml");
        try (BufferedInputStream stream2 = new BufferedInputStream(new FileInputStream(publicXmlFile));){
            KXmlParser parser = new KXmlParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
            parser.setInput((InputStream)stream2, StandardCharsets.UTF_8.name());
            ResourceType lastType = null;
            String lastTypeName = "";
            while (true) {
                int event;
                if ((event = parser.next()) == 2) {
                    ResourceType type;
                    if (!parser.getName().equals("public")) continue;
                    String name = null;
                    String typeName = null;
                    int n = parser.getAttributeCount();
                    for (int i2 = 0; i2 < n; ++i2) {
                        String attribute = parser.getAttributeName(i2);
                        if (attribute.equals("name")) {
                            name = parser.getAttributeValue(i2);
                            if (typeName == null) continue;
                            break;
                        }
                        if (!attribute.equals("type")) continue;
                        typeName = parser.getAttributeValue(i2);
                    }
                    if (name == null || typeName == null) continue;
                    if (typeName.equals(lastTypeName)) {
                        type = lastType;
                    } else {
                        lastType = type = ResourceType.fromXmlValue((String)typeName);
                        lastTypeName = typeName;
                    }
                    if (type != null) {
                        List matchingResources = this.getResources(ANDROID_NAMESPACE, type, name);
                        if (matchingResources.isEmpty()) continue;
                        THashSet publicSet = this.myPublicResources.get(type);
                        if (publicSet == null) {
                            publicSet = ContainerUtil.newIdentityTroveSet();
                            this.myPublicResources.put(type, (Set<ResourceItem>)publicSet);
                        }
                        publicSet.addAll(matchingResources);
                        continue;
                    }
                    LOG.error("Public resource declaration \"" + name + "\" of type " + typeName + " points to unknown resource type.");
                    continue;
                }
                if (event == 1) break;
            }
        }
        catch (FileNotFoundException stream2) {
        }
        catch (Exception e) {
            LOG.error("Can't read and parse public attribute list " + publicXmlFile.getPath(), (Throwable)e);
        }
        for (ResourceType type : ResourceType.values()) {
            Set<Object> items2 = this.myPublicResources.get(type);
            items2 = items2 == null ? Collections.emptySet() : Collections.unmodifiableSet(items2);
            this.myPublicResources.put(type, items2);
        }
    }

    @Override
    @NotNull
    protected ListMultimap<String, ResourceItem> getMap(@NotNull ResourceNamespace namespace, @NotNull ResourceType type, boolean create2) {
        if (namespace == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(15);
        }
        if (type == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(16);
        }
        if (!ANDROID_NAMESPACE.equals((Object)namespace)) {
            if (create2) {
                throw new IllegalArgumentException("Invalid namespace: " + namespace);
            }
            ImmutableListMultimap immutableListMultimap = ImmutableListMultimap.of();
            if (immutableListMultimap == null) {
                FrameworkResourceRepository.$$$reportNull$$$0(17);
            }
            return immutableListMultimap;
        }
        ListMultimap<String, ResourceItem> listMultimap = this.getMap(type, create2);
        if (listMultimap == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(18);
        }
        return listMultimap;
    }

    @NotNull
    private ListMultimap<String, ResourceItem> getMap(@NotNull ResourceType type, boolean create2) {
        ListMultimap<String, ResourceItem> map2;
        if (type == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(19);
        }
        ListMultimap<String, ResourceItem> listMultimap = (map2 = super.getMap(ANDROID_NAMESPACE, type, create2)) == null ? ImmutableListMultimap.of() : map2;
        if (listMultimap == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(20);
        }
        return listMultimap;
    }

    @NotNull
    public Set<ResourceType> getResourceTypes(@NotNull ResourceNamespace namespace) {
        if (namespace == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(21);
        }
        ImmutableSet immutableSet = namespace == ANDROID_NAMESPACE ? Sets.immutableEnumSet(this.getMapByType().keySet()) : ImmutableSet.of();
        if (immutableSet == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(22);
        }
        return immutableSet;
    }

    public boolean isWithLocaleResources() {
        return this.myWithLocaleResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadFromPersistentCache() {
        File cacheFile = this.getCacheFile();
        if (!cacheFile.exists()) {
            return false;
        }
        try (CacheInputStream in = new CacheInputStream(cacheFile);){
            if (!in.readUTF().equals(this.getResourceDirectory().getAbsolutePath())) {
                boolean bl = false;
                return bl;
            }
            if (!in.readUTF().equals(FrameworkResourceRepository.getAndroidPluginVersion())) {
                boolean bl = false;
                return bl;
            }
            int numFolderConfigurations = in.readUnsignedShort();
            FolderConfiguration[] folderConfigurations = new FolderConfiguration[numFolderConfigurations];
            for (int i2 = 0; i2 < numFolderConfigurations; ++i2) {
                String qualifiers = in.readUTF();
                FolderConfiguration folderConfig = FolderConfiguration.getConfigForQualifierString((String)qualifiers);
                if (folderConfig == null) {
                    throw new StreamCorruptedException("Invalid folder qualifiers: " + qualifiers);
                }
                folderConfigurations[i2] = folderConfig;
            }
            int numFiles = in.readUnsignedShort();
            ResourceFile[] resourceFiles = new ResourceFile[numFiles];
            for (int i3 = 0; i3 < numFiles; ++i3) {
                String path = in.readUTF();
                int folderConfigurationIndex = in.readUnsignedShort();
                FolderConfiguration folderConfig = folderConfigurations[folderConfigurationIndex];
                resourceFiles[i3] = new ResourceFile(new File(path), Collections.emptyList(), folderConfig);
            }
            int numTypes = in.readUnsignedByte();
            for (int i4 = 0; i4 < numTypes; ++i4) {
                ResourceType resourceType = in.readResourceType();
                ListMultimap<String, ResourceItem> map2 = this.getMap(resourceType, true);
                int numResources = in.readUnsignedShort();
                for (int j = 0; j < numResources; ++j) {
                    String resourceName = in.readUTF();
                    int n = in.readUnsignedShort();
                    for (int k = 0; k < n; ++k) {
                        Node node = in.readNode();
                        ResourceItemType itemType = ResourceItemType.values()[in.readUnsignedByte()];
                        ResourceMergerItem item = null;
                        switch (itemType) {
                            case VALUE: {
                                item = new ResourceMergerItem(resourceName, ANDROID_NAMESPACE, resourceType, node, null);
                                int fileIndex = in.readUnsignedShort();
                                ResourceFile resourceFile = resourceFiles[fileIndex];
                                resourceFile.addItem((DataItem)item);
                                break;
                            }
                            case FILE: {
                                item = new ResourceMergerItem(resourceName, ANDROID_NAMESPACE, resourceType, node, null);
                                int folderConfigurationIndex = in.readUnsignedShort();
                                FolderConfiguration folderConfig = folderConfigurations[folderConfigurationIndex];
                                String path = in.readUTF();
                                new ResourceFile(new File(path), item, folderConfig);
                                break;
                            }
                        }
                        if (item == null) continue;
                        map2.put((Object)resourceName, item);
                    }
                }
            }
            int numPublic = in.readUnsignedByte();
            for (int i5 = 0; i5 < numPublic; ++i5) {
                ResourceType resourceType = in.readResourceType();
                ListMultimap<String, ResourceItem> map3 = this.getMap(resourceType, false);
                int m = in.readUnsignedShort();
                for (int j = 0; j < m; ++j) {
                    String resourceName = in.readUTF();
                    List items2 = map3.get((Object)resourceName);
                    if (items2 == null) {
                        throw new StreamCorruptedException("Unresolved public resource reference, type: " + resourceType.getName() + ", name: " + resourceName);
                    }
                    THashSet publicItems = this.myPublicResources.get(resourceType);
                    if (publicItems == null) {
                        publicItems = ContainerUtil.newIdentityTroveSet((int)items2.size());
                        this.myPublicResources.put(resourceType, (Set<ResourceItem>)publicItems);
                    }
                    publicItems.addAll(items2);
                }
            }
            this.myLoadedFromCache = true;
        }
        catch (VersionMismatchException e) {
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            LOG.warn("Unable to load from cache file " + cacheFile.getAbsolutePath(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (!this.myLoadedFromCache) {
                this.getMapByType().clear();
            }
        }
        return true;
    }

    private void createPersistentCache() {
        File tempFile;
        File cacheFile = this.getCacheFile();
        cacheFile.delete();
        try {
            tempFile = FileUtilRt.createTempFile((File)cacheFile.getParentFile(), (String)cacheFile.getName(), (String)".tmp");
        }
        catch (IOException e) {
            LOG.error("Unable to create a temporary file in " + cacheFile.getParentFile().getAbsolutePath(), (Throwable)e);
            return;
        }
        try (CacheOutputStream out = new CacheOutputStream(tempFile);){
            ResourceType resourceType;
            out.writeUTF(this.getResourceDirectory().getAbsolutePath());
            out.writeUTF(FrameworkResourceRepository.getAndroidPluginVersion());
            ArrayList<FolderConfiguration> folderConfigurations = new ArrayList<FolderConfiguration>();
            ObjectIntHashMap folderConfigurationIndexes = new ObjectIntHashMap();
            ArrayList<ResourceFile> multiResourceFiles = new ArrayList<ResourceFile>();
            ObjectIntHashMap multiResourceFileIndexes = new ObjectIntHashMap();
            Map<ResourceType, ListMultimap<String, ResourceItem>> mapByType = this.getMapByType();
            for (ListMultimap<String, ResourceItem> map2 : mapByType.values()) {
                for (ResourceItem resourceItem : map2.values()) {
                    File file;
                    ResourceFile resourceFile;
                    ResourceMergerItem resourceMergerItem = (ResourceMergerItem)resourceItem;
                    FolderConfiguration folderConfiguration = resourceItem.getConfiguration();
                    if (!folderConfigurationIndexes.containsKey((Object)folderConfiguration)) {
                        folderConfigurationIndexes.put((Object)folderConfiguration, folderConfigurations.size());
                        folderConfigurations.add(folderConfiguration);
                    }
                    if (resourceMergerItem.getSourceType() == DataFile.FileType.SINGLE_FILE || (resourceFile = (ResourceFile)resourceMergerItem.getSourceFile()) == null || multiResourceFileIndexes.containsKey((Object)(file = resourceFile.getFile()))) continue;
                    multiResourceFileIndexes.put((Object)file, multiResourceFiles.size());
                    multiResourceFiles.add(resourceFile);
                }
            }
            if (folderConfigurations.size() > 65535) {
                throw new IOException("Too many folder configurations: " + folderConfigurations.size());
            }
            out.writeShort(folderConfigurations.size());
            for (FolderConfiguration config : folderConfigurations) {
                out.writeUTF(config.getQualifierString());
            }
            if (multiResourceFiles.size() > 65535) {
                throw new IOException("Too many multi-resource files: " + multiResourceFiles.size());
            }
            out.writeShort(multiResourceFiles.size());
            for (ResourceFile resourceFile : multiResourceFiles) {
                out.writeUTF(resourceFile.getFile().getPath());
                int folderConfigurationIndex = folderConfigurationIndexes.get((Object)resourceFile.getFolderConfiguration());
                out.writeShort(folderConfigurationIndex);
            }
            Set<Map.Entry<ResourceType, ListMultimap<String, ResourceItem>>> typeEntries = mapByType.entrySet();
            int numNonEmpty = 0;
            for (Map.Entry<ResourceType, ListMultimap<String, ResourceItem>> entry : typeEntries) {
                if (entry.getValue().isEmpty()) continue;
                ++numNonEmpty;
            }
            out.writeByte(numNonEmpty);
            for (Map.Entry<ResourceType, ListMultimap<String, ResourceItem>> entry : typeEntries) {
                ListMultimap<String, ResourceItem> multimap = entry.getValue();
                if (multimap.isEmpty()) continue;
                resourceType = entry.getKey();
                out.writeResourceType(resourceType);
                Map resources = multimap.asMap();
                if (resources.size() > 65535) {
                    throw new IOException("Too many resources of type " + resourceType.getName() + ": " + resources.size());
                }
                out.writeShort(resources.size());
                for (Map.Entry itemEntry : resources.entrySet()) {
                    String resourceName = (String)itemEntry.getKey();
                    Collection resourceItems = (Collection)itemEntry.getValue();
                    out.writeUTF(resourceName);
                    if (resources.size() > 65535) {
                        throw new IOException("Too many resources items: " + resourceItems.size());
                    }
                    out.writeShort(resourceItems.size());
                    for (ResourceItem resourceItem : resourceItems) {
                        ResourceMergerItem resourceMergerItem = (ResourceMergerItem)resourceItem;
                        out.writeNode(resourceMergerItem.getValue());
                        ResourceFile resourceFile = (ResourceFile)resourceMergerItem.getSourceFile();
                        assert (resourceFile != null);
                        ResourceItemType itemType = resourceItem.isFileBased() ? ResourceItemType.FILE : ResourceItemType.VALUE;
                        out.writeByte(itemType.ordinal());
                        if (itemType == ResourceItemType.VALUE) {
                            out.writeShort(multiResourceFileIndexes.get((Object)resourceFile.getFile()));
                            continue;
                        }
                        int folderConfigurationIndex = folderConfigurationIndexes.get((Object)resourceItem.getConfiguration());
                        out.writeShort(folderConfigurationIndex);
                        out.writeUTF(resourceFile.getFile().getPath());
                    }
                }
            }
            numNonEmpty = 0;
            for (Map.Entry<ResourceType, Object> entry : this.myPublicResources.entrySet()) {
                if (((Set)entry.getValue()).isEmpty()) continue;
                ++numNonEmpty;
            }
            out.writeByte(numNonEmpty);
            for (Map.Entry<ResourceType, Object> entry : this.myPublicResources.entrySet()) {
                Set resourceItems = (Set)entry.getValue();
                if (resourceItems.isEmpty()) continue;
                resourceType = entry.getKey();
                out.writeResourceType(resourceType);
                LinkedHashSet uniqueNames = Sets.newLinkedHashSetWithExpectedSize((int)resourceItems.size());
                for (ResourceItem item : resourceItems) {
                    uniqueNames.add(item.getName());
                }
                if (uniqueNames.size() > 65535) {
                    throw new IOException("Too many public resources of type " + resourceType.getName() + ": " + uniqueNames.size());
                }
                out.writeShort(uniqueNames.size());
                for (String name : uniqueNames) {
                    out.writeUTF(name);
                }
            }
        }
        catch (Throwable e) {
            LOG.error("Unable to create cache file " + tempFile.getAbsolutePath(), e);
            tempFile.delete();
            return;
        }
        try {
            Files.move(tempFile.toPath(), cacheFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (NoSuchFileException e) {
        }
        catch (IOException e) {
            LOG.error("Unable to create cache file " + cacheFile.getAbsolutePath(), (Throwable)e);
            tempFile.delete();
        }
    }

    @NotNull
    private Map<ResourceType, ListMultimap<String, ResourceItem>> getMapByType() {
        Map map2 = this.getFullTable().row((Object)ANDROID_NAMESPACE);
        if (map2 == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(23);
        }
        return map2;
    }

    @NotNull
    private File getCacheFile() {
        File file = FrameworkResourceRepository.getCacheFile(this.getResourceDirectory(), this.myWithLocaleResources);
        if (file == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(24);
        }
        return file;
    }

    @NotNull
    private static String getAndroidPluginVersion() {
        IdeaPluginDescriptor plugin = PluginManager.getPlugin((PluginId)PluginId.getId((String)ANDROID_PLUGIN_ID));
        if (plugin == null) {
            if ("unknown" == null) {
                FrameworkResourceRepository.$$$reportNull$$$0(25);
            }
            return "unknown";
        }
        String string = plugin.getVersion();
        if (string == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    private static UnsupportedOperationException createAndLogUnsupportedOperationException() {
        UnsupportedOperationException exception = new UnsupportedOperationException();
        LOG.error("Unsupported operation in FrameworkResourceRepository", (Throwable)exception);
        UnsupportedOperationException unsupportedOperationException = exception;
        if (unsupportedOperationException == null) {
            FrameworkResourceRepository.$$$reportNull$$$0(27);
        }
        return unsupportedOperationException;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resFolder";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/FrameworkResourceRepository";
                break;
            }
            case 4: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 5: 
            case 8: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eatCommentElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/FrameworkResourceRepository";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublicResources";
                break;
            }
            case 10: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getCacheFile";
                break;
            }
            case 17: 
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getMap";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceTypes";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getMapByType";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidPluginVersion";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndLogUnsupportedOperationException";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPublicResources";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isPublic";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setDescriptionAttribute";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "insertChildrenInQueue";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCommentBeforeEatComment";
                break;
            }
            case 15: 
            case 16: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getMap";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getResourceTypes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ResourceItemType {
        VALUE,
        FILE;

    }

    private static abstract class NodeImpl
    implements Node {
        static final NodeList EMPTY_NODE_LIST = new NodeList(){

            @Override
            public Node item(int index) {
                return null;
            }

            @Override
            public int getLength() {
                return 0;
            }
        };

        private NodeImpl() {
        }

        @Override
        public String getNodeName() {
            return null;
        }

        @Override
        public NamedNodeMap getAttributes() {
            return null;
        }

        @Override
        public boolean hasAttributes() {
            return false;
        }

        @Override
        public NodeList getChildNodes() {
            return EMPTY_NODE_LIST;
        }

        @Override
        public boolean hasChildNodes() {
            return this.getChildNodes().getLength() != 0;
        }

        @Override
        public String getLocalName() {
            return null;
        }

        @Override
        public String getPrefix() {
            return null;
        }

        @Override
        public String getNamespaceURI() {
            return null;
        }

        @Override
        public String getNodeValue() throws DOMException {
            return null;
        }

        @Override
        public void setNodeValue(String nodeValue) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public Node getParentNode() {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public Node getFirstChild() {
            NodeList children = this.getChildNodes();
            return children.getLength() != 0 ? children.item(0) : null;
        }

        @Override
        public Node getLastChild() {
            NodeList children = this.getChildNodes();
            int length = children.getLength();
            return length != 0 ? children.item(length - 1) : null;
        }

        @Override
        public Node getPreviousSibling() {
            return null;
        }

        @Override
        public Node getNextSibling() {
            return null;
        }

        @Override
        public Document getOwnerDocument() {
            return null;
        }

        @Override
        public Node insertBefore(Node newChild, Node refChild) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public Node removeChild(Node oldChild) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public Node appendChild(Node newChild) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public Node cloneNode(boolean deep) {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public void normalize() {
        }

        @Override
        public boolean isSupported(String feature, String version2) {
            return false;
        }

        @Override
        public void setPrefix(String prefix) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public String getBaseURI() {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public short compareDocumentPosition(Node other) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public String getTextContent() throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public void setTextContent(String textContent) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public boolean isSameNode(Node other) {
            return this == other;
        }

        @Override
        public String lookupPrefix(String namespaceUri) {
            for (int i2 = 1; i2 < WELL_KNOWN_NAMESPACES.length; i2 += 2) {
                if (!WELL_KNOWN_NAMESPACES[i2].equals(namespaceUri)) continue;
                return WELL_KNOWN_NAMESPACES[i2 - 1];
            }
            throw new IllegalStateException("Unknown namespace URI: \"" + namespaceUri + "\"");
        }

        @Override
        public boolean isDefaultNamespace(String namespaceUri) {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public String lookupNamespaceURI(String prefix) {
            for (int i2 = 0; i2 < WELL_KNOWN_NAMESPACES.length; i2 += 2) {
                if (!WELL_KNOWN_NAMESPACES[i2].equals(prefix)) continue;
                return WELL_KNOWN_NAMESPACES[i2 + 1];
            }
            throw new IllegalStateException("Unknown namespace prefix: \"" + prefix + "\"");
        }

        @Override
        public boolean isEqualNode(Node other) {
            return this == other;
        }

        @Override
        public Object getFeature(String feature, String version2) {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public Object setUserData(String key, Object data, UserDataHandler handler) {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public Object getUserData(String key) {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }
    }

    private static abstract class NamedNodeImpl
    extends NodeImpl {
        @NotNull
        private final String myName;

        private NamedNodeImpl(@NotNull String name) {
            if (name == null) {
                NamedNodeImpl.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        @Override
        public final String getNodeName() {
            return this.myName;
        }

        @Override
        public String getLocalName() {
            int colonPos = this.myName.lastIndexOf(58);
            if (colonPos < 0) {
                return this.myName;
            }
            return this.myName.substring(colonPos + 1);
        }

        @Override
        public final String getPrefix() {
            int colonPos = this.myName.indexOf(58);
            if (colonPos < 0) {
                return null;
            }
            return this.myName.substring(0, colonPos);
        }

        @Override
        public final String getNamespaceURI() {
            int colonPos = this.myName.indexOf(58);
            if (colonPos < 0) {
                return null;
            }
            for (int i2 = 0; i2 < WELL_KNOWN_NAMESPACES.length; i2 += 2) {
                String prefix = WELL_KNOWN_NAMESPACES[i2];
                if (prefix.length() != colonPos || !this.myName.startsWith(prefix)) continue;
                return WELL_KNOWN_NAMESPACES[i2 + 1];
            }
            throw new IllegalStateException("Unknown namespace prefix: \"" + this.myName.substring(0, colonPos) + "\"");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/res/FrameworkResourceRepository$NamedNodeImpl", "<init>"));
        }
    }

    private static final class TextImpl
    extends NodeImpl
    implements Text {
        @NotNull
        private final String myText;

        private TextImpl(@NotNull String text) {
            if (text == null) {
                TextImpl.$$$reportNull$$$0(0);
            }
            this.myText = text;
        }

        @Override
        public short getNodeType() {
            return 3;
        }

        @Override
        public String getNodeValue() throws DOMException {
            return this.myText;
        }

        @Override
        public String getWholeText() {
            return this.myText;
        }

        @Override
        public int getLength() {
            return this.myText.length();
        }

        @Override
        public String substringData(int offset, int count) throws DOMException {
            return this.myText.substring(offset, offset + count);
        }

        @Override
        public Text splitText(int offset) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public boolean isElementContentWhitespace() {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public Text replaceWholeText(String content) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public String getData() throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public void setData(String data) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public void appendData(String arg) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public void insertData(int offset, String arg) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public void deleteData(int offset, int count) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public void replaceData(int offset, int count, String arg) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/res/FrameworkResourceRepository$TextImpl", "<init>"));
        }
    }

    private static final class AttrImpl
    extends NamedNodeImpl
    implements Attr {
        @NotNull
        private final String myValue;

        private AttrImpl(@NotNull String name, @NotNull String value2) {
            if (name == null) {
                AttrImpl.$$$reportNull$$$0(0);
            }
            if (value2 == null) {
                AttrImpl.$$$reportNull$$$0(1);
            }
            super(name);
            this.myValue = value2;
        }

        @Override
        public short getNodeType() {
            return 2;
        }

        @Override
        public String getName() {
            return this.getNodeName();
        }

        @Override
        @NotNull
        public String getValue() {
            String string = this.myValue;
            if (string == null) {
                AttrImpl.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public String getNodeValue() {
            String string = this.myValue;
            if (string == null) {
                AttrImpl.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public void setValue(String value2) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public boolean getSpecified() {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public Element getOwnerElement() {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public TypeInfo getSchemaTypeInfo() {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public boolean isId() {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/res/FrameworkResourceRepository$AttrImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/res/FrameworkResourceRepository$AttrImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class NamedNodeMapImpl
    implements NamedNodeMap {
        @NotNull
        private final List<Node> myNodes;

        private NamedNodeMapImpl(@NotNull List<Node> nodes) {
            if (nodes == null) {
                NamedNodeMapImpl.$$$reportNull$$$0(0);
            }
            this.myNodes = nodes;
        }

        @Override
        public Node getNamedItem(String name) {
            for (int i2 = 0; i2 < this.myNodes.size(); ++i2) {
                Node node = this.myNodes.get(i2);
                if (!node.getNodeName().equals(name)) continue;
                return node;
            }
            return null;
        }

        @Override
        public Node item(int index) {
            return this.myNodes.get(index);
        }

        @Override
        public int getLength() {
            return this.myNodes.size();
        }

        @Override
        public Node getNamedItemNS(String namespaceUri, String localName) throws DOMException {
            for (int i2 = 0; i2 < this.myNodes.size(); ++i2) {
                int offset;
                Node node = this.myNodes.get(i2);
                String name = node.getNodeName();
                int colonPos = name.indexOf(58);
                if (colonPos < 0) {
                    if (namespaceUri != null) continue;
                    offset = 0;
                } else {
                    if (namespaceUri == null) continue;
                    offset = colonPos + 1;
                }
                if (name.length() != offset + localName.length() || !name.regionMatches(offset, localName, 0, localName.length())) continue;
                return node;
            }
            return null;
        }

        @Override
        public Node setNamedItem(Node arg) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public Node removeNamedItem(String name) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public Node setNamedItemNS(Node arg) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public Node removeNamedItemNS(String namespaceUri, String localName) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/android/tools/idea/res/FrameworkResourceRepository$NamedNodeMapImpl", "<init>"));
        }
    }

    private static final class ElementImpl
    extends NamedNodeImpl
    implements Element,
    NodeList {
        @NotNull
        private final NamedNodeMap myAttributeMap;
        @NotNull
        private final List<Node> myChildren;

        private ElementImpl(@NotNull String name, @NotNull NamedNodeMap attributeMap, @NotNull List<Node> children) {
            if (name == null) {
                ElementImpl.$$$reportNull$$$0(0);
            }
            if (attributeMap == null) {
                ElementImpl.$$$reportNull$$$0(1);
            }
            if (children == null) {
                ElementImpl.$$$reportNull$$$0(2);
            }
            super(name);
            this.myAttributeMap = attributeMap;
            this.myChildren = children;
        }

        @Override
        public short getNodeType() {
            return 1;
        }

        @Override
        public String getTagName() {
            return this.getNodeName();
        }

        @Override
        public NamedNodeMap getAttributes() {
            return this.myAttributeMap;
        }

        @Override
        public String getAttribute(String name) {
            return this.myAttributeMap.getNamedItem(name).getNodeValue();
        }

        @Override
        public Attr getAttributeNode(String name) {
            return (Attr)this.myAttributeMap.getNamedItem(name);
        }

        @Override
        public String getAttributeNS(String namespaceUri, String localName) throws DOMException {
            return this.myAttributeMap.getNamedItemNS(namespaceUri, localName).getNodeValue();
        }

        @Override
        public Attr getAttributeNodeNS(String namespaceUri, String localName) throws DOMException {
            return (Attr)this.myAttributeMap.getNamedItemNS(namespaceUri, localName);
        }

        @Override
        public boolean hasAttribute(String name) {
            return this.myAttributeMap.getNamedItem(name) != null;
        }

        @Override
        public boolean hasAttributeNS(String namespaceUri, String localName) throws DOMException {
            return this.myAttributeMap.getNamedItemNS(namespaceUri, localName) != null;
        }

        @Override
        public NodeList getChildNodes() {
            return this;
        }

        @Override
        public void setAttribute(String name, String value2) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public void removeAttribute(String name) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public Attr setAttributeNode(Attr newAttr) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public NodeList getElementsByTagName(String name) {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public void setAttributeNS(String namespaceUri, String qualifiedName, String value2) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public void removeAttributeNS(String namespaceUri, String localName) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public NodeList getElementsByTagNameNS(String namespaceUri, String localName) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public TypeInfo getSchemaTypeInfo() {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public void setIdAttribute(String name, boolean isId) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public void setIdAttributeNS(String namespaceUri, String localName, boolean isId) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
            throw FrameworkResourceRepository.createAndLogUnsupportedOperationException();
        }

        @Override
        public Node item(int index) {
            return index < this.myChildren.size() ? this.myChildren.get(index) : null;
        }

        @Override
        public int getLength() {
            return this.myChildren.size();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "attributeMap";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "children";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/res/FrameworkResourceRepository$ElementImpl";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FrameworkResourceSet
    extends ResourceSet {
        private final boolean myWithLocaleResources;

        FrameworkResourceSet(@NotNull File resourceFolder, boolean withLocaleResources) {
            if (resourceFolder == null) {
                FrameworkResourceSet.$$$reportNull$$$0(0);
            }
            super("AndroidFramework", ANDROID_NAMESPACE, null, false);
            this.myWithLocaleResources = withLocaleResources;
            this.addSource(resourceFolder);
            this.setShouldParseResourceIds(true);
            this.setTrackSourcePositions(false);
            this.setCheckDuplicates(false);
        }

        public boolean isIgnored(@NotNull File file) {
            FolderConfiguration config;
            if (file == null) {
                FrameworkResourceSet.$$$reportNull$$$0(1);
            }
            if (super.isIgnored(file)) {
                return true;
            }
            String fileName = file.getName();
            if (fileName.startsWith("values-mcc") || fileName.startsWith("raw-")) {
                return true;
            }
            if (!this.myWithLocaleResources && fileName.startsWith("values-") && ((config = FolderConfiguration.getConfigForFolder((String)fileName)) == null || config.getLocaleQualifier() != null)) {
                return true;
            }
            return fileName.equals("public.xml") || fileName.equals("symbols.xml");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourceFolder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/res/FrameworkResourceRepository$FrameworkResourceSet";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isIgnored";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class VersionMismatchException
    extends IOException {
        private VersionMismatchException() {
        }
    }

    private static class CacheInputStream
    extends ObjectInputStream {
        CacheInputStream(@NotNull File file) throws IOException {
            if (file == null) {
                CacheInputStream.$$$reportNull$$$0(0);
            }
            super(new BufferedInputStream(new FileInputStream(file)));
        }

        @Override
        protected void readStreamHeader() throws IOException {
            int i2;
            for (i2 = 0; i2 < FrameworkResourceRepository.CACHE_FILE_HEADER.length(); ++i2) {
                if (this.readUnsignedByte() == FrameworkResourceRepository.CACHE_FILE_HEADER.charAt(i2)) continue;
                throw new StreamCorruptedException();
            }
            if (this.readUnsignedByte() != 32) {
                throw new StreamCorruptedException();
            }
            for (i2 = 0; i2 < FrameworkResourceRepository.CACHE_FILE_FORMAT_VERSION.length(); ++i2) {
                if (this.readUnsignedByte() == FrameworkResourceRepository.CACHE_FILE_FORMAT_VERSION.charAt(i2)) continue;
                throw new VersionMismatchException();
            }
            if (this.readUnsignedByte() != 32) {
                throw new VersionMismatchException();
            }
        }

        @NotNull
        ResourceType readResourceType() throws IOException {
            ResourceType resourceType;
            int ordinal = this.readUnsignedByte();
            try {
                resourceType = ResourceType.values()[ordinal];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new StreamCorruptedException("Invalid resource type reference: " + ordinal);
            }
            if (resourceType == null) {
                CacheInputStream.$$$reportNull$$$0(1);
            }
            return resourceType;
        }

        @NotNull
        Attr readAttribute() throws IOException {
            String name = this.readUTF();
            String value2 = this.readUTF();
            AttrImpl attrImpl = new AttrImpl(name, value2);
            if (attrImpl == null) {
                CacheInputStream.$$$reportNull$$$0(2);
            }
            return attrImpl;
        }

        @Nullable
        Node readNode() throws IOException {
            int nodeType = this.readUnsignedByte();
            switch (nodeType) {
                case 0: {
                    return null;
                }
                case 1: {
                    String name = this.readUTF();
                    int numAttributes = this.readUnsignedByte();
                    ArrayList<Attr> attributes = new ArrayList<Attr>(numAttributes);
                    for (int i2 = 0; i2 < numAttributes; ++i2) {
                        attributes.add(this.readAttribute());
                    }
                    NamedNodeMapImpl attributeMap = new NamedNodeMapImpl(attributes);
                    int numChildren = this.readUnsignedShort();
                    ArrayList<Node> children = numChildren == 0 ? Collections.emptyList() : new ArrayList<Node>(numChildren);
                    for (int i3 = 0; i3 < numChildren; ++i3) {
                        Node child = this.readNode();
                        children.add(child);
                    }
                    return new ElementImpl(name, attributeMap, children);
                }
                case 3: {
                    String text = this.readUTF();
                    return new TextImpl(text);
                }
            }
            throw new RuntimeException("Unexpected node type: " + nodeType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/res/FrameworkResourceRepository$CacheInputStream";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/res/FrameworkResourceRepository$CacheInputStream";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readResourceType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readAttribute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CacheOutputStream
    extends ObjectOutputStream {
        CacheOutputStream(@NotNull File file) throws IOException {
            if (file == null) {
                CacheOutputStream.$$$reportNull$$$0(0);
            }
            super(new BufferedOutputStream(new FileOutputStream(file)));
        }

        @Override
        protected void writeStreamHeader() throws IOException {
            int i2;
            for (i2 = 0; i2 < FrameworkResourceRepository.CACHE_FILE_HEADER.length(); ++i2) {
                this.writeByte(FrameworkResourceRepository.CACHE_FILE_HEADER.charAt(i2));
            }
            this.writeByte(32);
            for (i2 = 0; i2 < FrameworkResourceRepository.CACHE_FILE_FORMAT_VERSION.length(); ++i2) {
                this.writeByte(FrameworkResourceRepository.CACHE_FILE_FORMAT_VERSION.charAt(i2));
            }
            this.writeByte(32);
        }

        void writeResourceType(@NotNull ResourceType type) throws IOException {
            if (type == null) {
                CacheOutputStream.$$$reportNull$$$0(1);
            }
            this.writeByte(type.ordinal());
        }

        void writeAttribute(@NotNull Attr attribute) throws IOException {
            if (attribute == null) {
                CacheOutputStream.$$$reportNull$$$0(2);
            }
            this.writeUTF(attribute.getName());
            this.writeUTF(attribute.getValue());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeNode(@Nullable Node node) throws IOException {
            if (node == null) {
                this.writeByte(0);
            } else {
                Document document = node.getOwnerDocument();
                synchronized (document) {
                    short nodeType = node.getNodeType();
                    this.writeByte(nodeType);
                    if (nodeType == 1) {
                        int i2;
                        this.writeUTF(node.getNodeName());
                        NamedNodeMap attributes = node.getAttributes();
                        int numAttributes = attributes.getLength();
                        if (numAttributes > 255) {
                            throw new IOException("XML node " + node.getNodeName() + " has too many attributes: " + numAttributes);
                        }
                        this.writeByte(numAttributes);
                        for (int i3 = 0; i3 < numAttributes; ++i3) {
                            this.writeAttribute((Attr)attributes.item(i3));
                        }
                        NodeList children = node.getChildNodes();
                        int numChildren = children.getLength();
                        if (numChildren > 65535) {
                            throw new IOException("XML node " + node.getNodeName() + " has too many children: " + numChildren);
                        }
                        int numSignificantChildren = numChildren;
                        for (i2 = 0; i2 < numChildren; ++i2) {
                            if (children.item(i2).getNodeType() != 8) continue;
                            --numSignificantChildren;
                        }
                        this.writeShort(numSignificantChildren);
                        for (i2 = 0; i2 < numChildren; ++i2) {
                            Node child = children.item(i2);
                            if (child.getNodeType() == 8) continue;
                            this.writeNode(child);
                        }
                    } else if (nodeType == 3) {
                        this.writeUTF(node.getNodeValue());
                    } else {
                        throw new RuntimeException("Unsupported XML node type: " + nodeType);
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attribute";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/res/FrameworkResourceRepository$CacheOutputStream";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeResourceType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeAttribute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

