/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.util.PathString;
import com.android.tools.idea.res.aar.ProtoXmlPullParser;
import com.android.utils.XmlUtils;
import com.google.common.io.ByteStreams;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FileResourceReader {
    @NotNull
    public static byte[] readBytes(@NotNull PathString resourcePath) throws IOException {
        String scheme;
        if (resourcePath == null) {
            FileResourceReader.$$$reportNull$$$0(0);
        }
        switch (scheme = resourcePath.getFilesystemUri().getScheme()) {
            case "file": {
                byte[] byArray = FileResourceReader.readFileBytes(resourcePath.getRawPath());
                if (byArray == null) {
                    FileResourceReader.$$$reportNull$$$0(1);
                }
                return byArray;
            }
            case "apk": {
                String path = resourcePath.getRawPath();
                int separatorPos = path.indexOf("!/");
                int separatorEnd = separatorPos + "!/".length();
                if (separatorPos <= 0 || separatorEnd == path.length()) {
                    throw new IllegalArgumentException("Invalid path in \"" + resourcePath + "\"");
                }
                byte[] byArray = FileResourceReader.readZipEntryBytes(path.substring(0, separatorPos), path.substring(separatorEnd));
                if (byArray == null) {
                    FileResourceReader.$$$reportNull$$$0(2);
                }
                return byArray;
            }
        }
        throw new IllegalArgumentException("Unknown schema in \"" + resourcePath + "\"");
    }

    @NotNull
    public static byte[] readBytes(@NotNull String resourcePath) throws IOException {
        if (resourcePath == null) {
            FileResourceReader.$$$reportNull$$$0(3);
        }
        if (resourcePath.startsWith("apk:")) {
            int prefixLength = "apk:".length();
            int separatorPos = resourcePath.lastIndexOf("!/");
            if (separatorPos < prefixLength) {
                throw new IllegalArgumentException("Invalid resource path \"" + resourcePath + "\"");
            }
            byte[] byArray = FileResourceReader.readZipEntryBytes(resourcePath.substring(prefixLength, separatorPos), resourcePath.substring(separatorPos + "!/".length()));
            if (byArray == null) {
                FileResourceReader.$$$reportNull$$$0(4);
            }
            return byArray;
        }
        if (resourcePath.startsWith("file:")) {
            int prefixLength = "file:".length();
            if (resourcePath.startsWith("//", prefixLength)) {
                prefixLength += "//".length();
            }
            resourcePath = resourcePath.substring(prefixLength);
        }
        byte[] byArray = FileResourceReader.readFileBytes(resourcePath);
        if (byArray == null) {
            FileResourceReader.$$$reportNull$$$0(5);
        }
        return byArray;
    }

    @NotNull
    private static byte[] readFileBytes(String filePath) throws IOException {
        byte[] byArray;
        block12: {
            try (FileInputStream fileStream = new FileInputStream(filePath);){
                ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
                ByteStreams.copy((InputStream)fileStream, (OutputStream)byteOutputStream);
                byArray = byteOutputStream.toByteArray();
                if (byArray != null) break block12;
            }
            FileResourceReader.$$$reportNull$$$0(6);
        }
        return byArray;
    }

    @NotNull
    private static byte[] readZipEntryBytes(String zipPath, String zipEntryPath) throws IOException {
        byte[] byArray;
        block15: {
            try (ZipFile zipFile = new ZipFile(zipPath);){
                ZipEntry entry = zipFile.getEntry(zipEntryPath);
                if (entry == null) {
                    throw new FileNotFoundException("Zip entry \"" + zipPath + ':' + zipEntryPath + "\" does not exist");
                }
                long size = entry.getSize();
                if (size > Integer.MAX_VALUE) {
                    throw new IOException("Zip entry \"" + zipPath + ':' + zipEntryPath + "\" is too large");
                }
                byte[] bytes = new byte[(int)size];
                InputStream stream = zipFile.getInputStream(entry);
                if ((long)stream.read(bytes) != size) {
                    throw new IOException("Incomplete read from \"" + zipPath + ':' + zipEntryPath + "\"");
                }
                byArray = bytes;
                if (byArray != null) break block15;
            }
            FileResourceReader.$$$reportNull$$$0(7);
        }
        return byArray;
    }

    @Nullable
    public static XmlPullParser createXmlPullParser(@NotNull PathString resourcePath) throws IOException {
        if (resourcePath == null) {
            FileResourceReader.$$$reportNull$$$0(8);
        }
        try {
            byte[] contents = FileResourceReader.readBytes(resourcePath);
            return FileResourceReader.createXmlPullParser(contents);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    @Nullable
    public static XmlPullParser createXmlPullParser(@NotNull VirtualFile resourceFile) throws IOException {
        if (resourceFile == null) {
            FileResourceReader.$$$reportNull$$$0(9);
        }
        try {
            byte[] contents = resourceFile.contentsToByteArray();
            return FileResourceReader.createXmlPullParser(contents);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    @NotNull
    public static XmlPullParser createXmlPullParser(@NotNull byte[] contents) {
        ProtoXmlPullParser protoXmlPullParser;
        if (contents == null) {
            FileResourceReader.$$$reportNull$$$0(10);
        }
        try {
            ProtoXmlPullParser parser;
            if (XmlUtils.isProtoXml((byte[])contents)) {
                parser = new ProtoXmlPullParser();
            } else {
                parser = new KXmlParser();
                parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            }
            parser.setInput(new ByteArrayInputStream(contents), null);
            protoXmlPullParser = parser;
        }
        catch (XmlPullParserException e) {
            throw new Error("Internal error", e);
        }
        if (protoXmlPullParser == null) {
            FileResourceReader.$$$reportNull$$$0(11);
        }
        return protoXmlPullParser;
    }

    private FileResourceReader() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/FileResourceReader";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/FileResourceReader";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readBytes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "readFileBytes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "readZipEntryBytes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createXmlPullParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readBytes";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createXmlPullParser";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

