/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.adtui.ImageUtils;
import com.google.common.base.Verify;
import com.intellij.util.ImageLoader;
import com.intellij.util.ui.StartupUiUtil;
import icons.AndroidIcons;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import org.jetbrains.annotations.NotNull;

public class ShadowPainter {
    public static final int SHADOW_SIZE = 20;
    public static final int SMALL_SHADOW_SIZE = 10;
    private static final Image ShadowBottom = ShadowPainter.loadIcon("/icons/shadow-b.png");
    private static final Image ShadowBottomLeft = ShadowPainter.loadIcon("/icons/shadow-bl.png");
    private static final Image ShadowBottomRight = ShadowPainter.loadIcon("/icons/shadow-br.png");
    private static final Image ShadowRight = ShadowPainter.loadIcon("/icons/shadow-r.png");
    private static final Image ShadowTopRight = ShadowPainter.loadIcon("/icons/shadow-tr.png");
    private static final Image Shadow2Bottom = ShadowPainter.loadIcon("/icons/shadow2-b.png");
    private static final Image Shadow2BottomLeft = ShadowPainter.loadIcon("/icons/shadow2-bl.png");
    private static final Image Shadow2BottomRight = ShadowPainter.loadIcon("/icons/shadow2-br.png");
    private static final Image Shadow2Right = ShadowPainter.loadIcon("/icons/shadow2-r.png");
    private static final Image Shadow2TopRight = ShadowPainter.loadIcon("/icons/shadow2-tr.png");

    @NotNull
    public static BufferedImage createDropShadow(BufferedImage source, int shadowSize) {
        BufferedImage bufferedImage = ShadowPainter.createDropShadow(source, shadowSize /= 2, 0.7f, 0);
        if (bufferedImage == null) {
            ShadowPainter.$$$reportNull$$$0(0);
        }
        return bufferedImage;
    }

    public static BufferedImage createDropShadow(BufferedImage source, int shadowSize, float shadowOpacity, int shadowRgb) {
        int a;
        int aSum;
        int width = source.getWidth();
        int height = source.getHeight();
        boolean isRetina = ImageUtils.isRetinaImage((BufferedImage)source);
        BufferedImage image = isRetina ? ImageUtils.createDipImage((int)(width + 20), (int)(height + 20), (int)2) : new BufferedImage(width + 20, height + 20, 2);
        Graphics2D g2 = image.createGraphics();
        StartupUiUtil.drawImage((Graphics)g2, (Image)source, (int)shadowSize, (int)shadowSize, null);
        int dstWidth = image.getWidth();
        int dstHeight = image.getHeight();
        int left = shadowSize - 1 >> 1;
        int right = shadowSize - left;
        int xStart = left;
        int xStop = dstWidth - right;
        int yStart = left;
        int yStop = dstHeight - right;
        shadowRgb &= 0xFFFFFF;
        int[] aHistory = new int[shadowSize];
        int historyIdx = 0;
        int[] dataBuffer = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int lastPixelOffset = right * dstWidth;
        float sumDivider = shadowOpacity / (float)shadowSize;
        int y = 0;
        int bufferOffset = 0;
        while (y < dstHeight) {
            aSum = 0;
            historyIdx = 0;
            int x = 0;
            while (x < shadowSize) {
                aHistory[x] = a = dataBuffer[bufferOffset] >>> 24;
                aSum += a;
                ++x;
                ++bufferOffset;
            }
            bufferOffset -= right;
            x = xStart;
            while (x < xStop) {
                a = (int)((float)aSum * sumDivider);
                dataBuffer[bufferOffset] = a << 24 | shadowRgb;
                aSum -= aHistory[historyIdx];
                aHistory[historyIdx] = a = dataBuffer[bufferOffset + right] >>> 24;
                aSum += a;
                if (++historyIdx >= shadowSize) {
                    historyIdx -= shadowSize;
                }
                ++x;
                ++bufferOffset;
            }
            bufferOffset = ++y * dstWidth;
        }
        int x = 0;
        bufferOffset = 0;
        while (x < dstWidth) {
            aSum = 0;
            historyIdx = 0;
            int y2 = 0;
            while (y2 < shadowSize) {
                aHistory[y2] = a = dataBuffer[bufferOffset] >>> 24;
                aSum += a;
                ++y2;
                bufferOffset += dstWidth;
            }
            bufferOffset -= lastPixelOffset;
            y2 = yStart;
            while (y2 < yStop) {
                a = (int)((float)aSum * sumDivider);
                dataBuffer[bufferOffset] = a << 24 | shadowRgb;
                aSum -= aHistory[historyIdx];
                aHistory[historyIdx] = a = dataBuffer[bufferOffset + lastPixelOffset] >>> 24;
                aSum += a;
                if (++historyIdx >= shadowSize) {
                    historyIdx -= shadowSize;
                }
                ++y2;
                bufferOffset += dstWidth;
            }
            bufferOffset = ++x;
        }
        StartupUiUtil.drawImage((Graphics)g2, (BufferedImage)source, null, (int)0, (int)0);
        g2.dispose();
        return image;
    }

    public static BufferedImage createRectangularDropShadow(BufferedImage source) {
        int type = source.getType();
        if (type == 0) {
            type = 2;
        }
        int width = source.getWidth();
        int height = source.getHeight();
        BufferedImage image = ImageUtils.isRetinaImage((BufferedImage)source) ? ImageUtils.createDipImage((int)(width + 20), (int)(height + 20), (int)type) : new BufferedImage(width + 20, height + 20, type);
        Graphics g = image.getGraphics();
        StartupUiUtil.drawImage((Graphics)g, (Image)source, (int)0, (int)0, null);
        ShadowPainter.drawRectangleShadow(image, 0, 0, width, height);
        g.dispose();
        return image;
    }

    public static BufferedImage createSmallRectangularDropShadow(BufferedImage source) {
        int type = source.getType();
        if (type == 0) {
            type = 2;
        }
        int width = source.getWidth();
        int height = source.getHeight();
        BufferedImage image = ImageUtils.isRetinaImage((BufferedImage)source) ? ImageUtils.createDipImage((int)(width + 10), (int)(height + 10), (int)type) : new BufferedImage(width + 10, height + 10, type);
        Graphics g = image.getGraphics();
        StartupUiUtil.drawImage((Graphics)g, (Image)source, (int)0, (int)0, null);
        ShadowPainter.drawSmallRectangleShadow(image, 0, 0, width, height);
        g.dispose();
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawRectangleShadow(BufferedImage image, int x, int y, int width, int height) {
        Graphics gc = image.getGraphics();
        try {
            ShadowPainter.drawRectangleShadow(gc, x, y, width, height);
        }
        finally {
            gc.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawSmallRectangleShadow(BufferedImage image, int x, int y, int width, int height) {
        Graphics gc = image.getGraphics();
        try {
            ShadowPainter.drawSmallRectangleShadow(gc, x, y, width, height);
        }
        finally {
            gc.dispose();
        }
    }

    public static void drawRectangleShadow(Graphics gc, int x, int y, int width, int height) {
        assert (ShadowBottomLeft != null);
        assert (ShadowBottomRight.getWidth(null) == 20);
        assert (ShadowBottomRight.getHeight(null) == 20);
        int blWidth = ShadowBottomLeft.getWidth(null);
        int trHeight = ShadowTopRight.getHeight(null);
        if (width < blWidth) {
            return;
        }
        if (height < trHeight) {
            return;
        }
        StartupUiUtil.drawImage((Graphics)gc, (Image)ShadowBottomLeft, (int)x, (int)(y + height), null);
        StartupUiUtil.drawImage((Graphics)gc, (Image)ShadowBottomRight, (int)(x + width), (int)(y + height), null);
        StartupUiUtil.drawImage((Graphics)gc, (Image)ShadowTopRight, (int)(x + width), (int)y, null);
        ImageUtils.drawDipImage((Graphics)gc, (Image)ShadowBottom, (int)(x + ShadowBottomLeft.getWidth(null)), (int)(y + height), (int)(x + width), (int)(y + height + ShadowBottom.getHeight(null)), (int)0, (int)0, (int)ShadowBottom.getWidth(null), (int)ShadowBottom.getHeight(null), null);
        ImageUtils.drawDipImage((Graphics)gc, (Image)ShadowRight, (int)(x + width), (int)(y + ShadowTopRight.getHeight(null)), (int)(x + width + ShadowRight.getWidth(null)), (int)(y + height), (int)0, (int)0, (int)ShadowRight.getWidth(null), (int)ShadowRight.getHeight(null), null);
    }

    public static void drawSmallRectangleShadow(Graphics gc, int x, int y, int width, int height) {
        assert (Shadow2BottomLeft != null);
        assert (Shadow2TopRight != null);
        assert (Shadow2BottomRight.getWidth(null) == 10);
        assert (Shadow2BottomRight.getHeight(null) == 10);
        int blWidth = Shadow2BottomLeft.getWidth(null);
        int trHeight = Shadow2TopRight.getHeight(null);
        if (width < blWidth) {
            return;
        }
        if (height < trHeight) {
            return;
        }
        StartupUiUtil.drawImage((Graphics)gc, (Image)Shadow2BottomLeft, (int)x, (int)(y + height), null);
        StartupUiUtil.drawImage((Graphics)gc, (Image)Shadow2BottomRight, (int)(x + width), (int)(y + height), null);
        StartupUiUtil.drawImage((Graphics)gc, (Image)Shadow2TopRight, (int)(x + width), (int)y, null);
        ImageUtils.drawDipImage((Graphics)gc, (Image)Shadow2Bottom, (int)(x + Shadow2BottomLeft.getWidth(null)), (int)(y + height), (int)(x + width), (int)(y + height + Shadow2Bottom.getHeight(null)), (int)0, (int)0, (int)Shadow2Bottom.getWidth(null), (int)Shadow2Bottom.getHeight(null), null);
        ImageUtils.drawDipImage((Graphics)gc, (Image)Shadow2Right, (int)(x + width), (int)(y + Shadow2TopRight.getHeight(null)), (int)(x + width + Shadow2Right.getWidth(null)), (int)(y + height), (int)0, (int)0, (int)Shadow2Right.getWidth(null), (int)Shadow2Right.getHeight(null), null);
    }

    @NotNull
    private static Image loadIcon(String path) {
        Image image = (Image)Verify.verifyNotNull((Object)ImageLoader.loadFromResource((String)path, AndroidIcons.class));
        if (image == null) {
            ShadowPainter.$$$reportNull$$$0(1);
        }
        return image;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/android/tools/idea/rendering/ShadowPainter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createDropShadow";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadIcon";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

